/* -*- Mode: C++ -*- */

/* Classes dealing with statistical stuff from data points */

/* Patrick Riley */

#include <math.h>
#include "data.h"

SingleDataSummary::SingleDataSummary()
{
  Reset();
}

void SingleDataSummary::Reset() 
{
  n = 0;
  sum = 0.0;
  sum_squares = 0.0;
}

void SingleDataSummary::AddPoint(float x)
{
  n++;
  sum += x;
  sum_squares += x*x;
}

float SingleDataSummary::GetMean()
{
  if (n==0)
    return 0.0;
  else
    return sum/n;
}
				 
float SingleDataSummary::GetVariance()
{
  if (n==1 || n==0)
    return 0;
  else
    return (n*sum_squares - sum*sum) / (n * (n-1));
}


float SingleDataSummary::GetStdDev()
{
  return (sqrt(GetVariance()));
}

int SingleDataSummary::GetNumPoints()
{
  return n;
}



void SingleDataSummary::WriteInfoToFile(ostream& output_file,
					int WithNumPoints)
{
  if (WithNumPoints)
    output_file << "NumPoints: " << GetNumPoints() << "\t";
  output_file << "Mean: " << GetMean()
	      << "\tVariance: " << GetVariance()
	      << "\tStdDev: " << GetStdDev()
	      << endl;
}


