/*************************************************************************/
/*									 */
/*		Definitions used in C4.5				 */
/*              ------------------------				 */
/*									 */
/*************************************************************************/
#ifndef DEFNS_I
#define DEFNS_I

#include <stdio.h>
#include <math.h>

/*#define malloc(X) NewPtr(X)
#define calloc(X, Y) NewPtrClear((X)*(Y));
#define free(X) DisposePtr((char *)(X))
#define cfree(X) DisposePtr((char *)(X))
*/

#define	 Eof			EOF             /*char read on end of file*/
#define	 Nil			0               /*null pointer*/
#define	 false			0 
#define	 true			1 
#define	 None			-1
#define	 Epsilon                1E-3

#ifndef __MWERKS__
//long	 random();
#define	 Random			((random()&2147483647) / 2147483648.0)
#else
#define	 Random			((rand()&2147483647) / 2147483648.0)
#endif

//#define	 Max(a,b)               ((a)>(b) ? a : b) 
//#define	 Min(a,b)               ((a)<(b) ? a : b) 
//#define	 Round(x)		((int) (x+0.5))
#define	 Log2			0.69314718055994530942
#define	 Log(x)			((x) <= 0 ? 0.0 : log((float)x) / Log2)

#define	 Bit(b)			(1 << (b))
#define	 In(b,s)		((s[(b) >> 3]) & Bit((b) & 07))
#define	 ClearBits(n,s)		memset(s,0,n)
#define	 CopyBits(n,f,t)	memcpy(t,f,n)
#define	 SetBit(b,s)		(s[(b) >> 3] |= Bit((b) & 07))

#define	 ForEach(v,f,l)		for(v=f ; v<=l ; ++v) 

#define	 Verbosity(d)		if(VERBOSITY >= d)

#define	 Check(v,l,h)\
	     if ( v<l||v>h ) {printf("\t** illegal value **\n"); exit(1);}

#endif
