/* -*- Mode: C++ -*- */

/* these are definition for adversaries beahvior classes.
   There are based on the observations in observe.h */

#ifndef _ADV_CLASS_H_
#define _ADV_CLASS_H_

#include "MemOption.h"
#include "observe.h"

class AdversaryType;

class AdversaryTypeList 
{
 private:
  typedef struct ADVERSARYTYPELISTITEM {
    struct ADVERSARYTYPELISTITEM* pNext;
    AdversaryType* pAdvT;
  } AdversaryTypeListItem;
  AdversaryTypeListItem* pHead;
  AdversaryTypeListItem* pIter;

 public:
  AdversaryTypeList()
    { pHead = pIter = NULL; }
  ~AdversaryTypeList();  
  
  void Add(AdversaryType* pAdvT);
  void ResetIter()
    { pIter = pHead; }
  AdversaryType* GetCurrentIter();
  AdversaryType* PeekCurrentIter() 
    { return (pIter != NULL ? pIter->pAdvT : NULL); }      
  Bool AdvanceCurrentIter()
    { return (pIter == NULL ? FALSE :
	      ((pIter = pIter->pNext) == NULL ? FALSE : TRUE)); }

  /* returns the adversary type in list closest to observations */
  AdversaryType* MatchToObservations(ObserveList* pObsList);
  
} ;



class AdversaryType 
{
public:
  //private:
  Bool ReadObservationsFromFile(istream& infile, OptionInfo* pMemOpt);

  ObserveList listTargetObs;
  const int name_len = 50;
  char name[name_len];  

public:
  AdversaryType();

  void WriteToFile(ostream& outfile);  
  Bool LoadFromFile(istream& infile, OptionInfo* pMemOpt);
  float CompareToObservations(ObserveList* pObsList);

  Bool CreateFromObservations(OptionInfo* pMemOpt);
  
  char* GetName() { return name; }
  void SetName(char* n) { strcpy(name, n); }

} ;





#endif



