/* -*- Mode: C++ -*- */

#ifdef RELEASE_VERSION  
THIS FILE SHOULD NOT BE INCLUDED!
#endif // RELEASE_VERSION

#ifndef _SETPLAY_H_
#define _SETPLAY_H_

#include "MemDT.h"
#include "MemRL.h"

#define SPnum_Unknown 0

/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        SetPlayPosition Class                                 */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

class SetPlayPosition {
public:

  void SetHome(Vector p, float buf, SPAtype type);
  void SetAim (Vector a, int wait);
  void SetAim (SPnum position, int wait);
  void SetAim (SPnum position, Vector p, int wait);

  inline Vector GetHome()       { return Home;       } 
  inline float  GetHomeX()      { return Home.x;     }
  inline float  GetHomeY()      { return Home.y;     }
  inline float  GetHomeBuffer() { return HomeBuffer; }

  inline SPAtype GetType()      { return ActionType; }

  inline Vector GetAimPoint()    { return AimPoint;    } 
  inline float  GetAimX()        { return AimPoint.x;  }
  inline float  GetAimY()        { return AimPoint.y;  }
  inline SPnum  GetAimPosition() { return AimPosition; }
  inline int    GetWaitTime()    { return WaitTime;    }

private:
  Vector Home;
  float HomeBuffer;

  SPAtype ActionType;

  SPnum AimPosition;
  Vector AimPoint;
  int WaitTime;
};




/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        SetPlayFormation Class                                */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/


class SetPlayFormation {
public:
  SetPlayFormation();
  ~SetPlayFormation();
  void Reset(int num);
   
  inline int GetNumPositions() { return num_positions; }

  void SpecifySetPlayPosition(SPnum pos, Vector p, float buf, SPAtype type);
  void SpecifySetPlayAction  (SPnum pos, Vector p, int wait);
  void SpecifySetPlayAction  (SPnum pos, SPnum target, int wait);
  void AssignSetPlayPosition (SPnum pos, Pnum formationPos);

  Pnum  SetPlayPositionPlayer(SPnum pos);
  SPnum SetPlayPlayerPosition(Pnum formationPos);

  Vector SetPlayPositionHome(SPnum pos);
  inline float SetPlayPositionX(SPnum pos) { return SetPlayPositionHome(pos).x; }
  inline float SetPlayPositionY(SPnum pos) { return SetPlayPositionHome(pos).y; }

  Vector SetPlayPlayerHome(Pnum formationPos);
  inline float SetPlayPlayerX(int formationPos) { return SetPlayPlayerHome(formationPos).x; }
  inline float SetPlayPlayerY(int formationPos) { return SetPlayPlayerHome(formationPos).y; }

  Vector SetPlayPlayerAimPoint(int formationPos);
  inline float SetPlayPlayerAimPointX(int formationPos) { return SetPlayPlayerAimPoint(formationPos).x; }
  inline float SetPlayPlayerAimPointY(int formationPos) { return SetPlayPlayerAimPoint(formationPos).y; }

  float   PositionBuffer(Pnum formationPos);
  int     WaitTime      (Pnum formationPos);
  Pnum    AimPosition   (Pnum formationPos);
  SPAtype PositionType  (Pnum formationPos);

  Pnum   Starter();

  void  Initialize(Pmode PlayMode) { type = PlayMode; }
  Pmode type;

  void Print();

private:

  int num_positions;           
  SetPlayPosition *positions;  /* x,y positions -- starts at positions[1]     */
  Pnum *positionPlayers;       /* Based on positions in the current formation */
};




/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        SetPlayInfo Class                                     */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

class SetplayInfo : public RLInfo, public DTInfo{
public:

  SetplayInfo();
  ~SetplayInfo();

  Bool NeedToInitializeSetPlay();
  void InitializeSetPlay();
  inline void EndSetPlay() { SetPlay = InSetPlay = FALSE; }

  inline Pmode SetPlayType() { return CurrentSetPlayFormation->type; }

  Vector PositionSetPlayHome(Pnum pos, Bool AdjustForOffsides=FALSE);
  inline float PositionSetPlayX(Pnum pos, Bool AdjustForOffsides=FALSE) 
    { return PositionSetPlayHome(pos,AdjustForOffsides).x; }
  inline float PositionSetPlayY(Pnum pos, Bool AdjustForOffsides=FALSE) 
    { return PositionSetPlayHome(pos,AdjustForOffsides).y; }

  Vector MySetPlayHome(Bool AdjustForOffsides=FALSE);
  inline float MySetPlayX(Bool AdjustForOffsides=FALSE) { return MySetPlayHome(AdjustForOffsides).x; }
  inline float MySetPlayY(Bool AdjustForOffsides=FALSE) { return MySetPlayHome(AdjustForOffsides).y; }

  SPnum  MySetPlayPosition();
  float  MySetPlayPositionBuffer();
  Bool   InMySetPlayPosition(Bool AdjustForOffsides=FALSE);

  Vector MySetPlayAimPoint(Bool AdjustForOffsides=FALSE);
  inline float MySetPlayAimX(Bool AdjustForOffsides=FALSE) { return MySetPlayAimPoint(AdjustForOffsides).x; }
  inline float MySetPlayAimY(Bool AdjustForOffsides=FALSE) { return MySetPlayAimPoint(AdjustForOffsides).y; }

  Pnum    MySetPlayAimPosition();
  int     MySetPlayWaitTime();
  SPAtype MySetPlayPositionType();

  Bool SetPlayPositionFilled(SPnum pos,Bool AdjustForOffsides=FALSE);
  Bool PositionInSetPlayPosition(Pnum pos,Bool AdjustForOffsides=FALSE);
  Bool AllInSetPlayPosition(Bool AdjustForOffsides=FALSE);
  Pnum SetPlayStarterPosition();
  Bool PositionInSetPlay(Pnum pos);
  Bool MyPositionInSetPlay();
  Bool BallInSetPlayPosition();
  Vector SetPlayBallAbsolutePosition();

  void ModifySetPlayStartAction();

  Bool UseSetPlays;
  Bool SetPlay;
  Bool InSetPlay;
  Bool GotBallInSetPlay;
  Time SetPlayStartTime;
  Time SetPlayInvokeTime;
  Time SetPlayLastSpoke;
  int  SetPlayTimeLimit;
  int  SetPlayStartActionChosen; /* Counts number of times changed */
  Pnum SetPlayStartReceiver;
  Vector SetPlayBallPositionFromCoach;
  Time   SetPlayBallPositionFromCoachTime;

  Unum  Confirmed_Setplay_Starter;
  SPnum Player_Setplay_Ready[MAX_PLAYERS];
  Bool  HaveBeenInSetPlayPosition;

  SetPlayFormation *CurrentSetPlayFormation;
};

#endif
