/* -*- Mode: C++ -*- */

#include "MemSetplay.h"

/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        SetPlayPosition Class                                 */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

void SetPlayPosition::SetHome(Vector p, float buf, SPAtype type)
{
  Home = p;
  HomeBuffer = buf;
  ActionType = type;
}

/********************************************************************************/

void SetPlayPosition::SetAim (Vector a, int wait)
{
  AimPoint = a;
  AimPosition = SPnum_Unknown;
  WaitTime = wait;
}

/********************************************************************************/

void SetPlayPosition::SetAim (SPnum position, int wait)
{
  AimPoint = 0;
  AimPosition = position;
  WaitTime = wait;
}

/********************************************************************************/

void SetPlayPosition::SetAim (SPnum position, Vector p, int wait)
{
  AimPoint = p;
  AimPosition = position;
  WaitTime = wait;
}


/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        SetPlayFormation Class                                */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

SetPlayFormation::SetPlayFormation()
{
  positions = NULL;
  positionPlayers = NULL;
}

/********************************************************************************/

SetPlayFormation::~SetPlayFormation()
{
  if ( positions != NULL ) 
    delete [] positions;
  if ( positionPlayers != NULL ) 
    delete [] positionPlayers;
}

/********************************************************************************/

void SetPlayFormation::Reset(int num)
{
  /* Reinitialize the structure */
  num_positions = num;
  if ( positions != NULL ) delete [] positions;
  if ( positionPlayers != NULL ) delete [] positionPlayers;
  positions = new SetPlayPosition[num_positions+1];
  positionPlayers = new Pnum[num_positions+1];
  for (int i=1; i<=num_positions; i++)
    positionPlayers[i] = Pnum_Unknown;
}

/********************************************************************************/
   
void SetPlayFormation::SpecifySetPlayPosition(SPnum pos, Vector p, float buf, SPAtype type)
{
  if (pos > num_positions) my_error("Too many set play positions");
  positions[pos].SetHome(p,buf,type);
}

/********************************************************************************/

/* SETPLAY_STARTER can be treated either as a passer or as a knocker */
/* SETPLAY_STARTER should always be set as pos 1 (used in memory.c)  */

void SetPlayFormation::SpecifySetPlayAction(SPnum pos, Vector p, int wait)
{
  if (pos > num_positions) my_error("Too many set play positions");
  if ( positions[pos].GetType() == SPA_Passer )
    my_error("Passers should be given a target player");
  positions[pos].SetAim(p,wait);
}

/********************************************************************************/

void SetPlayFormation::SpecifySetPlayAction(SPnum pos, SPnum target, int wait)
{
  if (pos > num_positions) my_error("Too many set play positions");
  if ( positions[pos].GetType() == SPA_Shooter || 
       positions[pos].GetType() == SPA_Knocker || 
       positions[pos].GetType() == SPA_Blaster ||
       positions[pos].GetType() == SPA_Getter    )
    my_error("Shooters should be given a target point");
  positions[pos].SetAim(target,SetPlayPositionHome(target),wait);
}

/********************************************************************************/

void SetPlayFormation::AssignSetPlayPosition(SPnum pos, Pnum formationPos)
{
  if (pos > num_positions) my_error("Too many set play positions");
  positionPlayers[pos] = formationPos;
}

/********************************************************************************/

Pnum SetPlayFormation::SetPlayPositionPlayer(SPnum pos)
{
  return positionPlayers[pos];
}

/********************************************************************************/

SPnum SetPlayFormation::SetPlayPlayerPosition(Pnum formationPos)
{
  for (int i=1; i<=num_positions; i++){
    if (SetPlayPositionPlayer(i) == formationPos)
      return i;
  }
  return SPnum_Unknown;
}

/********************************************************************************/	

Vector SetPlayFormation::SetPlayPositionHome(SPnum pos)
{
  return positions[pos].GetHome();
}

/********************************************************************************/

Vector SetPlayFormation::SetPlayPlayerHome(Pnum formationPos)
{
  SPnum pos = SetPlayPlayerPosition(formationPos);
  if (pos == SPnum_Unknown)
    my_error("Can't get the x of an unknown (sp) position");
  return SetPlayPositionHome(pos);
}

/********************************************************************************/

Vector SetPlayFormation::SetPlayPlayerAimPoint(Pnum formationPos)
{
  SPnum pos = SetPlayPlayerPosition(formationPos);
  if (pos == SPnum_Unknown)
    my_error("Can't get the aimx of an unknown (sp) position");
  return positions[pos].GetAimPoint();
}

/********************************************************************************/

float SetPlayFormation::PositionBuffer(Pnum formationPos)
{
  SPnum pos = SetPlayPlayerPosition(formationPos);
  if (pos == SPnum_Unknown)
    my_error("Can't get the buffer of an unknown (sp) position");
  return positions[pos].GetHomeBuffer();
}

/********************************************************************************/

int   SetPlayFormation::WaitTime      (Pnum formationPos)
{
  SPnum pos = SetPlayPlayerPosition(formationPos);
  if (pos == SPnum_Unknown)
    my_error("Can't get the wait time of an unknown (sp) position");
  return positions[pos].GetWaitTime();
}

/********************************************************************************/

Pnum   SetPlayFormation::AimPosition   (Pnum formationPos)
{
  SPnum setplayPos = positions[SetPlayPlayerPosition(formationPos)].GetAimPosition();
  if ( setplayPos == SPnum_Unknown )
    return Pnum_Unknown;
  else 
    return SetPlayPositionPlayer(setplayPos);
}

/********************************************************************************/

SPAtype SetPlayFormation::PositionType  (Pnum formationPos)
{
  SPnum pos = SetPlayPlayerPosition(formationPos);
  if (pos == SPnum_Unknown){
    my_error("Can't get the type of an unknown (sp) position (formationPos = %d)",formationPos);
    //dump_core("dump");
  }
  return positions[pos].GetType();
}

/********************************************************************************/

Pnum  SetPlayFormation::Starter   ()
{
  Pnum starter = Pnum_Unknown;
  for (int pos=1; pos <= num_positions; pos++){
    if ( positions[pos].GetType() == SPA_Starter )
      starter = SetPlayPositionPlayer(pos);
  }
  return starter;  /* Could be Pnum_Unknown */
}

/********************************************************************************/

void SetPlayFormation::Print()
{
  printf("spf(%d): ",num_positions);
  for (int i=1; i<=num_positions; i++)
    printf("%d->%d ",i,positionPlayers[i]);
  printf("\n");
}




/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        SetPlayInfo Class                                     */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

SetplayInfo::SetplayInfo()
{
  UseSetPlays = FALSE;
  SetPlay = FALSE;
  InSetPlay = FALSE;
  CurrentSetPlayFormation = (SetPlayFormation *) new SetPlayFormation;
  SetPlayBallPositionFromCoachTime = 0;
}

/********************************************************************************/

SetplayInfo::~SetplayInfo()
{
  delete CurrentSetPlayFormation;
}

/********************************************************************************/

Bool SetplayInfo::NeedToInitializeSetPlay()
{
  if ( CP_set_plays && PlayMode != PM_Play_On && SetPlay == FALSE && 
       CurrentTime - PlayModeTime > CP_Setplay_Delay && CurrentTime - PlayModeTime < CP_Setplay_Max_Delay )
    return TRUE;
  return FALSE;
}

/********************************************************************************/

void SetplayInfo::InitializeSetPlay()
{
  Pmode NextPlayMode;
  if ( PlayMode == PM_Before_Kick_Off ){
    if ( KickOffMode == KO_Mine )
      NextPlayMode = PM_My_Kick_Off;
    else /* KO_Theirs */
      NextPlayMode = PM_Their_Kick_Off;
  }
  else if ( PlayMode == PM_My_Offside_Kick )
    NextPlayMode = PM_My_Free_Kick;
  else if ( PlayMode == PM_Their_Offside_Kick )
    NextPlayMode = PM_Their_Free_Kick;
  else
    NextPlayMode = PlayMode;

  LogAction4(200,"InitializeSetPlay: PlayMode %d (%d)",NextPlayMode,PlayMode);

  if ( !BallPositionValid() || BallInSetPlayPosition() == FALSE ){
    LogAction2(30,"InitializeSetPlay:  ball not in setplay position");
    return;
  }

  /***************************************************/
  /************** INITIALIZE THE POSITIONS ***********/
  /***************************************************/

  float X0 = SP_pitch_length/2.0, Y0 = SP_pitch_width/2.0;
  float PA_X = SP_pitch_length/2.0 - SP_penalty_area_length;
  float PA_Y = SP_penalty_area_width/2.0;
  float GA_X = SP_pitch_length/2.0 - SP_goal_area_length;
  float GA_Y = SP_goal_area_width/2.0;
  Vector ball = SetPlayBallAbsolutePosition();
  int num_positions;

  switch(NextPlayMode){
  case PM_My_Kick_In:
    if ( ball.x < X0 - 45 )
      num_positions = 3;
    else
      num_positions = 5; /* going to corner kick mode */
    break;
  case PM_My_Corner_Kick:
    num_positions = 5;
    break;
  case PM_My_Kick_Off:
    num_positions = 2;
    break;
  case PM_My_Goal_Kick:
    num_positions = 3;
    break;
  case PM_Their_Kick_In:
    num_positions = 1;
    break;
  case PM_Their_Corner_Kick:
    num_positions = 5;
    break;
  case PM_Their_Goal_Kick:
    num_positions = 3;
    break;
  case PM_Their_Kick_Off:
    num_positions = 3;
    break;
  case PM_My_Goalie_Free_Kick:
    num_positions = 5;
    break;
  case PM_My_Free_Kick:
    num_positions = 3;
    break;
  case PM_Their_Goalie_Free_Kick:
    num_positions = 4;
    break;
  case PM_Their_Free_Kick:
    num_positions = 3;
    break;
  default: return;  /* No set play for that mode */
  }

  CurrentSetPlayFormation->Reset(num_positions);

  int ballside = BallLocationSide() == FS_Right ? 1 : -1;
  int buffer = 1;
  float tempx,dist;
  Vector temp,ck_targ;

  switch(NextPlayMode){
  case PM_My_Kick_Off:
    LogAction4(50,"Initializing my kickoff setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, Vector(-1,0), buffer, SPA_Starter);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(-15,-15), buffer, SPA_Knocker);
    
    CurrentSetPlayFormation->SpecifySetPlayAction  (1, 2, 10); 
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, Vector(SP_pitch_length/4,-SP_pitch_width/2), 25);  
    break;
  case PM_My_Kick_In:
    if ( ball.x < X0-45 ){
      LogAction4(50,"Initializing my kickin setplay (ball at %.1f,%.1f)",ball.x,ball.y);
#if 0 /* Started RoboCup'98 with this */
      CurrentSetPlayFormation->SpecifySetPlayPosition(1, ball, buffer, SPA_Starter);
      CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(ball.x+20, (Y0-5)*ballside), buffer, SPA_Passer);
      CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(ball.x+40, (Y0-15)*ballside), buffer, SPA_Passer);
      CurrentSetPlayFormation->SpecifySetPlayPosition(4, Vector(PA_X,     (PA_Y-10)*ballside), buffer, SPA_Shooter);
      
      CurrentSetPlayFormation->SpecifySetPlayAction  (1, 2, 10); 
      CurrentSetPlayFormation->SpecifySetPlayAction  (2, 3, 20);  
      CurrentSetPlayFormation->SpecifySetPlayAction  (3, 4, 40);  
      CurrentSetPlayFormation->SpecifySetPlayAction  (4,MarkerPosition(RM_Their_Goal),50);
      break;
#else
      CurrentSetPlayFormation->SpecifySetPlayPosition(1, ball, buffer, SPA_Starter);
      CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(ball.x+15, (Y0-5)*ballside), buffer, SPA_Knocker);
      CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(ball.x+10, (Y0-10)*ballside), buffer, SPA_Knocker);
      
      CurrentSetPlayFormation->SpecifySetPlayAction  (1, 2, 10); 
      CurrentSetPlayFormation->SpecifySetPlayAction  (2, Vector(PA_X-5,0), 20);  
      CurrentSetPlayFormation->SpecifySetPlayAction  (3, Vector(PA_X-5,0), 20);  
      break;
#endif
    }
    else{
      ; /* same as corner kick */
    }
  case PM_My_Corner_Kick:
    LogAction4(50,"Initializing my cornerkick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, ball, buffer, SPA_Starter);

    tempx = X0-20;  
    if ( ball.x > X0-30 && ball.x < X0-10 ){
      if ( ball.x > X0-20 ) tempx = ball.x-10;
      else                  tempx = ball.x+10;
    }

    ck_targ = Vector(PA_X+2,(PA_Y-12)*ballside);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(tempx,    (Y0-5)   *ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, ck_targ,                         buffer, SPA_Getter);
    CurrentSetPlayFormation->SpecifySetPlayPosition(4, ck_targ + Vector(-2,2*ballside), buffer, SPA_Getter);
    CurrentSetPlayFormation->SpecifySetPlayPosition(5, Vector(PA_X,    -(PA_Y-10)*ballside), buffer, SPA_Getter);

    CurrentSetPlayFormation->SpecifySetPlayAction  (1,2,20);
    CurrentSetPlayFormation->SpecifySetPlayAction  (2,ck_targ,30);
    CurrentSetPlayFormation->SpecifySetPlayAction  (3,MarkerPosition(RM_Their_Goal),40);
    CurrentSetPlayFormation->SpecifySetPlayAction  (4,MarkerPosition(RM_Their_Goal),40);
    CurrentSetPlayFormation->SpecifySetPlayAction  (5,MarkerPosition(RM_Their_Goal),50);
    break;
  case PM_My_Goalie_Free_Kick:
    LogAction4(50,"Initializing my goalie free kick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    /* For goalie catch : setup play on both sides of the field */
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, ball, buffer, SPA_Starter);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(MyRightGoalKickSpot.x+5, (Y0-5)*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(MyRightGoalKickSpot.x+5, -(Y0-5)*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(4, Vector(-20, (Y0-5)*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(5, Vector(-20, -(Y0-5)*ballside), buffer, SPA_Knocker);
    
    CurrentSetPlayFormation->SpecifySetPlayAction  (1, 2 ,10);
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, Vector(0,(Y0-5)*ballside), 30); 
    CurrentSetPlayFormation->SpecifySetPlayAction  (3, Vector(0,-(Y0-5)*ballside), 30); 
    CurrentSetPlayFormation->SpecifySetPlayAction  (4, Vector(SP_pitch_length/2,(Y0-5)*ballside),50); 
    CurrentSetPlayFormation->SpecifySetPlayAction  (5, Vector(SP_pitch_length/2,-(Y0-5)*ballside),50); 
    break;
  case PM_My_Free_Kick:
    if ( !BallInOwnPenaltyArea() ){
      LogAction4(50,"Initializing my free kick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
#if 0 /* Used at the start of RoboCup'98 */
      CurrentSetPlayFormation->SpecifySetPlayPosition(1, ball, buffer, SPA_Starter);
      CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(ball.x+15, ball.y - 15*ballside), buffer, SPA_Passer);
      CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(ball.x+30, ball.y - 15*ballside), buffer, SPA_Knocker);
      
      CurrentSetPlayFormation->SpecifySetPlayAction  (1, 2 ,10);
      CurrentSetPlayFormation->SpecifySetPlayAction  (2, 3, 20); 
      CurrentSetPlayFormation->SpecifySetPlayAction  (3, MarkerPosition(RM_Their_Goal), 20); /* make own decision */
      break;
#else
      CurrentSetPlayFormation->SpecifySetPlayPosition(1, ball, buffer, SPA_Starter);
      CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(ball.x+20, (Y0-5)*ballside), buffer, SPA_Knocker);
      CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(ball.x+25, ball.y - 5*ballside), buffer, SPA_Knocker);
      
      CurrentSetPlayFormation->SpecifySetPlayAction  (1, 2 ,10);
      CurrentSetPlayFormation->SpecifySetPlayAction  (2, Vector(X0,(Y0-5)*ballside), 20); 
      CurrentSetPlayFormation->SpecifySetPlayAction  (3, Vector(PA_X-5,0), 20); 
      break;
#endif
    }
    else {
      ; /* Same as goal kick */
    }
  case PM_My_Goal_Kick:
    LogAction4(50,"Initializing my goalkick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, ball, buffer, SPA_Starter);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(ball.x+5, (Y0-5)*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(-20, (Y0-5)*ballside), buffer, SPA_Knocker);
    
    CurrentSetPlayFormation->SpecifySetPlayAction  (1, 2 ,10);
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, Vector(0,(Y0-5)*ballside), 30); 
    CurrentSetPlayFormation->SpecifySetPlayAction  (3, Vector(SP_pitch_length/2,(Y0-5)*ballside),50); 
    break;
  case PM_Their_Kick_In:
    LogAction4(50,"Initializing their kickin setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    temp = PointInBetween(ball,MarkerPosition(RM_My_Goal),SP_free_kick_buffer+1);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, temp, buffer, SPA_Knocker);

    CurrentSetPlayFormation->SpecifySetPlayAction  (1, MarkerPosition(RM_Their_Goal), 0);  /* Just get to position */
    break;
  case PM_Their_Kick_Off:
    LogAction4(50,"Initializing their kickoff setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    /* Need to use absolute here -- might not see ball            */
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, Vector(-10, 0), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(-8,  5), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(-8,  -5), buffer, SPA_Knocker);

    CurrentSetPlayFormation->SpecifySetPlayAction  (1, MarkerPosition(RM_Their_Goal) , 0);  /* Just get to position */
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, MarkerPosition(RM_Their_Goal) , 0);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (3, MarkerPosition(RM_Their_Goal) , 0);  
    break;
  case PM_Their_Goal_Kick:
    LogAction4(50,"Initializing their goalkick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    temp = Vector(TheirPenaltyArea.LeftX()-buffer, (TheirPenaltyArea.BottomY()+buffer)*ballside);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, temp + Vector(5,0)            , buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, temp - Vector(0,7.5)*ballside , buffer, SPA_Knocker); 
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, temp - Vector(0,15)*ballside  , buffer, SPA_Knocker);

    CurrentSetPlayFormation->SpecifySetPlayAction  (1, MarkerPosition(RM_Their_Goal) , 0);  /* Just get to position */
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, MarkerPosition(RM_Their_Goal) , 0);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (3, MarkerPosition(RM_Their_Goal) , 0);  
    break;
  case PM_Their_Corner_Kick:
    LogAction4(50,"Initializing their cornerkick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, Vector(-(X0-2), (Y0-10)*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(-(X0-5), (Y0-10)*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(-PA_X,  PA_Y*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(4, Vector(-GA_X, -GA_Y*ballside), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(5, Vector(-PA_X,  0),             buffer, SPA_Knocker);
    
    CurrentSetPlayFormation->SpecifySetPlayAction  (1, MarkerPosition(RM_Their_Goal) , 0);  /* Just get to position */
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, MarkerPosition(RM_Their_Goal) , 0);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (3, Vector(0, Y0*ballside), 20);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (4, Vector(0,-Y0*ballside), 20);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (5, Vector(0, Y0*ballside), 20);  
    break;
  case PM_Their_Goalie_Free_Kick:
    LogAction4(50,"Initializing their goalie freekick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, TheirPenaltyArea.BottomLeftCorner() -Vector(buffer,-buffer), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, Vector(TheirPenaltyArea.LeftX()-buffer,TheirPenaltyArea.BottomY()/2), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, Vector(TheirPenaltyArea.LeftX()-buffer,TheirPenaltyArea.TopY()/2), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(4, TheirPenaltyArea.TopLeftCorner() -Vector(buffer,buffer), buffer, SPA_Knocker);

    CurrentSetPlayFormation->SpecifySetPlayAction  (1, MarkerPosition(RM_Their_Goal) , 0);  /* Just get to position */
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, MarkerPosition(RM_Their_Goal) , 0);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (3, MarkerPosition(RM_Their_Goal) , 0);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (4, MarkerPosition(RM_Their_Goal) , 0);  
    break;
  case PM_Their_Free_Kick:
    LogAction4(50,"Initializing their freekick setplay (ball at %.1f,%.1f)",ball.x,ball.y);
    CurrentSetPlayFormation->SpecifySetPlayPosition(1, Vector(ball.x-10, ball.y), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(2, FieldRectangle.AdjustToWithin(Vector(ball.x-8,  ball.y+5*ballside)), buffer, SPA_Knocker);
    CurrentSetPlayFormation->SpecifySetPlayPosition(3, FieldRectangle.AdjustToWithin(Vector(ball.x-8,  ball.y-5*ballside)), buffer, SPA_Knocker);

    CurrentSetPlayFormation->SpecifySetPlayAction  (1, MarkerPosition(RM_Their_Goal) , 0);  /* Just get to position */
    CurrentSetPlayFormation->SpecifySetPlayAction  (2, MarkerPosition(RM_Their_Goal) , 0);  
    CurrentSetPlayFormation->SpecifySetPlayAction  (3, MarkerPosition(RM_Their_Goal) , 0);  
    break;


  default: return;  /* No set play for that mode */
  }

  /***************************************************/
  /***************************************************/
  /***************************************************/

  /* Go through the positions in order, finding the closest player
     to that position, and mark the player as going there       */
  /* When it's me set my mode to Insetplay                      */

  float minDist;
  int closestPosition, i, closestPlayer;
  int NumPositions = CurrentSetPlayFormation->GetNumPositions();
  int formationSize = MyCurrentFormationSize();
  Bool *PositionAssigned = new Bool[formationSize+1];
  
  for (i=1; i<=formationSize; i++) PositionAssigned[i] = FALSE;

  for (i=1; i<=NumPositions; i++){
    minDist = HUGE;
    if ( i==1 && NextPlayMode == PM_My_Goalie_Free_Kick ){
      /* Goalie starts the setplay after a catch */
      closestPosition = PlayerPosition(FP_goalie_number);
    }
    else {
      for (int position=1; position<=formationSize; position++){
	dist = DistanceToPositionHome(position,CurrentSetPlayFormation->SetPlayPositionHome(i));
	if (dist < minDist && PositionAssigned[position] == FALSE){
	  if ( PositionType(position) != PT_Goaltender ){ /* goalie not in most set plays */
	    minDist = dist;
	    closestPosition = position;
	  }
	}
      }
    }

    closestPlayer = PositionPlayer(closestPosition);
    if ( closestPlayer == Unum_Unknown && MyPosition() == Pnum_Unknown ){
      SetMyPosition(GetNewPosition());
      Say(PMsg_none); /* announce my position */
      closestPlayer = PositionPlayer(closestPosition);
    }

    /*if ( CurrentTime.t > 0 ){
      printf("position %d player %d to set-play position %.1f %.1f\n",closestPosition,closestPlayer,
	     CurrentSetPlayFormation->SetPlayPositionHome(i).x,	   
	     CurrentSetPlayFormation->SetPlayPositionHome(i).y);
      PositionHome(closestPosition).Print();
    }*/

    CurrentSetPlayFormation->AssignSetPlayPosition(i,closestPosition);
    PositionAssigned[closestPosition] = TRUE;

    if ( closestPlayer == MyNumber ){
      LogAction4(30,"InitializeSetPlay:  I'm in the set play (%d of %d)",i,NumPositions);
      InSetPlay = TRUE;
    }
  }
  delete [] PositionAssigned;

  SetPlay = TRUE;
  SetPlayStartTime = 0;                /* Not started yet */
  GotBallInSetPlay = FALSE;
  SetPlayInvokeTime = CurrentTime;
  SetPlayLastSpoke = 0;
  SetPlayTimeLimit = CP_Setplay_Time_Limit;
  SetPlayStartActionChosen = 0;
  SetPlayStartReceiver = Pnum_Unknown;
  HaveBeenInSetPlayPosition = FALSE;
  
  for( i=1; i<=SP_team_size; i++)
    Player_Setplay_Ready[i] = SPnum_Unknown;
  
  if ( MyPosition() == SetPlayStarterPosition() ){
    Confirmed_Setplay_Starter = MyNumber;
    Say(PMsg_Setplay_Starter,TRUE);
  }
  else 
    Confirmed_Setplay_Starter = Unum_Unknown;

  CurrentSetPlayFormation->type = NextPlayMode;
}

/********************************************************************************/

Vector SetplayInfo::PositionSetPlayHome(int pos, Bool AdjustForOffsides)
{
  Vector home = CurrentSetPlayFormation->SetPlayPlayerHome(pos);

  if ( AdjustForOffsides ) 
    home = PositionToAdjustForOffsidePosition(home);
  return home;
}

/********************************************************************************/

Vector SetplayInfo::MySetPlayHome(Bool AdjustForOffsides)
{
  return PositionSetPlayHome(MyPosition(),AdjustForOffsides);
}

/********************************************************************************/

SPnum  SetplayInfo::MySetPlayPosition()
{
  return CurrentSetPlayFormation->SetPlayPlayerPosition(MyPosition());
}

/********************************************************************************/

float  SetplayInfo::MySetPlayPositionBuffer()
{
  return CurrentSetPlayFormation->PositionBuffer(MyPosition());
}

/********************************************************************************/

Bool SetplayInfo::InMySetPlayPosition(Bool AdjustForOffsides)
{
  float dist = MySetPlayHome(AdjustForOffsides).dist(MyPos());
  if (dist < MySetPlayPositionBuffer()){
    HaveBeenInSetPlayPosition = TRUE;
    return TRUE;
  }
  else{
    LogAction4(150,"Not InMySetPlayPosition: (%.2f,%.2f)",MySetPlayHome(AdjustForOffsides).x,
	       MySetPlayHome(AdjustForOffsides).y);
    return FALSE;
  }
}

/********************************************************************************/

Vector SetplayInfo::MySetPlayAimPoint(Bool AdjustForOffsides)
{
  Vector point = CurrentSetPlayFormation->SetPlayPlayerAimPoint(MyPosition());
  if ( AdjustForOffsides )
    point = PositionToAdjustForOffsidePosition(point);
  return point;
}

/********************************************************************************/

Pnum SetplayInfo::MySetPlayAimPosition()
{
  return CurrentSetPlayFormation->AimPosition(MyPosition());
}

/********************************************************************************/

int   SetplayInfo::MySetPlayWaitTime()
{
  return CurrentSetPlayFormation->WaitTime(MyPosition());
}

/********************************************************************************/

SPAtype SetplayInfo::MySetPlayPositionType()
{
  Pnum position = MyPosition();
  if ( position == Pnum_Unknown ) my_error("Setplay position type with no position?");
  return CurrentSetPlayFormation->PositionType(position);
}

/********************************************************************************/

Bool SetplayInfo::SetPlayPositionFilled(SPnum pos, Bool AdjustForOffsides)
{
  Pnum formationPos = CurrentSetPlayFormation->SetPlayPositionPlayer(pos);
  if ( formationPos == Pnum_Unknown ){
    my_error("Why aren't all set play positions filled?");
  }
  Unum player = PositionPlayer(formationPos);
  if ( player == Unum_Unknown || !TeammatePositionValid(player) ) {
    LogAction4(150,"don't know who's playing position  %d   at %d\n", formationPos, CurrentTime.t); 
    return FALSE;
  }

  /* Assuming I know if I'm in place */
  if ( player == MyNumber || (Player_Setplay_Ready[player] == pos) 
       || TeammateDistance2To(player,PositionSetPlayHome(formationPos,AdjustForOffsides)) < 
         Sqr(CurrentSetPlayFormation->PositionBuffer(formationPos)) ){
    Player_Setplay_Ready[player] = pos;  /* once it's true, keep it true */
    return TRUE;
  }
  else {
    LogAction4(150,"Position %d not filled:  Player_Setplay_Ready = %d",pos,Player_Setplay_Ready[player]);
    return FALSE;
  }
}

/********************************************************************************/

Bool SetplayInfo::PositionInSetPlayPosition(Pnum pos, Bool AdjustForOffsides)
{
  SPnum SPpos = CurrentSetPlayFormation->SetPlayPlayerPosition(pos);
  return SetPlayPositionFilled(SPpos,AdjustForOffsides);
}

/********************************************************************************/

Bool SetplayInfo::AllInSetPlayPosition(Bool AdjustForOffsides)
{
  float dist;
  for (int pos=1; pos<=CurrentSetPlayFormation->GetNumPositions(); pos++){

    dist = CurrentSetPlayFormation->SetPlayPositionHome(pos).dist(MySetPlayHome());

    /* Don't worry about far players being in position */
    if ( !SetPlayPositionFilled(pos,AdjustForOffsides) && dist < SP_audio_cut_dist - 5){
      LogAction4(100,"setplay position %d (%d) not filled",pos,
		PositionPlayer(CurrentSetPlayFormation->SetPlayPositionPlayer(pos)));
      return FALSE;
    }
  }
  return TRUE;
}

/********************************************************************************/

Pnum SetplayInfo::SetPlayStarterPosition()
{
  return CurrentSetPlayFormation->Starter();  /* could be Pnum_Unknown */
}

/********************************************************************************/

Bool SetplayInfo::PositionInSetPlay(Pnum pos)
{
  for (int i=1; i<=CurrentSetPlayFormation->GetNumPositions(); i++){
    if ( CurrentSetPlayFormation->SetPlayPositionPlayer(i) == pos )
      return TRUE;
  }
  return FALSE;
}

/********************************************************************************/

Bool SetplayInfo::MyPositionInSetPlay()
{
  return PositionInSetPlay(MyPosition());
}

/********************************************************************************/

Bool SetplayInfo::BallInSetPlayPosition()
{
  //moved to end
  //if ( BallPositionValid() != 1 ) return FALSE;

  Vector ball = BallAbsolutePosition();

  float ball_leeway = 1;
  if ( BallDistance() > 50 ) ball_leeway = 3; /* Might not see it well enough */
  else ball_leeway += 2*(BallDistance()/50);

  switch(PlayMode){
  case PM_Their_Kick_In:
  case PM_My_Kick_In:
    if ( SetPlayBallPositionFromCoachTime >= PlayModeTime-5 ) /* clock might have just started */
      return TRUE; 
    else if ( CurrentTime-(2*CP_Setplay_Delay) > PlayModeTime ) { /* coach must be gone */
      my_error("What happened to the coach??");
      if ( fabs(fabs(ball.y) - SP_pitch_width/2.0) > ball_leeway ) 
	return FALSE; 
      return TRUE;
    }
    else 
      return FALSE;
    break;
  case PM_My_Corner_Kick:
    return TRUE;
/*     if ( fabs(ball.x - SP_pitch_length/2.0) > ball_leeway )      { return FALSE; } */
/*     if ( fabs(fabs(ball.y) - SP_pitch_width/2.0) > ball_leeway ){ return FALSE; } */
    break;
  case PM_Their_Corner_Kick:
    return TRUE;
/*     if ( fabs(ball.x + SP_pitch_length/2.0) > ball_leeway )      { return FALSE; } */
/*     if ( fabs(fabs(ball.y) - SP_pitch_width/2.0) > ball_leeway ){ return FALSE; } */
    break;
  case PM_Before_Kick_Off:
  case PM_Their_Kick_Off:
  case PM_My_Kick_Off:
    return TRUE;
    /* Ball is definitely at 0,0 */
    /* if ( fabs(ball.x) > ball_leeway ){ return FALSE; }
       if ( fabs(ball.y) > ball_leeway ){ return FALSE; }    */
    break;
  case PM_My_Goal_Kick:
    return TRUE;
/*     if ( fabs(ball.x + (SP_pitch_length/2.0 - SP_goal_area_length)) > ball_leeway ){ return FALSE;} */
/*     if ( fabs(fabs(ball.y) - SP_goal_area_width/2.0) > ball_leeway ){ return FALSE;} */
    break;
  case PM_Their_Goal_Kick:
    return TRUE;
/*     if ( fabs(ball.x - (SP_pitch_length/2.0 - SP_goal_area_length)) > ball_leeway ){ return FALSE;} */
/*     if ( fabs(fabs(ball.y) - SP_goal_area_width/2.0) > ball_leeway ){ return FALSE;} */
    break;
  case PM_Their_Offside_Kick:
  case PM_My_Offside_Kick:
  case PM_Their_Free_Kick:
  case PM_My_Free_Kick:
  case PM_Their_Goalie_Free_Kick:
  case PM_My_Goalie_Free_Kick:
    if ( SetPlayBallPositionFromCoachTime >= PlayModeTime-5 ) /* clock might have just started */
      return TRUE; 
    else if ( CurrentTime-(2*CP_Setplay_Delay) > PlayModeTime ) { /* coach must be gone */
      my_error("What happened to the coach??");
      return TRUE;
    }
    else 
      return FALSE;
    break;
  default: return FALSE;  /* No set play for that mode */
  }
  if ( BallPositionValid() < CP_ball_conf_decay ) return FALSE;
  return TRUE;
}

/********************************************************************************/

Vector SetplayInfo::SetPlayBallAbsolutePosition()
{
  if ( !BallPositionValid() ) my_error("Don't know where the ball is -- SetPlayBallAbsolutePosition");

  switch(PlayMode){
  case PM_Their_Kick_In:
  case PM_My_Kick_In:
  case PM_Their_Offside_Kick:
  case PM_My_Offside_Kick:
  case PM_Their_Free_Kick:
  case PM_My_Free_Kick:
  case PM_Their_Goalie_Free_Kick:
  case PM_My_Goalie_Free_Kick:
    if ( SetPlayBallPositionFromCoachTime < PlayModeTime-5 ){ /* Clock might have just started */
      my_error("Haven't heard from coach since play mode changed");
      return BallAbsolutePosition();
    }
    return SetPlayBallPositionFromCoach;
    break;
  case PM_My_Corner_Kick:
    if ( BallY() < 0 ) return MarkerPosition(RM_LF_Flag);
    else               return MarkerPosition(RM_RF_Flag);
  case PM_Their_Corner_Kick:
    if ( BallY() < 0 ) return MarkerPosition(RM_LB_Flag);
    else               return MarkerPosition(RM_RB_Flag);
    break;
  case PM_Before_Kick_Off:
  case PM_Their_Kick_Off:
  case PM_My_Kick_Off:
    return Vector(0,0);
    break;
  case PM_My_Goal_Kick:
    if ( BallY() < 0 ) return MyLeftGoalKickSpot;
    else               return MyRightGoalKickSpot;
    break;
  case PM_Their_Goal_Kick:
    if ( BallY() < 0 ) return TheirLeftGoalKickSpot;
    else               return TheirRightGoalKickSpot;
    break;
  default: return FALSE;  /* No set play for that mode */
  }
  return TRUE;
}

/********************************************************************************/

void SetplayInfo::ModifySetPlayStartAction()
{
  //printf("%d:%d modifying start action\n",MyNumber,CurrentTime.t);

  if ( MySetPlayPositionType() != SPA_Starter )
    my_error("Only the starter should have to modify setplay action");

  /* Send the ball to the earliest filled position */
  /* Otherwise just shoot                          */
  /* Start with pos 1 so not to consider self      */

  int NumSetPlayPositions = CurrentSetPlayFormation->GetNumPositions();

  int choicePosition = 0;

  if ( SetPlayStartActionChosen >= 1 ){ /* don't switch more than twice */
    LogAction2(100,"start action chosen already");
    choicePosition = SetPlayStartReceiver;
  }
  else if ( NumSetPlayPositions > 2 ){  /* There's a choice */
    Bool *filledPositions = new Bool[NumSetPlayPositions+1];

    for (int pos=2; pos<=NumSetPlayPositions; pos++){
      if ( SetPlayPositionFilled(pos) )
	filledPositions[pos] = TRUE;
      else 
	filledPositions[pos] = FALSE;
    }
    
    Pnum formationPos;
    Unum teammates[2];
    
    formationPos = CurrentSetPlayFormation->SetPlayPositionPlayer(2);
    teammates[0] = PositionPlayer(formationPos);
    formationPos = CurrentSetPlayFormation->SetPlayPositionPlayer(3);
    teammates[1] = PositionPlayer(formationPos);

    for (int i=0; i<2; i++){
      if ( teammates[i] == Unum_Unknown || !TeammatePositionValid(teammates[i]) ) filledPositions[i+2]= FALSE;
      else if ( VP_use_DT && PassConfidence(teammates[i])<=0 ) filledPositions[i+2]= FALSE;
    }
    
    if ( filledPositions[2] && filledPositions[3] ){
      if ( VP_use_DT && PassConfidence(teammates[1]) > PassConfidence(teammates[0]) ){
	choicePosition = 3;
	LogAction3(100,"Changing set play start to player %d",teammates[1]);
	//printf("....change\n");
      }
      else{
	choicePosition = 2;
	LogAction3(100,"No change in set play start -- staying with %d",teammates[0]);
	//printf(".... no change\n");
      }
      /* choose better of two */
    }
    else if ( CurrentSetPlayFormation->type == PM_My_Goalie_Free_Kick ){
      if ( filledPositions[2] ){
	LogAction3(100,"modify goalie setplay: %d Only one with positive DT",teammates[0]);
	choicePosition = 2;
      }
      else if ( filledPositions[3] ){
	LogAction3(100,"modify goalie setplay: %d Only one with positive DT",teammates[1]);
	choicePosition = 3;
      }
      else if ( SetPlayPositionFilled(2) && !SetPlayPositionFilled(3) ){
	LogAction3(100,"modify goalie setplay: %d Only one filled",teammates[0]);
	choicePosition = 2;
      }
      else if ( SetPlayPositionFilled(3) && !SetPlayPositionFilled(2) ){
	LogAction3(100,"modify goalie setplay: %d Only one filled",teammates[1]);
	choicePosition = 3;
      }
      else if ( SetPlayPositionFilled(3) && SetPlayPositionFilled(2) ){
	/* go to the side with fewer opps */
	int left_count = 0, right_count = 0;
	for (int opp=1; opp<=SP_team_size; opp++){
	  if ( !OpponentPositionValid(opp) ) continue;
	  if ( OpponentY(opp) > OwnGoalieArea.BottomY() ) right_count++;
	  else if ( OpponentY(opp) < OwnGoalieArea.TopY() ) left_count++;
	}
	if ( left_count > right_count ){
	  LogAction2(100,"modify goalie setplay: more opponents on left");
	  if ( TeammateY(teammates[0]) > 0 ) choicePosition = 2;
	  else choicePosition = 3;
	}
	else if ( right_count > left_count ){
	  LogAction2(100,"modify goalie setplay: more opponents on right");
	  if ( TeammateY(teammates[0]) < 0 ) choicePosition = 2;
	  else choicePosition = 3;
	}
      }
    }
    
    if (!choicePosition) {
      for (int pos=2; pos<=NumSetPlayPositions; pos++)
	if ( SetPlayPositionFilled(pos) ){  /* Take first filled position */
	  choicePosition = pos;
	  LogAction3(100,"taking first filled position to start set play: %d",choicePosition);
	  break;
	}
    }
    delete [] filledPositions;
  }
  else { /* There's no choice.  Just check if the player's there */
    LogAction2(100,"only one other in set play anyway");
    if ( SetPlayPositionFilled(2) )
      choicePosition = 2;
  }

  if ( choicePosition ){
    SetPlayStartReceiver = choicePosition;
    SetPlayStartActionChosen++;
    CurrentSetPlayFormation->SpecifySetPlayAction(1,choicePosition,10);
    //printf("%d:%d choicePosition = %d\n",MyNumber,CurrentTime.t,choicePosition);
    return;
  }

  /* Nobody in position */
  LogAction3(100,"There's nobody in position %d!",choicePosition);
  //printf("%d:%d nobody in position = %d\n",MyNumber,CurrentTime.t,choicePosition);
  /* leave it as is -- setplay should clear */
}

