/* -*- Mode: C++ -*- */
#include "types.h"
#include "MemPat.h"
#include "test.h"
#include "kick.h"
#include "intercept.h"
#include "dribble.h"
#include "behave.h"

#ifdef DEBUG_OUTPUT
#define Debug1v1(x) x
#define Debug1v1D(x)
#define Debug1v1O(x) 
#define DebugBlock(x) x
#else
#define Debug1v1(x) 
#define Debug1v1D(x)
#define Debug1v1O(x) 
#define DebugBlock(x) 
#endif

void PatsTest_vel() 
{
  if (Mem->CurrentTime.t > 0) {
    if (Mem->BallVelocityValid())
      printf("%d 1 %f %f %f\n", Mem->CurrentTime.t,
	     Mem->BallAbsoluteVelocity().x, Mem->BallAbsoluteVelocity().y,
	     Mem->BallSpeed());
    else
      printf("%d 0 0 0 0\n", Mem->CurrentTime.t);
  }
}

void PatsTest_1v1()
{
  if (Mem->MyNumber == 1) {
    
    static int First_time = TRUE;
    if ( First_time ){
      move(-10,0);
      First_time=FALSE;
      return;
    }

    if (!Mem->MyConf())
      scan_field_with_body();
    
    static Vector targ(25, 0);
    // Rectangle rec(-15, 15, -20, 10);

    //Debug1v1(cout << "Time: " << Mem->CurrentTime.t << "at 1v1\n");
    if (!strcmp(Mem->MyTeamName, "CMUnited")) {
      if (!Mem->BallPositionValid())
	face_neck_to_ball();
      else if (Offensive1v1(targ, 75))
	targ = Vector(-targ.x, range_random(-10, 10));
    } else {
      DebugBlock(printf("Time: %d\n", Mem->CurrentTime.t));
      //      Defensive1v1_block(FALSE, 75);
      Unum opp = Mem->ClosestOpponent();
      if (opp == Unum_Unknown)
	scan_field_with_body();
      else if (Mem->BallKickable())
	TurnballTo(Mem->OpponentAngleFromBody(opp)+180);
      else if (!Mem->BallPositionValid())
	face_neck_to_ball();
      else if (defensive_block_opponent(opp, 75,
					//Vector(Mem->SP_pitch_length/2,0))
					Mem->MarkerPosition(Mem->RM_My_Goal))
	       == AQ_ActionNotQueued)
	face_neck_and_body_to_opponent(opp);
    }
    
    
  } else {
    /* stand and watch and shout to teammate */
    static int First_time = TRUE;
    if ( First_time ){
      move(0,-20);
      First_time=FALSE;
      return;
    }

    if (fabs(Mem->MyNeckGlobalAng() - 90) > 5) {
      turn(90 - Mem->MyNeckGlobalAng());
      return;
    }

    if (Mem->ViewWidth != VW_Wide)
      change_view(VW_Wide);

    if (Mem->CurrentTime.t % 5 == 1)
      Mem->SayToPlayer(1, PMsg_none);
    
  }
}

int Offensive1v1(Vector targPos, float dash_power)
{
  Unum opponent;
  AngleDeg ang;
  Debug1v1O(cout << endl << "Time: " << Mem->CurrentTime.t << " at 1v1\n");
  if ( (opponent = Mem->ClosestOpponent()) != Unum_Unknown ){
    ang = Mem->OpponentAngleFromBody(opponent) + 180;
    NormalizeAngleDeg(&ang);
    Debug1v1O(cout << "Opponent ang: " << ang << endl);
  }
  //SMURF:
  if (Mem->BallKickable())
    Debug1v1O(cout << "KeepBall: " << Mem->CanKeepBall() << endl);
    {
    Line trajLine = LineFromTwoPoints(Mem->MyPos(), targPos);
    /*
    if (!Mem->BallKickable(Mem->CP_collision_buffer) ||
	((opponent == Unum_Unknown ||
	  fabs(Mem->OpponentAngle(opponent) + Mem->MyAng() -
	       (targPos - Mem->MyPos()).dir()) > 80) ||
	 (fabs(GetNormalizeAngleDeg(ang - Mem->BallAngle())) < 20 &&
	  (trajLine.dist(Mem->OpponentAbsolutePosition(opponent)) > 1 ||
	   Mem->OpponentDistance(opponent) > 4)))) {
	   */
    //SMURF: numbers shoudl be options in the followin if
    if (!Mem->BallKickable(Mem->CP_collision_buffer) ||
	opponent == Unum_Unknown ||
	Mem->IsOpponentBehind(opponent, targPos) ||
	Mem->move_importance_1v1 > Mem->CP_move_imp_1v1_threshold ||	
	Mem->OpponentDistance(opponent) > 4 ||
	trajLine.dist(Mem->OpponentAbsolutePosition(opponent)) > 1.5) {	
      Debug1v1O(cout << "SmartDribbleTo\n");	  
      DribbleRes res = SmartDribbleTo(targPos, dash_power);
      //	DribbleRes res = DribbleTo(pos, dash_power, 1, drib_ang, DM_Lazy);
      if (Mem->LastAction->type == CMD_dash)
	Mem->move_importance_1v1 = Mem->CP_move_imp_1v1_initial;
      Debug1v1O(printf("DribRes: %d\n", res));
      if (res == DR_GotThere) {    
	if (Mem->BallKickable()) {	  
	  stop_ball();
	} else {
	  if (Mem->MyInterceptionAble(dash_power))
	    go_to_point(Mem->MyInterceptionPoint(dash_power));
	}	
	return 1;
      } else if (res == DR_LostBall) {
	/* go to intercept */
	if (Mem->MyInterceptionAble(dash_power)) {
	  if (Mem->BallKickable())
	    stop_ball();
	  else
	    go_to_point(Mem->MyInterceptionPoint(dash_power));
	} else
	  my_error("Lost ball and can't intercept it");
      }
    } else {
      Debug1v1O(cout << "can't dribble, turnballing\n");
      TurnballTo(ang, TURN_AVOID);
      Mem->move_importance_1v1 += Mem->CP_move_imp_1v1_inc;
    }
  }
  
  return 0;
}


void Defensive1v1(DodgeType dodge, float dash_power)
{
  Debug1v1D(cout << "Time: " << Mem->CurrentTime.t << " at 1v1\n");
  if ( Mem->BallPositionValid() ){
    if ( Mem->BallKickable() ) {
      AngleDeg ang = 0;
      Unum opponent;
      if ( (opponent = Mem->ClosestOpponent()) != Unum_Unknown ){
	ang = Mem->OpponentAngleFromBody(opponent) + 180;
	NormalizeAngleDeg(&ang);
      }

      if ( opponent == Unum_Unknown ){
	if ( Mem->TimeToTurnForScan() )
	  turn(Mem->MyViewAngle() * 2);
      }
      else if ( Mem->OpponentPositionValid(opponent) < .9 ) {
	Debug1v1D(cout << "turning to opponent\n");	
	turn( Mem->OpponentAngleFromNeck(opponent) );
      } else {
	TurnballTo(ang,TURN_CW);
      }
      
    }
    else {
      Debug1v1D(cout << "test_go_to_ball\n");
      go_to_point(Mem->BallAbsolutePosition(), 1, dash_power, dodge);
      //test_go_to_ball();
    }
    
  }
  else {
    Debug1v1D(cout << "test_face_ball\n");
    test_face_ball();
  }
  
}

#ifdef SNORK
/* trys to stay between the player and the goal */ 
/* if the player beats him, he'll overrun and come back */
void Defensive1v1_block(float dash_power, Vector block_targ)
{
  DebugBlock(cout << endl << "Time: " << Mem->CurrentTime.t << " at 1v1\n");
  if ( Mem->BallPositionValid() ) {
    AngleDeg ang = 0;
    Unum opponent;
    if ( (opponent = Mem->ClosestOpponent()) != Unum_Unknown ){
      ang = Mem->OpponentAngle(opponent) + 180;
      NormalizeAngleDeg(&ang);
      DebugBlock(cout << "Closest Opponent is " << opponent << endl);
    }
    
    if ( opponent == Unum_Unknown ){
      if ( Mem->TimeToTurnForScan() ) {
	DebugBlock(cout << "lost opponent, turning to find" << endl);
	turn(Mem->MyViewAngle() * 2);
      }      
    }
    else if ( Mem->OpponentPositionValid(opponent) < .9 ) {
      DebugBlock(cout << "turning to opponent\n");	
      turn( Mem->OpponentAngle(opponent) );
    } else if ( Mem->BallKickable() ) {
      //SMURF: waht shoudl defense do with a kickable ball
      DebugBlock(cout << "Got ball trying to turnball" << endl);
      TurnballTo(ang,TURN_CW);
    } else {
      //SMURF is there an cleaner way to say center of goal?
      /* passing a negative argument gives a more liberal answer */
      if ((Mem->def_block_overrun_time == Mem->CurrentTime - 1 &&
	   Mem->def_block_overrun) ||
	  Mem->OpponentX(opponent) < Mem->MyX()) {
	change_view(VW_Wide);	
	/* opponent is past us, and we're overrunning */
 	DebugBlock(cout << "Overrunning opponent" << endl);
	DebugBlock(cout << "Opponent position"
		  << Mem->OpponentAbsolutePosition(opponent) << endl);
	Vector disp = GetOverrunBlockPos(block_targ, opponent);
	disp +=  (disp * (Mem->CP_overrun_buffer / disp.mod()))
	  .rotate(signf(Mem->OpponentY(opponent) - Mem->MyY()) * 90);
	Vector targ = Mem->OpponentAbsolutePosition(opponent) + disp;
	DebugBlock(cout << "MyPos: " << Mem->MyPos() << endl);
	DebugBlock(cout << "targ: " << targ << endl);
	if (Mem->DistanceTo(targ) < Mem->CP_at_point_buffer) {	    
	  Mem->def_block_overrun = FALSE;
	  Mem->def_block_overrun_time = Mem->CurrentTime;  
	} else {
	  //SMURF: use greater dash power?
	  go_to_point(targ, Mem->CP_at_point_buffer, 100);
	  Mem->def_block_overrun = TRUE;
	  Mem->def_block_overrun_time = Mem->CurrentTime;  
	}	  

      }
      if (!(Mem->def_block_overrun_time == Mem->CurrentTime &&
	    Mem->def_block_overrun)) {
	DebugBlock(cout << "BallPos: " << Mem->BallAbsolutePosition() << endl);
	DebugBlock(cout << "OppPos : " << Mem->OpponentAbsolutePosition(opponent) << endl);
	DebugBlock(cout << "Dist: " << (Mem->BallAbsolutePosition() - Mem->OpponentAbsolutePosition(opponent)).mod() << endl);
	if (Mem->BallKickableForOpponent(opponent, -Mem->CP_collision_buffer)) {  
	  DebugBlock(cout << "blocking opponent	" << endl);
	  if (!move_to_point_in_between(Mem->OpponentAbsolutePosition(opponent),
			       block_targ, Mem->CP_def_block_dist, dash_power)) {
	    //SMURF: do something else now?
	    //turn to opponent
	  }
	  
	  Mem->def_block_overrun = FALSE;
	  Mem->def_block_overrun_time = Mem->CurrentTime;  
	} else {
	  DebugBlock(cout << "Calling test_go_to_ball" << endl);
	  test_go_to_ball();
	}
      }
      
    }
    
  } else {
    DebugBlock(cout << "test_face_ball\n");
    test_face_ball();
  }
}
#endif





void PatsTest_clear() 
{
  if (!strcmp(Mem->MyTeamName, "CMUnited")) {    
    if (Mem->PlayMode == PM_Before_Kick_Off)
      move(-35, 20);
    else if (!Mem->MyConf())
      scan_field_with_body();
    else if (Mem->BallKickable())
      clear_ball();
    else
      scan_field_with_body();
  } else {
    if (!Mem->MyConf())
      scan_field_with_body();
  }
}








void PatInfo::Initialize()
{
  ;
  //set our variables
  move_importance_1v1 = Mem->CP_move_imp_1v1_initial;
  idle_cycles = 0;
}





void PatInfo::TestPred() 
{
  static int FirstTime = 1;
  static Vector p[5];
  
  if (FirstTime) {
    move(-30, 5);
    FirstTime = 0;
    return;
  }

  printf("Time: %d\n", CurrentTime.t);
  switch (CurrentTime.t % 10) {    
  case 0:
    cout << "MyPos: " << MyPos() << endl;
    {      
    for (int i=0; i<5; i++) {
      p[i] = MyPredictedPosition(i+1, 50);
      cout << " Pred " << i+1 << ":" << p[i] << endl;
    }
    }    
    /*
    turn(40); 
    break; */
  case 1:
  case 2:
  case 3:
  case 4:
    cout << "MyPos: " << MyPos() << "\tPred: " << p[(CurrentTime.t % 10)-1] << endl;
    cout << "Diff: " << (MyPos() - p[(CurrentTime.t % 10)-1]).mod() << endl;
    dash(50);
    break;
  }
  
  return;
}

void PatInfo::TestPred2()
{
  if (MyNumber == 2) {
    cout << "player 2" << endl;
    Vector PlayerDash =
      Polar2Vector(100*SP_dash_power_rate, 0);
    for (int i=0; i<5; i++) {      
      //cout << i << endl;
      /*
      Vector vEndSpot =
	PlayerPredictedPosition(MySide, 1, i, PlayerDash);
	*/
      //printf("about to get player\n");
      fflush(stdout);
      PlayerObject *pPlay = GetPlayer(MySide,1);
      if (pPlay != NULL) {	
	//printf("about to est	imate future\n");
	fflush(stdout);
	Vector vEndSpot = pPlay->estimate_future_pos(i, 0, PlayerDash);
	cout << "Pred " << i << ": " << vEndSpot << endl;
      }
      
    }
    
  }  
}

void PatInfo::TestPosVelEst()
{
  if (ViewWidth != VW_Normal)
    change_view(VW_Normal);

  if (!MyConf() || !BallKickable())
    return;
  
  if (fabs(MyNeckGlobalAng() - 90) > 5) {    
    turn(90 - MyNeckGlobalAng());
    return;
  }  

  static AngleDeg ang = 90;
  static TurnDir rot  = TURN_CCW;
  
  KickToRes res = TurnballTo(ang, rot);
  if (res == KT_Success) {
    ang = -ang;
    rot = (TurnDir)-rot;
  }
  
}







