/* -*- Mode: C++ -*- */
#include "MemFormation.h"

/************************ 4-3-3 Formation ********************************/

#define f433_GOALIE           1
#define f433_SWEEPER         (f433_GOALIE         +1)
#define f433_RIGHT_DEFENSE   (f433_SWEEPER        +1)
#define f433_CENTER_DEFENSE  (f433_RIGHT_DEFENSE  +1)
#define f433_LEFT_DEFENSE    (f433_CENTER_DEFENSE +1)
#define f433_RIGHT_MIDFIELD  (f433_LEFT_DEFENSE   +1)
#define f433_CENTER_MIDFIELD (f433_RIGHT_MIDFIELD +1) 
#define f433_LEFT_MIDFIELD   (f433_CENTER_MIDFIELD+1) 
#define f433_RIGHT_WING      (f433_LEFT_MIDFIELD  +1) 
#define f433_CENTER_FORWARD  (f433_RIGHT_WING     +1) 
#define f433_LEFT_WING       (f433_CENTER_FORWARD +1) 


/************************ 4-4-2 Formation ********************************/

#define f442_GOALIE                     1
#define f442_SWEEPER                   (f442_GOALIE         +1)
#define f442_RIGHT_DEFENSE             (f442_SWEEPER        +1)
#define f442_CENTER_DEFENSE            (f442_RIGHT_DEFENSE  +1)
#define f442_LEFT_DEFENSE              (f442_CENTER_DEFENSE +1)
#define f442_RIGHT_MIDFIELD            (f442_LEFT_DEFENSE   +1)
#define f442_DEFENSIVE_CENTER_MIDFIELD (f442_RIGHT_MIDFIELD +1) 
#define f442_OFFENSIVE_CENTER_MIDFIELD (f442_DEFENSIVE_CENTER_MIDFIELD +1) 
#define f442_LEFT_MIDFIELD             (f442_OFFENSIVE_CENTER_MIDFIELD+1) 
#define f442_RIGHT_WING                (f442_LEFT_MIDFIELD  +1) 
#define f442_LEFT_WING                 (f442_RIGHT_WING +1) 


/************************ 3-5-2 Formation ********************************/

#define f352_GOALIE                   1
#define f352_SWEEPER                 (f352_GOALIE         +1)
#define f352_RIGHT_DEFENSE           (f352_SWEEPER        +1)
#define f352_LEFT_DEFENSE            (f352_RIGHT_DEFENSE  +1)
#define f352_RIGHT_OUTSIDE_MIDFIELD  (f352_LEFT_DEFENSE   +1)
#define f352_RIGHT_INSIDE_MIDFIELD   (f352_RIGHT_OUTSIDE_MIDFIELD   +1)
#define f352_CENTER_MIDFIELD         (f352_RIGHT_INSIDE_MIDFIELD +1) 
#define f352_LEFT_INSIDE_MIDFIELD    (f352_CENTER_MIDFIELD+1) 
#define f352_LEFT_OUTSIDE_MIDFIELD   (f352_LEFT_INSIDE_MIDFIELD+1) 
#define f352_RIGHT_WING              (f352_LEFT_OUTSIDE_MIDFIELD  +1) 
#define f352_LEFT_WING               (f352_RIGHT_WING     +1) 


/************************ 7-2 Formation ********************************/

#define f72_RIGHT_GOALIE             1
#define f72_LEFT_GOALIE             (f72_RIGHT_GOALIE   +1)
#define f72_RIGHT_DEFENSE           (f72_LEFT_GOALIE    +1)
#define f72_CENTER_DEFENSE          (f72_RIGHT_DEFENSE  +1)
#define f72_LEFT_DEFENSE            (f72_CENTER_DEFENSE +1)
#define f72_RIGHT_OUTSIDE_MIDFIELD  (f72_LEFT_DEFENSE   +1)
#define f72_RIGHT_INSIDE_MIDFIELD   (f72_RIGHT_OUTSIDE_MIDFIELD   +1)
#define f72_LEFT_INSIDE_MIDFIELD    (f72_RIGHT_INSIDE_MIDFIELD +1) 
#define f72_LEFT_OUTSIDE_MIDFIELD   (f72_LEFT_INSIDE_MIDFIELD+1) 
#define f72_RIGHT_WING              (f72_LEFT_OUTSIDE_MIDFIELD  +1) 
#define f72_LEFT_WING               (f72_RIGHT_WING     +1) 

/************************ 3-3-4 Formation ********************************/

#define f334_GOALIE                   1
#define f334_SWEEPER                 (f334_GOALIE         +1)
#define f334_RIGHT_DEFENSE           (f334_SWEEPER        +1)
#define f334_LEFT_DEFENSE            (f334_RIGHT_DEFENSE  +1)
#define f334_RIGHT_MIDFIELD          (f334_LEFT_DEFENSE   +1)
#define f334_CENTER_MIDFIELD         (f334_RIGHT_MIDFIELD +1) 
#define f334_LEFT_MIDFIELD           (f334_CENTER_MIDFIELD+1) 
#define f334_RIGHT_WING              (f334_LEFT_MIDFIELD  +1) 
#define f334_RIGHT_INSIDE_FORWARD    (f334_RIGHT_WING     +1) 
#define f334_LEFT_INSIDE_FORWARD     (f334_RIGHT_INSIDE_FORWARD +1) 
#define f334_LEFT_WING               (f334_LEFT_INSIDE_FORWARD  +1) 

/************************ 2-4-4 Formation ********************************/

#define f244_GOALIE                   1
#define f244_RIGHT_DEFENSE           (f244_GOALIE         +1)
#define f244_LEFT_DEFENSE            (f244_RIGHT_DEFENSE  +1)
#define f244_RIGHT_MIDFIELD          (f244_LEFT_DEFENSE   +1)
#define f244_DEFENSIVE_CENTER_MIDFIELD (f244_RIGHT_MIDFIELD +1) 
#define f244_OFFENSIVE_CENTER_MIDFIELD (f244_DEFENSIVE_CENTER_MIDFIELD+1) 
#define f244_LEFT_MIDFIELD             (f244_OFFENSIVE_CENTER_MIDFIELD+1) 
#define f244_RIGHT_WING              (f244_LEFT_MIDFIELD  +1) 
#define f244_RIGHT_INSIDE_FORWARD    (f244_RIGHT_WING     +1) 
#define f244_LEFT_INSIDE_FORWARD     (f244_RIGHT_INSIDE_FORWARD +1) 
#define f244_LEFT_WING               (f244_LEFT_INSIDE_FORWARD  +1) 

/************************ 4-3-2 Formation ********************************/

#define f532_GOALIE                     1
#define f532_RIGHT_SWEEPER             (f532_GOALIE         +1)
#define f532_LEFT_SWEEPER              (f532_RIGHT_SWEEPER  +1)
#define f532_RIGHT_DEFENSE             (f532_LEFT_SWEEPER   +1)
#define f532_CENTER_DEFENSE            (f532_RIGHT_DEFENSE  +1)
#define f532_LEFT_DEFENSE              (f532_CENTER_DEFENSE +1)
#define f532_RIGHT_MIDFIELD            (f532_LEFT_DEFENSE   +1)
#define f532_CENTER_MIDFIELD           (f532_RIGHT_MIDFIELD +1) 
#define f532_LEFT_MIDFIELD             (f532_CENTER_MIDFIELD+1) 
#define f532_RIGHT_WING                (f532_LEFT_MIDFIELD  +1) 
#define f532_LEFT_WING                 (f532_RIGHT_WING +1) 

/************************ RIGHT Formation ********************************/

#define fRT_GOALIE                    1
#define fRT_INSIDE_FULLBACK           (fRT_GOALIE          +1)
#define fRT_OUTSIDE_FULLBACK          (fRT_INSIDE_FULLBACK +1)
#define fRT_INSIDE_QTRBACK            (fRT_OUTSIDE_FULLBACK+1)
#define fRT_OUTSIDE_QTRBACK           (fRT_INSIDE_QTRBACK  +1)
#define fRT_INSIDE_HALFBACK           (fRT_OUTSIDE_QTRBACK +1)
#define fRT_OUTSIDE_HALFBACK          (fRT_INSIDE_HALFBACK +1)
#define fRT_INSIDE_3QTRBACK           (fRT_OUTSIDE_HALFBACK+1)
#define fRT_OUTSIDE_3QTRBACK          (fRT_INSIDE_3QTRBACK +1) 
#define fRT_INSIDE_FORWARD            (fRT_OUTSIDE_3QTRBACK+1) 
#define fRT_OUTSIDE_FORWARD           (fRT_INSIDE_FORWARD  +1) 

/************************ LEFT  Formation ********************************/

#define fLT_GOALIE                    1
#define fLT_INSIDE_FULLBACK           (fLT_GOALIE          +1)
#define fLT_OUTSIDE_FULLBACK          (fLT_INSIDE_FULLBACK +1)
#define fLT_INSIDE_QTRBACK            (fLT_OUTSIDE_FULLBACK+1)
#define fLT_OUTSIDE_QTRBACK           (fLT_INSIDE_QTRBACK  +1)
#define fLT_INSIDE_HALFBACK           (fLT_OUTSIDE_QTRBACK +1)
#define fLT_OUTSIDE_HALFBACK          (fLT_INSIDE_HALFBACK +1)
#define fLT_INSIDE_3QTRBACK           (fLT_OUTSIDE_HALFBACK+1)
#define fLT_OUTSIDE_3QTRBACK          (fLT_INSIDE_3QTRBACK +1) 
#define fLT_INSIDE_FORWARD            (fLT_OUTSIDE_3QTRBACK+1) 
#define fLT_OUTSIDE_FORWARD           (fLT_INSIDE_FORWARD  +1) 




/*************************************************************************/
/*************************************************************************/
/************************ FORMATION DEFINITIONS **************************/
/*************************************************************************/
/*************************************************************************/

/*************************************************************************/
/************************ 4-3-3 Formation ********************************/
/*************************************************************************/

#define f433_GOALIE_BUF      2
#define f433_POSITION_BUF    3

#define f433_GOALTENDERX  (-52)
#define f433_SWEEPERX     (-43)
#define f433_DEFENDERX    (-35)
#define f433_MIDFIELDERX     0
#define f433_FORWARDX       30
#define f433_RIGHTY         25
#define f433_CENTERY         0
#define f433_LEFTY       (-25)

#define f433_HOMEXRANGE f433_FORWARDX
#define f433_HOMEYRANGE f433_RIGHTY
#define f433_MAXXRANGE  (f433_FORWARDX*2)
#define f433_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f433_RIGHTY)*2)

void FormationInfo::Initialize_433_Formation(){

  /* set position within goal stay, in penalty box      */
  Formation_433->SetPosition(f433_GOALIE, Vector(f433_GOALTENDERX,f433_CENTERY), f433_GOALIE_BUF, 
			     Vector(f433_GOALTENDERX,f433_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f433_GOALTENDERX))*2,SP_goal_width),
			     Vector(f433_GOALTENDERX,f433_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f433_GOALTENDERX))*2,SP_goal_width),
			     PT_Goaltender,PS_Center);

  /* set position inside penalty box, don't go more than half-way to mid  */
  Formation_433->SetPosition(f433_SWEEPER, Vector(f433_SWEEPERX,f433_CENTERY), f433_POSITION_BUF, 
			     Vector(f433_SWEEPERX,f433_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f433_SWEEPERX))*2,(SP_penalty_area_width/2.0)*2),
			     Vector(f433_SWEEPERX,f433_CENTERY),
			     Vector(-f433_SWEEPERX - (SP_pitch_length/2.0)/2,((SP_pitch_width/2.0)+5)*2),
			     PT_Sweeper,PS_Center);

  Formation_433->SetPosition(f433_RIGHT_DEFENSE, Vector(f433_DEFENDERX,f433_RIGHTY), f433_POSITION_BUF, 
			     Vector(f433_DEFENDERX,f433_RIGHTY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_DEFENDERX,f433_RIGHTY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Defender, PS_Right);

  Formation_433->SetPosition(f433_CENTER_DEFENSE, Vector(f433_DEFENDERX+5,f433_CENTERY), f433_POSITION_BUF, 
			     Vector(f433_DEFENDERX+5,f433_CENTERY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_DEFENDERX+5,f433_CENTERY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Defender, PS_Center);

  Formation_433->SetPosition(f433_LEFT_DEFENSE, Vector(f433_DEFENDERX,f433_LEFTY), f433_POSITION_BUF, 
			     Vector(f433_DEFENDERX,f433_LEFTY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_DEFENDERX,f433_LEFTY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Defender, PS_Left);

  Formation_433->SetPosition(f433_RIGHT_MIDFIELD, Vector(f433_MIDFIELDERX,f433_RIGHTY), f433_POSITION_BUF, 
			     Vector(f433_MIDFIELDERX,f433_RIGHTY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_MIDFIELDERX,f433_RIGHTY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Midfielder, PS_Right);

  Formation_433->SetPosition(f433_CENTER_MIDFIELD, Vector(f433_MIDFIELDERX,f433_CENTERY), f433_POSITION_BUF, 
			     Vector(f433_MIDFIELDERX,f433_CENTERY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_MIDFIELDERX,f433_CENTERY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_433->SetPosition(f433_LEFT_MIDFIELD, Vector(f433_MIDFIELDERX,f433_LEFTY), f433_POSITION_BUF, 
			     Vector(f433_MIDFIELDERX,f433_LEFTY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_MIDFIELDERX,f433_LEFTY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Midfielder, PS_Left);
  
  Formation_433->SetPosition(f433_RIGHT_WING, Vector(f433_FORWARDX,f433_RIGHTY), f433_POSITION_BUF, 
			     Vector(f433_FORWARDX,f433_RIGHTY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_FORWARDX,f433_RIGHTY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Forward, PS_Right);

  Formation_433->SetPosition(f433_CENTER_FORWARD, Vector(f433_FORWARDX+5,f433_CENTERY), f433_POSITION_BUF, 
			     Vector(f433_FORWARDX+5,f433_CENTERY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_FORWARDX+5,f433_CENTERY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Forward, PS_Center);

  Formation_433->SetPosition(f433_LEFT_WING, Vector(f433_FORWARDX,f433_LEFTY), f433_POSITION_BUF, 
			     Vector(f433_FORWARDX,f433_LEFTY),
			     Vector(f433_HOMEXRANGE,f433_HOMEYRANGE),
			     Vector(f433_FORWARDX,f433_LEFTY),
			     Vector(f433_MAXXRANGE ,f433_MAXYRANGE),
			     PT_Forward, PS_Left);

  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=Formation_433->GetSize(); i++)
    Formation_433->SetCandidateReceivers(i,0,dummylist);

  Formation_433->AllocateUnits(6);

  /* Positions listed in order of importance, captain indicated as index into list */

  Pnum defenders[5] = {f433_GOALIE, f433_SWEEPER,
		      f433_CENTER_DEFENSE, f433_RIGHT_DEFENSE, f433_LEFT_DEFENSE};
  Formation_433->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 5, defenders, 0);

  Pnum midfielders[3] = {f433_CENTER_MIDFIELD, f433_RIGHT_MIDFIELD, f433_LEFT_MIDFIELD};
  Formation_433->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 3, midfielders, 0);

  Pnum forwards[3] = {f433_CENTER_FORWARD, f433_RIGHT_WING, f433_LEFT_WING};
  Formation_433->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 3, forwards, 0);

  Pnum rights[3] = {f433_RIGHT_DEFENSE, f433_RIGHT_MIDFIELD, f433_RIGHT_WING};
  Formation_433->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f433_GOALIE, f433_SWEEPER, f433_CENTER_DEFENSE, 
		    f433_CENTER_MIDFIELD, f433_CENTER_FORWARD};
  Formation_433->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 3);

  Pnum lefts[3] = {f433_LEFT_DEFENSE, f433_LEFT_MIDFIELD, f433_LEFT_WING};
  Formation_433->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);
}

/*************************************************************************/

int Formation::Build_433_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;

  switch ( position ){
  case f433_CENTER_FORWARD: 
    NumOptions = 2;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
  case f433_LEFT_WING:
    NumOptions = 2;
    PreferenceList[0] = f433_CENTER_FORWARD;
    PreferenceList[1] = f433_RIGHT_WING;
  case f433_RIGHT_WING:
    NumOptions = 2;
    PreferenceList[0] = f433_CENTER_FORWARD;
    PreferenceList[1] = f433_LEFT_WING;
    break;
  case f433_CENTER_MIDFIELD:
    NumOptions = 5;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
    PreferenceList[2] = f433_CENTER_FORWARD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD :f433_LEFT_MIDFIELD;
    PreferenceList[4] = (LocationSide == FS_Right) ? f433_LEFT_MIDFIELD :f433_RIGHT_MIDFIELD;
    break;
  case f433_RIGHT_MIDFIELD:
  case f433_LEFT_MIDFIELD:
    NumOptions = 4;
    PreferenceList[0] = f433_CENTER_FORWARD;
    PreferenceList[1] = f433_CENTER_MIDFIELD;
    PreferenceList[2] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[3] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
    break;
  case f433_CENTER_DEFENSE:    
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD : f433_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_MIDFIELD : f433_RIGHT_MIDFIELD;
    PreferenceList[2] = f433_CENTER_MIDFIELD;
    break;
  case f433_RIGHT_DEFENSE:
  case f433_LEFT_DEFENSE:
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD : f433_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[2] = f433_CENTER_MIDFIELD;
    break;
  case f433_SWEEPER:
  case f433_GOALIE:
    NumOptions = 7;
    PreferenceList[0] = (LocationSide == FS_Right) ? f433_RIGHT_DEFENSE : f433_LEFT_DEFENSE;
    PreferenceList[1] = (LocationSide == FS_Right) ? f433_LEFT_DEFENSE : f433_RIGHT_DEFENSE;
    PreferenceList[2] = (LocationSide == FS_Right) ? f433_RIGHT_MIDFIELD : f433_LEFT_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f433_LEFT_MIDFIELD : f433_RIGHT_MIDFIELD;
    PreferenceList[4] = f433_CENTER_MIDFIELD;
    PreferenceList[5] = (LocationSide == FS_Right) ? f433_RIGHT_WING : f433_LEFT_WING;
    PreferenceList[6] = (LocationSide == FS_Right) ? f433_LEFT_WING : f433_RIGHT_WING;
    break;
  }	

  for (int i = NumOptions; i<size; i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}



/*************************************************************************/
/************************ 4-4-2 Formation ********************************/
/*************************************************************************/

#define f442_GOALIE_BUF      2
#define f442_POSITION_BUF    3

#define f442_GOALTENDERX  (-52)
#define f442_SWEEPERX     (-43)
#define f442_DEFENDERX    (-35)
#define f442_MIDFIELDERX     0
#define f442_FORWARDX       30
#define f442_RIGHTY         25
#define f442_INSIDERIGHTY   15
#define f442_CENTERY         0
#define f442_INSIDELEFTY (-f442_INSIDERIGHTY)
#define f442_LEFTY       (-f442_RIGHTY)

#define f442_HOMEXRANGE f442_FORWARDX
#define f442_HOMEYRANGE f442_RIGHTY
#define f442_MAXXRANGE  (f442_FORWARDX*2)
#define f442_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f442_RIGHTY)*2)
#define f442_INSIDE_MAXYRANGE ((((SP_pitch_width/2.0)+5) - f442_INSIDERIGHTY)*2)


void FormationInfo::Initialize_442_Formation(){
  
  /* set position within goal stay, in penalty box      */
  Formation_442->SetPosition(f442_GOALIE, Vector(f442_GOALTENDERX,f442_CENTERY), f442_GOALIE_BUF, 
			     Vector(f442_GOALTENDERX,f442_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f442_GOALTENDERX))*2,SP_goal_width),
			     Vector(f442_GOALTENDERX,f442_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f442_GOALTENDERX))*2,SP_goal_width),
			     PT_Goaltender,PS_Center);

  /* set position inside penalty box, don't go more than half-way to mid  */
  Formation_442->SetPosition(f442_SWEEPER, Vector(f442_SWEEPERX,f442_CENTERY), f442_POSITION_BUF, 
			     Vector(f442_SWEEPERX,f442_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f442_SWEEPERX))*2,(SP_penalty_area_width/2.0)*2),
			     Vector(f442_SWEEPERX,f442_CENTERY),
			     Vector(-f442_SWEEPERX - (SP_pitch_length/2.0)/2,((SP_pitch_width/2.0)+5)*2),
			     PT_Sweeper,PS_Center);

  Formation_442->SetPosition(f442_RIGHT_DEFENSE, Vector(f442_DEFENDERX,f442_RIGHTY), f442_POSITION_BUF, 
			     Vector(f442_DEFENDERX,f442_RIGHTY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_DEFENDERX,f442_RIGHTY),
			     Vector(f442_MAXXRANGE ,f442_MAXYRANGE),
			     PT_Defender, PS_Right);

  Formation_442->SetPosition(f442_CENTER_DEFENSE, Vector(f442_DEFENDERX+5,f442_CENTERY), f442_POSITION_BUF, 
			     Vector(f442_DEFENDERX+5,f442_CENTERY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_DEFENDERX+5,f442_CENTERY),
			     Vector(f442_MAXXRANGE ,f442_MAXYRANGE),
			     PT_Defender, PS_Center);

  Formation_442->SetPosition(f442_LEFT_DEFENSE, Vector(f442_DEFENDERX,f442_LEFTY), f442_POSITION_BUF, 
			     Vector(f442_DEFENDERX,f442_LEFTY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_DEFENDERX,f442_LEFTY),
			     Vector(f442_MAXXRANGE ,f442_MAXYRANGE),
			     PT_Defender, PS_Left);

  Formation_442->SetPosition(f442_RIGHT_MIDFIELD, Vector(f442_MIDFIELDERX,f442_RIGHTY), f442_POSITION_BUF, 
			     Vector(f442_MIDFIELDERX,f442_RIGHTY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_MIDFIELDERX,f442_RIGHTY),
			     Vector(f442_MAXXRANGE ,f442_MAXYRANGE),
			     PT_Midfielder, PS_Right);

  Formation_442->SetPosition(f442_DEFENSIVE_CENTER_MIDFIELD, Vector(f442_MIDFIELDERX-10,f442_CENTERY), f442_POSITION_BUF, 
			     Vector(f442_MIDFIELDERX-10,f442_CENTERY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_MIDFIELDERX-10,f442_CENTERY),
			     Vector(f442_MAXXRANGE ,f442_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_442->SetPosition(f442_OFFENSIVE_CENTER_MIDFIELD, Vector(f442_MIDFIELDERX+10,f442_CENTERY), f442_POSITION_BUF, 
			     Vector(f442_MIDFIELDERX+10,f442_CENTERY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_MIDFIELDERX+10,f442_CENTERY),
			     Vector(f442_MAXXRANGE ,f442_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_442->SetPosition(f442_LEFT_MIDFIELD, Vector(f442_MIDFIELDERX,f442_LEFTY), f442_POSITION_BUF, 
			     Vector(f442_MIDFIELDERX,f442_LEFTY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_MIDFIELDERX,f442_LEFTY),
			     Vector(f442_MAXXRANGE ,f442_MAXYRANGE),
			     PT_Midfielder, PS_Left);
  
  Formation_442->SetPosition(f442_RIGHT_WING, Vector(f442_FORWARDX,f442_INSIDERIGHTY), f442_POSITION_BUF, 
			     Vector(f442_FORWARDX,f442_INSIDERIGHTY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_FORWARDX,f442_INSIDERIGHTY),
			     Vector(f442_MAXXRANGE ,f442_INSIDE_MAXYRANGE),
			     PT_Forward, PS_Right);

  Formation_442->SetPosition(f442_LEFT_WING, Vector(f442_FORWARDX,f442_INSIDELEFTY), f442_POSITION_BUF, 
			     Vector(f442_FORWARDX,f442_INSIDELEFTY),
			     Vector(f442_HOMEXRANGE,f442_HOMEYRANGE),
			     Vector(f442_FORWARDX,f442_INSIDELEFTY),
			     Vector(f442_MAXXRANGE ,f442_INSIDE_MAXYRANGE),
			     PT_Forward, PS_Left);

  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=Formation_442->GetSize(); i++)
    Formation_442->SetCandidateReceivers(i,0,dummylist);

  Formation_442->AllocateUnits(6);

  /* Positions listed in order of importance, captain indicated as index into list */

  Pnum defenders[5] = {f442_GOALIE, f442_SWEEPER,
		      f442_CENTER_DEFENSE, f442_RIGHT_DEFENSE, f442_LEFT_DEFENSE};
  Formation_442->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 5, defenders, 0);

  Pnum midfielders[4] = {f442_DEFENSIVE_CENTER_MIDFIELD, f442_OFFENSIVE_CENTER_MIDFIELD,
			f442_RIGHT_MIDFIELD, f442_LEFT_MIDFIELD};
  Formation_442->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 4, midfielders, 0);

  Pnum forwards[2] = {f442_RIGHT_WING, f442_LEFT_WING};
  Formation_442->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 2, forwards, 0);

  Pnum rights[3] = {f442_RIGHT_DEFENSE, f442_RIGHT_MIDFIELD, f442_RIGHT_WING};
  Formation_442->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f442_GOALIE, f442_SWEEPER, f442_CENTER_DEFENSE, 
		    f442_DEFENSIVE_CENTER_MIDFIELD, f442_OFFENSIVE_CENTER_MIDFIELD};
  Formation_442->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 4);

  Pnum lefts[3] = {f442_LEFT_DEFENSE, f442_LEFT_MIDFIELD, f442_LEFT_WING};
  Formation_442->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);
}

/*************************************************************************/

int Formation::Build_442_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;
  
  Pside Side = GetPosition(position)->GetSide();

  switch ( position ){
  case f442_LEFT_WING:
  case f442_RIGHT_WING:
    NumOptions = (int_random(3) ? 1 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] =  (Side == PS_Right) ? f442_LEFT_WING : f442_RIGHT_WING;
    break;
  case f442_OFFENSIVE_CENTER_MIDFIELD:
    NumOptions = 2;
    PreferenceList[0] = (LocationSide == FS_Right) ? f442_RIGHT_WING : f442_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f442_LEFT_WING : f442_RIGHT_WING;
    break;
  case f442_DEFENSIVE_CENTER_MIDFIELD:
    NumOptions = 5;
    PreferenceList[0] = (LocationSide == FS_Right) ? f442_RIGHT_WING : f442_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f442_LEFT_WING : f442_RIGHT_WING;
    PreferenceList[2] = f442_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f442_RIGHT_MIDFIELD :f442_LEFT_MIDFIELD;
    PreferenceList[4] = (LocationSide == FS_Right) ? f442_LEFT_MIDFIELD :f442_RIGHT_MIDFIELD;
    break;
  case f442_RIGHT_MIDFIELD:
  case f442_LEFT_MIDFIELD:
    NumOptions = 4;
    PreferenceList[0] = (LocationSide == FS_Right) ? f442_RIGHT_WING : f442_LEFT_WING;
    PreferenceList[1] = f442_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[2] = (LocationSide == FS_Right) ? f442_LEFT_WING : f442_RIGHT_WING;
    PreferenceList[3] = f442_DEFENSIVE_CENTER_MIDFIELD;
    break;
  case f442_CENTER_DEFENSE:    
    NumOptions = 4;
    PreferenceList[0] = (LocationSide == FS_Right) ? f442_RIGHT_MIDFIELD : f442_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f442_LEFT_MIDFIELD : f442_RIGHT_MIDFIELD;
    PreferenceList[2] = f442_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[3] = f442_DEFENSIVE_CENTER_MIDFIELD;
    break;
  case f442_RIGHT_DEFENSE:
  case f442_LEFT_DEFENSE:
    NumOptions = 4;
    PreferenceList[0] = (LocationSide == FS_Right) ? f442_RIGHT_MIDFIELD : f442_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f442_RIGHT_WING : f442_LEFT_WING;
    PreferenceList[2] = f442_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[3] = f442_DEFENSIVE_CENTER_MIDFIELD;
    break;
  case f442_SWEEPER:
  case f442_GOALIE:
    NumOptions = 8;
    PreferenceList[0] = (LocationSide == FS_Right) ? f442_RIGHT_DEFENSE : f442_LEFT_DEFENSE;
    PreferenceList[1] = (LocationSide == FS_Right) ? f442_LEFT_DEFENSE : f442_RIGHT_DEFENSE;
    PreferenceList[2] = (LocationSide == FS_Right) ? f442_RIGHT_MIDFIELD : f442_LEFT_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f442_LEFT_MIDFIELD : f442_RIGHT_MIDFIELD;
    PreferenceList[4] = f442_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[5] = f442_DEFENSIVE_CENTER_MIDFIELD;
    PreferenceList[6] = (LocationSide == FS_Right) ? f442_RIGHT_WING : f442_LEFT_WING;
    PreferenceList[7] = (LocationSide == FS_Right) ? f442_LEFT_WING : f442_RIGHT_WING;
    break;
  }	

  for (int i = NumOptions; i<GetSize(); i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}



/*************************************************************************/
/************************ 3-5-2 Formation ********************************/
/*************************************************************************/

#define f352_GOALIE_BUF      2
#define f352_POSITION_BUF    3

#define f352_GOALTENDERX  (-52)
#define f352_SWEEPERX     (-43)
#define f352_DEFENDERX    (-35)
#define f352_MIDFIELDERX     0
#define f352_FORWARDX       30
#define f352_RIGHTY         30 /*25*/
#define f352_INSIDERIGHTY   15
#define f352_CENTERY         0
#define f352_INSIDELEFTY (-f352_INSIDERIGHTY)
#define f352_LEFTY       (-f352_RIGHTY)

#define f352_HOMEXRANGE f352_FORWARDX
#define f352_HOMEYRANGE f352_RIGHTY
#define f352_MAXXRANGE  (f352_FORWARDX*2)
#define f352_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f352_RIGHTY)*2)
#define f352_INSIDE_MAXYRANGE ((((SP_pitch_width/2.0)+5) - f352_INSIDERIGHTY)*2)

void FormationInfo::Initialize_352_Formation()
{
  /* set position within goal stay, in penalty box      */
  Formation_352->SetPosition(f352_GOALIE, Vector(f352_GOALTENDERX,f352_CENTERY), f352_GOALIE_BUF, 
			     Vector(f352_GOALTENDERX,f352_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f352_GOALTENDERX))*2,SP_goal_width),
			     Vector(f352_GOALTENDERX,f352_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f352_GOALTENDERX))*2,SP_goal_width),
			     PT_Goaltender,PS_Center);

  /* set position inside penalty box, don't go more than half-way to mid  */
  Formation_352->SetPosition(f352_SWEEPER, Vector(f352_SWEEPERX,f352_CENTERY), f352_POSITION_BUF, 
			     Vector(f352_SWEEPERX,f352_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f352_SWEEPERX))*2,(SP_penalty_area_width/2.0)*2),
			     Vector(f352_SWEEPERX,f352_CENTERY),
			     Vector(-f352_SWEEPERX - (SP_pitch_length/2.0)/2,((SP_pitch_width/2.0)+5)*2),
			     PT_Sweeper,PS_Center);

  Formation_352->SetPosition(f352_RIGHT_DEFENSE, Vector(f352_DEFENDERX,f352_INSIDERIGHTY), f352_POSITION_BUF, 
			     Vector(f352_DEFENDERX,f352_INSIDERIGHTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_DEFENDERX,f352_INSIDERIGHTY),
			     Vector(f352_MAXXRANGE ,f352_INSIDE_MAXYRANGE),
			     PT_Defender, PS_Right);

  Formation_352->SetPosition(f352_LEFT_DEFENSE, Vector(f352_DEFENDERX,f352_INSIDELEFTY), f352_POSITION_BUF, 
			     Vector(f352_DEFENDERX,f352_INSIDELEFTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_DEFENDERX,f352_INSIDELEFTY),
			     Vector(f352_MAXXRANGE ,f352_INSIDE_MAXYRANGE),
			     PT_Defender, PS_Left);

  Formation_352->SetPosition(f352_RIGHT_OUTSIDE_MIDFIELD, Vector(f352_MIDFIELDERX,f352_RIGHTY), f352_POSITION_BUF, 
			     Vector(f352_MIDFIELDERX,f352_RIGHTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_MIDFIELDERX,f352_RIGHTY),
			     Vector(((SP_pitch_length/2.0)+5)*2,f352_MAXYRANGE),
			     PT_Midfielder, PS_Right);

  Formation_352->SetPosition(f352_RIGHT_INSIDE_MIDFIELD, Vector(f352_MIDFIELDERX-10,f352_INSIDERIGHTY), f352_POSITION_BUF, 
			     Vector(f352_MIDFIELDERX-10,f352_INSIDERIGHTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_MIDFIELDERX-10,f352_INSIDERIGHTY),
			     Vector(f352_MAXXRANGE ,f352_INSIDE_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_352->SetPosition(f352_CENTER_MIDFIELD, Vector(f352_MIDFIELDERX+9,f352_CENTERY), f352_POSITION_BUF, 
			     Vector(f352_MIDFIELDERX+9,f352_CENTERY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_MIDFIELDERX+9,f352_CENTERY),
			     Vector(f352_MAXXRANGE ,f352_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_352->SetPosition(f352_LEFT_INSIDE_MIDFIELD, Vector(f352_MIDFIELDERX-10,f352_INSIDELEFTY), f352_POSITION_BUF, 
			     Vector(f352_MIDFIELDERX-10,f352_INSIDELEFTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_MIDFIELDERX-10,f352_INSIDELEFTY),
			     Vector(f352_MAXXRANGE ,f352_INSIDE_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_352->SetPosition(f352_LEFT_OUTSIDE_MIDFIELD, Vector(f352_MIDFIELDERX,f352_LEFTY), f352_POSITION_BUF, 
			     Vector(f352_MIDFIELDERX,f352_LEFTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_MIDFIELDERX,f352_LEFTY),
			     Vector(((SP_pitch_length/2.0)+5)*2,f352_MAXYRANGE),
			     PT_Midfielder, PS_Left);
  
  Formation_352->SetPosition(f352_RIGHT_WING, Vector(f352_FORWARDX,f352_INSIDERIGHTY), f352_POSITION_BUF, 
			     Vector(f352_FORWARDX,f352_INSIDERIGHTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_FORWARDX,f352_INSIDERIGHTY),
			     Vector(f352_MAXXRANGE ,f352_INSIDE_MAXYRANGE),
			     PT_Forward, PS_Right);

  Formation_352->SetPosition(f352_LEFT_WING, Vector(f352_FORWARDX,f352_INSIDELEFTY), f352_POSITION_BUF, 
			     Vector(f352_FORWARDX,f352_INSIDELEFTY),
			     Vector(f352_HOMEXRANGE,f352_HOMEYRANGE),
			     Vector(f352_FORWARDX,f352_INSIDELEFTY),
			     Vector(f352_MAXXRANGE ,f352_INSIDE_MAXYRANGE),
			     PT_Forward, PS_Left);

  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=Formation_352->GetSize(); i++)
    Formation_352->SetCandidateReceivers(i,0,dummylist);

  Formation_352->AllocateUnits(6);

  Pnum defenders[4] = {f352_GOALIE, f352_SWEEPER, f352_RIGHT_DEFENSE, f352_LEFT_DEFENSE};
  Formation_352->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 4, defenders, 0);

  Pnum midfielders[5] = {f352_CENTER_MIDFIELD, 
			f352_RIGHT_OUTSIDE_MIDFIELD, f352_LEFT_OUTSIDE_MIDFIELD,
			f352_RIGHT_INSIDE_MIDFIELD, f352_LEFT_INSIDE_MIDFIELD};
  Formation_352->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 5, midfielders, 0);

  Pnum forwards[2] = {f352_RIGHT_WING, f352_LEFT_WING};
  Formation_352->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 2, forwards, 0);

  Pnum rights[3] = {f352_RIGHT_DEFENSE, f352_RIGHT_OUTSIDE_MIDFIELD, f352_RIGHT_WING};
  Formation_352->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f352_GOALIE, f352_SWEEPER, 
		    f352_CENTER_MIDFIELD, f352_RIGHT_INSIDE_MIDFIELD, 
		    f352_LEFT_INSIDE_MIDFIELD};
  Formation_352->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 2);

  Pnum lefts[3] = {f352_LEFT_DEFENSE, f352_LEFT_OUTSIDE_MIDFIELD, f352_LEFT_WING};
  Formation_352->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);
}

/*************************************************************************/

int Formation::Build_352_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;
  
  Pside Side = GetPosition(position)->GetSide();

  switch ( position ){
  case f352_LEFT_WING:
    NumOptions = (int_random(3) ? 1 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] = f352_RIGHT_WING; 
    break;
  case f352_RIGHT_WING:
    NumOptions = (int_random(3) ? 1 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] = f352_LEFT_WING; 
    break;
  case f352_CENTER_MIDFIELD:
    NumOptions = 4;
    PreferenceList[0] = (LocationSide == FS_Right) ? f352_RIGHT_WING : f352_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f352_LEFT_WING : f352_RIGHT_WING;
    PreferenceList[2] = (LocationSide == FS_Right) ? f352_RIGHT_OUTSIDE_MIDFIELD : 
      f352_LEFT_OUTSIDE_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f352_LEFT_OUTSIDE_MIDFIELD : 
      f352_RIGHT_OUTSIDE_MIDFIELD;
    break;
  case f352_RIGHT_OUTSIDE_MIDFIELD:
  case f352_LEFT_OUTSIDE_MIDFIELD:
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f352_RIGHT_WING : f352_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f352_LEFT_WING : f352_RIGHT_WING; 
    PreferenceList[2] = f352_CENTER_MIDFIELD;
    break;
  case f352_RIGHT_INSIDE_MIDFIELD:
  case f352_LEFT_INSIDE_MIDFIELD:
    NumOptions = 6;
    PreferenceList[0] = (LocationSide == FS_Right) ? f352_RIGHT_WING : f352_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f352_RIGHT_OUTSIDE_MIDFIELD : 
      f352_LEFT_OUTSIDE_MIDFIELD;
    PreferenceList[2] = f352_CENTER_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f352_LEFT_WING : f352_RIGHT_WING;
    PreferenceList[4] = (LocationSide == FS_Right) ? f352_LEFT_OUTSIDE_MIDFIELD : 
      f352_RIGHT_OUTSIDE_MIDFIELD;
    PreferenceList[5] = (Side == PS_Right) ? f352_LEFT_INSIDE_MIDFIELD : 
      f352_RIGHT_INSIDE_MIDFIELD;
    break;
  case f352_RIGHT_DEFENSE:
  case f352_LEFT_DEFENSE:
  case f352_SWEEPER:
  case f352_GOALIE:
    NumOptions = 7;
    PreferenceList[0] = (LocationSide == FS_Right) ? f352_RIGHT_OUTSIDE_MIDFIELD : 
      f352_LEFT_OUTSIDE_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f352_RIGHT_INSIDE_MIDFIELD : 
      f352_LEFT_INSIDE_MIDFIELD;
    PreferenceList[2] = (LocationSide == FS_Right) ? f352_LEFT_OUTSIDE_MIDFIELD : 
      f352_RIGHT_OUTSIDE_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f352_LEFT_INSIDE_MIDFIELD : 
      f352_RIGHT_INSIDE_MIDFIELD;
    PreferenceList[4] = f352_CENTER_MIDFIELD;
    PreferenceList[5] = (LocationSide == FS_Right) ? f352_RIGHT_WING : f352_LEFT_WING;
    PreferenceList[6] = (LocationSide == FS_Right) ? f352_LEFT_WING : f352_RIGHT_WING;
    break;
  }	

  for (int i = NumOptions; i<GetSize(); i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}



/*************************************************************************/
/************************ 7-2 Formation ********************************/
/*************************************************************************/

#define f72_GOALIE_BUF      2
#define f72_POSITION_BUF    3

#define f72_GOALTENDERX  (-52)
#define f72_DEFENDERX    (-43)
#define f72_MIDFIELDERX  (-20)
#define f72_FORWARDX       17   /* > ROUGH_FORWARDX/2 so treated as a forward */
#define f72_RIGHTY         25
#define f72_INSIDERIGHTY   15
#define f72_CENTERY         0
#define f72_INSIDELEFTY (-f72_INSIDERIGHTY)
#define f72_LEFTY       (-f72_RIGHTY)

#define f72_HOMEXRANGE 15
#define f72_HOMEYRANGE f72_INSIDERIGHTY
#define f72_MAXXRANGE  30
#define f72_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f72_RIGHTY)*2)
#define f72_INSIDE_MAXYRANGE ((((SP_pitch_width/2.0)+5) - f72_INSIDERIGHTY)*2)

void FormationInfo::Initialize_72_Formation(){

  /* set position within goal stay, in penalty box      */
  Formation_72->SetPosition(f72_RIGHT_GOALIE, Vector(f72_GOALTENDERX,f72_CENTERY-(SP_goal_width/4)), f72_GOALIE_BUF, 
			    Vector(f72_GOALTENDERX,f72_CENTERY-(SP_goal_width/4)),
			    Vector(((SP_pitch_length/2.0)- (-f72_GOALTENDERX))*2,SP_goal_width/2),
			    Vector(f72_GOALTENDERX,f72_CENTERY-(SP_goal_width/4)),
			    Vector(((SP_pitch_length/2.0)- (-f72_GOALTENDERX))*2,SP_goal_width),
			    PT_Goaltender,PS_Center);

  Formation_72->SetPosition(f72_LEFT_GOALIE, Vector(f72_GOALTENDERX,f72_CENTERY+(SP_goal_width/4)), f72_GOALIE_BUF, 
			    Vector(f72_GOALTENDERX,f72_CENTERY+(SP_goal_width/4)),
			    Vector(((SP_pitch_length/2.0)- (-f72_GOALTENDERX))*2,SP_goal_width/2),
			    Vector(f72_GOALTENDERX,f72_CENTERY+(SP_goal_width/4)),
			    Vector(((SP_pitch_length/2.0)- (-f72_GOALTENDERX))*2,SP_goal_width),
			    PT_Goaltender,PS_Center);

  Formation_72->SetPosition(f72_RIGHT_DEFENSE, Vector(f72_DEFENDERX,f72_INSIDERIGHTY), f72_POSITION_BUF, 
			    Vector(f72_DEFENDERX,f72_INSIDERIGHTY),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_DEFENDERX,f72_INSIDERIGHTY),
			    Vector(f72_MAXXRANGE ,f72_INSIDE_MAXYRANGE),
			    PT_Defender, PS_Right);

  Formation_72->SetPosition(f72_CENTER_DEFENSE, Vector(f72_DEFENDERX+5,f72_CENTERY), f72_POSITION_BUF, 
			    Vector(f72_DEFENDERX+5,f72_CENTERY),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_DEFENDERX+5,f72_CENTERY),
			    Vector(f72_MAXXRANGE ,f72_INSIDE_MAXYRANGE),
			    PT_Defender, PS_Center);

  Formation_72->SetPosition(f72_LEFT_DEFENSE, Vector(f72_DEFENDERX,f72_INSIDELEFTY), f72_POSITION_BUF, 
			    Vector(f72_DEFENDERX,f72_INSIDELEFTY),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_DEFENDERX,f72_INSIDELEFTY),
			    Vector(f72_MAXXRANGE ,f72_INSIDE_MAXYRANGE),
			    PT_Defender, PS_Left);

  Formation_72->SetPosition(f72_RIGHT_OUTSIDE_MIDFIELD, Vector(f72_MIDFIELDERX,f72_RIGHTY), f72_POSITION_BUF, 
			    Vector(f72_MIDFIELDERX,f72_RIGHTY),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_MIDFIELDERX,f72_RIGHTY),
			    Vector(f72_MAXXRANGE ,f72_MAXYRANGE),
			    PT_Midfielder, PS_Right);

  Formation_72->SetPosition(f72_RIGHT_INSIDE_MIDFIELD, Vector(f72_MIDFIELDERX-5,f72_INSIDERIGHTY+5), f72_POSITION_BUF, 
			    Vector(f72_MIDFIELDERX-5,f72_INSIDERIGHTY+5),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_MIDFIELDERX-5,f72_INSIDERIGHTY+5),
			    Vector(f72_MAXXRANGE ,f72_INSIDE_MAXYRANGE),
			    PT_Midfielder, PS_Center);

  Formation_72->SetPosition(f72_LEFT_INSIDE_MIDFIELD, Vector(f72_MIDFIELDERX-5,f72_INSIDELEFTY-5), f72_POSITION_BUF, 
			    Vector(f72_MIDFIELDERX-5,f72_INSIDELEFTY-5),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_MIDFIELDERX-5,f72_INSIDELEFTY-5),
			    Vector(f72_MAXXRANGE ,f72_INSIDE_MAXYRANGE),
			    PT_Midfielder, PS_Center);

  Formation_72->SetPosition(f72_LEFT_OUTSIDE_MIDFIELD, Vector(f72_MIDFIELDERX,f72_LEFTY), f72_POSITION_BUF, 
			    Vector(f72_MIDFIELDERX,f72_LEFTY),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_MIDFIELDERX,f72_LEFTY),
			    Vector(f72_MAXXRANGE ,f72_MAXYRANGE),
			    PT_Midfielder, PS_Left);
  
  Formation_72->SetPosition(f72_RIGHT_WING, Vector(f72_FORWARDX,f72_INSIDERIGHTY), f72_POSITION_BUF, 
			    Vector(f72_FORWARDX,f72_INSIDERIGHTY),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_FORWARDX,f72_INSIDERIGHTY),
			    Vector(f72_MAXXRANGE ,f72_INSIDE_MAXYRANGE),
			    PT_Forward, PS_Right);

  Formation_72->SetPosition(f72_LEFT_WING, Vector(f72_FORWARDX,f72_INSIDELEFTY), f72_POSITION_BUF, 
			    Vector(f72_FORWARDX,f72_INSIDELEFTY),
			    Vector(f72_HOMEXRANGE,f72_HOMEYRANGE),
			    Vector(f72_FORWARDX,f72_INSIDELEFTY),
			    Vector(f72_MAXXRANGE ,f72_INSIDE_MAXYRANGE),
			    PT_Forward, PS_Left);

  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=Formation_72->GetSize(); i++)
    Formation_72->SetCandidateReceivers(i,0,dummylist);

  Formation_72->AllocateUnits(6);

  Pnum defenders[9] = {f72_RIGHT_GOALIE, f72_LEFT_GOALIE, f72_RIGHT_DEFENSE, 
		      f72_CENTER_DEFENSE, f72_LEFT_DEFENSE, 
		      f72_RIGHT_INSIDE_MIDFIELD, f72_LEFT_INSIDE_MIDFIELD,
		      f72_RIGHT_OUTSIDE_MIDFIELD, f72_LEFT_OUTSIDE_MIDFIELD};
  Formation_72->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 9, defenders, 0);

  Pnum midfielders[4] = {f72_RIGHT_INSIDE_MIDFIELD, f72_LEFT_INSIDE_MIDFIELD,
			f72_RIGHT_OUTSIDE_MIDFIELD, f72_LEFT_OUTSIDE_MIDFIELD};
  Formation_72->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 4, midfielders, 0);

  Pnum forwards[2] = {f72_RIGHT_WING, f72_LEFT_WING};
  Formation_72->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 2, forwards, 0);

  Pnum rights[3] = {f72_RIGHT_DEFENSE, f72_RIGHT_OUTSIDE_MIDFIELD, f72_RIGHT_WING};
  Formation_72->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f72_RIGHT_GOALIE, f72_LEFT_GOALIE, 
		    f72_CENTER_DEFENSE,
		    f72_RIGHT_INSIDE_MIDFIELD, f72_LEFT_INSIDE_MIDFIELD};
  Formation_72->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 3);

  Pnum lefts[3] = {f72_LEFT_DEFENSE, f72_LEFT_OUTSIDE_MIDFIELD, f72_LEFT_WING};
  Formation_72->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);
}

/*************************************************************************/

int Formation::Build_72_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;

  switch ( position ){
  case f72_LEFT_WING:
  case f72_RIGHT_WING:
    break;  /* shoot */
  case f72_RIGHT_OUTSIDE_MIDFIELD:
  case f72_LEFT_OUTSIDE_MIDFIELD:
  case f72_RIGHT_INSIDE_MIDFIELD:
  case f72_LEFT_INSIDE_MIDFIELD:
  case f72_RIGHT_DEFENSE:
  case f72_CENTER_DEFENSE:
  case f72_LEFT_DEFENSE:
    NumOptions = 2;
    PreferenceList[0] = (LocationSide == FS_Right) ? f72_RIGHT_WING : f72_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f72_LEFT_WING : f72_RIGHT_WING;
    break;
  case f72_RIGHT_GOALIE:
  case f72_LEFT_GOALIE:
    break; /* clear */
  }	

  for (int i = NumOptions; i<GetSize(); i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}



/*************************************************************************/
/************************ 3-3-4 Formation ********************************/
/*************************************************************************/

#define f334_GOALIE_BUF      2
#define f334_POSITION_BUF    3

#define f334_GOALTENDERX  (-52)
#define f334_SWEEPERX     (-43)
#define f334_DEFENDERX    (-35)
#define f334_MIDFIELDERX     0
#define f334_FORWARDX       30
#define f334_RIGHTY         25
#define f334_INSIDERIGHTY   15
#define f334_CENTERY         0
#define f334_INSIDELEFTY (-f334_INSIDERIGHTY)
#define f334_LEFTY       (-f334_RIGHTY)

#define f334_HOMEXRANGE f334_FORWARDX
#define f334_HOMEYRANGE f334_RIGHTY
#define f334_MAXXRANGE  (f334_FORWARDX*2)
#define f334_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f334_RIGHTY)*2)
#define f334_INSIDE_MAXYRANGE ((((SP_pitch_width/2.0)+5) - f334_INSIDERIGHTY)*2)

void FormationInfo::Initialize_334_Formation(){
  
  /* set position within goal stay, in penalty box      */
  Formation_334->SetPosition(f334_GOALIE, Vector(f334_GOALTENDERX,f334_CENTERY), f334_GOALIE_BUF, 
			     Vector(f334_GOALTENDERX,f334_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f334_GOALTENDERX))*2,SP_goal_width),
			     Vector(f334_GOALTENDERX,f334_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f334_GOALTENDERX))*2,SP_goal_width),
			     PT_Goaltender,PS_Center);

  /* set position inside penalty box, don't go more than half-way to mid  */
  Formation_334->SetPosition(f334_SWEEPER, Vector(f334_SWEEPERX,f334_CENTERY), f334_POSITION_BUF, 
			     Vector(f334_SWEEPERX,f334_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f334_SWEEPERX))*2,(SP_penalty_area_width/2.0)*2),
			     Vector(f334_SWEEPERX,f334_CENTERY),
			     Vector(-f334_SWEEPERX - (SP_pitch_length/2.0)/2,((SP_pitch_width/2.0)+5)*2),
			     PT_Sweeper,PS_Center);

  Formation_334->SetPosition(f334_RIGHT_DEFENSE, Vector(f334_DEFENDERX,f334_INSIDERIGHTY), f334_POSITION_BUF, 
			     Vector(f334_DEFENDERX,f334_INSIDERIGHTY),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_DEFENDERX,f334_INSIDERIGHTY),
			     Vector(f334_MAXXRANGE ,f334_INSIDE_MAXYRANGE),
			     PT_Defender, PS_Right);

  Formation_334->SetPosition(f334_LEFT_DEFENSE, Vector(f334_DEFENDERX,f334_INSIDELEFTY), f334_POSITION_BUF, 
			     Vector(f334_DEFENDERX,f334_INSIDELEFTY),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_DEFENDERX,f334_INSIDELEFTY),
			     Vector(f334_MAXXRANGE ,f334_INSIDE_MAXYRANGE),
			     PT_Defender, PS_Left);

  Formation_334->SetPosition(f334_RIGHT_MIDFIELD, Vector(f334_MIDFIELDERX,f334_RIGHTY), f334_POSITION_BUF, 
			     Vector(f334_MIDFIELDERX,f334_RIGHTY),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_MIDFIELDERX,f334_RIGHTY),
			     Vector(f334_MAXXRANGE ,f334_MAXYRANGE),
			     PT_Midfielder, PS_Right);

  Formation_334->SetPosition(f334_CENTER_MIDFIELD, Vector(f334_MIDFIELDERX,f334_CENTERY), f334_POSITION_BUF, 
			     Vector(f334_MIDFIELDERX,f334_CENTERY),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_MIDFIELDERX,f334_CENTERY),
			     Vector(f334_MAXXRANGE ,f334_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_334->SetPosition(f334_LEFT_MIDFIELD, Vector(f334_MIDFIELDERX,f334_LEFTY), f334_POSITION_BUF, 
			     Vector(f334_MIDFIELDERX,f334_LEFTY),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_MIDFIELDERX,f334_LEFTY),
			     Vector(f334_MAXXRANGE ,f334_MAXYRANGE),
			     PT_Midfielder, PS_Left);
  
  Formation_334->SetPosition(f334_RIGHT_WING, Vector(f334_FORWARDX+5,f334_RIGHTY), f334_POSITION_BUF, 
			     Vector(f334_FORWARDX+5,f334_RIGHTY),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_FORWARDX+5,f334_RIGHTY),
			     Vector(f334_MAXXRANGE ,f334_MAXYRANGE),
			     PT_Forward, PS_Right);

  Formation_334->SetPosition(f334_RIGHT_INSIDE_FORWARD, Vector(f334_FORWARDX,f334_CENTERY-10), f334_POSITION_BUF, 
			     Vector(f334_FORWARDX,f334_CENTERY-10),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_FORWARDX,f334_CENTERY-10),
			     Vector(f334_MAXXRANGE ,f334_MAXYRANGE),
			     PT_Forward, PS_Center);

  Formation_334->SetPosition(f334_LEFT_INSIDE_FORWARD, Vector(f334_FORWARDX,f334_CENTERY+10), f334_POSITION_BUF, 
			     Vector(f334_FORWARDX,f334_CENTERY+10),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_FORWARDX,f334_CENTERY+10),
			     Vector(f334_MAXXRANGE ,f334_MAXYRANGE),
			     PT_Forward, PS_Center);

  Formation_334->SetPosition(f334_LEFT_WING, Vector(f334_FORWARDX+5,f334_LEFTY), f334_POSITION_BUF, 
			     Vector(f334_FORWARDX+5,f334_LEFTY),
			     Vector(f334_HOMEXRANGE,f334_HOMEYRANGE),
			     Vector(f334_FORWARDX+5,f334_LEFTY),
			     Vector(f334_MAXXRANGE ,f334_MAXYRANGE),
			     PT_Forward, PS_Left);


  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=Formation_334->GetSize(); i++)
    Formation_334->SetCandidateReceivers(i,0,dummylist);

  Formation_334->AllocateUnits(6);

  Pnum defenders[4] = {f334_GOALIE, f334_SWEEPER, f334_RIGHT_DEFENSE, f334_LEFT_DEFENSE};
  Formation_334->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 4, defenders, 0);

  Pnum midfielders[3] = {f334_CENTER_MIDFIELD, 
			f334_RIGHT_MIDFIELD, f334_LEFT_MIDFIELD};
  Formation_334->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 3, midfielders, 0);

  Pnum forwards[4] = {f334_RIGHT_INSIDE_FORWARD, f334_LEFT_INSIDE_FORWARD,
		     f334_RIGHT_WING, f334_LEFT_WING};
  Formation_334->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 4, forwards, 0);

  Pnum rights[3] = {f334_RIGHT_DEFENSE, f334_RIGHT_MIDFIELD, f334_RIGHT_WING};
  Formation_334->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f334_GOALIE, f334_SWEEPER, 
		    f334_CENTER_MIDFIELD, f334_RIGHT_INSIDE_FORWARD, 
		    f334_LEFT_INSIDE_FORWARD};
  Formation_334->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 2);

  Pnum lefts[3] = {f334_LEFT_DEFENSE, f334_LEFT_MIDFIELD, f334_LEFT_WING};
  Formation_334->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);
}

/*************************************************************************/

int Formation::Build_334_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;
  
  Pside Side = GetPosition(position)->GetSide();

  switch ( position ){
  case f334_LEFT_INSIDE_FORWARD:
  case f334_RIGHT_INSIDE_FORWARD:
      break; /* shoot */
  case f334_LEFT_WING:
    NumOptions = (int_random(3) ? 3 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] = f334_LEFT_INSIDE_FORWARD; 
    PreferenceList[1] = f334_RIGHT_INSIDE_FORWARD; 
    PreferenceList[2] = f334_RIGHT_WING; 
    break;
  case f334_RIGHT_WING:
    NumOptions = (int_random(3) ? 3 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] = f334_RIGHT_INSIDE_FORWARD; 
    PreferenceList[1] = f334_LEFT_INSIDE_FORWARD; 
    PreferenceList[2] = f334_LEFT_WING; 
    break;
  case f334_CENTER_MIDFIELD:
    NumOptions = 6;
    PreferenceList[0] = (LocationSide == FS_Right) ? f334_RIGHT_WING : f334_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f334_LEFT_WING : f334_RIGHT_WING;
    PreferenceList[2] = (LocationSide == FS_Right) ? f334_RIGHT_INSIDE_FORWARD : 
      f334_LEFT_INSIDE_FORWARD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f334_LEFT_INSIDE_FORWARD : 
      f334_RIGHT_INSIDE_FORWARD;
    PreferenceList[4] = (LocationSide == FS_Right) ? f334_RIGHT_MIDFIELD : 
      f334_LEFT_MIDFIELD;
    PreferenceList[5] = (LocationSide == FS_Right) ? f334_LEFT_MIDFIELD : 
      f334_RIGHT_MIDFIELD;
    break;
  case f334_RIGHT_MIDFIELD:
  case f334_LEFT_MIDFIELD:
    NumOptions = 5;
    PreferenceList[0] = (Side == PS_Right) ? f334_RIGHT_WING : f334_LEFT_WING;
    PreferenceList[1] = (Side == PS_Right) ? f334_RIGHT_INSIDE_FORWARD : 
      f334_LEFT_INSIDE_FORWARD;
    PreferenceList[2] = (Side == PS_Right) ? f334_LEFT_INSIDE_FORWARD :
      f334_RIGHT_INSIDE_FORWARD;
    PreferenceList[3] = f334_CENTER_MIDFIELD;
    PreferenceList[4] = (Side == PS_Right) ? f334_LEFT_WING : f334_RIGHT_WING;
    break;
  case f334_RIGHT_DEFENSE:
  case f334_LEFT_DEFENSE:
  case f334_SWEEPER:
  case f334_GOALIE:
    NumOptions = 7;
    PreferenceList[0] = (LocationSide == FS_Right) ? f334_RIGHT_MIDFIELD : 
      f334_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f334_RIGHT_WING : f334_LEFT_WING;
    PreferenceList[2] = (Side == PS_Right) ? f334_RIGHT_INSIDE_FORWARD : 
      f334_LEFT_INSIDE_FORWARD;
    PreferenceList[3] = f334_CENTER_MIDFIELD;
    PreferenceList[4] = (LocationSide == FS_Right) ? f334_LEFT_MIDFIELD : 
      f334_RIGHT_MIDFIELD;
    PreferenceList[5] = (Side == PS_Right) ? f334_LEFT_INSIDE_FORWARD :
      f334_RIGHT_INSIDE_FORWARD;
    PreferenceList[6] = (LocationSide == FS_Right) ? f334_LEFT_WING : f334_RIGHT_WING;
    break;
  }	

  for (int i = NumOptions; i<GetSize(); i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}




/*************************************************************************/
/************************ 2-4-4 Formation ********************************/
/*************************************************************************/

#define f244_GOALIE_BUF      2
#define f244_POSITION_BUF    3

#define f244_GOALTENDERX  (-52)
#define f244_SWEEPERX     (-43)
#define f244_DEFENDERX    (-35)
#define f244_MIDFIELDERX     0
#define f244_FORWARDX       30
#define f244_RIGHTY         25
#define f244_INSIDERIGHTY   15
#define f244_CENTERY         0
#define f244_INSIDELEFTY (-f244_INSIDERIGHTY)
#define f244_LEFTY       (-f244_RIGHTY)

#define f244_HOMEXRANGE f244_FORWARDX
#define f244_HOMEYRANGE f244_RIGHTY
#define f244_MAXXRANGE  (f244_FORWARDX*2)
#define f244_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f244_RIGHTY)*2)
#define f244_INSIDE_MAXYRANGE ((((SP_pitch_width/2.0)+5) - f244_INSIDERIGHTY)*2)

void FormationInfo::Initialize_244_Formation(){
  
  /* set position within goal stay, in penalty box      */
  Formation_244->SetPosition(f244_GOALIE, Vector(f244_GOALTENDERX,f244_CENTERY), f244_GOALIE_BUF, 
			     Vector(f244_GOALTENDERX,f244_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f244_GOALTENDERX))*2,SP_goal_width),
			     Vector(f244_GOALTENDERX,f244_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f244_GOALTENDERX))*2,SP_goal_width),
			     PT_Goaltender, PS_Center);

  Formation_244->SetPosition(f244_RIGHT_DEFENSE, Vector(f244_DEFENDERX,f244_INSIDERIGHTY), f244_POSITION_BUF, 
			     Vector(f244_DEFENDERX,f244_INSIDERIGHTY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_DEFENDERX,f244_INSIDERIGHTY),
			     Vector(f244_MAXXRANGE ,f244_INSIDE_MAXYRANGE),
			     PT_Defender, PS_Right);

  Formation_244->SetPosition(f244_LEFT_DEFENSE, Vector(f244_DEFENDERX,f244_INSIDELEFTY), f244_POSITION_BUF, 
			     Vector(f244_DEFENDERX,f244_INSIDELEFTY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_DEFENDERX,f244_INSIDELEFTY),
			     Vector(f244_MAXXRANGE ,f244_INSIDE_MAXYRANGE),
			     PT_Defender, PS_Left);

  Formation_244->SetPosition(f244_RIGHT_MIDFIELD, Vector(f244_MIDFIELDERX,f244_RIGHTY), f244_POSITION_BUF, 
			     Vector(f244_MIDFIELDERX,f244_RIGHTY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_MIDFIELDERX,f244_RIGHTY),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Midfielder, PS_Right);

  Formation_244->SetPosition(f244_DEFENSIVE_CENTER_MIDFIELD, Vector(f244_MIDFIELDERX-10,f244_CENTERY), f244_POSITION_BUF, 
			     Vector(f244_MIDFIELDERX-10,f244_CENTERY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_MIDFIELDERX-10,f244_CENTERY),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_244->SetPosition(f244_OFFENSIVE_CENTER_MIDFIELD, Vector(f244_MIDFIELDERX+10,f244_CENTERY), f244_POSITION_BUF, 
			     Vector(f244_MIDFIELDERX+10,f244_CENTERY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_MIDFIELDERX+10,f244_CENTERY),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_244->SetPosition(f244_LEFT_MIDFIELD, Vector(f244_MIDFIELDERX,f244_LEFTY), f244_POSITION_BUF, 
			     Vector(f244_MIDFIELDERX,f244_LEFTY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_MIDFIELDERX,f244_LEFTY),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Midfielder, PS_Left);
  
  Formation_244->SetPosition(f244_RIGHT_WING, Vector(f244_FORWARDX+5,f244_RIGHTY), f244_POSITION_BUF, 
			     Vector(f244_FORWARDX+5,f244_RIGHTY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_FORWARDX+5,f244_RIGHTY),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Forward, PS_Right);

  Formation_244->SetPosition(f244_RIGHT_INSIDE_FORWARD, Vector(f244_FORWARDX,f244_CENTERY-10), f244_POSITION_BUF, 
			     Vector(f244_FORWARDX,f244_CENTERY-10),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_FORWARDX,f244_CENTERY-10),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Forward, PS_Center);

  Formation_244->SetPosition(f244_LEFT_INSIDE_FORWARD, Vector(f244_FORWARDX,f244_CENTERY+10), f244_POSITION_BUF, 
			     Vector(f244_FORWARDX,f244_CENTERY+10),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_FORWARDX,f244_CENTERY+10),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Forward, PS_Center);

  Formation_244->SetPosition(f244_LEFT_WING, Vector(f244_FORWARDX+5,f244_LEFTY), f244_POSITION_BUF, 
			     Vector(f244_FORWARDX+5,f244_LEFTY),
			     Vector(f244_HOMEXRANGE,f244_HOMEYRANGE),
			     Vector(f244_FORWARDX+5,f244_LEFTY),
			     Vector(f244_MAXXRANGE ,f244_MAXYRANGE),
			     PT_Forward, PS_Left);


  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=Formation_244->GetSize(); i++)
    Formation_244->SetCandidateReceivers(i,0,dummylist);

  Formation_244->AllocateUnits(6);

  Pnum defenders[3] = {f244_GOALIE, f244_RIGHT_DEFENSE, f244_LEFT_DEFENSE};
  Formation_244->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 3, defenders, 0);

  Pnum midfielders[4] = {f244_DEFENSIVE_CENTER_MIDFIELD, f244_OFFENSIVE_CENTER_MIDFIELD,
			f244_RIGHT_MIDFIELD, f244_LEFT_MIDFIELD};
  Formation_244->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 4, midfielders, 0);

  Pnum forwards[4] = {f244_RIGHT_INSIDE_FORWARD, f244_LEFT_INSIDE_FORWARD,
		     f244_RIGHT_WING, f244_LEFT_WING};
  Formation_244->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 4, forwards, 0);

  Pnum rights[3] = {f244_RIGHT_DEFENSE, f244_RIGHT_MIDFIELD, f244_RIGHT_WING};
  Formation_244->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f244_GOALIE, 
		    f244_DEFENSIVE_CENTER_MIDFIELD, f244_OFFENSIVE_CENTER_MIDFIELD,
		    f244_RIGHT_INSIDE_FORWARD, f244_LEFT_INSIDE_FORWARD};
  Formation_244->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 2);

  Pnum lefts[3] = {f244_LEFT_DEFENSE, f244_LEFT_MIDFIELD, f244_LEFT_WING};
  Formation_244->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);
}

/*************************************************************************/

int Formation::Build_244_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;
  
  Pside Side = GetPosition(position)->GetSide();

  switch ( position ){
  case f244_LEFT_INSIDE_FORWARD:
  case f244_RIGHT_INSIDE_FORWARD:
      break; /* shoot */
  case f244_LEFT_WING:
    NumOptions = (int_random(3) ? 3 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] = f244_LEFT_INSIDE_FORWARD; 
    PreferenceList[1] = f244_RIGHT_INSIDE_FORWARD; 
    PreferenceList[2] = f244_RIGHT_WING; 
    break;
  case f244_RIGHT_WING:
    NumOptions = (int_random(3) ? 3 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] = f244_RIGHT_INSIDE_FORWARD; 
    PreferenceList[1] = f244_LEFT_INSIDE_FORWARD; 
    PreferenceList[2] = f244_LEFT_WING; 
    break;
  case f244_OFFENSIVE_CENTER_MIDFIELD:
    NumOptions = 4;
    PreferenceList[0] = (LocationSide == FS_Right) ? f244_RIGHT_WING : f244_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f244_LEFT_WING : f244_RIGHT_WING;
    PreferenceList[2] = (LocationSide == FS_Right) ? f244_RIGHT_INSIDE_FORWARD : 
      f244_LEFT_INSIDE_FORWARD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f244_LEFT_INSIDE_FORWARD : 
      f244_RIGHT_INSIDE_FORWARD;
    break;
  case f244_DEFENSIVE_CENTER_MIDFIELD:
    NumOptions = 7;
    PreferenceList[0] = (LocationSide == FS_Right) ? f244_RIGHT_WING : f244_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f244_LEFT_WING : f244_RIGHT_WING;
    PreferenceList[2] = (LocationSide == FS_Right) ? f244_RIGHT_INSIDE_FORWARD : 
      f244_LEFT_INSIDE_FORWARD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f244_LEFT_INSIDE_FORWARD : 
      f244_RIGHT_INSIDE_FORWARD;
    PreferenceList[4] = f244_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[5] = (LocationSide == FS_Right) ? f244_RIGHT_MIDFIELD :f244_LEFT_MIDFIELD;
    PreferenceList[6] = (LocationSide == FS_Right) ? f244_LEFT_MIDFIELD :f244_RIGHT_MIDFIELD;
    break;
  case f244_RIGHT_MIDFIELD:
  case f244_LEFT_MIDFIELD:
    NumOptions = 5;
    PreferenceList[0] = (Side == PS_Right) ? f244_RIGHT_WING : f244_LEFT_WING;
    PreferenceList[1] = (Side == PS_Right) ? f244_RIGHT_INSIDE_FORWARD : 
      f244_LEFT_INSIDE_FORWARD;
    PreferenceList[2] = (Side == PS_Right) ? f244_LEFT_INSIDE_FORWARD :
      f244_RIGHT_INSIDE_FORWARD;
    PreferenceList[3] = f244_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[4] = (Side == PS_Right) ? f244_LEFT_WING : f244_RIGHT_WING;
    break;
  case f244_RIGHT_DEFENSE:
  case f244_LEFT_DEFENSE:
  case f244_GOALIE:
    NumOptions = 7;
    PreferenceList[0] = (LocationSide == FS_Right) ? f244_RIGHT_MIDFIELD : 
      f244_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f244_RIGHT_WING : f244_LEFT_WING;
    PreferenceList[2] = (Side == PS_Right) ? f244_RIGHT_INSIDE_FORWARD : 
      f244_LEFT_INSIDE_FORWARD;
    PreferenceList[3] = f244_OFFENSIVE_CENTER_MIDFIELD;
    PreferenceList[4] = (LocationSide == FS_Right) ? f244_LEFT_MIDFIELD : 
      f244_RIGHT_MIDFIELD;
    PreferenceList[5] = (Side == PS_Right) ? f244_LEFT_INSIDE_FORWARD :
      f244_RIGHT_INSIDE_FORWARD;
    PreferenceList[6] = (LocationSide == FS_Right) ? f244_LEFT_WING : f244_RIGHT_WING;
    break;
  }	

  for (int i = NumOptions; i<GetSize(); i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}



/*************************************************************************/
/************************ 4-3-2 Formation ********************************/
/*************************************************************************/

#define f532_GOALIE_BUF      2
#define f532_POSITION_BUF    3

#define f532_GOALTENDERX  (-52)
#define f532_SWEEPERX     (-43)
#define f532_DEFENDERX    (-35)
#define f532_MIDFIELDERX     0
#define f532_FORWARDX       30
#define f532_RIGHTY         25
#define f532_INSIDERIGHTY   15
#define f532_CENTERY         0
#define f532_INSIDELEFTY (-f532_INSIDERIGHTY)
#define f532_LEFTY       (-f532_RIGHTY)

#define f532_HOMEXRANGE f532_FORWARDX
#define f532_HOMEYRANGE f532_RIGHTY
#define f532_MAXXRANGE  (f532_FORWARDX*2)
#define f532_MAXYRANGE  ((((SP_pitch_width/2.0)+5) - f532_RIGHTY)*2)
#define f532_INSIDE_MAXYRANGE ((((SP_pitch_width/2.0)+5) - f532_INSIDERIGHTY)*2)


void FormationInfo::Initialize_532_Formation(){
  
  /* set position within goal stay, in penalty box      */
  Formation_532->SetPosition(f532_GOALIE, Vector(f532_GOALTENDERX,f532_CENTERY), f532_GOALIE_BUF, 
			     Vector(f532_GOALTENDERX,f532_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f532_GOALTENDERX))*2,SP_goal_width),
			     Vector(f532_GOALTENDERX,f532_CENTERY),
			     Vector(((SP_pitch_length/2.0)- (-f532_GOALTENDERX))*2,SP_goal_width),
			     PT_Goaltender, PS_Center);

  /* set position inside penalty box, don't go more than half-way to mid  */
  Formation_532->SetPosition(f532_RIGHT_SWEEPER, Vector(f532_SWEEPERX,f532_CENTERY+SP_penalty_area_width/4), f532_POSITION_BUF, 
			     Vector(f532_SWEEPERX,f532_CENTERY+SP_penalty_area_width/4),
			     Vector(((SP_pitch_length/2.0)- (-f532_SWEEPERX))*2,(SP_penalty_area_width/2)),
			     Vector(f532_SWEEPERX,f532_CENTERY+SP_penalty_area_width/4),
			     Vector(-f532_SWEEPERX - (SP_pitch_length/2.0)/2,((SP_pitch_width/2.0)+5)),
			     PT_Sweeper,PS_Center);

  Formation_532->SetPosition(f532_LEFT_SWEEPER, Vector(f532_SWEEPERX,f532_CENTERY-SP_penalty_area_width/4), f532_POSITION_BUF, 
			     Vector(f532_SWEEPERX,f532_CENTERY-SP_penalty_area_width/4),
			     Vector(((SP_pitch_length/2.0)- (-f532_SWEEPERX))*2,(SP_penalty_area_width/2)),
			     Vector(f532_SWEEPERX,f532_CENTERY-SP_penalty_area_width/4),
			     Vector(-f532_SWEEPERX - (SP_pitch_length/2.0)/2,((SP_pitch_width/2.0)+5)),
			     PT_Sweeper,PS_Center);

  Formation_532->SetPosition(f532_RIGHT_DEFENSE, Vector(f532_DEFENDERX,f532_RIGHTY-13), f532_POSITION_BUF, 
			     Vector(f532_DEFENDERX,f532_RIGHTY+13),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_DEFENDERX,f532_RIGHTY+13),
			     Vector(f532_MAXXRANGE ,f532_MAXYRANGE),
			     PT_Defender, PS_Right);

  Formation_532->SetPosition(f532_CENTER_DEFENSE, Vector(f532_DEFENDERX+5,f532_CENTERY), f532_POSITION_BUF, 
			     Vector(f532_DEFENDERX+5,f532_CENTERY),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_DEFENDERX+5,f532_CENTERY),
			     Vector(f532_MAXXRANGE ,f532_MAXYRANGE),
			     PT_Defender, PS_Center);

  Formation_532->SetPosition(f532_LEFT_DEFENSE, Vector(f532_DEFENDERX,f532_LEFTY+13), f532_POSITION_BUF, 
			     Vector(f532_DEFENDERX,f532_LEFTY-13),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_DEFENDERX,f532_LEFTY-13),
			     Vector(f532_MAXXRANGE ,f532_MAXYRANGE),
			     PT_Defender, PS_Left);

  Formation_532->SetPosition(f532_RIGHT_MIDFIELD, Vector(f532_MIDFIELDERX,f532_RIGHTY), f532_POSITION_BUF, 
			     Vector(f532_MIDFIELDERX,f532_RIGHTY),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_MIDFIELDERX,f532_RIGHTY),
			     Vector(f532_MAXXRANGE ,f532_MAXYRANGE),
			     PT_Midfielder, PS_Right);

  Formation_532->SetPosition(f532_CENTER_MIDFIELD, Vector(f532_MIDFIELDERX,f532_CENTERY), f532_POSITION_BUF, 
			     Vector(f532_MIDFIELDERX,f532_CENTERY),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_MIDFIELDERX,f532_CENTERY),
			     Vector(f532_MAXXRANGE ,f532_MAXYRANGE),
			     PT_Midfielder, PS_Center);

  Formation_532->SetPosition(f532_LEFT_MIDFIELD, Vector(f532_MIDFIELDERX,f532_LEFTY), f532_POSITION_BUF, 
			     Vector(f532_MIDFIELDERX,f532_LEFTY),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_MIDFIELDERX,f532_LEFTY),
			     Vector(f532_MAXXRANGE ,f532_MAXYRANGE),
			     PT_Midfielder, PS_Left);
  
  Formation_532->SetPosition(f532_RIGHT_WING, Vector(f532_FORWARDX,f532_INSIDERIGHTY), f532_POSITION_BUF, 
			     Vector(f532_FORWARDX,f532_INSIDERIGHTY),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_FORWARDX,f532_INSIDERIGHTY),
			     Vector(f532_MAXXRANGE ,f532_INSIDE_MAXYRANGE),
			     PT_Forward, PS_Right);

  Formation_532->SetPosition(f532_LEFT_WING, Vector(f532_FORWARDX,f532_INSIDELEFTY), f532_POSITION_BUF, 
			     Vector(f532_FORWARDX,f532_INSIDELEFTY),
			     Vector(f532_HOMEXRANGE,f532_HOMEYRANGE),
			     Vector(f532_FORWARDX,f532_INSIDELEFTY),
			     Vector(f532_MAXXRANGE ,f532_INSIDE_MAXYRANGE),
			     PT_Forward, PS_Left);

  /* Candidate receivers will be chosen on the fly here */
  Pnum dummylist[1];
  for (int i=1; i<=Formation_532->GetSize(); i++)
    Formation_532->SetCandidateReceivers(i,0,dummylist);

  Formation_532->AllocateUnits(6);

  /* Positions listed in order of importance, captain indicated as index into list */

  Pnum defenders[6] = {f532_GOALIE, f532_RIGHT_SWEEPER, f532_LEFT_SWEEPER,
		      f532_CENTER_DEFENSE, f532_RIGHT_DEFENSE, f532_LEFT_DEFENSE};
  Formation_532->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 6, defenders, 0);

  Pnum midfielders[3] = {f532_CENTER_MIDFIELD, 
			f532_RIGHT_MIDFIELD, f532_LEFT_MIDFIELD};
  Formation_532->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 3, midfielders, 0);

  Pnum forwards[2] = {f532_RIGHT_WING, f532_LEFT_WING};
  Formation_532->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 3, forwards, 0);

  Pnum rights[4] = {f532_RIGHT_DEFENSE, f532_RIGHT_MIDFIELD, f532_RIGHT_WING};
  Formation_532->GetUnit(UT_Right)->InitializeUnit(UT_Right, 3, rights, 1);

  Pnum centers[5] = {f532_GOALIE, f532_RIGHT_SWEEPER, f532_LEFT_SWEEPER, f532_CENTER_DEFENSE, 
		    f532_CENTER_MIDFIELD};
  Formation_532->GetUnit(UT_Center)->InitializeUnit(UT_Center, 5, centers, 4);

  Pnum lefts[3] = {f532_LEFT_DEFENSE, f532_LEFT_MIDFIELD, f532_LEFT_WING};
  Formation_532->GetUnit(UT_Left)->InitializeUnit(UT_Left, 3, lefts, 1);
}

/*************************************************************************/

int Formation::Build_532_ReceiverList(Pnum *PreferenceList, Pnum position, Fside LocationSide){

  int NumOptions=0;
  
  Pside Side = GetPosition(position)->GetSide();

  switch ( position ){
  case f442_LEFT_WING:
  case f442_RIGHT_WING:
    NumOptions = (int_random(3) ? 1 : 0); /* shoot 1 in 3 times */
    PreferenceList[0] =  (Side == PS_Right) ? f442_LEFT_WING : f442_RIGHT_WING;
    break;
  case f532_CENTER_MIDFIELD:
    NumOptions = 4;
    PreferenceList[0] = (LocationSide == FS_Right) ? f532_RIGHT_WING : f532_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f532_LEFT_WING : f532_RIGHT_WING;
    PreferenceList[2] = (LocationSide == FS_Right) ? f532_RIGHT_MIDFIELD :f532_LEFT_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f532_LEFT_MIDFIELD :f532_RIGHT_MIDFIELD;
    break;
  case f532_RIGHT_MIDFIELD:
  case f532_LEFT_MIDFIELD:
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f532_RIGHT_WING : f532_LEFT_WING;
    PreferenceList[1] = (LocationSide == FS_Right) ? f532_LEFT_WING : f532_RIGHT_WING;
    PreferenceList[2] = f532_CENTER_MIDFIELD;
    break;
  case f532_CENTER_DEFENSE:    
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f532_RIGHT_MIDFIELD : f532_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f532_LEFT_MIDFIELD : f532_RIGHT_MIDFIELD;
    PreferenceList[2] = f532_CENTER_MIDFIELD;
    break;
  case f532_RIGHT_DEFENSE:
  case f532_LEFT_DEFENSE:
    NumOptions = 3;
    PreferenceList[0] = (LocationSide == FS_Right) ? f532_RIGHT_MIDFIELD : f532_LEFT_MIDFIELD;
    PreferenceList[1] = (LocationSide == FS_Right) ? f532_RIGHT_WING : f532_LEFT_WING;
    PreferenceList[2] = f532_CENTER_MIDFIELD;
    break;
  case f532_RIGHT_SWEEPER:
  case f532_LEFT_SWEEPER:
    NumOptions = 7;
    PreferenceList[0] = (LocationSide == FS_Right) ? f532_RIGHT_DEFENSE : f532_LEFT_DEFENSE;
    PreferenceList[1] = (LocationSide == FS_Right) ? f532_LEFT_DEFENSE : f532_RIGHT_DEFENSE;
    PreferenceList[2] = (LocationSide == FS_Right) ? f532_RIGHT_MIDFIELD : f532_LEFT_MIDFIELD;
    PreferenceList[3] = (LocationSide == FS_Right) ? f532_LEFT_MIDFIELD : f532_RIGHT_MIDFIELD;
    PreferenceList[4] = f532_CENTER_MIDFIELD;
    PreferenceList[5] = (LocationSide == FS_Right) ? f532_RIGHT_WING : f532_LEFT_WING;
    PreferenceList[6] = (LocationSide == FS_Right) ? f532_LEFT_WING : f532_RIGHT_WING;
    break;
  case f532_GOALIE:
    break; /* clear */
  }	

  for (int i = NumOptions; i<GetSize(); i++)
    PreferenceList[i] = Pnum_Unknown;  /* Pad list with own number, meaning no receiver */

  return NumOptions;
}



/*************************************************************************/
/************************ RIGHT Formation ********************************/
/*************************************************************************/

#define fRT_GOALIE_BUF      2
#define fRT_POSITION_BUF    3

#define fRT_GOALTENDERX   (-52)
#define fRT_FULLBACKX     (-35)
#define fRT_QTRBACKX      (-15)
#define fRT_HALFBACKX      0
#define fRT_3QTRBACKX      12
#define fRT_FORWARDX       30
#define fRT_OUTSIDEY      (-22)
#define fRT_INSIDEY       (-7)
#define fRT_CENTERY        0

#define fRT_HOMEXRANGE    20
#define fRT_HOMEYRANGE    10
#define fRT_MAXXRANGE     30
#define fRT_MAXYRANGE     30

void FormationInfo::Initialize_right_Formation(){
  
  /* set position within goal stay, in penalty box      */
  Formation_right->SetPosition(fRT_GOALIE, Vector(fRT_GOALTENDERX,fRT_CENTERY), fRT_GOALIE_BUF, 
			       Vector(fRT_GOALTENDERX,fRT_CENTERY),
			       Vector(((SP_pitch_length/2.0)- (-fRT_GOALTENDERX))*2,SP_goal_width),
			       Vector(fRT_GOALTENDERX,fRT_CENTERY),
			       Vector(((SP_pitch_length/2.0)- (-fRT_GOALTENDERX))*2,SP_goal_width),
			       PT_Goaltender,PS_Center);

  Formation_right->SetPosition(fRT_INSIDE_FULLBACK, Vector(fRT_FULLBACKX,fRT_INSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_FULLBACKX,fRT_INSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_FULLBACKX,fRT_INSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Defender, PS_Center);

  Formation_right->SetPosition(fRT_OUTSIDE_FULLBACK, Vector(fRT_FULLBACKX,fRT_OUTSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_FULLBACKX,fRT_OUTSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_FULLBACKX,fRT_OUTSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Defender, PS_Right);

  Formation_right->SetPosition(fRT_INSIDE_QTRBACK, Vector(fRT_QTRBACKX,fRT_INSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_QTRBACKX,fRT_INSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_QTRBACKX,fRT_INSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Defender, PS_Center);

  Formation_right->SetPosition(fRT_OUTSIDE_QTRBACK, Vector(fRT_QTRBACKX,fRT_OUTSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_QTRBACKX,fRT_OUTSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_QTRBACKX,fRT_OUTSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Defender, PS_Right);

  Formation_right->SetPosition(fRT_INSIDE_HALFBACK, Vector(fRT_HALFBACKX,fRT_INSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_HALFBACKX,fRT_INSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_HALFBACKX,fRT_INSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Midfielder, PS_Center);

  Formation_right->SetPosition(fRT_OUTSIDE_HALFBACK, Vector(fRT_HALFBACKX,fRT_OUTSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_HALFBACKX,fRT_OUTSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_HALFBACKX,fRT_OUTSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Midfielder, PS_Right);

  Formation_right->SetPosition(fRT_INSIDE_3QTRBACK, Vector(fRT_3QTRBACKX,fRT_INSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_3QTRBACKX,fRT_INSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_3QTRBACKX,fRT_INSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Midfielder, PS_Center);

  Formation_right->SetPosition(fRT_OUTSIDE_3QTRBACK, Vector(fRT_3QTRBACKX,fRT_OUTSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_3QTRBACKX,fRT_OUTSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_3QTRBACKX,fRT_OUTSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Midfielder, PS_Right);

  Formation_right->SetPosition(fRT_INSIDE_FORWARD, Vector(fRT_FORWARDX,fRT_INSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_FORWARDX,fRT_INSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_FORWARDX,fRT_INSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Forward, PS_Center);

  Formation_right->SetPosition(fRT_OUTSIDE_FORWARD, Vector(fRT_FORWARDX,fRT_OUTSIDEY), fRT_POSITION_BUF, 
			       Vector(fRT_FORWARDX,fRT_OUTSIDEY),
			       Vector(fRT_HOMEXRANGE,fRT_HOMEYRANGE),
			       Vector(fRT_FORWARDX,fRT_OUTSIDEY),
			       Vector(fRT_MAXXRANGE ,fRT_MAXYRANGE),
			       PT_Forward, PS_Right);


  /* Candidate receivers will be chosen on the fly here */
  Pnum receiverlist[MAX_PLAYERS] = {fRT_INSIDE_FORWARD,fRT_OUTSIDE_FORWARD,
				 fRT_INSIDE_3QTRBACK,fRT_OUTSIDE_3QTRBACK,
				 fRT_INSIDE_HALFBACK,fRT_OUTSIDE_HALFBACK,
				 fRT_INSIDE_QTRBACK,fRT_OUTSIDE_QTRBACK,
				 fRT_INSIDE_FULLBACK,fRT_OUTSIDE_FULLBACK,0};
  for (int i=1; i<=Formation_right->GetSize(); i++)
    Formation_right->SetCandidateReceivers(i,Formation_right->GetSize()-i,receiverlist);

  Formation_right->AllocateUnits(3);

  /* Positions listed in order of importance, captain indicated as index into list */

  Pnum defenders[3] = {fRT_GOALIE, fRT_INSIDE_FULLBACK, fRT_OUTSIDE_FULLBACK};
  Formation_right->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 3, defenders, 0);

  Pnum midfielders[6] = {fRT_INSIDE_QTRBACK,  fRT_OUTSIDE_QTRBACK,
			fRT_INSIDE_HALFBACK, fRT_OUTSIDE_HALFBACK,
			fRT_INSIDE_3QTRBACK,  fRT_OUTSIDE_3QTRBACK};
  Formation_right->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 6, midfielders, 2);

  Pnum forwards[2] = {fRT_INSIDE_FORWARD, fRT_OUTSIDE_FORWARD};
  Formation_right->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 2, forwards, 0);
}



/*************************************************************************/
/************************ LEFT  Formation ********************************/
/*************************************************************************/

#define fLT_GOALIE_BUF      2
#define fLT_POSITION_BUF    3

#define fLT_GOALTENDERX   (-52)
#define fLT_FULLBACKX     (-35)
#define fLT_QTRBACKX      (-15)
#define fLT_HALFBACKX      0
#define fLT_3QTRBACKX      12
#define fLT_FORWARDX       30
#define fLT_OUTSIDEY       22
#define fLT_INSIDEY        7
#define fLT_CENTERY        0

#define fLT_HOMEXRANGE    20
#define fLT_HOMEYRANGE    10
#define fLT_MAXXRANGE     30
#define fLT_MAXYRANGE     30

void FormationInfo::Initialize_left_Formation(){
  
  /* set position within goal stay, in penalty box      */
  Formation_left->SetPosition(fLT_GOALIE, Vector(fLT_GOALTENDERX,fLT_CENTERY), fLT_GOALIE_BUF, 
			      Vector(fLT_GOALTENDERX,fLT_CENTERY),
			      Vector(((SP_pitch_length/2.0)- (-fLT_GOALTENDERX))*2,SP_goal_width),
			      Vector(fLT_GOALTENDERX,fLT_CENTERY),
			      Vector(((SP_pitch_length/2.0)- (-fLT_GOALTENDERX))*2,SP_goal_width),
			      PT_Goaltender,PS_Center);

  Formation_left->SetPosition(fLT_INSIDE_FULLBACK, Vector(fLT_FULLBACKX,fLT_INSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_FULLBACKX,fLT_INSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_FULLBACKX,fLT_INSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Defender, PS_Center);

  Formation_left->SetPosition(fLT_OUTSIDE_FULLBACK, Vector(fLT_FULLBACKX,fLT_OUTSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_FULLBACKX,fLT_OUTSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_FULLBACKX,fLT_OUTSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Defender, PS_Left);

  Formation_left->SetPosition(fLT_INSIDE_QTRBACK, Vector(fLT_QTRBACKX,fLT_INSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_QTRBACKX,fLT_INSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_QTRBACKX,fLT_INSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Defender, PS_Center);

  Formation_left->SetPosition(fLT_OUTSIDE_QTRBACK, Vector(fLT_QTRBACKX,fLT_OUTSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_QTRBACKX,fLT_OUTSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_QTRBACKX,fLT_OUTSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Defender, PS_Left);

  Formation_left->SetPosition(fLT_INSIDE_HALFBACK, Vector(fLT_HALFBACKX,fLT_INSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_HALFBACKX,fLT_INSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_HALFBACKX,fLT_INSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Midfielder, PS_Center);

  Formation_left->SetPosition(fLT_OUTSIDE_HALFBACK, Vector(fLT_HALFBACKX,fLT_OUTSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_HALFBACKX,fLT_OUTSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_HALFBACKX,fLT_OUTSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Midfielder, PS_Left);

  Formation_left->SetPosition(fLT_INSIDE_3QTRBACK, Vector(fLT_3QTRBACKX,fLT_INSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_3QTRBACKX,fLT_INSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_3QTRBACKX,fLT_INSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Midfielder, PS_Center);

  Formation_left->SetPosition(fLT_OUTSIDE_3QTRBACK, Vector(fLT_3QTRBACKX,fLT_OUTSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_3QTRBACKX,fLT_OUTSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_3QTRBACKX,fLT_OUTSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Midfielder, PS_Left);

  Formation_left->SetPosition(fLT_INSIDE_FORWARD, Vector(fLT_FORWARDX,fLT_INSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_FORWARDX,fLT_INSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_FORWARDX,fLT_INSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Forward, PS_Center);

  Formation_left->SetPosition(fLT_OUTSIDE_FORWARD, Vector(fLT_FORWARDX,fLT_OUTSIDEY), fLT_POSITION_BUF, 
			      Vector(fLT_FORWARDX,fLT_OUTSIDEY),
			      Vector(fLT_HOMEXRANGE,fLT_HOMEYRANGE),
			      Vector(fLT_FORWARDX,fLT_OUTSIDEY),
			      Vector(fLT_MAXXRANGE ,fLT_MAXYRANGE),
			      PT_Forward, PS_Left);


  /* Candidate receivers will be chosen on the fly here */
  Pnum receiverlist[MAX_PLAYERS] = {fLT_INSIDE_FORWARD,fLT_OUTSIDE_FORWARD,
				 fLT_INSIDE_3QTRBACK,fLT_OUTSIDE_3QTRBACK,
				 fLT_INSIDE_HALFBACK,fLT_OUTSIDE_HALFBACK,
				 fLT_INSIDE_QTRBACK,fLT_OUTSIDE_QTRBACK,
				 fLT_INSIDE_FULLBACK,fLT_OUTSIDE_FULLBACK,0};
  for (int i=1; i<=Formation_left->GetSize(); i++)
    Formation_left->SetCandidateReceivers(i,Formation_left->GetSize()-i,receiverlist);

  Formation_left->AllocateUnits(3);

  /* Positions listed in order of importance, captain indicated as index into list */

  Pnum defenders[3] = {fLT_GOALIE, fLT_INSIDE_FULLBACK, fLT_OUTSIDE_FULLBACK};
  Formation_left->GetUnit(UT_Defense)->InitializeUnit(UT_Defense, 3, defenders, 0);

  Pnum midfielders[6] = {fLT_INSIDE_QTRBACK,  fLT_OUTSIDE_QTRBACK,
			fLT_INSIDE_HALFBACK, fLT_OUTSIDE_HALFBACK,
			fLT_INSIDE_3QTRBACK,  fLT_OUTSIDE_3QTRBACK};
  Formation_left->GetUnit(UT_Midfield)->InitializeUnit(UT_Midfield, 6, midfielders, 2);

  Pnum forwards[2] = {fLT_INSIDE_FORWARD, fLT_OUTSIDE_FORWARD};
  Formation_left->GetUnit(UT_Forward)->InitializeUnit(UT_Forward, 2, forwards, 0);
}
