/* -*- Mode: C++ -*- */

#ifdef RELEASE_VERSION  
THIS FILE SHOULD NOT BE INCLUDED!
#endif // RELEASE_VERSION


#ifndef _TEAMPOSITION_H_
#define _TEAMPOSITION_H_

#include "MemPosition.h"
#include "geometry.h"


/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        TeamPosition Class                                    */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

class TeamPosition {
public:
  TeamPosition();

  void SetHome(Vector p, float buf, Ptype t, Pside s);
  void SetHomeRange(Vector c, Vector s);
  void SetMaxRange (Vector c, Vector s);

  void PrintHomeRange();
  void PrintMaxRange();

  inline float GetHomeX()      { return Home.x;     }
  inline float GetHomeY()      { return Home.y;     }
  inline Vector GetHome()      { return Home;       } 
  inline float GetHomeBuffer() { return HomeBuffer; }

  inline Rectangle *GetHomeRange() { return &HomeRange; }
  inline Rectangle *GetMaxRange()  { return &MaxRange;  }

  inline Ptype GetType() { return type; }
  inline Pside GetSide() { return side; }

private:
  Vector Home;
  float HomeBuffer;

  Rectangle HomeRange;
  Rectangle MaxRange;

  Ptype type;
  Pside side;
};




/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        Unit Class                                            */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

class Unit {
public:
  Unit();
  ~Unit();

  void InitializeUnit(Utype tp, int sz, int *mems, int capt);

  inline Utype GetType(){ return type;    }
  inline int      GetSize()     { return size;    }
  inline Pnum     GetCaptain()  { return captain; }
  inline Pnum     *GetMembers() { return members; }
  
  Bool IsMember(Pnum position);
  Bool IsCaptain(Pnum position);

  Pnum ImportantPosition(Pnum p1, Pnum p2);

private:
  Utype type;      /* defensive, mid, left, center, etc. */
  int      size;      /* number of members                  */
  Pnum      *members;  /* The POSITIONS in the unit          */
  Pnum     captain;   /* The Captain has special privileges */
};




/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        Unit Class                                            */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

class Formation {
public:

  Formation(Ftype type, int size);
  ~Formation();

  void AllocateUnits(int num);

  inline Ftype GetType() { return type; }
  inline int   GetSize() { return size; }

  void SetPosition(Pnum num, Vector home, float buffer,
		   Vector home_center, Vector home_size,
		   Vector max_center,  Vector max_size,
		   Ptype t, Pside s);

  TeamPosition *GetPosition(Pnum num);

  int Build_433_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_442_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_352_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_72_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_334_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_244_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_532_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_right_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  int Build_left_ReceiverList(int *PreferenceList, int position, Fside LocationSide);
  
  void   SetCandidateReceivers(Pnum position, int num, Pnum *PrefList);
  int   *GetCandidateReceivers(Pnum position, Fside LocationSide);

  Unit *GetUnit(int unit);
  inline int GetNumUnits() {return NumUnits;}
  Bool IsUnitMember(int unit, Pnum position);
  Bool IsUnitCaptain(int unit, Pnum position);

  Bool IsMoreImportantPosition(Pnum pos1, Pnum pos2);

  Pnum  LocationToPosition(Vector p);
  float DistanceToPositionHome(Pnum position, Vector p);
  Pnum  ClosestPosition(Vector p);

private:
  Ftype type;
  int  size;

  TeamPosition PositionList[MAX_PLAYERS]; /* A static list of positions:     */
                                          /* Shouldn't change once defined   */
  Pnum *ReceiverList[MAX_PLAYERS]; /* map position to candidate       */
                                   /* receiver positions              */
  Pnum *TempReceiverList;          /* Used to pass back possible receivers */

  int  NumUnits;
  Unit *FormationUnits;
};





/********************************************************************************/
/********************************************************************************/
/********************************************************************************/
/*                        FormationInfo Class                                */
/********************************************************************************/
/********************************************************************************/
/********************************************************************************/

#define Pnum_Unknown  0
#define Formation_Unknown NULL

class FormationInfo : public PositionInfo {
public:

  FormationInfo();
  ~FormationInfo();

  void Initialize(); 
  void Initialize_433_Formation();
  void Initialize_442_Formation();
  void Initialize_352_Formation();
  void Initialize_72_Formation();
  void Initialize_334_Formation();
  void Initialize_244_Formation();
  void Initialize_532_Formation();
  void Initialize_right_Formation();
  void Initialize_left_Formation();

  void Reset();

  void SetPlayerPosition(Unum player, Pnum position, Time time);
  void ClearPlayerPosition(Unum player);
  void ClearPositionPlayer(Pnum position); 

  void SetMyPosition(Pnum position);
  void ClearMyPosition();

  Bool PositionOccupied(Pnum position);

  Pnum  LocationToPosition(Vector p, Bool AdjustForOffsides = FALSE);
  float DistanceToPositionHome(Pnum position, Vector p, Bool AdjustForOffsides = FALSE);
  Pnum  ClosestPosition(Vector p, Bool AdjustForOffsides = FALSE);

  Pnum  LocationToAdjustedForOffsidePosition(Vector p);
  float DistanceToAdjustedForOffsidePositionHome(Pnum position, Vector p);
  float Distance2ToAdjustedForOffsidePositionHome(Pnum position, Vector p);
  Pnum  ClosestAdjustedForOffsidePosition(Vector p);
  int   NumCloserAdjustedForOffsidePositions(Pnum pos, Vector p);

  Vector PositionHome          (Pnum position, Bool AdjustForOffsides = FALSE);
  inline float PositionHomeX   (Pnum position, Bool AdjustForOffsides = FALSE) 
    { return PositionHome(position,AdjustForOffsides).x; }
  inline float PositionHomeY   (Pnum position, Bool AdjustForOffsides = FALSE) 
    { return PositionHome(position,AdjustForOffsides).y; }
  float PositionHomeBuffer     (Pnum position);
  Ptype PositionType           (Pnum position);
  Pside PositionSide           (Pnum position);
  Rectangle PositionHomeRange (Pnum position, Bool AdjustForOffsides = FALSE);
  Rectangle PositionMaxRange  (Pnum position, Bool AdjustForOffsides = FALSE);
  float PositionHomeRangeWidth (Pnum position, Bool AdjustForOffsides = FALSE);
  float PositionHomeRangeHeight(Pnum position, Bool AdjustForOffsides = FALSE);
  float PositionMaxRangeWidth  (Pnum position, Bool AdjustForOffsides = FALSE);
  float PositionMaxRangeHeight (Pnum position, Bool AdjustForOffsides = FALSE);
  Vector PlayerHome            (Unum player, Bool AdjustForOffsides = FALSE);
  inline float PlayerHomeX     (Unum player, Bool AdjustForOffsides = FALSE) 
    { return PlayerHome(player,AdjustForOffsides).x; }
  inline float PlayerHomeY     (Unum player, Bool AdjustForOffsides = FALSE) 
    { return PlayerHome(player,AdjustForOffsides).y; }
  float PlayerHomeBuffer       (Unum player  );
  Ptype PlayerType             (Unum player  );
  Pside PlayerSide             (Unum player  );

  Pnum  PlayerPosition(Unum player);
  Unum  PositionPlayer(Pnum position);
  Time  PlayerPositionTime(Unum player);

  Pnum   MyPosition();
  Vector MyPositionHome(Bool AdjustForOffsides = FALSE);
  inline float MyPositionX(Bool AdjustForOffsides = FALSE) { return MyPositionHome(AdjustForOffsides).x; }
  inline float MyPositionY(Bool AdjustForOffsides = FALSE) { return MyPositionHome(AdjustForOffsides).y; }

  Ptype MyPositionType();
  Pside MyPositionSide();
  float MyPositionBuffer();
  Rectangle MyHomeRange(Bool AdjustForOffsides = FALSE);
  Rectangle MyMaxRange(Bool AdjustForOffsides = FALSE);
  float MyHomeRangeWidth(Bool AdjustForOffsides = FALSE);
  float MyHomeRangeHeight(Bool AdjustForOffsides = FALSE);
  float MyMaxRangeWidth(Bool AdjustForOffsides = FALSE);
  float MyMaxRangeHeight(Bool AdjustForOffsides = FALSE);

  void PrintMyHomeRange(Bool AdjustForOffsides);
  void PrintMyMaxRange(Bool AdjustForOffsides);

  Bool IsWithinMyHomeRange(Vector p, Bool AdjustForOffsides = FALSE);
  Bool IsWithinMyMaxRange (Vector p, Bool AdjustForOffsides = FALSE);

  void  ResetCurrentHome();

  void  SetFormation (Ftype formation_number, Time time);
  inline Formation *MyCurrentFormation() { return CurrentFormation; }
  inline Ftype MyCurrentFormationType() { return CurrentFormation->GetType(); }
  inline int   MyCurrentFormationSize() { return CurrentFormation->GetSize(); }

  inline float MyCurrentHomeX() { return CurrentHome.x; }
  inline float MyCurrentHomeY() { return CurrentHome.y; }
  inline Vector MyCurrentHome() { return CurrentHome; }

  Bool SetCurrentHome (Vector p);
  Bool SetCurrentHomeX(float x );
  Bool SetCurrentHomeY(float y );

  void HearTeammateFormationPosition(Unum player, Ftype form, Time formtime, Pnum pos, Time postime);

  int UnitSize(int unit);
  Pnum *UnitMembers(int unit);
  Bool IsUnitMember(int unit, Unum player);
  Bool IsUnitCaptain(int unit, Unum player);
  Bool IsMyUnit(int unit);
  Bool AmUnitCaptain(int unit);
  Bool IsMyUnitCaptain(Unum player);

  int  *CandidateReceivers(Pnum position, Fside LocationSide);
  Bool AmCandidateReceiverOfPlayer(Unum player);

  Bool IsMoreImportantPosition(Pnum pos1, Pnum pos2);
  Pnum GetNewPosition();
  Pnum ConsiderPosition(Pnum position);
  Pnum ConsiderNewPosition();

  Bool  InPosition();
  Bool  InKickoffPosition();
  Pnum  PositionOfMyLocation(Bool AdjustForOffsides = FALSE);
  Ptype MyLocationsPositionType(Bool AdjustForOffsides = FALSE);
  Pside MyLocationsPositionSide(Bool AdjustForOffsides = FALSE);

  Bool IsWithinMyHomeRange(char side, Unum number, Bool AdjustForOffsides = FALSE);
  Bool IsWithinMyMaxRange (char side, Unum number, Bool AdjustForOffsides = FALSE);
  inline Bool TeammateIsWithinMyHomeRange(Unum num, Bool AdjustForOffsides = FALSE)
    {return IsWithinMyHomeRange(MySide,num,AdjustForOffsides); }
  inline Bool OpponentIsWithinMyHomeRange(Unum num, Bool AdjustForOffsides = FALSE)
    {return IsWithinMyHomeRange(TheirSide,num,AdjustForOffsides); }
  inline Bool TeammateIsWithinMyMaxRange(Unum num, Bool AdjustForOffsides = FALSE)
    {return IsWithinMyMaxRange(MySide,num,AdjustForOffsides); }
  inline Bool OpponentIsWithinMyMaxRange(Unum num, Bool AdjustForOffsides = FALSE)
    {return IsWithinMyMaxRange(TheirSide,num,AdjustForOffsides); }
  Bool AmWithinMyHomeRange(Bool AdjustForOffsides = FALSE);
  Bool AmWithinMyMaxRange (Bool AdjustForOffsides = FALSE);
  Bool BallIsWithinMyHomeRange(Bool AdjustForOffsides = FALSE);
  Bool BallIsWithinMyMaxRange (Bool AdjustForOffsides = FALSE);
  Bool OpponentIsWithinPlayerHomeRange(Unum opponent, Unum player, Bool AdjustForOffsides = FALSE);
  Bool OpponentIsWithinPlayerMaxRange(Unum opponent, Unum player, Bool AdjustForOffsides = FALSE);

  float PlayerDistanceToPositionHome(Unum player, Pnum position, Bool AdjustForOffsides = FALSE);

  void  UpdateHome();
  void  UpdateMark();
  int   MyReceiverList(Pnum *ReceiverList);

  void SetPositionMark(Pnum pos, Unum mark, Time t);
  void SetMyMark(Unum mark,Time t);
  inline void SetMarkBuffer(float buffer) { MarkBuffer = buffer; }
  Unum PositionMark(Pnum pos);
  Pnum OpponentMarker(Unum opp);
  Bool OpponentMarked(Unum opp);
  inline Unum MyMark() { return PositionMark(MyPosition()); }
  float MarkBuffer;    /* The distance at which I should mark           */

  /**** Public Variables  ***********************************************/

  MCtype MarkChangeMethod;      /* There might be different ways of     */
  HCtype HomeChangeMethod;      /* positions, and where to make home    */

  /* int    PositionChangeMethod; */ /* deciding who to mark, when to change */ 
  /* int   MarkPursuitRange;      */ /* range, max_range, everywhere, etc.   */
  /* int   PositionStrategy;      */ /* evade, mark, hold home, etc.         */

  Time  FormationTime;          /* Time the current formation was set   */

  Bool ChangePositions;

  Ftype InitialFormation;
  Ftype FormationWhenWinning;
  Ftype FormationWhenLosing;
  Ftype FormationWhenLosingByLots;
  Ftype FormationWhenTied;

private:
  Vector CurrentHome;  /* This could be different from Home in my position */

  Unum *PositionPlayers;  /* Maps positions to their players  */
  Pnum *PlayerPositions;  /* Maps players to their positions  */
  Time *PlayerPositionTimes; /* LATEST time position verified */

  Unum *PositionMarks;    /* Maps positions to the opponents they mark */
  Time *PositionMarkTimes; 
  
  Formation *CurrentFormation;
  Formation *Formation_433;
  Formation *Formation_442;
  Formation *Formation_352;
  Formation *Formation_72;
  Formation *Formation_334;
  Formation *Formation_244;
  Formation *Formation_532;
  Formation *Formation_right;
  Formation *Formation_left;

  Pnum stored_PositionOfMyLocation;
  Time stored_PositionOfMyLocation_time;
};

#endif
