/* -*- Mode: C++ -*- */

#ifdef RELEASE_VERSION  
THIS FILE SHOULD NOT BE INCLUDED!
#endif // RELEASE_VERSION

#ifndef _DT_H_
#define _DT_H_

#include "MemFormation.h"

enum PassTargetType{
  PT_none,
  PT_teammate,
  PT_point
};

enum PassResultType{
  PR_none,
  PR_success,
  PR_failure
};


class DTInfo : public virtual FormationInfo{
public:

  ~DTInfo();
  void Initialize(); 

  inline Bool TrainingPassInProgress() { return training_pass_in_progress; }

  void StartTrainingPass();
  void StartTrainingPass(Unum teammate);
  void StartTrainingPass(Vector point);
  void EndTrainingPass(PassResultType result);
  Unum MonitorControl();
  void MonitorTrainingPass();

  void GetPassData(Vector point, char *outstream = NULL);
  void GetPassData(Unum receiver, char *outstream = NULL);
  void GetPassDataCones(Vector point, char *outstream = NULL);
  void GetPassDataCones(Unum receiver, char *outstream = NULL);
  void GetPassDataOld(Vector point, char *outstream = NULL);
  void GetPassDataOld(Unum receiver, char *outstream = NULL);

  void FillAttributes(Unum receiver);
  void FillAttributes(Vector point);

  float PassConfidence(Unum receiver);
  float PassConfidence(Vector point);
  Unum  MaxPassConfidenceTeammate();

  char datafilename[40];

private:
  //const int Max_Data_Len = 1024;
#define Max_Data_Len (1024)

  Bool           training_pass_in_progress;
  PassTargetType training_pass_type;
  Unum           training_pass_target_teammate;
  Vector         training_pass_target_point;
  Time           training_pass_time;

  float          *pass_confidence;
  Time           *pass_confidence_time;

  char           data_buf[Max_Data_Len];
};

#endif
