/* -*- Mode: C++ -*- */
#include "MemDT.h"
#include "c4.5/consult.h"
#include "c4.5/getnames.h"
#include "c4.5/trees.h"
#include "c4.5/userint.h"
#include "c4.5/defns.i"


/***********************************************************************************************/
/***********************************************************************************************/
/***********************************************************************************************/

DTInfo::~DTInfo()
{
  delete pass_confidence;
  delete pass_confidence_time;
}

/***********************************************************************************************/

void DTInfo::Initialize()
{
  data_buf[0] = '\0';

  if ( VP_train_DT ){
    if ( MySide == 'l' && MyNumber == 1 )
      system("date > ../date.log");
    GetStampedName(datafilename,"../data/DTdat");
  }

  training_pass_in_progress = FALSE;

  int a;
  if ( VP_use_DT ){
    /* Initialize the tree */
    FileName = CP_tree_stem;   
    printf("%s\n",FileName);
    GetNames();
    DecisionTree = GetTree(".tree");
  
    RangeDesc = new ValRange[MaxAtt+1];
    ForEach(a, 0, MaxAtt){
	if ( MaxAttVal[a] ){
	    RangeDesc[a].Probability = new double[MaxAttVal[a]+1];
	}
    } 
  }

  pass_confidence      = new float[SP_team_size+1];
  pass_confidence_time = new Time [SP_team_size+1];
  
  for (int i=1; i<=SP_team_size; i++)
    pass_confidence_time[i] = -CP_DT_evaluate_interval;
}

/***********************************************************************************************/

void DTInfo::StartTrainingPass()
{
  training_pass_time = CurrentTime;
  training_pass_in_progress = TRUE;
}

/***********************************************************************************************/

void DTInfo::StartTrainingPass(Unum teammate)
{
  training_pass_type = PT_teammate;
  training_pass_target_teammate = teammate;
  GetPassData(teammate);
  StartTrainingPass();
}

/***********************************************************************************************/

void DTInfo::StartTrainingPass(Vector point)
{
  training_pass_type = PT_point;
  training_pass_target_point = point;
  GetPassData(point);
  StartTrainingPass();
}

/***********************************************************************************************/

void DTInfo::EndTrainingPass(PassResultType result)
{
  if ( !training_pass_in_progress ) my_error("can't end a training event that hasn't started");

  training_pass_in_progress = FALSE;

  char result_char = '?';
  if      ( result == PR_success ) result_char = 'S';
  else if ( result == PR_failure ) result_char = 'F';

  FILE *datafile = fopen(datafilename,"a");
  /* fprintf(datafile,"%d to %d at %d  ****  %s %c\n",
	  MyNumber,target_teammate,kick_time.t,data_buf,result_char);*/
  fprintf(datafile,"%s %c\n",data_buf,result_char);
  fclose(datafile);
}

/***********************************************************************************************/

Unum DTInfo::MonitorControl()
{
  return PlayerWithBall();
}

/***********************************************************************************************/

void DTInfo::MonitorTrainingPass()
{
  if ( !training_pass_in_progress ) my_error("can't monitor if not in progress");
  if ( !BallPositionValid() ) my_error("can't monitor if ball not valid");

  Unum controller = MonitorControl();

  if ( controller != Unum_Unknown ){
    if ( training_pass_type == PT_teammate && controller == training_pass_target_teammate )
      EndTrainingPass(PR_success);
    else
      EndTrainingPass(PR_failure);
  }
  else if ( training_pass_type == PT_point && 
	    BallAbsolutePosition().dist(training_pass_target_point) < SP_goal_width/2 ) 
    EndTrainingPass(PR_success);
}

/***********************************************************************************************/

void DTInfo::GetPassData(Unum receiver, char *outstream)
{
  GetPassDataCones(receiver,outstream);
}

/***********************************************************************************************/

void DTInfo::GetPassData(Vector point, char *outstream)
{
  GetPassDataCones(point,outstream);
}

/***********************************************************************************************/

void DTInfo::GetPassDataCones(Unum receiver, char *outstream){
  if ( !TeammatePositionValid(receiver) ) my_error("Can't get pass data for unknown receiver");
  GetPassDataCones( TeammateAbsolutePosition(receiver),outstream );
}

/***********************************************************************************************/

/* Can be used to get data to a point--not just a receiver */
/* Eventually want to do this from other players' perspective (if works) */

void DTInfo::GetPassDataCones(Vector point, char *outstream){

  if ( outstream == NULL ) outstream = data_buf;

  int index=0, j;
  int DistLength = 5;
  int DistPrecision = 1;

#define WRITE_DISTANCE(a)   for(j=0; j<DistLength; j++) outstream[index++] = ' '; put_float( &outstream[index++], a, DistPrecision );  outstream[index++] = ','

#define WRITE_STAT(a) outstream[index++]='0'+Min(9,a);  outstream[index++]=','

  /* dist to dest 

     teammates, opponents, players in cone of ratio .1,.2,.3,....9

     repeat extending the cone by 25%
  */

  float point_dist = DistanceTo(point);
  WRITE_DISTANCE(point_dist);
  
  int teammates,opponents,players;
  Vector dest = point;

  for (float ratio=.1; ratio<.95; ratio+=.1){
    teammates = NumTeammatesInCone(ratio,dest);
    opponents = NumOpponentsInCone(ratio,dest);
    players   = teammates+opponents;
    WRITE_STAT(teammates);
    WRITE_STAT(opponents);
    WRITE_STAT(players);
  }

  Vector traj = point - MyPos();
  traj *=  1.25;
  dest = MyPos() + traj;  

  for (float ratio=.1; ratio<.95; ratio+=.1){
    teammates = NumTeammatesInCone(ratio,dest);
    opponents = NumOpponentsInCone(ratio,dest);
    players   = teammates+opponents;
    WRITE_STAT(teammates);
    WRITE_STAT(opponents);
    WRITE_STAT(players);
  }

  outstream[index]='\0';
}

/***********************************************************************************************/

void DTInfo::GetPassDataOld(Unum receiver, char *outstream){
  if ( !TeammatePositionValid(receiver) ) my_error("Can't get pass data for unknown receiver");
  GetPassData( TeammateAbsolutePosition(receiver),outstream );
}

/***********************************************************************************************/

/* Can be used to get data to a point--not just a receiver */
/* Eventually want to do this from other players' perspective (if works) */

void DTInfo::GetPassDataOld(Vector point, char *outstream){

  if ( outstream == NULL ) outstream = data_buf;

  int index = 0, counter=0, i,j,k;
  int MaxPlayers = 5;
  int DistLength = 5;
  int DistPrecision = 1;
  int AngLength = 5;
  int AngPrecision = 1;
  Vector player_position;
  Unum player;
  float player_dist_to_point, player_dist_to_line, player_dist;
  AngleDeg angle_diff;

  int tp4=0,tp8=0,tp12=0,op4=0,op8=0,op12=0,pp4=0,pp8=0,pp12=0; /* players within x of dest */
  int tl4=0,tl8=0,tl12=0,ol4=0,ol8=0,ol12=0,pl4=0,pl8=0,pl12=0; /* players with x of line */

#define WRITE_DISTANCE(a)   for(j=0; j<DistLength; j++) outstream[index++] = ' '; put_float( &outstream[index++], a, DistPrecision );  outstream[index++] = ','

#define WRITE_ANGLE(a)      for(j=0; j<AngLength; j++) outstream[index++] = ' ';  put_float( &outstream[index++], a, AngPrecision );   outstream[index++] = ','

  /* dist to dest 

     sort teammates by dist to dest (top 5) 
     sort opps by dist to dest (top 5)
     dist to dest, dist from me, me to dest -dist to dest, diff in angle to target, player

     sort teammates by dist to line if between (top 5) (no receiver, no me)
     sort opps by dist to line if between (top 5) 
     dist to line, dist to me, dist to dest (along line), angle diff to point and player

     count stats as go:
     num teammates, opps, players within 4,8,12 of dest,line
  */

  Unum teammates[SP_team_size];
  Unum opponents[SP_team_size];
  
  float point_dist = DistanceTo(point);
  WRITE_DISTANCE(point_dist);

  int NumTeammates = SortPlayersByDistanceToPoint('m',point,teammates);
  int NumOpponents = SortPlayersByDistanceToPoint('t',point,opponents);

  counter=0;
  for (i=0; i<NumTeammates; i++){  
    if ( (player=teammates[i])==MyNumber ) 
      continue; /* don't include me */

    if ( TeammatePositionValid(player) ){
      if ( (player_position=TeammateAbsolutePosition(player)) == point )
	continue; /* don't include target player */

      player_dist_to_point = point.dist(player_position);
      player_dist = DistanceTo(player_position);

      WRITE_DISTANCE(player_dist_to_point);
      WRITE_DISTANCE(player_dist);
      WRITE_DISTANCE(player_dist - point_dist);
      
      angle_diff = GetNormalizeAngleDeg(AngleToFromBody(point)-AngleToFromBody(player_position));

      WRITE_ANGLE(fabs(angle_diff));

      if ( player_dist_to_point <= 12 ){ tp12++; pp12++;
      if ( player_dist_to_point <= 8 ) {  tp8++;  pp8++;
      if ( player_dist_to_point <= 4 ) {  tp4++;  pp4++; }}}

      if (++counter == MaxPlayers)
	break;
    }
  }
  for (i=counter; i<MaxPlayers; i++){ 
    for (j=0;j<4;j++){ outstream[index++]='?'; outstream[index++]=','; }
  }

  counter=0;
  for (i=0; i<NumOpponents; i++){  
    player=opponents[i];
    if ( OpponentPositionValid(player) ){

      player_position=OpponentAbsolutePosition(player);
      player_dist_to_point = point.dist(player_position);
      player_dist = DistanceTo(player_position);

      /* Don't consider the goalie */
      if ( MarkerPosition(RM_Their_Goal).dist(point) < SP_goal_width/2 && 
	   player_dist_to_point < SP_goal_width/2 )
	continue;

      WRITE_DISTANCE(player_dist_to_point);
      WRITE_DISTANCE(player_dist);
      WRITE_DISTANCE(player_dist - point_dist);
      
      angle_diff = GetNormalizeAngleDeg(AngleToFromBody(point)-AngleToFromBody(player_position));

      WRITE_ANGLE(fabs(angle_diff));

      if ( player_dist_to_point <= 12 ){ op12++; pp12++;
      if ( player_dist_to_point <= 8 ) {  op8++;  pp8++;
      if ( player_dist_to_point <= 4 ) {  op4++;  pp4++; }}}

      if (++counter == MaxPlayers)
	break;
    }
  }
  for (i=counter; i<MaxPlayers; i++){ 
    for (j=0;j<4;j++){ outstream[index++]='?'; outstream[index++]=','; }
  }

  /* now do distance to the line segment */

  Line line = LineFromTwoPoints(point,MyPos());
  Vector projected_player;

  NumTeammates = SortPlayersByDistanceToLine('m',line,teammates,TRUE,point,MyPos());
  NumOpponents = SortPlayersByDistanceToLine('t',line,opponents,TRUE,point,MyPos());

  counter=0;
  for (i=0; i<NumTeammates; i++){  
    if ( (player=teammates[i])==MyNumber ) 
      continue; /* don't include me */

    if ( TeammatePositionValid(player) ){
      if ( (player_position=TeammateAbsolutePosition(player)) == point )
	continue; /* don't include target player */

      projected_player = line.ProjectPoint(player_position);
      player_dist_to_line = projected_player.dist(player_position);

      WRITE_DISTANCE(player_dist_to_line);
      WRITE_DISTANCE(DistanceTo(projected_player));
      WRITE_DISTANCE(projected_player.dist(point));

      angle_diff = GetNormalizeAngleDeg(AngleToFromBody(point)-AngleToFromBody(player_position));

      WRITE_ANGLE(fabs(angle_diff));

      if ( player_dist_to_line <= 12 ){ tl12++; pl12++;
      if ( player_dist_to_line <= 8 ) {  tl8++;  pl8++;
      if ( player_dist_to_line <= 4 ) {  tl4++;  pl4++; }}}

      if (++counter == MaxPlayers)
	break;
    }
  }
  for (i=counter; i<MaxPlayers; i++){ 
    /* not really unknown -- know nobody else is on line -- so make a fixed big attribute */
    for (j=0;j<4;j++){ for (k=0;k<3;k++) outstream[index++]='2'; outstream[index++]=','; }
  }

  counter=0;
  for (i=0; i<NumOpponents; i++){  
    player=opponents[i];
    if ( OpponentPositionValid(player) ){

      player_position=OpponentAbsolutePosition(player);
      projected_player = line.ProjectPoint(player_position);
      player_dist_to_line = projected_player.dist(player_position);

      /* Don't consider the goalie (closest player to the goal */
      if ( MarkerPosition(RM_Their_Goal).dist(point) < SP_goal_width/2 && 
	   player_dist_to_point < SP_goal_width/2 && i == 0 ) 
	continue;

      WRITE_DISTANCE(player_dist_to_line);
      WRITE_DISTANCE(DistanceTo(projected_player));
      WRITE_DISTANCE(projected_player.dist(point));
      
      angle_diff = GetNormalizeAngleDeg(AngleToFromBody(point)-AngleToFromBody(player_position));

      WRITE_ANGLE(fabs(angle_diff));

      if ( player_dist_to_line <= 12 ){ ol12++; pl12++;
      if ( player_dist_to_line <= 8 ) {  ol8++;  pl8++;
      if ( player_dist_to_line <= 4 ) {  ol4++;  pl4++; }}}

      if (++counter == MaxPlayers)
	break;
    }
  }
  for (i=counter; i<MaxPlayers; i++){ 
    /* not really unknown -- know nobody else is on line -- so make a fixed big attribute */
    for (j=0;j<4;j++){ for (k=0;k<3;k++) outstream[index++]='2'; outstream[index++]=','; }
  }

  /* now put in the stats */

#define WRITE_STAT(a) outstream[index++]='0'+Min(9,a);  outstream[index++]=','

  WRITE_STAT(tp4);
  WRITE_STAT(tp8);
  WRITE_STAT(tp12);
  WRITE_STAT(op4);
  WRITE_STAT(op8);
  WRITE_STAT(op12);
  WRITE_STAT(pp4);
  WRITE_STAT(pp8);
  WRITE_STAT(pp12);

  WRITE_STAT(tl4);
  WRITE_STAT(tl8);
  WRITE_STAT(tl12);
  WRITE_STAT(ol4);
  WRITE_STAT(ol8);
  WRITE_STAT(ol12);
  WRITE_STAT(pl4);
  WRITE_STAT(pl8);
  WRITE_STAT(pl12);

  outstream[index]='\0';
}

/***********************************************************************************************/

void DTInfo::FillAttributes(Unum receiver){
  if ( !TeammatePositionValid(receiver) ) my_error("Can't fill attributes for unknown receiver");
  FillAttributes( TeammateAbsolutePosition(receiver) );
}

/***********************************************************************************************/

void DTInfo::FillAttributes(Vector point){
  if ( !VP_use_DT ) my_error("can't fill attributes if not using DT");

  /* go through all of RangeDesc[a]'s, setting values as in userint.c */
  /* Gonna have to convert from strings */
  char dataStream[Max_Data_Len];

  GetPassData(point,dataStream);

  Clear(); 
  int i = 0;
  for (int att=0; att<=MaxAtt; ++att){
    while (dataStream[i] == ' ') i++;
    if (dataStream[i] == '?'){
      RangeDesc[att].Known = FALSE;
    }
    else if ( MaxAttVal[att] )
      my_error(" Can't handle discrete attributes here yet. ");
    else{ /* It's a continuous attribute */
      RangeDesc[att].LowerBound = get_double(&dataStream[i]); 
      /* Not handling ranges here--just single values. See userint.c */
      RangeDesc[att].UpperBound = RangeDesc[att].LowerBound;
      RangeDesc[att].Known = TRUE;
    }
    RangeDesc[att].Asked = TRUE; /* Set it to known */

    while (dataStream[i] != ',') i++; /* Advance to next attribute */
    i++; /* Advance past comma */
  }
}

/***********************************************************************************************/

float DTInfo::PassConfidence(Unum receiver){

  if (!VP_use_DT) my_error ("can't call PassConfidence if not using DT (1)");

  if ( CurrentTime - CP_DT_evaluate_interval < pass_confidence_time[receiver] )
    return pass_confidence[receiver];

  if ( !TeammatePositionValid(receiver) ) my_error("Can't fill attributes for unknown receiver");
  float confidence = PassConfidence( TeammateAbsolutePosition(receiver) );

#if 0 /*HACK*/
  if ( TeammateDistance(receiver) < 40 && NumOpponentsInConeToTeammate(.3,receiver)==0 )
    confidence = 0.9;
#endif
  
  pass_confidence[receiver] = confidence;
  pass_confidence_time[receiver] = CurrentTime;

  return confidence;
}

/***********************************************************************************************/

float DTInfo::PassConfidence(Vector point){

  if (!VP_use_DT) my_error ("can't call PassConfidence if not using DT (2)");

  float confidence = 0;

  FillAttributes(point);   
  int TreeClass = InterpretTree(&confidence);

  if ( ClassName[TreeClass][0] == 'F' ) /* failure */
    confidence = -confidence; /* Failures with low conf, better */

  return confidence;
}

/***********************************************************************************************/

Unum DTInfo::MaxPassConfidenceTeammate()
{
  Unum player = Unum_Unknown;
  float max_confidence = PassConfidence(MarkerPosition(RM_Their_Goal));
  float tmp;

  for (int i=1; i<SP_team_size; i++){
    if ( i == MyNumber ) continue;
    if ( !TeammatePositionValid(i) ) continue;
    if ( (tmp=PassConfidence(i)) > max_confidence ){
      player = i;
      max_confidence = tmp;
    }
  }

  return player;
}

