/* -*- Mode: C++ -*- */

#ifdef RELEASE_VERSION  
THIS FILE SHOULD NOT BE INCLUDED!
#endif // RELEASE_VERSION

#ifndef _COMMUNICATE_H_
#define _COMMUNICATE_H_

#include "MemPat.h"

class MessageStruct {
public:

  MessageStruct();

  TargetType target_type;
  int        target;

  MessageType message_type;
  int         data1;
  int         data2;
  /* 
  float       f_data1; 
  float       f_data2; 
  */

  Time        time;
  int         delay;

  Bool        respond;

  MessageStruct     *Next;
  MessageStruct     *Prev;
};



class MessageList {
public:
  MessageList();
  ~MessageList();

  void AddMessage(MessageStruct *msg);
  void DeleteMessage(MessageStruct* msg);
	     
  MessageStruct *head;
  MessageStruct *tail;
};




class CommunicateInfo : public PatInfo{
public:

  ~CommunicateInfo();
  void Initialize(); 

  int  EncodeKey();
  Time DecodeKey(int key, int from, Vector from_pos);

  void FillMessageHead();
  Unum ParseMessageHead();

  void FillMessageState();  /* formation, ball, players, etc. */
  Bool ParseMessageState(Unum from, Time time);

  Bool FillMessageBody(MessageStruct *msg);
  void ParseMessageBody(Unum from, Time time);

  Bool fill_message(MessageStruct *msg);
  void ParsePlayerSound(char *msg, Time time);

  void AddMessage(Time time, int delay, Bool respond, TargetType ttype, int target, 
		  MessageType mtype, int d1, int d2);

  void Say(MessageType mtype, int d1, int d2);
  inline void Say(MessageType mtype, int d1) { Say(mtype,d1,0); }
  inline void Say(MessageType mtype)         { Say(mtype,0 ,0); }

  void SayToPlayer(Unum player, MessageType mtype, int d1, int d2);
  inline void SayToPlayer(Unum player, MessageType mtype, int d1) { SayToPlayer(player,mtype,d1,0); }
  inline void SayToPlayer(Unum player, MessageType mtype)         { SayToPlayer(player,mtype,0 ,0); }

  void SayToPosition(Pnum position, MessageType mtype, int d1, int d2);
  inline void SayToPosition(Pnum position, MessageType mtype, int d1) { SayToPosition(position,mtype,d1,0); }
  inline void SayToPosition(Pnum position, MessageType mtype)         { SayToPosition(position,mtype,0 ,0); }

  void SayToUnit(int unit, MessageType mtype, int d1, int d2);
  inline void SayToUnit(int unit, MessageType mtype, int d1) { SayToUnit(unit,mtype,d1,0); }
  inline void SayToUnit(int unit, MessageType mtype)         { SayToUnit(unit,mtype,0 ,0); }

  Bool Communicate();

  char *SayBuffer() { return say_buffer; }
  
  Bool MessageTypePending(MessageType mtype);
    
private:
  char *say_buffer;		
  char *message_buffer;     /* the message excluding '(say '                 */
  char *hear_buffer;
  
  int MessageStateIndex;    /* index in say_buffer (and hear_buffer) at which the state starts */
  int MessageBodyIndex;     /* index in say_buffer (and hear_buffer) at which the body  starts */
  int MessageEndIndex;      /* say_buffer + SP_say_msg_size                                    */

  /* Variables for filling and parsing the message state */
  int KeyLength;
  int FormLength;
  int TimeLength;
  int ConfLength; 
  int PosLength; 
  int VelLength; 
  int PastTimeLength;
  int PositionLength;
  int ConfPrecision;
  int PosPrecision;
  int VelPrecision;

  int MinDelay;       /* If this is 0, communicate immediately by default */
  int MaxDelay;       /* Time after which I'll respond before acting more */
  int HearInterval;   /* time steps need to wait before hearing again     */

  Time LastComCheckTime;
  Time LastSayTime;
  Time LastHearTime; /* from teammates */
  Unum LastSpeaker;  /* who spoke ??   */

  MessageList MsgList;
};

#endif
