/* -*- Mode: C -*- */

/* test.h
 * CMUnited98 (soccer client for Robocup98)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1998 Peter Stone
 *
 * CMUnited-98 was created by Peter Stone, Manuela Veloso, and Patrick Riley
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* test.C contains functions that demonstrate our client's abilities
 * They should be called from behave.C
 */


#ifndef _BEHAVE_TEST_H_
#define _BEHAVE_TEST_H_

#include "geometry.h"

void test_dribble_to_goal();
void test_random_movement_in_rectangle(Rectangle *rect);
void test_1v1();
void test_volley();
void test_go_to_ball(AngleDeg kick_angle);
void test_go_to_ball();
void test_go_to_point(Vector p, float buffer, float dash_power = 100);
void test_face_ball();
void test_random_movement();
void test_straight_to_ball();
void test_run_straight();
void test_turn_and_dash_slow();
void test_print_ball();
void test_print_positions();

#ifndef RELEASE_VERSION
void test_DT();
Unum test_control();
void test_2v3(Rectangle *rect);
void test_get_open_in_rectangle(Rectangle *rect);
void test_dodge();
void test_play();
void test_say();
void test_go_to_position();
void test_move();
void test_print_mode();
void test_time();
void test_good_pass();
#endif

#endif
