/* -*- Mode: C++ -*- */

/* dribble.h
 * CMUnited98 (soccer client for Robocup98)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1998 Peter Stone
 *
 * CMUnited-98 was created by Peter Stone, Manuela Veloso, and Patrick Riley
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* dribble.C contains functions for dribbling the ball
 * Created by Patrick Riley
 */

#include "Memory.h"
#include "kick.h"

void PatsTest_dribble();
void PatsTest_dribble2();

typedef enum DRIBBLERES {
  DR_None,
  DR_Error,
  DR_LostBall,
  DR_GotThere,
  DR_Going
} DribbleRes;

typedef enum DRIBBLEMODE {
  DM_None,
  DM_Strict, /* moves very little if ball is at wrong angle */
  DM_Lazy    /* will pick an intermediate point if switching sides, but will
		keep moving. Not as safe with players around */
} DribbleMode;


TurnKickCommand dribble_dash(Vector vEndPos, float max_pow,
			     AngleDeg drib_ang, DribbleMode mode);
TurnKickCommand dribble_kick(Vector vEndPos, float max_pow,
			     AngleDeg drib_ang, DribbleMode mode);
AngleDeg NormalizeDribbleAngle(AngleDeg ang);

/* drib_ang should be between 90 and -90
   we always dribble in front of us */
DribbleRes DribbleTo(Vector vEndPos, float max_dash_pow, float buffer,
		     AngleDeg drib_ang, DribbleMode mode,
		     Bool IsDodge=FALSE, Vector DodgePoint=0);

DribbleRes SimpleDribbleTo(Vector vEndPos, float max_dash_pow = 75,
			   float buffer = 1.0);

