/* client.h
 * CMUnited98 (soccer client for Robocup98)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1998 Peter Stone
 *
 * CMUnited-98 was created by Peter Stone, Manuela Veloso, and Patrick Riley
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* client.C contains the main program loop 
 * It is partially based on Player.C from the turnballclient of Alessandro Bissacco  
 */

#ifndef _CLIENT_H_
#define _CLIENT_H_

#include "Memory.h"

extern Memory *Mem;

void turn(AngleDeg ang);
void dash(float power);
void kick(float power, AngleDeg dir);
void goalie_catch(AngleDeg dir);
void move(float x, float y);
inline void move(Vector p) { move(p.x,p.y); }
void disconnect();

void change_view(Vqual qual, Vwidth width);
inline void change_view(Vqual qual) { change_view(qual,Mem->ViewWidth); }
inline void change_view(Vwidth width) { change_view(Mem->ViewQuality,width); }

#endif
