/* -*- Mode: C -*- */

/* behave.h
 * CMUnited98 (soccer client for Robocup98)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1998 Peter Stone
 *
 * CMUnited-98 was created by Peter Stone, Manuela Veloso, and Patrick Riley
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* behave.C is called once every server cycle.
   It determines the action to be sent to the server
 */


#ifndef _BEHAVE_H_
#define _BEHAVE_H_

#include "geometry.h"
#include "types.h"

void behave();

 ActionQueueRes scan_field(); 
 void           face_point(Vector point); 
 ActionQueueRes face_teammate(Unum teammate); 
 ActionQueueRes face_opponent(Unum opponent); 
 ActionQueueRes face_ball(); 

 void get_ball(); 
 void stop_ball(); 
 void hold_ball(); 
 void pass_ball(Unum teammate, float target_vel=1.0); 
 void kick_ball(AngleDeg target_angle, KickMode mode = KM_Moderate, 
 	       TurnDir rotation = TURN_NONE); 
 void kick_ball(Vector point, KickMode mode = KM_Moderate, TurnDir rotation = TURN_NONE); 
 ActionQueueRes go_to_point(Vector p, float buffer = 0, float dash_power = 100, Bool dodge = TRUE); 

#ifndef RELEASE_VERSION
 void watch_pass(); 
 void move_to_position(); 
 void handle_ball(); 
 void get_on_sides(); 
 void go_to_position(); 
 void support_ball(); 
 void mark_opponent(Unum opp, float dist); 
 void track_opponent(Unum opp, float dist); 
 ActionQueueRes get_open_in_rectangle(Rectangle rect); 
 ActionQueueRes get_open_for_pass_from_in_rectangle(Rectangle rect,Vector from); 
 void passive_defend(); 
 void auxiliary_defend(); 
 void active_defend(); 

 ActionQueueRes move_to_point_in_between(Vector pt1, Vector pt2, 
 			      float pt1dist, float dash_power = 100); 
 inline ActionQueueRes move_to_point_in_between(Vector pt1, float ang, 
 				     float pt1dist, float dash_power = 100) 
 { 
   return move_to_point_in_between(pt1, pt1 + Polar2Vector(1000, ang), 
 				  pt1dist, dash_power); 
 } 

 ActionQueueRes move_in_between(Vector pt1, Vector pt2, float dash_power = 100); 
 inline ActionQueueRes move_in_between(Vector pt1, float ang, float dash_power = 100) 
 { 
   return move_in_between(pt1, pt1 + Polar2Vector(1000, ang), dash_power); 
 } 


 ActionQueueRes defensive_block_opponent(Unum opponent,float dash_power,Vector block_targ); 
 void clear_ball(); 
 void send_ball(); 
#endif

#endif
