/* -*- Mode: C -*- */

#ifndef _MEMACTION_H_
#define _MEMACTION_H_

#ifndef RELEASE_VERSION
#include "MemSetplay.h"
#else
#include "MemPosition.h"
#endif

/* MemAction.C
 * CMUnited98 (soccer client for Robocup98)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1998 Peter Stone
 *
 * CMUnited-98 was created by Peter Stone, Manuela Veloso, and Patrick Riley
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* MemAction.C contains utility functions for ball interception
   Created by Patrick Riley
 */

/****************************************************************************************/

typedef struct PLAYERINTERCEPTINFO 
{
  Time time;
  float dash_pow;
  int lookahead;
  InterceptRes res;
  int numCyc;
  Vector pos;
} PlayerInterceptInfo;

typedef struct TURNKICKCOMMAND 
{
  CMDType type;
  Time time;
  float angle;
  float power;  
} TurnKickCommand;

const int LA_Default = -2;
const int LA_BestSoFar = -1;




/****************************************************************************************/
/****************************************************************************************/
/****************************************************************************************/

#ifndef RELEASE_VERSION
class ActionInfo : public SetplayInfo{
#else
class ActionInfo : public PositionInfo{
#endif

public:

  void Initialize();

#ifndef RELEASE_VERSION
  void UpdateActionMode();
  ActionMode MyActionMode;
#endif

  // these are for hard kicking 
  Time HKTime;
  int HKStep;
  int HKStepNext;
  TurnDir HKrot;

  float VelAtPt2VelAtFoot(Vector pt, float targ_vel_at_pt);

  /* these are for ball interception */
  InterceptRes PlayerInterceptionResult(char side, Unum num, float dash_pow);
  InterceptRes PlayerInterceptionResult(char side, Unum num)
    { return PlayerInterceptionResult(side, num, 
				      (side==MySide && TeammateTired(num)) ? SP_stamina_inc : SP_max_power); }
  Bool PlayerInterceptionAble(char side, Unum num, float dash_pow);
  Bool PlayerInterceptionAble(char side, Unum num)
    { return PlayerInterceptionAble(side, num, 
				    (side==MySide && TeammateTired(num)) ? SP_stamina_inc : SP_max_power); }
  int PlayerInterceptionNumberCycles(char side, Unum num, float dash_pow);
  int PlayerInterceptionNumberCycles(char side, Unum num)
    { return PlayerInterceptionNumberCycles(side, num, 
					    (side==MySide&&TeammateTired(num)) ? SP_stamina_inc:SP_max_power); }
  Vector PlayerInterceptionPoint(char side, Unum num, float dash_pow);
  Vector PlayerInterceptionPoint(char side, Unum num)
    { return PlayerInterceptionPoint(side, num, 
				     (side==MySide && TeammateTired(num)) ? SP_stamina_inc : SP_max_power); }

  InterceptRes TeammateInterceptionResult(Unum num, float dash_pow)
    { return PlayerInterceptionResult(MySide, num, dash_pow); }
  InterceptRes TeammateInterceptionResult(Unum num)
    { return TeammateInterceptionResult(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power); }
  Bool TeammateInterceptionAble(Unum num, float dash_pow)
    { return PlayerInterceptionAble(MySide, num, dash_pow); }
  Bool TeammateInterceptionAble(Unum num)
    { return TeammateInterceptionAble(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power); }
  int TeammateInterceptionNumberCycles(Unum num, float dash_pow)
    { return PlayerInterceptionNumberCycles(MySide, num, dash_pow); }
  int TeammateInterceptionNumberCycles(Unum num)
    { return TeammateInterceptionNumberCycles(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power); }
  Vector TeammateInterceptionPoint(Unum num, float dash_pow)
    { return PlayerInterceptionPoint(MySide, num, dash_pow); }
  Vector TeammateInterceptionPoint(Unum num)
    { return TeammateInterceptionPoint(num, TeammateTired(num) ? SP_stamina_inc : SP_max_power); }

  InterceptRes OpponentInterceptionResult(Unum num, float dash_pow)
    { return PlayerInterceptionResult(TheirSide, num, dash_pow); }
  InterceptRes OpponentInterceptionResult(Unum num)
    { return OpponentInterceptionResult(num, SP_max_power); }
  Bool OpponentInterceptionAble(Unum num, float dash_pow)
    { return PlayerInterceptionAble(TheirSide, num, dash_pow); }
  Bool OpponentInterceptionAble(Unum num)
    { return OpponentInterceptionAble(num, SP_max_power); }
  int OpponentInterceptionNumberCycles(Unum num, float dash_pow)
    { return PlayerInterceptionNumberCycles(TheirSide, num, dash_pow); }
  int OpponentInterceptionNumberCycles(Unum num)
    { return OpponentInterceptionNumberCycles(num, SP_max_power); }
  Vector OpponentInterceptionPoint(Unum num, float dash_pow)
    { return PlayerInterceptionPoint(TheirSide, num, dash_pow); }
  Vector OpponentInterceptionPoint(Unum num)
    { return OpponentInterceptionPoint(num, SP_max_power); }

  InterceptRes MyInterceptionResult(float dash_pow)
    { return PlayerInterceptionResult(MySide, MyNumber, dash_pow); }
  InterceptRes MyInterceptionResult()
    { return MyInterceptionResult(CorrectDashPowerForStamina(SP_max_power)); }
  Bool MyInterceptionAble(float dash_pow)
    { return PlayerInterceptionAble(MySide, MyNumber, dash_pow); }
  Bool MyInterceptionAble()
    { return MyInterceptionAble(CorrectDashPowerForStamina(SP_max_power)); }
  int MyInterceptionNumberCycles(float dash_pow)
    { return PlayerInterceptionNumberCycles(MySide, MyNumber, dash_pow); }
  int MyInterceptionNumberCycles()
    { return MyInterceptionNumberCycles(CorrectDashPowerForStamina(SP_max_power)); }
  Vector MyInterceptionPoint(float dash_pow)
    { return PlayerInterceptionPoint(MySide, MyNumber, dash_pow); }
  Vector MyInterceptionPoint()
    { return MyInterceptionPoint(CorrectDashPowerForStamina(SP_max_power)); }

  /* just min of what's been done so far - returns -1 if nothing done */
  int GetInterceptionMinCyc();
  inline void ResetInterceptionMinCyc()  { IntMinCycTime -= 1; }
  inline int  GetInterceptionLookahead() { return InterceptLookahead; }
  void SetInterceptionLookahead(int newval);

  Bool BallPathInterceptValid();
  Vector BallPathInterceptPoint();
  Bool BallPathInterceptAmIThere(float buffer);
  Bool BallPathInterceptAmIThere()
    { return BallPathInterceptAmIThere(CP_at_point_buffer); }
  float BallPathInterceptDistance();
  /* careful! if ball is kickable, next func returns 0 */
  int BallPathInterceptCyclesForBall();
  Bool BallPathInterceptCanIGetThere(float max_pow = 100.0);

  KickMode BestKickModeAbs(AngleDeg abs_ang);
  KickMode BestKickMode(AngleDeg rel_ang) 
    { return BestKickModeAbs(GetNormalizeAngleDeg(rel_ang + MyAng())); }

  int EstimatedCyclesToSteal(Unum opp, Vector ball_pos);  
  inline int EstimatedCyclesToSteal(Unum opp, AngleDeg ball_ang) //absolute angle
    { return EstimatedCyclesToSteal(opp, MyPos() +
				    Polar2Vector(CP_opt_ctrl_dist, ball_ang));
    }
  inline int EstimatedCyclesToSteal(Unum opp)
    {
      if (!BallPositionValid())
	my_error("EstimateCyclesToSteal: don;t know where ball is");
      return EstimatedCyclesToSteal(opp, BallAbsolutePosition());
    }

#ifndef RELEASE_VERSION
  Bool     HaveAShot();
  Bool     HasAShot(Unum teammate);
  Bool     HaveAGoodShot();
  Bool     HasAGoodShot(Unum teammate);
  KickMode ShotMode();
  Vector   ShotTarget();
  Unum     PassTarget(Bool use_receiver_list, PassChoiceType choice_type);
  Bool     NeedToClear();
  float    EvaluateClearAngle(Vector end);
  AngleDeg ClearTarget();
  AngleDeg ClearTargetOffensive();
  Bool     CanWeDribbleAroundOpponent();
  Bool     CanDribbleTowards(Vector pt);
  Bool     CanDribbleTo(Vector pt);  
  Bool     CanDribble();
  Vector   DribbleTarget();
  Bool     CanKeepBall();

  /* if we get beat in block mode, we need to overrun */
  Vector   OverrunBlockPos(Vector block_targ, Unum opponent, Line TrajLine);
  Time def_block_overrun_time;
  Bool def_block_overrun;
#endif

  Bool KickInProgress(); 
  void StartKick(AngleDeg target_angle, KickMode mode, float target_vel, TurnDir rot=TURN_AVOID);
  void StartShot(AngleDeg target_angle, KickMode mode, TurnDir rot=TURN_AVOID);
  void StartPass(Unum target, float target_vel, TurnDir rot=TURN_AVOID);  
  
  AngleDeg       kick_in_progress_abs_angle;
  float          kick_in_progress_target_vel;
  KickMode       kick_in_progress_mode;
  TurnDir        kick_in_progress_rotation;

  Unum team_receiver;
  Unum team_passer; 
  Time team_pass_time;

#ifndef RELEASE_VERSION
  Time goalie_last_catch_time;
  Time GoalieWarnTime;

  Unum FastestTeammateToBall();
  Unum FastestOpponentToBall();
  Unum BallPossessor();   /* possessor means can get there quickest */
  char TeamInPossession();
  Bool TheirBreakaway();
  Bool OurBreakaway();
#endif

private:

  Bool           kick_in_progress;
  Time           start_kick_time;
  Time           kick_in_progress_time;

#ifndef RELEASE_VERSION
  Time           DribbleTargetTime;
  Vector         DribbleTargetVector;
  Bool           DribbleTargetAvailable;
#endif

  PlayerInterceptInfo* TeamIntInfo[MAX_PLAYERS];
  PlayerInterceptInfo* OppIntInfo[MAX_PLAYERS];

  Time Stored_Fastest_Teammate_Time;
  Unum Stored_Fastest_Teammate;

  int InterceptLookahead; /* can either be a positve number or a LA_constant
			     from above */
  int IntMinCyc;
  Time IntMinCycTime;
  void SetIntMinCyc(int newval);

  void BallIntercept_active(float max_pow_to_use, int max_lookahead,
			    char PlayerSide, Unum PlayerNum,
			    PlayerInterceptInfo* pInfo);
  PlayerInterceptInfo CloseBallInterception(float max_pow, int max_lookahead,
					    Vector vBallPos, Vector vBallVel);
  PlayerInterceptInfo  ActiveCanGetThere(float max_pow, int max_lookahead,
					 Vector vBallPos, Vector vBallVel,
					 char side, Unum num,
					 Vector vPlayerPos, Vector vPlayerVel,
					 float vPlayerAng, int PlayerAngValid,
					 bool IsThisMe);

  PlayerInterceptInfo* GetPlayerIntInfo(char side, Unum num);
  PlayerInterceptInfo* VerifyIntInfo(char side, Unum num, float dash_pow);

  bool IsSuccessRes(InterceptRes res)
    { return (res == BI_CanChase || res == BI_ReadyToKick); }

  Time BPItime;
  Bool BPIvalid;
  Bool BPIable; 
  float BPIdist;
  Vector BPIpoint;
  float BPIballcyc;

  void VerifyBPIInfo();
  int GetClosestPointToBallPath(Vector* pvPt, float* pNumCycles,
				Vector PlayerPos, Vector BallPos,
				Vector BallVel);
  void BallIntercept_passive(float max_pow_to_use, 
			     PlayerInterceptInfo* pInfo);      
};

inline Bool ActionInfo::BallPathInterceptValid()
{
  VerifyBPIInfo();
  return BPIvalid;
}

#endif
