/* utils.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

/* -*- Mode: C -*- */

#ifndef _GEOMETRY_
#define _GEOMETRY_

/* Avoid Domain error signal */
#define my_atan2(a,b) ((a == 0 && b == 0) ? 0 : atan2(a,b)) 
/*#define my_atan2(a,b) atan2(a,b)*/

#define mod(a,b) (a - (b)*(int)((a)/(b)))

my_error(char*);
CleanAngle(int*);
CleanAngle(float*);
CleanAngleRad(float*);
float GetDistance(float *x, float *y, float *a, float *b);

extern double get_double(char *str);
extern float  get_float(char *str);
extern int    get_int(char *str);

extern void BubbleSort(int length, int *elements, float *keys);
extern int BinarySearch(int length, float *elements, float key);
extern void StrReplace(char *str, char oldchar, char newchar);

extern int int_random(int n);
extern float range_random(float lo, float hi);
extern int very_random_int(int n);

extern float weighted_avg(float val1, float val2, float w1, float w2);

#define END_OF_QUEUE -1

class PointQueue{ 
public:
  PointQueue(int maxsize);
  ~PointQueue();

  inline GetMaxSize()     { return maxsize;  }
  inline GetCurrentSize() { return currsize; }
  
  void Append(float x_, float y_, int t_); /* Add's to tail of Queue     */
  void Pop();                              /* Pops off the head          */
  void Reset();                            /* Empty the queue            */
  void Add(float x_, float y_, int t_);    /* Appends or overwrites head */

  float GetIndexX(int index);
  float GetIndexY(int index);
  int   GetIndexTime(int index);
  inline float GetHeadX()    { return GetIndexX(0); }
  inline float GetHeadY()    { return GetIndexY(0); }
  inline int   GetHeadTime() { return GetIndexTime(0); }
  inline float GetTailX()    { return GetIndexX(currsize-1); }
  inline int   GetTailTime() { return GetIndexTime(currsize-1); }
  inline void GetIndex(int index, float *x, float *y)
    { *x = GetIndexX(index); *y = GetIndexY(index); }
  inline void GetHead(float *x, float *y) { GetIndex(0,x,y); }
  inline void GetTail(float *x, float *y) { GetIndex(currsize-1,x,y); }

  int  OldestIndexWithin(int bound);

  void Print ();

private:
  int maxsize;
  int head;  /* points to head of Queue */
  int tail;  /* points to slot _after_ end of Queue */
  int currsize; /* should equal (tail-head)%maxsize */
  float *x;
  float *y; 
  int   *time;
};

#endif
