/* setplay.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _SETPLAY_H_
#define _SETPLAY_H_

/******************** SETPLAYPOSITION CLASS DEFINITION ******************/

#define SETPLAY_STARTER  0
#define SETPLAY_PASSER  (SETPLAY_STARTER+1)  /* goes and passes   */
#define SETPLAY_SHOOTER (SETPLAY_PASSER +1)  /* goes and shoots   */
#define SETPLAY_KNOCKER (SETPLAY_SHOOTER+1)  /* aims at a point   */
#define SETPLAY_BLASTER (SETPLAY_KNOCKER+1)  /* blasts at a point */

class SetPlayPosition {
public:

  void SetHome(float x, float y, float buf, int type);
  void SetAim (float x, float y, int wait);
  void SetAim (int position, int wait);
  void SetAim (int position, float x, float y, int wait);

  inline float GetHomeX()      { return HomeX;      }
  inline float GetHomeY()      { return HomeY;      }
  inline float GetHomeBuffer() { return HomeBuffer; }

  inline int   GetType()       { return PositionType; }

  inline float GetAimX()        { return AimX;        }
  inline float GetAimY()        { return AimY;        }
  inline int   GetAimPosition() { return AimPosition; }
  inline int   GetWaitTime()    { return WaitTime;    }

private:
  float HomeX;
  float HomeY;
  float HomeBuffer;

  int PositionType;

  int AimPosition;
  float AimX;
  float AimY;
  int WaitTime;
};

/******************** SETPLAYFORMATION CLASS DEFINITION ******************/

class SetPlayFormation {
public:
  SetPlayFormation();
  ~SetPlayFormation();
   
  inline int GetNumPositions() { return num_positions; }

  void SpecifySetPlayPosition(int pos, float x, float y, float buf, int type);
  void SpecifySetPlayAction  (int pos, float x, float y, int wait);
  void SpecifySetPlayAction  (int pos, int pos, int wait);
  void AssignSetPlayPosition (int pos, int formationPos);

  int  SetPlayPositionPlayer(int pos);
  int  SetPlayPlayerPosition(int formationPos);

  float GetSetPlayPositionX(int pos);
  float GetSetPlayPositionY(int pos);
  void  GetSetPlayPositionXY(int pos, float *x, float *y);

  float GetSetPlayPlayerX(int formationPos);
  float GetSetPlayPlayerY(int formationPos);
  void  GetSetPlayPlayerXY(int formationPos, float *x, float *y);

  float GetSetPlayPlayerAimX(int formationPos);
  float GetSetPlayPlayerAimY(int formationPos);
  void  GetSetPlayPlayerAimXY(int formationPos, float *x, float *y);

  float GetPositionBuffer(int formationPos);
  int   GetWaitTime      (int formationPos);
  int   GetAimPosition   (int formationPos);
  int   GetPositionType  (int formationPos);

  int   GetStarter();
  
  int Initialize(int PlayMode, float ballx, float bally);

  void Print();

private:

  int num_positions;
  SetPlayPosition *positions;  /* x,y positions                               */
  int *positionPlayers;        /* Based on positions in the current formation */
};

#endif
