/* roles.c
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#include "global.h"

/*****************************************************************************/
/** Decide where exactly to position oneself within the context of a        **/
/** high-level position.                                                    **/
/** MOVED TO UPDATEMARK AND UPDATEHOME in memory.c
/*****************************************************************************/


/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/** Execute captainly duties for this unit                                  **/
/*****************************************************************************/

#define MY_ZONE_LINE -20

int DirectUnit(int unit){

  /* must be the captain to get here */
  /* call a function that's attached to the unit? */
  /* For now just do it here, and only do it for defensive unit */

  if (unit != DEFENSIVE_UNIT)
    return 0;

  if ( !Mem->AmUnitCaptain(unit) )
    my_error("I can only direct a unit if I'm the captain");

  /* Look for opponents in "my zone" that don't have a teammate "nearby" */
  /* If there's a teammate not marking someone, assign him to mark       */

  /* WIDE_VIEW; */

  char myside = Mem->MySide, theirside = Mem->TheirSide;

  for (int i=0; i<TEAM_SIZE+1; i++){

    if ( !Mem->PlayerValid(theirside,i) || 
	 Mem->GetPlayerGlobalX(theirside,i) > MY_ZONE_LINE )
      continue;

    /* make this a function in memory.h -- numteammateswithinrangeofopponent */
    if ( Mem->NumTeammatesWithin(5,5,Mem->GetPlayerDistance(theirside,i),
				 Mem->GetPlayerAngle(theirside,i)) ){
      /* printf("Opponent %d already marked\n",i); */
      continue;
    }

    /* choose a player to mark the opponent        */
    /* Keep track of who's marking and who's free? */
    /* Make an auxiliary array in Unit???          */
    int *members = Mem->GetUnitMembers(unit);
    int player;
    for (int j=0; j<Mem->GetUnitSize(unit); j++){
      player = Mem->GetPositionPlayer(members[j]);

      if ( player == UNKNOWN_PLAYER ){
	SAYTOPOSITION(members[j],PING_MSG);
	break;
      }

      if ( player == Mem->MyNumber || player == 0 )
	continue;

      if ( Mem->NumOpponentsWithin(5,5,Mem->GetPlayerDistance(myside,i),
				   Mem->GetPlayerAngle(myside,i)) )
	continue; /* player already marking */

      if ( Mem->OpponentIsWithinPlayerMaxRange(i,player) ){
	/*printf("assigning %d to mark %d\n",player,i); */
	ASSIGNMARK(unit,player,i);
	break; /* Only assign one player to mark */
      }
    }
    
  }

  /* If there's an unoccupied position in my unit, and if it's important,*/
  /* assign someone else to it                                           */
  
  return 0;
}

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/** Consider changing the high-level position of a player                   **/
/*****************************************************************************/

/* Return the closest unoccupied position */
int GetNewPosition(){

  if (Mem->ChangePositions || Mem->GetMyPosition() == UNKNOWN_POSITION){ 

    int bestPosition=UNKNOWN_POSITION;
    float dist,minDist=1000;
    for (int position=0; position<TEAM_SIZE; position++){
      if ( !Mem->PositionOccupied(position) 
#if 0
	   &&
	   (position==Mem->EncodePosition(GOALTENDER,CENTER) ||
	    position==Mem->EncodePosition(DEFENDER  ,RIGHT ) ||
	    position==Mem->EncodePosition(MIDFIELDER,RIGHT ) ||
	    position==Mem->EncodePosition(FORWARD   ,RIGHT ) ||
	    position==Mem->EncodePosition(FORWARD   ,CENTER) ) 
#endif
	                                                       ){
	dist = Mem->DistanceToPositionHome(position,Mem->GetGlobalX(),Mem->GetGlobalY());
	if (dist < minDist){ /* find closest unoccupied position */
	  bestPosition = position;
	  minDist = dist;
	}
      }
    }
    if ( bestPosition == UNKNOWN_POSITION ) {
      for (int position=0; position<TEAM_SIZE; position++){
	printf("    *****    position %2d held by %2d\n",
	       position,Mem->GetPositionPlayer(position));
      }
      printf("    *****    I'm at (%.1f, %.1f)\n",Mem->GetGlobalX(),Mem->GetGlobalY());
      my_error("Some position should have been unoccupied");
    }
    return bestPosition;
  } 
  else 
    /* The following line allows more than one player to play the same 
       position when Mem->ChangePositions is FALSE                    */
/*    return Mem->GetMyPosition(); */
    my_error("Shouldn't be calling GetNewPosition if Mem->ChangePositions is FALSE");
}

/*****************************************************************************/

/* 
What's in a state?  Want this to be as small as possible, yet meaningful
Do this here and in ConsiderPositions (below)?

--Position I'm considering
--My current position
--My position on the field
--Teammate/opponent locations--distances + position (i.e. where on field)
       angle is irrelevant (sort all by distance?)
--DT outputs to all teammates (do it with only passer data?)
--Decision (random)

When there's a goal, record it in the file as well.
Intermediate occurences?  -- receive the ball (sooner, the better)
*/

/* in communications.c */
/* This must return the position number for true (?) */
int ConsiderPosition(int position){

  int OnlyGoalieSwitch = FALSE;

  if (Mem->ChangePositions){

    if ( Mem->PositionOccupied(position) )
      return UNKNOWN_POSITION;

    int teammate;
    /*float dist;
    dist = Mem->ClosestTeammateTo(Mem->PositionHomeX(position),
				  Mem->PositionHomeY(position),
			   &teammate);  /* Find the closest teammate to the position */
    if ( /* teammate == Mem->MyNumber && dist < 40 && */
	Mem->IsMoreImportantPosition(position,Mem->GetMyPosition()) ){
      /*printf("%d:%d Decided %d more important than %d\n",
	Mem->MyNumber,Mem->CurrentTime,position,Mem->GetMyPosition());*/
      if ( OnlyGoalieSwitch && position != 0 )
	return UNKNOWN_POSITION;
      else 
	return position;
    }
    else 
      return UNKNOWN_POSITION; /* Someone else will go */
  }
  else /* Don't change positions */
    return UNKNOWN_POSITION;
}

/*****************************************************************************/

/* Return the new position to go to or FALSE if stay the same */
int ConsiderNewPosition(){

#if 0
return FALSE;
#endif
  if (Mem->ChangePositions){

    for (int position=0; position<TEAM_SIZE; position++){
      if ( position != Mem->GetMyPosition() && 
	   ConsiderPosition(position) != UNKNOWN_POSITION &&
	   int_random(100)                             )
	return position;
    }
    return UNKNOWN_POSITION;
  }
  else /* Keep my Position */
    return UNKNOWN_POSITION;
}






