/* peterclient.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _CLIENT_H_
#define _CLIENT_H_

/*
 * Definitions for UDP c/s program.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>
#include <sys/time.h>
#include <ctype.h>
#include "memory.h"

#define INIT_ToUse_FILE "nets/weights-Dec31-16:5.dat" /*Jun13-14:53.dat"*/
#define TREE_STEM       "trees/Data/pass.05Noise.25CF"
#define DASH_MEM_FILE   "dashMem/Memory.dat"

extern int      SIMULATOR_STEP;
#define DEFAULT_SIMULATOR_STEP  100
#define SEND_STEP               (SIMULATOR_STEP*3)
#define MAX_ACTS                (2*(SEND_STEP/SIMULATOR_STEP))

#define DEFAULT_PORT_NUMBER	6000
#define MAXMESG			2048
#define SAVE_FREQ               10   /* How many actions before saving    */
#define SAVE_SOUND_FREQ         10   /* How many sounds  before saving    */
#define SAVE_COLLECT_DATA       0
#define SAVE_PASS_DATA          0
#define DETAILED_PASS_STATS     1
#define USE_LEARNED_MOVE        0
#define MOVE_LEARN              0
#define PRACTICE                0
#define DELAY_FACTOR            2    /* How much slower to go in practice phase */

#define FORGET -1
#define RANDOM_INTERCEPT FORGET+1
#define INTERCEPT RANDOM_INTERCEPT+1
#define SHOOT INTERCEPT+1
#define RANDOM_PASS SHOOT+1
#define LEARNED_PASS RANDOM_PASS+1
#define COLLECT_PASS LEARNED_PASS+1
#define INTERCEPT_PASS COLLECT_PASS+1
#define CHASE_AND_SHOOT INTERCEPT_PASS+1
#define DRIBBLE_AND_SHOOT CHASE_AND_SHOOT+1
#define DEFEND DRIBBLE_AND_SHOOT+1
#define KAMRAM DEFEND+1
#define GOALIE KAMRAM+1
#define CENTER_SWEEPER GOALIE+1
#define RIGHT_DEFENSE CENTER_SWEEPER+1
#define CENTER_DEFENSE RIGHT_DEFENSE+1
#define LEFT_DEFENSE CENTER_DEFENSE+1
#define RIGHT_MIDFIELD LEFT_DEFENSE+1
#define CENTER_MIDFIELD RIGHT_MIDFIELD+1
#define LEFT_MIDFIELD CENTER_MIDFIELD+1
#define RIGHT_WING LEFT_MIDFIELD+1
#define CENTER_FORWARD RIGHT_WING+1
#define LEFT_WING CENTER_FORWARD+1
#define START_SET_PLAY LEFT_WING+1
#define RIGHT_MID_SET_PLAY START_SET_PLAY+1
#define LEFT_MID_SET_PLAY RIGHT_MID_SET_PLAY+1
#define RIGHT_WINGER_SET_PLAY LEFT_MID_SET_PLAY+1
#define LEFT_WINGER_SET_PLAY RIGHT_WINGER_SET_PLAY+1
#define FINISH_SET_PLAY LEFT_WINGER_SET_PLAY+1

#define JUSTIN_KICK 100
#define JUSTIN_COLLECT 101

#ifndef MAX
#define MAX(a,b) (a>b) ? a : b
#define MIN(a,b) (a<b) ? a : b
#endif

#ifdef MEMSET
#define bzero(a, b) memset(a, 0, b)
#endif

#ifdef __cplusplus
class Socket {
 public:
  int			socketfd  ;
  struct sockaddr_in	serv_addr ;
};
#else
typedef struct socket{
    int			socketfd  ;
    struct sockaddr_in	serv_addr ;
}Socket ;
#endif

extern int    send_message(char* buf, Socket *sock) ;
extern int    message_poll_while_waiting(Socket *sock);
extern int    message_poll_until_sight(Socket *sock);

/* Make this Global instead of passing them around */
extern Socket   *GLOBAL_sock;

#endif
