/* memory.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef MEMORY_H
#define MEMORY_H

#include "position.h"
#include "formation.h"
#include "setplay.h"
#include "utils.h"
#include "rl.h"

class Memory : public PositionInfo, public TeamPositionInfo, public RewardInfo {
public:
  Memory();
  ~Memory();
  Initialize(const char team, const int number, char *team_name, char *mode, int sock);

  virtual void Reset();
  virtual void Dashing(float power);
  virtual void Tick(int marker,int time);

#if 0
/* Useful if you want to reference players by position
  float GetPlayerDistance(char side, int number);
  inline float GetPlayerDistance(char side, int type, int pside)
    {return GetPlayerDistance(side, EncodePosition(type,pside));}
  float GetPlayerAngle(char side, int number);
  inline float GetPlayerAngle(char side, int type, int pside)
    {return GetPlayerAngle(side, EncodePosition(type,pside));}
  float PlayerDistanceValid(char side, int number);
  inline float PlayerDistanceValid(char side, int type, int pside)
    {return PlayerDistanceValid(side, EncodePosition(type,pside));}
  float PlayerAngleValid(char side, int number);
  inline float PlayerAngleValid(char side, int type, int pside)
    {return PlayerAngleValid(side, EncodePosition(type,pside));}
  float PlayerValid(char side, int number);
  inline float PlayerValid(char side, int type, int pside)
    {return PlayerValid(side, EncodePosition(type,pside));}
*/
#endif
  int FindTeammateWithStatus(char*);    // Return teammate with status
  int FindTeammatesWithStatus(char*, int*);  /* Put appropriate teammate nums in array
						return the number of teammates found */
  int SortPlayersBy(char side, char keyFunc, float keyNum, int* players);
                                    /* side = m,t,b (both) keyFunc = d,a
				       (dist/ang), keyNum = central val.
				       players = array.  Return num found */

  int NumTeammatesWithin(float Dist, float Ang, float ofDist, float ofAng);
  inline int NumTeammatesWithin(float Dist, float Ang) 
    {return NumTeammatesWithin(Dist, Ang, 0, 0);}
  inline int NumTeammatesWithin(float Dist)
    {return NumTeammatesWithin(Dist, 360, 0, 0);}
  int NumOpponentsWithin(float Dist, float Ang, float ofDist, float ofAng);
  inline int NumOpponentsWithin(float Dist, float Ang) 
    {return NumOpponentsWithin(Dist, Ang, 0, 0);}
  inline int NumOpponentsWithin(float Dist)
    {return NumOpponentsWithin(Dist, 360, 0, 0);}
  int NumPlayersWithin  (float Dist, float Ang, float ofDist, float ofAng);
  inline int NumPlayersWithin(float Dist, float Ang) 
    {return NumPlayersWithin(Dist, Ang, 0, 0);}
  inline int NumPlayersWithin(float Dist)
    {return NumPlayersWithin(Dist, 360, 0, 0);}
                                /* Within Dist AND Ang of the point ofDist,ofAng */

  int GetClosestTeammate();
  int GetClosestOpponent();

  /* This is expensive.  If I do it too much, I should store global positions
     in the position structure---but remember to erase them every tick           */
  float ClosestTeammateTo(float toX, float toY, int *teammate_number);
  inline float ClosestTeammateTo(float toX, float toY)
    {int x; return ClosestTeammateTo(toX,toY,&x);}
  inline float ClosestTeammateToBall()
    { return ClosestTeammateTo(GetBallGlobalX(),GetBallGlobalY()); }

  int InOwnPenaltyArea();
  int FacingBackInOwnPA();
  int FacingBackNearOwnGoal();

  int NewCoach;
  int RecordCollectData;

  int NewSight;                 /* Has a new sight come through?       */
  int StoppedClockTime;         /* Measures sights since clock stopped */

  int HeardNewSound();                    
  inline char *GetNewSound() {return new_sound;} /* Returns the actual sound heard */ 
  inline int   GetNewSoundTime() { return new_sound_time; } 
  inline int   GetNewSoundSpeaker() { return new_sound_speaker; }
  ClearSound();
  NewSound(int, int, char*); 
  int CommunicateDelay;

#define INACTIVE     0
#define ACTIVE       1
#define AT_ATTENTION 2
#define AUXILIARY    3
#define INSETPLAY    4
  inline void SetActive  (int player) { my_team_active[player] = ACTIVE;   }
  inline void SetInactive(int player) { my_team_active[player] = INACTIVE; }
         void SetAtAttention(int player);
         void SetAuxiliary  (int player);
         void SetInSetPlay  (int player);
  inline int  GetActiveStatus (int player) { return my_team_active[player];}
  inline int  GetMyActiveStatus()     { return my_team_active[0];          }
  void ClearActives();
  void SetMyselfActive();
  void SetMyselfInactive();
  void SetMyselfAtAttention();
  void SetMyselfInSetPlay();
  void SetMyselfAuxiliary();
  void UpdateActive();

  char *GetStatus(char, int);
  inline char *GetMyStatus()  {return GetStatus(MySide,MyNumber);}
  void SetStatus (char, int, char*);
  inline void SetMyStatus(char *stat) { SetStatus(MySide,MyNumber,stat); }
  void ClearStatus(char, int);
  inline void ClearMyStatus() {ClearStatus(MySide,MyNumber);}
  void ClearStatuses();         /* Set everyone on team's status to blank  */
  void ClearStatuses(char *status); /* Only clear players with stat status */
  void ClearOtherStatuses();    /* Set everyone but self's status to blank */

  char *GetData(int);
  void SetData (int, char*);
  void ClearData();

  inline int GetMyLocationSide() /* Which side of the field am I on? */
                    {return ( GetGlobalY() < 0 ? RIGHT : LEFT );}
  inline int BallLocationSide() /* Which side of the field am I on? */
                    {return ( GetBallGlobalY() < 0 ? RIGHT : LEFT );}

  int InPosition();
  int InKickoffPosition();
  int GetPositionOfMyLocation();
  int GetMyLocationsPositionType();
  int GetMyLocationsPositionSide();

  void CheckForPlayersInMyPosition();

  int   OnlyActiveIfClosest();
  float GetMaxActiveDistance();
  float GetMinInactiveDistance();

  int IsWithinMyHomeRange(char side, int number);
  int IsWithinMyMaxRange (char side, int number);
  int AmWithinMyHomeRange();
  int AmWithinMyMaxRange ();
  int BallIsWithinMyHomeRange();
  int BallIsWithinMyMaxRange ();
  int OpponentIsWithinPlayerHomeRange(int opponent, int player);
  int OpponentIsWithinPlayerMaxRange(int opponent, int player);

  float PlayerDistanceToPositionHome(int player, int position);

  void  UpdateHome();
  void  UpdateMark();
  int   GetMyReceiverList(int *ReceiverList);

  inline int   GetMyStamina()        {return stamina_estimate;                   }
  inline void  StaminaReset()        {stamina_estimate = STAMINA_MAX;            }

  void InitializeSetPlay();

  float GetPositionSetPlayX(int pos);
  float GetPositionSetPlayY(int pos);
  void  GetPositionSetPlayXY(int pos, float *x, float *y);

  float GetMySetPlayX();
  float GetMySetPlayY();
  void  GetMySetPlayXY(float *x, float *y);
  float  GetMySetPlayPositionBuffer();
  int   InMySetPlayPosition();

  float GetMySetPlayAimX();
  float GetMySetPlayAimY();
  void  GetMySetPlayAimXY(float *x, float *y);
  int   GetMySetPlayAimPosition();
  int   GetMySetPlayWaitTime();
  int   GetMySetPlayPositionType();

  int SetPlayPositionFilled(int pos);
  int AllInSetPlayPosition();
  int GetSetPlayStarterPosition();
  int PositionInSetPlay(int pos);
  int MyPositionInSetPlay();
  int BallInSetPlayPosition();

  void ModifySetPlayStartAction();
/*
  inline void SetMyAuxiliaryPosition(float x, float y) 
    {auxiliary_x = x; auxiliary_y = y;}
  inline float GetMyAuxiliaryX() {return auxiliary_x;}
  inline float GetMyAuxiliaryY() {return auxiliary_y;}
  inline void  GetMyAuxiliaryXY(float *x, float *y)
    {*x = GetMyAuxiliaryX(); *y = GetMyAuxiliaryY();}
*/  

#define NO_MODE            0
#define BEFORE_KICK_OFF   (NO_MODE+1)
#define MY_KICK_OFF       (BEFORE_KICK_OFF+1)
#define THEIR_KICK_OFF    (MY_KICK_OFF+1)
#define MY_KICK_IN        (THEIR_KICK_OFF+1)
#define THEIR_KICK_IN     (MY_KICK_IN+1)
#define MY_CORNER_KICK    (THEIR_KICK_IN+1)
#define THEIR_CORNER_KICK (MY_CORNER_KICK+1)
#define MY_GOAL_KICK      (THEIR_CORNER_KICK+1)
#define THEIR_GOAL_KICK   (MY_GOAL_KICK+1)
#define MY_FREE_KICK      (THEIR_GOAL_KICK+1)
#define THEIR_FREE_KICK   (MY_FREE_KICK+1)
#define DROP_BALL         (THEIR_FREE_KICK+1)  
#define PLAY_ON           (DROP_BALL+1)
#define HALF_TIME         (PLAY_ON+1)
#define TIME_UP           (HALF_TIME+1)
#define EXTENDED_TIME     (TIME_UP+1)

  int  OriginalBehavior;

  int  PlayMode;
  int  KickOffMode;
  int  ChangePositions;
  int  UseUnitCoaching;
  int  EchoSounds;

  int  UseSetPlays;
  int  SetPlay;
  int  SetPlayStartTime;
  int  SetPlayInvokeTime;
  int  SetPlayTimeLimit;
  int  SetPlayStartActionChosen;
  int  SetPlayStartReceiver;

  SetPlayFormation *CurrentSetPlayFormation;

  int  MyScore;
  int  TheirScore;

  int   MoveRecorded;
  float LastDashPower;
  int   LastDashTimes;
  float PreDashGlobalX,PreDashGlobalY;
  
#define NUM_THEIR_SOUNDS_SAVED 5

  void SetTheirSound(int num, char *msg, int time);
  char *GetTheirSound(int num);
  int  GetTheirSoundTime(int num);
  void ClearTheirSound(int num);
  void ClearTheirSounds();
  int  GetTheirOldestSoundNumber();
  int  GetTheirBlankSoundNumber();
  void ReplaceTheirOldestSound(char *msg);
  char *GetTheirOldestSound();

private:
  int              socket;          // assigned socket  

  char             new_sound[MAXMESG]; // Has a new sound come through?       
  int              new_sound_time;					 
  int              new_sound_speaker;					 

  char             their_sounds[NUM_THEIR_SOUNDS_SAVED][MAXMESG];
  int              their_sounds_times[NUM_THEIR_SOUNDS_SAVED];

  int              my_team_active[TEAM_SIZE+1];
/*
  float            auxiliary_x;
  float            auxiliary_y;
*/
  char             my_team_status[TEAM_SIZE+1][1024];
  char             my_team_data[TEAM_SIZE+1][1024];
  /*char             their_team_status[TEAM_SIZE+1][1024];*/
  /*char             their_team_data[TEAM_SIZE+1][1024];*/

  int              stamina_estimate;      /* a lower bound */
};

/* Make this Global instead of passing them around */
extern Memory *Mem;  /* defined in peterclient.c   */

#endif
