/* knockorpass.c
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#include "global.h"

/* In this file, the choice of what to do with the ball (pass,dribble,or shoot)
   is made */

#define WHATEVER 0
#define SHOOT_DIST 30
#define PASS_DEBUG 0
#define PASSER_DEBUG 0

/*****************************************************************************/

int NoChange(char *KnockOrPass, int *BallTo){
  /* only if they're assigned coming in */
  return WHATEVER;
}

/*****************************************************************************/

int AlwaysShoot(char *KnockOrPass, int *BallTo){
  *KnockOrPass = 'k';
  *BallTo = THEIR_GOAL;
  return WHATEVER;
}

/*****************************************************************************/

int RandomOccupied(char *KnockOrPass, int *BallTo){

  int MyPositionType = Mem->GetMyPositionType();
  int MyPositionSide = Mem->GetMyPositionSide();

  if ( Mem->GetMyPositionType() == FORWARD ){  /* If I'm forward, shoot */
    *KnockOrPass = 'k';  
    *BallTo = THEIR_GOAL;
    return WHATEVER;
  }

  *KnockOrPass = 'p';            /* otherwise pass         */

  int OccupiedPositions[TEAM_SIZE];
  int NumOccupied=0;

  for(int position=0; position<TEAM_SIZE; position++){
    if ( position != Mem->GetMyPosition() && 
	 Mem->PositionOccupied(position)      ){
      OccupiedPositions[NumOccupied] = position;
      NumOccupied++;
    }
  }
  if (!NumOccupied){  /* No positions occupied, so shoot */
    *KnockOrPass = 'k';
    *BallTo = THEIR_GOAL;
  }
  else /* Pick a random position */
    *BallTo = Mem->GetPositionPlayer(OccupiedPositions[int_random(NumOccupied)]); 
        
  return WHATEVER;
}

/*****************************************************************************/

int UnderPressure(){

    if ( Mem->NumOpponentsWithin(10) || Mem->FacingBackInOwnPA() )
      return TRUE;
    else 
      return FALSE;
}

/*****************************************************************************/

int ResolveConfidencesAndPreferences(int NumPrefs, int PreferenceList[], 
				     int NumMates, int teammates[], float Confidences[]){
  /* Start by finding the ones with the highest confs.
     Then choose most preferable of those. 
     If none on the list, see if there is another candidate from prefs
     with a reasonable conf */

  int NumWithHighConf = 0;
  float HighConf = 0;
  int HighConfMates[NumMates];

  int hurry = UnderPressure(); /*FALSE*/
  if (hurry)
    printf("Gotta Hurry (%d)\n",Mem->MyNumber);

  /* Get all the highest confidences into an array */
  for (int i=0; i<NumMates; i++){
    /* If under pressure, only consider the facing ones */
    while (hurry && NEEDTOCIRCLETOPASSTO(teammates[i]))
      i++;
    if ( i>=NumMates ) 
      break; 
    if (Confidences[i] > HighConf){
      HighConf = Confidences[i];
      NumWithHighConf = 1;
      HighConfMates[0] = teammates[i]; 
    }
    else if (Confidences[i] == HighConf){
      HighConfMates[NumWithHighConf++] = teammates[i];
    }
  }

  /* If all options are bad, forget it */
  if ( !NumWithHighConf )
    return 0;

  /* If only one is best, go with it   */
  if ( NumWithHighConf == 1 )
    return HighConfMates[0];

  /* Find the most preferable of the ones with the top confidence */
  for (int i=0; i<NumWithHighConf; i++)
    for (int j=0; j<NumPrefs; j++)
      if ( Mem->GetPlayerPosition(HighConfMates[i]) == PreferenceList[j] ){
	return HighConfMates[i];
      }
  
  /* If none were good, all options are bad*/
  return 0;
  
}

/*****************************************************************/

int ConsiderDTOutput(char *KnockOrPass, int *BallTo){

#if 0
  if ( Mem->GetPositionTypeOfMyLocation() == FORWARD ){  /* If I'm forward, shoot */
    *KnockOrPass = 'k';  
    *BallTo = THEIR_GOAL;
    return WHATEVER;
  }
#endif

  if ( !Mem->BallValid() || Mem->GetBallDistance() > KICK_DISTANCE ){
    /* Doesn't matter -- won't get used anyway, just collecting the ball */
    *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    return WHATEVER;
  }

  if ( Mem->FacingBackNearOwnGoal() ||/*FacingBackInOwnPA()*/ 
       Mem->InOwnPenaltyArea() ){
    /* Similar condition in Cleartowards --- change there too */
    *KnockOrPass = 'c';
    if ( Mem->GetMyLocationSide() == RIGHT )
      *BallTo = RC_FLAG;
    else
      *BallTo = LC_FLAG;
    return WHATEVER;
  }

  *KnockOrPass = 'p';            /* otherwise pass         */

#if PASSER_DEBUG
  printf("*** player %d passing *** %d *** %d *** %d ***\n",
	 Mem->MyNumber,Mem->MyNumber,Mem->MyNumber,Mem->MyNumber);
#endif

  int PreferenceList[TEAM_SIZE];
  int NumOptions = Mem->GetMyReceiverList(PreferenceList);

  int hurry = UnderPressure(); 
#if PASSER_DEBUG
  if (hurry)
    printf("Gotta Hurry (%d)\n",Mem->MyNumber);
#endif

  /* choose the eligible receivers */
  int teammates[TEAM_SIZE];
  int NumOpen = 0, teammateIndex = 0;
  for (int i=0; i<NumOptions; i++){
    if ( Mem->PositionOccupied(PreferenceList[i]) && 
	 Mem->GetPositionPlayer(PreferenceList[i]) != Mem->MyNumber ){
      int PossibleReceiver = Mem->GetPositionPlayer(PreferenceList[i]);
      
      if ( Mem-> PlayerValid(Mem->MySide,PossibleReceiver) &&
	   Mem->GetPlayerDistance(Mem->MySide,PossibleReceiver) > 10 &&
	   Mem->GetPlayerDistance(Mem->MySide,PossibleReceiver) < 50 &&
	   (!hurry || !NEEDTOCIRCLETOPASSTO(PossibleReceiver)) )
	teammates[NumOpen++] = PossibleReceiver;
    }
  }

#if PASSER_DEBUG
  printf("NumOpen: %d\n",NumOpen);
#endif

#if 0
  int WaitForData = FALSE;
  for (int j=0; j<NumOpen; j++){
    if ( !strcmp(Mem->GetData(teammates[j]),BLANK_DAT) ){
      SAYTO(teammates[j],GIVE_DATA_MSG);    /* Ping the individual for data */
      WaitForData = TRUE;
    }
  }
#endif

/* Ask for the data, but don't wait for it */
#if 0  
  if ( WaitForData ){     /* waiting for data:  don't bother evaluating yet */
    *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    printf("ChooseReceiverTree returned FALSE\n");
    return WHATEVER;
  }
#endif

#if 1
  if ( !NumOpen ){
    /* printf("          None open\n");*/
    if ( hurry || 
	 (Mem->MarkerValid(THEIR_GOAL) && 
	  Mem->GetMarkerDistance(THEIR_GOAL) < SHOOT_DIST) )
      *KnockOrPass = 'k';
    else 
      *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    int myType = Mem->GetMyLocationsPositionType();
    int mySide = Mem->GetMyLocationsPositionSide();
    if ( myType <= DEFENDER && 	 mySide == CENTER ){
      if (Mem->GetMyLocationSide() == RIGHT) /* Actual side */
	*BallTo = RF_FLAG;   /* center backs shouldn't clear it up the middle */
      else
	*BallTo = LF_FLAG;   
    }
    if ( myType != FORWARD )
      *KnockOrPass = 'c';  /* avoid players */
    return WHATEVER;
  }
#endif

#if PASSER_DEBUG
  printf("Running the DT stuff\n");
#endif

  /* Find the best teammate */
  float Confidences[NumOpen];  /* Array to keep confidence that pass will succeed */

  /* Limit the options that are considered */
  /* if (NumOpen > 3) NumOpen = 3;         */

#if PASS_DEBUG
  /* Random choice among DT options */
  /* int receiverIndex = int_random(NumOpen);*/
  /* First choice among DT options (like WTW)*/
  printf("random pass\n");
  int receiverIndex = 0;
  int receiver = teammates[receiverIndex];
  float PassSuccessConf = 1;
#else 
  int receiverIndex = FindTreeConfidences(NumOpen,teammates,Confidences);
  int receiver = teammates[receiverIndex];
  float PassSuccessConf = Confidences[receiverIndex];
#endif

  if ( PassSuccessConf < 0 ){
    /* printf("          None will succeed\n");    */
    if ( hurry || 
	 (Mem->MarkerValid(THEIR_GOAL) && 
	  Mem->GetMarkerDistance(THEIR_GOAL) < SHOOT_DIST) )
      *KnockOrPass = 'k';
    else 
      *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    int myType = Mem->GetMyLocationsPositionType();
    int mySide = Mem->GetMyLocationsPositionSide();
    if ( myType <= DEFENDER && 	 mySide == CENTER ){
      if (Mem->GetMyLocationSide() == RIGHT)  /* Actual side */
	*BallTo = RF_FLAG;   /* center backs shouldn't clear it up the middle */
      else
	*BallTo = LF_FLAG;   
    }
    if ( myType != FORWARD )
      *KnockOrPass = 'c';  /* avoid players */
#if PASSER_DEBUG
    printf("Don't pass with confidence of %.1f\n",PassSuccessConf);
#endif
    return WHATEVER;
  }
  else{
    /* printf("ChooseReceiverTree returned %d\n",receiver); */
    *BallTo = receiver;
  }

  if ( *KnockOrPass == 'p' && ( !*BallTo || *BallTo>TEAM_SIZE ) ){
    printf("*BallTo = %d\n",*BallTo);
    my_error("Need to pass to a teammate with a valid number");
  }

  return WHATEVER;
}

/*****************************************************************/

/* 
What's in a state?  Want this to be as small as possible, yet meaningful

--My position on the field
--Teammate/opponent locations--distances + position (i.e. where on field)
       angle is irrelevant (sort all by distance?)
--DT outputs to all teammates (do it with only passer data?)
--did I pass, shoot, or dribble?
--to whom?

When there's a goal, record it in the file as well.
Intermediate occurences?  -- retain possession on next decision?
*/

//int OldUseRL(char *KnockOrPass, int *BallTo){
//
//  if ( !Mem->BallValid() || Mem->GetBallDistance() > KICK_DISTANCE ){
//    /* Doesn't matter -- won't get used anyway, just collecting the ball */
//    *KnockOrPass = 'd';
//    *BallTo = THEIR_GOAL;
//    return WHATEVER;
//  }
//
//  *KnockOrPass = 'p';            /* otherwise pass         */
//
//#if PASSER_DEBUG
//  printf("*** player %d passing *** %d *** %d *** %d ***\n",
//         Mem->MyNumber,Mem->MyNumber,Mem->MyNumber,Mem->MyNumber);
//#endif
//
//  int PreferenceList[TEAM_SIZE];
//
//#if 0
//  /* Only consider from list */
//  int NumOptions = Mem->GetMyReceiverList(PreferenceList); 
//#else
//  /* Consider all positions*/
//  int NumOptions=TEAM_SIZE;
//  for (int i=0; i<TEAM_SIZE; i++)
//    PreferenceList[i]=i;
//#endif
//
//  int hurry = UnderPressure(); 
//#if PASSER_DEBUG
//  if (hurry)
//    printf("Gotta Hurry (%d)\n",Mem->MyNumber);
//#endif
//
//  /* choose the eligible receivers */
//  int teammates[TEAM_SIZE];
//  int NumOpen = 0;
//  for (int i=0; i<NumOptions; i++){
//    if ( Mem->PositionOccupied(PreferenceList[i]) && 
//         Mem->GetPositionPlayer(PreferenceList[i]) != Mem->MyNumber ){
//      int PossibleReceiver = Mem->GetPositionPlayer(PreferenceList[i]);
//      
//      if ( Mem-> PlayerValid(Mem->MySide,PossibleReceiver) &&
//           Mem->GetPlayerDistance(Mem->MySide,PossibleReceiver) > 10 &&
//           Mem->GetPlayerDistance(Mem->MySide,PossibleReceiver) < 50 &&
//           (!hurry || !NEEDTOCIRCLETOPASSTO(PossibleReceiver)) )
//        teammates[NumOpen++] = PossibleReceiver;
//    }
//  }
//  teammates[NumOpen]=Mem->MyNumber;
//
//
//#if PASSER_DEBUG
//  printf("NumOpen: %d\n",NumOpen);
//#endif
//
//#if 0
//  int WaitForData = FALSE;
//  for (int j=0; j<NumOpen; j++){
//    if ( !strcmp(Mem->GetData(teammates[j]),BLANK_DAT) ){
//      SAYTO(teammates[j],GIVE_DATA_MSG);    /* Ping the individual for data */
//      WaitForData = TRUE;
//    }
//  }
//#endif
//
///* Ask for the data, but don't wait for it */
//#if 0  
//  if ( WaitForData ){     /* waiting for data:  don't bother evaluating yet */
//    *KnockOrPass = 'd';
//    *BallTo = THEIR_GOAL;
//    printf("ChooseReceiverTree returned FALSE\n");
//    return WHATEVER;
//  }
//#endif
//
//  if ( 0 && !NumOpen /* let the clear be selected */){
//
//    printf("%d:%d          None open\n", Mem->MyNumber, Mem->CurrentTime);
//
//    /* Was at top of function */
//    if ( Mem->FacingBackNearOwnGoal() ||/*FacingBackInOwnPA()*/ 
//         Mem->InOwnPenaltyArea() ){
//      /* Similar condition in Cleartowards --- change there too */
//      *KnockOrPass = 'c';
//      if ( Mem->GetMyLocationSide() == RIGHT )
//        *BallTo = RC_FLAG;
//      else
//        *BallTo = LC_FLAG;
//      return WHATEVER;
//    }
//
//    if ( hurry || 
//         (Mem->MarkerValid(THEIR_GOAL) && 
//          Mem->GetMarkerDistance(THEIR_GOAL) < SHOOT_DIST) )
//      *KnockOrPass = 'k';
//    else 
//      *KnockOrPass = 'd';
//    *BallTo = THEIR_GOAL;
//    int myType = Mem->GetMyLocationsPositionType();
//    int mySide = Mem->GetMyLocationsPositionSide();
//    if ( myType <= DEFENDER &&   mySide == CENTER ){
//      if (Mem->GetMyLocationSide() == RIGHT) /* Actual side */
//        *BallTo = RF_FLAG;   /* center backs shouldn't clear it up the middle */
//      else
//        *BallTo = LF_FLAG;   
//    }
//    if ( myType != FORWARD )
//      *KnockOrPass = 'c';  /* avoid players */
//    return WHATEVER;
//  }
//
//#if PASSER_DEBUG
//  printf("Running the DT stuff\n");
//#endif
//
//  /* Find the best teammate */
//  float Confidences[NumOpen+1];  /* Array to keep confidence that pass will succeed */
//
//  /* Limit the options that are considered */
//  /* if (NumOpen > 3) NumOpen = 3;         */
//
//#if PASS_DEBUG
//  /* Random choice among DT options */
//  /* int receiverIndex = int_random(NumOpen);*/
//  /* First choice among DT options (like WTW)*/
//  printf("random pass\n");
//  int receiverIndex = 0;
//  int receiver = teammates[receiverIndex];
//  float PassSuccessConf = 1;
//#else 
//  int receiverIndex = FindTreeConfidences(NumOpen,teammates,Confidences);
//  Confidences[NumOpen]=KNOCK_CONF;
//  if (receiverIndex<0) receiverIndex=0;  /* To adjust for passing in self */
//  /* Overwrite the max value */
//  receiverIndex = RLforReceiver(NumOpen,teammates,Confidences);
//
//  int receiver = teammates[receiverIndex];
//  float PassSuccessConf = Confidences[receiverIndex];
//#endif
//
//  //printf("%d passing to %d\n",Mem->MyNumber,receiver);
//
//  static int Attempts = 0, Shots = 0;
//  if (receiver == Mem->MyNumber)
//    Shots++;
//  if ( Attempts++%100 == 0 ){
//    char fileName[100];
//    sprintf(fileName,"rlDat/rlDatShots%d.dat",Mem->MyNumber);
//    FILE *shotsFile = fopen(fileName,"w");
//    fprintf(shotsFile,"%d shots out of %d attempts (%.1f\%)\n",
//            Shots,Attempts,100*((float)Shots)/Attempts);
//    fclose(shotsFile);
//  }
//
//  if (receiver == Mem->MyNumber /* || PassSuccessConf < 0 */){
//
//#if 1
//    *KnockOrPass = 'k';
//    *BallTo = THEIR_GOAL;
//    return WHATEVER;
//#endif
//
//    /* Was up top */
//    if ( Mem->FacingBackNearOwnGoal() ||/*FacingBackInOwnPA()*/ 
//         Mem->InOwnPenaltyArea() ){
//      /* Similar condition in Cleartowards --- change there too */
//      *KnockOrPass = 'c';
//      if ( Mem->GetMyLocationSide() == RIGHT )
//        *BallTo = RC_FLAG;
//      else
//        *BallTo = LC_FLAG;
//      return WHATEVER;
//    }
//
//    /* printf("          None will succeed\n");    */
//    if ( hurry || 
//         (Mem->MarkerValid(THEIR_GOAL) && 
//          Mem->GetMarkerDistance(THEIR_GOAL) < SHOOT_DIST) )
//      *KnockOrPass = 'k';
//    else 
//      *KnockOrPass = 'd';
//    *BallTo = THEIR_GOAL;
//    int myType = Mem->GetMyLocationsPositionType();
//    int mySide = Mem->GetMyLocationsPositionSide();
//    if ( myType <= DEFENDER &&   mySide == CENTER ){
//      if (Mem->GetMyLocationSide() == RIGHT)  /* Actual side */
//        *BallTo = RF_FLAG;   /* center backs shouldn't clear it up the middle */
//      else
//        *BallTo = LF_FLAG;   
//    }
//    if ( myType != FORWARD )
//      *KnockOrPass = 'c';  /* avoid players */
//#if PASSER_DEBUG
//    printf("Don't pass with confidence of %.1f\n",PassSuccessConf);
//#endif
//    return WHATEVER;
//  }
//  else{
//    /* printf("ChooseReceiverTree returned %d\n",receiver); */
//    *BallTo = receiver;
//  }
//
//  if ( *KnockOrPass == 'p' && ( !*BallTo || *BallTo>TEAM_SIZE ) )
//    my_error("Need to pass to a teammate with a valid number");
//
//  return WHATEVER;
//}

int ImmediatelyBlocked(float x, float y){

  if (!UnderPressure()) return FALSE;

  float ballX,ballY;
  Mem->GetBallGlobalXY(&ballX,&ballY);
  LINEP PassLine=LnFrom2Pts(ballX,ballY,x,y);
  POSN Ball, Dest, Player;
  Ball.x = ballX; Ball.y = ballY;
  Dest.x = x, Dest.y = y;
  float DistAlong, DistFrom;
  int blocked = FALSE;
  int blockedBy = 0;

  for (int i=1; i<=TEAM_SIZE; i++){
    if (i == Mem->MyNumber) continue;
    if (!Mem->TeammateValid(i)) continue;
    if (Mem->GetTeammateDistance(i) > 11) continue;
    Mem->GetTeammateGlobalXY(i,&(Player.x),&(Player.y));
    if ( !LnDistanceIfBetween(&Player,&Ball,&Dest,PassLine,&DistFrom,&DistAlong) )
      continue;
    if (fabs(DistAlong) < 10 && fabs(DistFrom) < 2){
      blocked = TRUE;
      blockedBy = i;
      break;
    }
  }
  if (!blocked){
    for (int i=1; i<=TEAM_SIZE; i++){
      if (!Mem->OpponentValid(i)) continue;
      if (Mem->GetOpponentDistance(i) > 11) continue;
      if (x == X0 && y == 0 && i==1) continue; /* At the goal, ignore goalie */
      Mem->GetOpponentGlobalXY(i,&(Player.x),&(Player.y));
      if ( !LnDistanceIfBetween(&Player,&Ball,&Dest,PassLine,&DistFrom,&DistAlong) )
	continue;
      if (fabs(DistAlong) < 10 && fabs(DistFrom) < 2){
	blocked = TRUE;
	blockedBy = i+100;
	break;
      }
    }
  }

  /*if (Mem->MyNumber==11 && blocked) 
    printf("%d:%d **** To (%.1f %.1f) is blocked (by %d: %.1f %.1f)! ****\n",
	   Mem->MyNumber, Mem->CurrentTime, x, y, blockedBy, DistAlong, DistFrom);*/

  delete PassLine;
  return blocked;
}

int ImmediatelyBlocked(int receiver){
  return ImmediatelyBlocked(Mem->GetTeammateGlobalX(receiver),
			    Mem->GetTeammateGlobalY(receiver));
}

int UseRL(char *KnockOrPass, int *BallTo){

  if ( !Mem->BallValid() || Mem->GetBallDistance() > KICK_DISTANCE ){
    /* Doesn't matter -- won't get used anyway, just collecting the ball */
    *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    return WHATEVER;
  }

  *KnockOrPass = 'p';            /* otherwise pass         */

#if PASSER_DEBUG
  printf("*** player %d passing *** %d *** %d *** %d ***\n",
         Mem->MyNumber,Mem->MyNumber,Mem->MyNumber,Mem->MyNumber);
#endif

  int PreferenceList[TEAM_SIZE];

#if 0
  /* Only consider from list */
  int NumOptions = Mem->GetMyReceiverList(PreferenceList); 
#else
  /* Consider all positions*/
  int NumOptions=TEAM_SIZE;
  for (int i=0; i<TEAM_SIZE; i++)
    PreferenceList[i]=i;
#endif

  int hurry = UnderPressure(); 
#if PASSER_DEBUG
  if (hurry)
    printf("Gotta Hurry (%d)\n",Mem->MyNumber);
#endif

  /* choose the eligible receivers */
  int actions[NUM_RL_ACTIONS];
  int action_types[NUM_RL_ACTIONS];
  int NumOpen = 0;
  for (int i=0; i<NumOptions; i++){
    if ( Mem->PositionOccupied(PreferenceList[i]) && 
         Mem->GetPositionPlayer(PreferenceList[i]) != Mem->MyNumber &&
	 PreferenceList[i] != Mem->GetPositionOfMyLocation() ){
      int PossibleReceiver = Mem->GetPositionPlayer(PreferenceList[i]);
      
      if ( Mem-> PlayerValid(Mem->MySide,PossibleReceiver) &&
           Mem->GetPlayerDistance(Mem->MySide,PossibleReceiver) > 10 &&
           Mem->GetPlayerDistance(Mem->MySide,PossibleReceiver) < 50 &&
           (!hurry || !NEEDTOCIRCLETOPASSTO(PossibleReceiver)) &&
	   !ImmediatelyBlocked(PossibleReceiver)){
	action_types[NumOpen] = RL_PASS_ACTION;
        actions[NumOpen++] = PossibleReceiver;
      }
    }
  }

  int NumActions = NumOpen;
#if 1
  for (int i=0; i<NUM_RL_KNOCK_ACTIONS; i++){
    if ( (!hurry || !NEEDTOCIRCLE(Mem->GetMarkerAngle(i+MY_GOAL))) ){
      float markerX,markerY;
      Mem->GetMarkerGlobalXY(i+MY_GOAL,&markerX,&markerY);
      if ( !ImmediatelyBlocked(markerX,markerY) ){
	action_types[NumActions] = RL_KNOCK_ACTION;
	actions[NumActions++] = i+MY_GOAL;
      }
    }
  }
  if (NumActions == NumOpen){ /* all knocks blocked */
    action_types[NumActions] = RL_KNOCK_ACTION;
    actions[NumActions++] = THEIR_GOAL;
  }
#else
  /* Only shoot */
  action_types[NumActions] = RL_KNOCK_ACTION;
  actions[NumActions++] = THEIR_GOAL;
#endif

#if PASSER_DEBUG
  printf("NumOpen: %d\n",NumOpen);
#endif

#if 0
  int WaitForData = FALSE;
  for (int j=0; j<NumOpen; j++){
    if ( !strcmp(Mem->GetData(actions[j]),BLANK_DAT) ){
      SAYTO(actions[j],GIVE_DATA_MSG);    /* Ping the individual for data */
      WaitForData = TRUE;
    }
  }
#endif

/* Ask for the data, but don't wait for it */
#if 0  
  if ( WaitForData ){     /* waiting for data:  don't bother evaluating yet */
    *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    printf("ChooseReceiverTree returned FALSE\n");
    return WHATEVER;
  }
#endif

#if 0
  if ( 0 && !NumOpen /* let the clear be selected */){

    printf("%d:%d          None open\n", Mem->MyNumber, Mem->CurrentTime);

    /* Was at top of function */
    if ( Mem->FacingBackNearOwnGoal() ||/*FacingBackInOwnPA()*/ 
         Mem->InOwnPenaltyArea() ){
      /* Similar condition in Cleartowards --- change there too */
      *KnockOrPass = 'c';
      if ( Mem->GetMyLocationSide() == RIGHT )
        *BallTo = RC_FLAG;
      else
        *BallTo = LC_FLAG;
      return WHATEVER;
    }

    if ( hurry || 
         (Mem->MarkerValid(THEIR_GOAL) && 
          Mem->GetMarkerDistance(THEIR_GOAL) < SHOOT_DIST) )
      *KnockOrPass = 'k';
    else 
      *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    int myType = Mem->GetMyLocationsPositionType();
    int mySide = Mem->GetMyLocationsPositionSide();
    if ( myType <= DEFENDER &&   mySide == CENTER ){
      if (Mem->GetMyLocationSide() == RIGHT) /* Actual side */
        *BallTo = RF_FLAG;   /* center backs shouldn't clear it up the middle */
      else
        *BallTo = LF_FLAG;   
    }
    if ( myType != FORWARD )
      *KnockOrPass = 'c';  /* avoid players */
    return WHATEVER;
  }
#endif
#if PASSER_DEBUG
  printf("Running the DT stuff\n");
#endif

  /* Find the best teammate */
  float Confidences[NumActions];  /* Array to keep confidence that pass will succeed */

  /* Limit the options that are considered */
  /* if (NumOpen > 3) NumOpen = 3;         */

#if PASS_DEBUG
  /* Random choice among DT options */
  /* int receiverIndex = int_random(NumOpen);*/
  /* First choice among DT options (like WTW)*/
  printf("random pass\n");
  int receiverIndex = 0;
  int receiver = actions[receiverIndex];
  float PassSuccessConf = 1;
#else 
  int receiverIndex = FindTreeConfidences(NumActions,actions,action_types,Confidences);
  if (receiverIndex<0) receiverIndex=0;  /* To adjust for passing in self */

  /*
  printf("%d hurry:%d -- ",Mem->MyNumber,hurry);
  for (int i=0; i<NumActions; i++)
    printf("%d ",actions[i]);
  printf("\n");
  */
  /* Overwrite the max value */
  receiverIndex = RLforReceiver(NumActions,actions,action_types,Confidences);

  int receiver = actions[receiverIndex];
  float PassSuccessConf = Confidences[receiverIndex];
#endif

  /* printf("%d passing to %d\n",Mem->MyNumber,receiver); */
#if 0
  static int Attempts = 0, Shots = 0;
  if (action_types[receiverIndex] == RL_KNOCK_ACTION &&
      receiver == THEIR_GOAL)
    Shots++;
  if ( Attempts++%100 == 0 ){
    char fileName[100];
    sprintf(fileName,"rlDat/rlDatShots%d.dat",Mem->MyNumber);
    FILE *shotsFile = fopen(fileName,"w");
    fprintf(shotsFile,"%d shots out of %d attempts (%.1f\%)\n",
            Shots,Attempts,100*((float)Shots)/Attempts);
    fclose(shotsFile);
  }
#endif
  if (action_types[receiverIndex]==RL_KNOCK_ACTION)
    *KnockOrPass = 'k';
  else
    *KnockOrPass = 'p';
  *BallTo = receiver;

#if 0
    /* printf("          None will succeed\n");    */
  if (receiver == Mem->MyNumber /* || PassSuccessConf < 0 */){

#if 1
    *KnockOrPass = 'k';
    *BallTo = THEIR_GOAL;
    return WHATEVER;
#endif

    /* printf("          None will succeed\n");    */
    if ( hurry || 
         (Mem->MarkerValid(THEIR_GOAL) && 
          Mem->GetMarkerDistance(THEIR_GOAL) < SHOOT_DIST) )
      *KnockOrPass = 'k';
    else 
      *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    int myType = Mem->GetMyLocationsPositionType();
    int mySide = Mem->GetMyLocationsPositionSide();
    if ( myType <= DEFENDER &&   mySide == CENTER ){
      if (Mem->GetMyLocationSide() == RIGHT)  /* Actual side */
        *BallTo = RF_FLAG;   /* center backs shouldn't clear it up the middle */
      else
        *BallTo = LF_FLAG;   
    }
    if ( myType != FORWARD )
      *KnockOrPass = 'c';  /* avoid players */
#if PASSER_DEBUG
    printf("Don't pass with confidence of %.1f\n",PassSuccessConf);
#endif
    return WHATEVER;
  }
  else{
    /* printf("ChooseReceiverTree returned %d\n",receiver); */
    *BallTo = receiver;
  }
#endif

  if ( *KnockOrPass == 'p' && ( !*BallTo || *BallTo>TEAM_SIZE ) )
    my_error("Need to pass to a teammate with a valid number (rl)");

  return WHATEVER;
}


























/*****************************************************************************/
/*****************************************************************************/
/****************   OLD STUFF ************************************************/
/*****************************************************************************/
/*****************************************************************************/

/*****************************************************************************/
#if 0
int WorkRightWing(char *KnockOrPass, int *BallTo){
  /* This is brain dead */
  float dist;
  int MyPositionType = Mem->GetMyPositionType();
  int MyPositionSide = Mem->GetMyPositionSide();

  *KnockOrPass = 'p';
  if (MyPositionType < DEFENDER){
    *BallTo = Mem->EncodePosition(DEFENDER,RIGHT); /* encode has to make receiver 
						      > teammate */
  }
  else if (MyPositionType < FORWARD){
    if ( MyPositionSide == CENTER )
      *BallTo = Mem->EncodePosition(MyPositionType,RIGHT);
    else
      *BallTo = Mem->EncodePosition(MyPositionType+1,MyPositionSide);
  }
  else { /* MyPositionType == FORWARD */
    if ( MyPositionSide != CENTER )
      *BallTo = Mem->EncodePosition(FORWARD,CENTER);
    else {
      *KnockOrPass = 'k';
      *BallTo = THEIR_GOAL;
    }
  }

  return WHATEVER;
}
#endif
/*****************************************************************************/
#if 0
#define OLD_PREF_LIST 0

/* Based on your position, prioritize your possible receivers */
/* return the number of options in the priority list          */
int BuildPreferenceList(int MyPositionType, int MyPositionSide, 
			int PreferenceList[]){

  int MyLocationSide = Mem->GetMyLocationSide();
  
  int NumOptions=0;

#if OLD_PREF_LIST  
  /* from client 11-2 */
  /* build pref lists */
  switch (MyPositionType){
  case FORWARD: 
    if ( MyPositionSide == CENTER );  /* Never Pass */
    else{
      NumOptions = (int_random(5) ? 1 : 0); /* shoot 1 in 5 times */
      PreferenceList[0] = Mem->EncodePosition(FORWARD,CENTER);
    }
    break;
  case MIDFIELDER:
    if ( MyPositionSide == CENTER ){
      NumOptions = 5;
      PreferenceList[0] = Mem->EncodePosition(MIDFIELDER,RIGHT );
      PreferenceList[1] = Mem->EncodePosition(MIDFIELDER,LEFT  );
      PreferenceList[2] = Mem->EncodePosition(FORWARD   ,RIGHT );
      PreferenceList[3] = Mem->EncodePosition(FORWARD   ,LEFT  );
      PreferenceList[4] = Mem->EncodePosition(FORWARD   ,CENTER);
    }
    else{
      NumOptions = 3;
      PreferenceList[0] = Mem->EncodePosition(FORWARD , MyPositionSide);
      PreferenceList[1] = Mem->EncodePosition(FORWARD , CENTER        );
      PreferenceList[2] = Mem->EncodePosition(FORWARD ,-MyPositionSide);
      /* preceding line assumes LEFT = -RIGHT */
    }
    break;
  case DEFENDER:    
  case SWEEPER:
  case GOALTENDER:
    if ( MyPositionSide == CENTER ){
      NumOptions = 7;
      PreferenceList[0] = Mem->EncodePosition(DEFENDER  ,RIGHT );
      PreferenceList[1] = Mem->EncodePosition(DEFENDER  ,LEFT  );
      PreferenceList[2] = Mem->EncodePosition(MIDFIELDER,RIGHT );
      PreferenceList[3] = Mem->EncodePosition(MIDFIELDER,LEFT  );
      PreferenceList[4] = Mem->EncodePosition(MIDFIELDER,CENTER);
      PreferenceList[5] = Mem->EncodePosition(FORWARD   ,RIGHT );
      PreferenceList[6] = Mem->EncodePosition(FORWARD   ,LEFT  );
    }
    else{
      NumOptions = 3;
      PreferenceList[0] = Mem->EncodePosition(MIDFIELDER,MyPositionSide);
      PreferenceList[1] = Mem->EncodePosition(FORWARD   ,MyPositionSide);
      PreferenceList[2] = Mem->EncodePosition(MIDFIELDER,CENTER); 
    }
    break;
  }				      
  /* built pref lists */
#else
  /* build pref lists */
  switch (MyPositionType){
  case FORWARD: 
    if ( MyPositionSide == CENTER );  /* Never Pass */
    else{
      NumOptions = (int_random(3) ? 1 : 0); /* shoot 1 in 3 times */
      PreferenceList[0] = Mem->EncodePosition(FORWARD,CENTER);
    }
    break;
  case MIDFIELDER:
    if ( MyPositionSide == CENTER ){
      NumOptions = 5;
      PreferenceList[0] = Mem->EncodePosition(FORWARD   , MyLocationSide );
      PreferenceList[1] = Mem->EncodePosition(FORWARD   ,-MyLocationSide );
      PreferenceList[2] = Mem->EncodePosition(FORWARD   , CENTER);
      PreferenceList[3] = Mem->EncodePosition(MIDFIELDER, MyLocationSide );
      PreferenceList[4] = Mem->EncodePosition(MIDFIELDER,-MyLocationSide );
    }
    else{
      NumOptions = 4;
      PreferenceList[0] = Mem->EncodePosition(FORWARD   , CENTER        );
      PreferenceList[1] = Mem->EncodePosition(MIDFIELDER, CENTER );
      PreferenceList[2] = Mem->EncodePosition(FORWARD   , MyPositionSide);
      PreferenceList[3] = Mem->EncodePosition(FORWARD   ,-MyPositionSide);
      /* preceding line assumes LEFT = -RIGHT */
    }
    break;
  case DEFENDER:    
    if ( MyPositionSide == CENTER ){
      NumOptions = 3;
      PreferenceList[0] = Mem->EncodePosition(MIDFIELDER, MyLocationSide);
      PreferenceList[1] = Mem->EncodePosition(MIDFIELDER,-MyLocationSide);
      PreferenceList[2] = Mem->EncodePosition(MIDFIELDER, CENTER); 
    }
    else{
      NumOptions = 3;
      PreferenceList[0] = Mem->EncodePosition(MIDFIELDER,MyPositionSide);
      PreferenceList[1] = Mem->EncodePosition(FORWARD   ,MyPositionSide);
      PreferenceList[2] = Mem->EncodePosition(MIDFIELDER,CENTER); 
    }
    break;
  case SWEEPER:
  case GOALTENDER:
    if ( MyPositionSide == CENTER ){
      NumOptions = 7;
      PreferenceList[0] = Mem->EncodePosition(DEFENDER  , MyLocationSide );
      PreferenceList[1] = Mem->EncodePosition(DEFENDER  ,-MyLocationSide );
      PreferenceList[2] = Mem->EncodePosition(MIDFIELDER, MyLocationSide );
      PreferenceList[3] = Mem->EncodePosition(MIDFIELDER,-MyLocationSide );
      PreferenceList[4] = Mem->EncodePosition(MIDFIELDER, CENTER);
      PreferenceList[5] = Mem->EncodePosition(FORWARD   , MyLocationSide );
      PreferenceList[6] = Mem->EncodePosition(FORWARD   ,-MyLocationSide );
    }
    break;
  }				      
  /* built pref lists */
#endif

  return NumOptions;
}
#endif
/*****************************************************************************/

#if 0
/* This function just prioritizes the players that are considered 
   as receivers and then takes the favorite receiver  */
int WorkTheWings(char *KnockOrPass, int *BallTo){

#if 0
  /* Base pass on my position */
  int MyPositionType = Mem->GetMyPositionType();
  int MyPositionSide = Mem->GetMyPositionSide();
#else
  /* Base pass on my location */
  int MyPositionType = Mem->GetPositionTypeOfMyLocation();
  int MyPositionSide = Mem->GetPositionSideOfMyLocation();
#endif

  int PreferenceList[TEAM_SIZE];
  int NumOptions = BuildPreferenceList(MyPositionType,MyPositionSide,PreferenceList);

  int FoundReceiver = FALSE;
  for(int i=0; !FoundReceiver && i<NumOptions; i++){
    if ( Mem->PositionOccupied(PreferenceList[i]) && 
	 Mem->GetPositionHolder(PreferenceList[i]) != Mem->MyNumber ){
      *BallTo = PreferenceList[i];
      FoundReceiver = TRUE;
    }
  }

  if (FoundReceiver)
    *KnockOrPass = 'p';            /* *BallTo already set */
  else {  /* No positions occupied, so shoot */
    if ( Mem->MarkerValid(THEIR_GOAL) && Mem->GetMarkerDistance(THEIR_GOAL) < SHOOT_DIST )
      *KnockOrPass = 'k';
    else 
      *KnockOrPass = 'd';
    *BallTo = THEIR_GOAL;
    if ( MyPositionType <= DEFENDER && MyPositionSide == CENTER )
      *BallTo = RF_FLAG;   /* center backs shouldn't clear it up the middle */
  }

  return WHATEVER;
}
#endif
/*****************************************************************************/
