/* geometry.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _ROBO_GEOMETRY_
#define _ROBO_GEOMETRY_


typedef struct LINE_SEG_STRUCT {
  float startx, starty;
  float endx, endy;
} LINE_SEG, *LINE_SEGP;

typedef struct LINE_STRUCT {
  float slope;
  float y_intcpt;
} LINE, *LINEP;

typedef struct POSN_STRUCT {
  float x;
  float y;
} POSN, *POSNP;


float mod2pi(float angle);
float AngleFromSlope(float slope, float dir);
float ComputeAngleDeg(POSNP point1, POSNP vertex, POSNP point3);
LINEP LnFrom2Pts (float x1, float y1, float x2, float y2);
LINEP LnFromSlopeAndPoint (float slope, float x, float y);
POSNP OffsetAlongLine(POSNP pt, float ln_slope, float dist, float dir);
POSNP OffsetTowards(POSNP origin, POSNP towards, float dist);
POSNP OffsetAlongLineTowards(POSNP origin, float ln_slope, POSNP towards, float dist);
float PtDistance (POSNP a, POSNP b);
float PtDistanceSqr (POSNP a, POSNP b);
//float ComputeHeadingOffset(float head, float targ);
//float ComputeAngle(float h1, float h2);

void LnDistance (POSNP point, POSNP pointOnLine, LINE *line, float *DistanceToLine, float  *DistanceAlongLine);
int LnDistanceIfBetween (POSNP point, POSNP pointOnLine, POSNP boundaryPoint, LINE *line, float *DistanceToLine, float *DistanceAlongLine);
void Projection(POSNP point, LINEP line, POSNP intrsct);
void Reflection(POSNP point, LINEP line, POSNP reflct);
void GetPerpLine(POSNP point, LINEP line, LINEP perp);
void Intersection (LINEP line1, LINEP line2, POSNP intrsct);

#endif
