/* communications.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _COMMUNICATIONS_
#define _COMMUNICATIONS_

#define MIN_COMMUNICATE_DELAY   0   /* If this is 0, communicate immediately by default */
#define MAX_COMMUNICATE_DELAY   10  /* Time after which I'll respond before acting more */
#define COMMUNICATE_INTERVAL    2   /* time steps need to wait before hearing again     */
#define MAX_COMMUNICATE_DIST    50  /* Can't hear players who are farther than that     */

/* char to replace ',' in communications -- shouldn't be used otherwise */
#define COMMA_STANDIN '+'

int Say (char*);
#define SAY(a) if(Say(a)==-1) {my_error("bla");}

int SayTo (int, char*);
#define SAYTO(a,b) if(SayTo(a,b)==-1) {my_error("bla");}
#define SAYTOCOACH(a) if(SayTo(0,a)==-1) {my_error("bla");}

int SayToPosition (int position, char *msg);
#define SAYTOPOSITION(a,b) if(SayToPosition(a,b)==-1) {my_error("bla");}

int SayToUnit (int, char*);
#define SAYTOUNIT(a,b) if(SayToUnit(a,b)==-1) {my_error("bla");}

int EchoTheirSound();
#define ECHOTHEIRSOUND if(EchoTheirSound()==-1) {my_error("bla");}

int AnnounceMyPosition();
#define ANNOUNCEMYPOSITION AnnounceMyPosition()

int AnnounceLeavingPosition(int position);
#define ANNOUNCELEAVINGPOSITION(a) AnnounceLeavingPosition(a)

int AnnounceBallCoordinates();
#define ANNOUNCEBALLCOORDINATES AnnounceBallCoordinates()

int AnnouncePlayerCoordinates(char side, int player);
#define ANNOUNCEPLAYERCOORDINATES(a,b) AnnouncePlayerCoordinates(a,b)
#define ANNOUNCETEAMMATECOORDINATES(a) AnnouncePlayerCoordinates(Mem->MySide,a)
#define ANNOUNCEOPPONENTCOORDINATES(a) AnnouncePlayerCoordinates(Mem->TheirSide,a)

int PingPlayer(char side, int player);
#define PINGPLAYER(a,b) PingPlayer(a,b)
#define PINGTEAMMATE(a) PingPlayer(Mem->MySide,a)
#define PINGOPPONENT(a) PingPlayer(Mem->TheirSide,a)

int AssignMark(int unit, int player, int mark);
#define ASSIGNMARK(a,b,c) AssignMark(a,b,c)

int AssignPosition(int unit, int player, int position);
#define ASSIGNPOSITION(a,b,c) AssignPosition(a,b,c)

int SayPassDataTo(int player);
#define SAYPASSDATATO(a) SayPassDataTo(a)

/* For communicating with the coach */
/* Start with Capital letters so not to confuse with referee messages */
#define NEW_COACH_MSG      "Hello"
#define RESET_MSG          "Reset"
#define MISS_MSG           "Miss"
#define SAVE_MSG           "Save"
#define GOAL_MSG           "Goal"
#define PASS_SUCCESS_MSG   "Success"
#define PASS_FAILURE_MSG   "Failure"
#define PASS_MISS_MSG      "Pmiss"
#define KICKED_MSG         "Kicked"
#define WAKEUP_MSG         "Wake up"
#define TEST_KICK_MSG      "Test Kick %f %f %f"
#define TEST_KICK_MSG_LEN  9
#define TEST_COLLECT_MSG   "Test Collect %f %f %f %f %f %f %f %f %f %f"
#define TEST_COLLECT_MSG_LEN 12
#define PLAYER_POS_MSG     "Players"
#define PLAYER_POS_MSG_LEN 7
#define PLAYER_POS_ELM_LEN 17

/* For communicating with teammates */
#define TO_DELIMITER             "---->" /*No white space*/
#define TO_DELIMITER_LEN         5
#define TO_UNIT_DELIMITER        "->unit->" /*No white space*/
#define TO_UNIT_DELIMITER_LEN    8
#define TO_POS_DELIMITER         "->pos->" /*No white space*/
#define TO_POS_DELIMITER_LEN     7
#define READY_TO_PASS_MSG        "ready to pass"
#define READY_FOR_SETPLAY_MSG    "whos in position"
#define PASSING_DECISION         "passing to %d"  /* the receiver must come last */
#define PASSING_DECISION_LEN     10
#define INFORM_POSITION_MSG      "at position %d" /* the vars must come last */
#define INFORM_POSITION_MSG_LEN  11
#define BALL_COORDINATES_MSG     "ball is at %f %f" /* the coords must come last */
#define SAY_BALL_COORDINATES_MSG "ball is at %.1f %.1f"
#define BALL_COORDINATES_MSG_LEN 10
#define PLAYER_COORDS_MSG        "player %c %d is at %f %f"
#define SAY_PLAYER_COORDS_MSG    "player %c %d is at %.1f %.1f"
#define PLAYER_COORDS_MSG_LEN    6
#define READY_TO_RECEIVE_MSG     "ready to receive"
#define OK_READY_TO_RECEIVE_MSG  "got it--youre open"
#define BYE_MSG                  "bye"
#define BLANK_MSG                "blank"
#define PING_MSG                 "where are you"
#define PING_BALL_MSG            "cant find the ball"
#define PING_PLAYER_MSG          "cant find the player %c %d"
#define PING_PLAYER_MSG_LEN      20
#define HELLO_MSG                "here"
#define GIVE_DATA_MSG            "gimme your data"
#define JOLT_MSG                 "jolt"
#define MY_BALL_MSG              "Going to the ball"
#define MARK_ASSIGN_MSG          "mark player %d (to %d)"
#define MARK_ASSIGN_MSG_LEN      11
#define POSITION_ASSIGN_MSG      "play position %d (to %d)"
#define POSITION_ASSIGN_MSG_LEN  13
#define LEAVING_POSITION_MSG     "vacating %d"
#define LEAVING_POSITION_MSG_LEN 8
#define ALREADY_THERE_MSG        "position taken"
#define SETPLAY_STARTER_MSG      "im the starter"
#define NOT_SETPLAY_STARTER_MSG  "im not the starter"
#define ARE_YOU_STARTER_MSG      "are you the starter?"

/* In data storage */
#define BLANK_DAT             "nodat"
#define DATA_MSG              "data %s"
#define DATA_MSG_LEN          4

/* For keeping track of player status */
#define BLANK_STAT     "nothing"
#define OPEN_STAT      "open"
#define WITH_BALL_STAT "with ball"
#define RECEIVER_STAT  "receiver"
#define ANNOUNCED_OPEN_STAT "I said I was open"
#define SETPLAY_STARTER_STAT "setplay starter"

extern int Communicate(int);
extern void HearReferee(char*, int);
extern void HearCoach  (char*, int);
extern void HearTeammate(int from, float ang, char *msg, int time);
extern void HearTeammate(int from, int key, float ang, int formation, int formtime, int pos, 
			 float x, float y, char *msg, int time);
extern void HearOpponent(float ang, char *msg, int time, int save);


#endif



