/* communications.c
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#include "global.h"

#define SOUND_OFF 0

#define TIME_ADDITION 37  /* Must be positive */

int GetKey(int from, int formation, int formtime, int pos, float x, float y){
  /* Can put in a time component */
  int key = from * (Mem->CurrentTime + TIME_ADDITION) ;
  /*printf("%d's key: %d\n",from,key);*/
  return key;
}

/*****************************************************************************/

int KeyValid(int key,int from, int formation, int formtime, int pos, 
	     float x, float y, int time){
  int sentTime = key/from - TIME_ADDITION;
  /*printf("%d got %d's key: %d at %d (now %d) \n",Mem->MyNumber,from,key,sentTime,time);*/
  if ( abs(sentTime - time) < 60 )  /* Was 10 for communication paper */
    return TRUE;
  else
    return FALSE;
}

/*****************************************************************************/

int Say (char *msg){
  char buf[MAXMESG];

#if SOUND_OFF
  return 0;
#endif

#if PRACTICE
  return 0;
#endif

  /* Should have team, number, formation, formation time, position, x, y, msg     */
  /* Change here must also happen in sayto, saytounit, saytoposition, communicate,*/
  /* and in parse.c (including call to HearTeammate below)                        */

  int from = Mem->MyNumber;

  int formation,formtime,position;
  if ( Mem->GetCurrentFormation() == UNKNOWN_FORMATION ){
    formation = UNKNOWN_FORMATION;
    formtime = position = 0;
  }
  else{
    formation = Mem->GetCurrentFormationType();
    formtime  = Mem->FormationTime;
    position = Mem->GetMyPosition();
  }

  float x = Mem->GetGlobalX();
  float y = Mem->GetGlobalY();

  int key = GetKey(from,formation,formtime,position,x,y);

  sprintf(buf,"(say %s %d %d %d %d %d %.1f %.1f %s)\n", Mem->MyTeamName, from, key,
	  formation, formtime, position, x, y, msg);

  if(send_message(buf, GLOBAL_sock) == -1){
    return -1;
  }
  return 0;
}
/*#define SAY(a) if(Say(a)==-1) return -1*/

/*****************************************************************************/

int SayTo (int num, char *msg){
  char buf[MAXMESG];

#if SOUND_OFF
  return 0;
#endif

#if PRACTICE
  return 0;
#endif

  if ( !num || num>TEAM_SIZE )
    my_error("Can't SayTo a player that doesn't exist");

  if ( num == Mem->MyNumber )
    my_error("Why talking to myself?");

  int from = Mem->MyNumber;

  int formation,formtime,position;
  if ( Mem->GetCurrentFormation() == UNKNOWN_FORMATION ){
    formation = UNKNOWN_FORMATION;
    formtime = position = 0;
  }
  else{
    formation = Mem->GetCurrentFormationType();
    formtime  = Mem->FormationTime;
    position = Mem->GetMyPosition();
  }

  float x = Mem->GetGlobalX();
  float y = Mem->GetGlobalY();

  int key = GetKey(from,formation,formtime,position,x,y);

  sprintf(buf,"(say %s %d %d %d %d %d %.1f %.1f %s %d %s)\n", Mem->MyTeamName, from, key,
	  formation, formtime, position, x, y, TO_DELIMITER, num, msg);

  if(send_message(buf, GLOBAL_sock) == -1){
    return -1;
  }
  return 0;
}
/*#define SAYTO(a,b) if(SayTo(a,b)==-1) return -1
#define SAYTOCOACH(a) if(SayTo(0,b)==-1) return -1
*/

/*****************************************************************************/

int SayToPosition (int position, char *msg){
  char buf[MAXMESG];

#if SOUND_OFF
  return 0;
#endif

#if PRACTICE
  return 0;
#endif

  if ( position > TEAM_SIZE )
    my_error("How many positions are there?");

  int from = Mem->MyNumber;

  int formation,formtime,myposition;
  if ( Mem->GetCurrentFormation() == UNKNOWN_FORMATION ){
    formation = UNKNOWN_FORMATION;
    formtime = myposition = 0;
  }
  else{
    formation = Mem->GetCurrentFormationType();
    formtime  = Mem->FormationTime;
    myposition = Mem->GetMyPosition();
  }

  float x = Mem->GetGlobalX();
  float y = Mem->GetGlobalY();

  int key = GetKey(from,formation,formtime,myposition,x,y);

  sprintf(buf,"(say %s %d %d %d %d %d %.1f %.1f %s %d %s)\n", Mem->MyTeamName, from, key,
	  formation, formtime, myposition, x, y, TO_POS_DELIMITER, position, msg);

  if(send_message(buf, GLOBAL_sock) == -1){
    return -1;
  }
  return 0;
}
/*#define SAYTOPOSITION(a,b) if(SayToPosition(a,b)==-1) return -1*/

/*****************************************************************************/

int SayToUnit (int unit, char *msg){
  char buf[MAXMESG];

#if SOUND_OFF
  return 0;
#endif

#if PRACTICE
  return 0;
#endif

  if ( !Mem->IsMyUnit(unit) )
    my_error("Can't SayToUnit unless I'm in the unit");

  int from = Mem->MyNumber;

  int formation,formtime,position;
  if ( Mem->GetCurrentFormation() == UNKNOWN_FORMATION ){
    formation = UNKNOWN_FORMATION;
    formtime = position = 0;
  }
  else{
    formation = Mem->GetCurrentFormationType();
    formtime  = Mem->FormationTime;
    position = Mem->GetMyPosition();
  }

  float x = Mem->GetGlobalX();
  float y = Mem->GetGlobalY();

  int key = GetKey(from,formation,formtime,position,x,y);

  sprintf(buf,"(say %s %d %d %d %d %d %.1f %.1f %s %d %s)\n", Mem->MyTeamName, from, key,
	  formation, formtime, position, x, y, TO_UNIT_DELIMITER, unit, msg);

  if(send_message(buf, GLOBAL_sock) == -1){
    return -1;
  }
  return 0;
}
/*#define SAYTOUNIT(a,b) if(SayToUnit(a,b)==-1) return -1*/

/*****************************************************************************/

int EchoTheirSound(){
  char buf[MAXMESG];

  char *msg = Mem->GetTheirOldestSound();
  if ( msg != NULL ){
    sprintf(buf,"(say %s",msg);
    if(send_message(buf, GLOBAL_sock) == -1)
      return -1;
    /* printf("%d:%d echoing message %s\n",Mem->MyNumber,Mem->CurrentTime,msg); */
  }
  return 0;
}
/*#define ECHOTHEIRSOUND EchoTheirSound()*/

/*****************************************************************************/

int AnnounceMyPosition(){
/*
  char Announcement[MAXMESG];
  sprintf(Announcement,INFORM_POSITION_MSG,Mem->GetMyPosition());
  SAY(Announcement);         
*/
/*  if (Mem->GetMyActiveStatus() == ACTIVE)
    printf("%d:%d Well then I can't assume the player's inactive when saying 'here'\n",
	   Mem->MyNumber,Mem->CurrentTime); */
  SAY(HELLO_MSG);
  return 0;
}
/*#define ANNOUNCEMYPOSITION AnnounceMyPosition()*/

/*****************************************************************************/

int AnnounceLeavingPosition(int position){
  char Announcement[MAXMESG];
  sprintf(Announcement,LEAVING_POSITION_MSG,position);
  SAY(Announcement);         
}
/*#define ANNOUNCELEAVINGPOSITION(a) AnnounceLeavingPosition(a)*/

/*****************************************************************************/

int AnnounceBallCoordinates(){
  char Announcement[MAXMESG];
  float x,y;
  Mem->polar_to_globalxy(Mem->GetBallDistance(),Mem->GetBallAngleRad(),&x,&y);
  sprintf(Announcement,SAY_BALL_COORDINATES_MSG,x,y); 
  SAY(Announcement);         
  return 0;
}
/*#define ANNOUNCEBALLCOORDINATES AnnounceBallCoordinates()*/

/*****************************************************************************/

int AnnouncePlayerCoordinates(char side, int player){
  char Announcement[MAXMESG];
  float x,y;
  Mem->polar_to_globalxy(Mem->GetPlayerDistance(side,player),
			 Mem->GetPlayerAngleRad(side,player),&x,&y);
  sprintf(Announcement,SAY_PLAYER_COORDS_MSG,side,player,x,y); 
  SAY(Announcement);         
  return 0;
}
/*
#define ANNOUNCEPLAYERCOORDINATES(a,b) AnnouncePlayerCoordinates(a,b)
#define ANNOUNCETEAMMATECOORDINATES(a) AnnouncePlayerCoordinates(Mem->MySide,a)
#define ANNOUNCEOPPONENTCOORDINATES(a) AnnouncePlayerCoordinates(Mem->TheirSide,a)
*/

/*****************************************************************************/

int PingPlayer(char side, int player){
  char Announcement[MAXMESG];
  sprintf(Announcement,PING_PLAYER_MSG,side,player); 
  SAY(Announcement);         
  return 0;
}
#define PINGPLAYER(a,b) PingPlayer(a,b)
#define PINGTEAMMATE(a) PingPlayer(Mem->MySide,a)
#define PINGOPPONENT(a) PingPlayer(Mem->TheirSide,a)

/*****************************************************************************/

int AssignMark(int unit, int player, int mark){
  if ( !Mem->IsUnitMember(unit,player) || 
       !Mem->IsUnitCaptain(unit,Mem->MyNumber) )
    my_error("Only captains can assign their unit-members marks");

  char Announcement[MAXMESG];
  sprintf(Announcement,MARK_ASSIGN_MSG,mark,player); 
  SAYTOUNIT(unit, Announcement);         
  return 0;
}
/*#define ASSIGNMARK(a,b,c) AssignMark(a,b,c)*/

/*****************************************************************************/

int AssignPosition(int unit, int player, int position){
  if ( !Mem->IsUnitMember(unit,player) || 
       !Mem->IsUnitCaptain(unit,Mem->MyNumber) )
    my_error("Only captains can assign their unit-members positions");

  char Announcement[MAXMESG];
  sprintf(Announcement,POSITION_ASSIGN_MSG,position,player); 
  SAYTOUNIT(unit, Announcement);         
  return 0;
}
/*#define ASSIGNPOSITION(a,b,c) AssignPosition(a,b,c)*/

/*****************************************************************************/

int SayPassDataTo(int player){
    char outStream[MAXMESG];
    char dataStream[MAXMESG];
    GetPassData(outStream, player, 'd');/* Get the data stream              */
    StrReplace(outStream,',',COMMA_STANDIN);
    sprintf(dataStream,DATA_MSG,outStream);/* Put on the DATA_MSG tag       */
    SAYTO(player,dataStream);
}
/*#define SAYPASSDATATO(a) SayPassDataTo(a)*/

/*****************************************************************************/

void HearCoach(char *msg, int time){

  if ( msg[0] <= 'z' && msg[0] >= 'a' ) 
    my_error("Coach messages should be capitalized");

  if ( !strncmp(msg,RESET_MSG,5) ){ /* A reset message              */
    Mem->Reset();
  }
  else if ( !strncmp(msg,NEW_COACH_MSG,5) ){
    Mem->NewCoach = TRUE;
  }
  else if ( !strncmp(msg,SAVE_MSG,4) ){
    RecordCollectResult(COLLECT_SAVE);
/*    Mem->Reset();*/
    Mem->RecordCollectData = TRUE;
  }
  else if ( !strncmp(msg,MISS_MSG,4) ){
    RecordCollectResult(COLLECT_MISS);
/*    Mem->Reset();*/
    Mem->RecordCollectData = TRUE;
  }
  else if ( !strncmp(msg,GOAL_MSG,4) ){
    RecordCollectResult(COLLECT_GOAL);
/*    Mem->Reset();*/
    Mem->RecordCollectData = TRUE;
  }
  else if ( !strncmp(msg,PASS_SUCCESS_MSG,4) ){
    RecordPassResult(PASS_SUCCESS);
  }
  else if ( !strncmp(msg,PASS_FAILURE_MSG,4) ){
    RecordPassResult(PASS_FAILURE);
  }
  else if ( !strncmp(msg,PASS_MISS_MSG,4) ){
    RecordPassResult(PASS_MISS);
  }
  else if ( !strncmp(msg,TEST_KICK_MSG,TEST_KICK_MSG_LEN) ){
    float param1, param2, param3;
    sscanf(msg,TEST_KICK_MSG,&param1,&param2,&param3);
    
    TESTKICKPARAMETERS(param1,param2,param3);
  }
  else if ( !strncmp(msg,TEST_COLLECT_MSG,TEST_COLLECT_MSG_LEN) ){
    float param1, param2, param3, param4, param5, param6, param7, param8, param9, param10;
    sscanf(msg,TEST_COLLECT_MSG,&param1,&param2,&param3,&param4,
	   &param5,&param6,&param7,&param8,&param9,&param10);
    Mem->RecordCollectData = FALSE;
      
    if ( Mem->OriginalBehavior == JUSTIN_COLLECT ){
      while( !Mem->RecordCollectData ){
	Mem->NewSight = FALSE;    /* Undo the sight bit */
	Mem->ClearAction();
	TESTCOLLECTPARAMETERS(param1,param2,param3,param4, param5, 
			      param6, param7, param8, param9);
	if ( !Mem->NewSight )
	  WAITFORSIGHT;
      }
    }
    else if ( Mem->OriginalBehavior == SHOOT ){
      while( !Mem->RecordCollectData ){
	Mem->NewSight = FALSE;    /* Undo the sight bit */
	Mem->ClearAction();
	SHOOTATANGLE(100,param10);
	if ( !Mem->NewSight )
	  WAITFORSIGHT;
      }
    }
  }
  else if ( !strncmp(msg,PLAYER_POS_MSG,PLAYER_POS_MSG_LEN) ){
    /* Only matters when you're near the ball */
    /* else scanf too expensive */
    if (Mem->GetBallDistance()>KICK_DISTANCE+5) return;
/*
    static int last_time = -50;
    if (Mem->CurrentTime < last_time + 50) return;
    last_time = Mem->CurrentTime;
*/        
    char side;
    int unum;
    float x,y;
    int index=PLAYER_POS_MSG_LEN;

    for (int i=0; i<TEAM_SIZE*2; i++){
      sscanf(&msg[index]," %c %d %f %f",&side,&unum,&x,&y);
      index+=PLAYER_POS_ELM_LEN;
      if (Mem->MySide == 'l') y*=-1; else x*=-1; /* coach uses different coords */
      if (side != Mem->MySide || unum != Mem->MyNumber)
	Mem->HearPlayerGlobalPosition(side,unum,x,y,time);
    }
    //printf("%d\n",Mem->CurrentTime);
  }
}

/*****************************************************************************/

void HearTeammate(int from, float ang, char *msg, int time)
{
  char side = Mem->MySide;

  /* Assume you're not hearing your own message (filtered in parse.c) */

  char tmp[MAX(MAX(TO_DELIMITER_LEN,TO_UNIT_DELIMITER_LEN),TO_POS_DELIMITER_LEN)];
  int  to, toMe=FALSE, toMyUnit=FALSE;

  Mem->HearPlayer(side, from, ang, msg, time); /* Could go at end, but then     */
                                               /* would miss if to someone else */

  if ( !strncmp(msg,TO_UNIT_DELIMITER,TO_UNIT_DELIMITER_LEN) ){
    sscanf(msg,"%s %d %[^)]",tmp,&to,msg); /* If the message is to a specific
					      unit, trim the message and
					      ignore unless it's for me.  */
    if ( !Mem->IsMyUnit(to) ) 
      return;
    toMyUnit = TRUE;
  }

  if ( !strncmp(msg,TO_POS_DELIMITER,TO_POS_DELIMITER_LEN) ){
    sscanf(msg,"%s %d %[^)]",tmp,&to,msg); /* If the message is to a specific
					      position, trim the message and
					      ignore unless it's for me.  */
    if ( to != Mem->GetMyPosition() ) 
      return;
    toMe = TRUE;
  }

  if ( !strncmp(msg,TO_DELIMITER,TO_DELIMITER_LEN) ){
    sscanf(msg,"%s %d %[^)]",tmp,&to,msg); /* If the message is to a specific
					      teammate, trim the message and
					      ignore unless it's for me.  */
    if (to != Mem->MyNumber ) 
      return;
    toMe = TRUE;
  }

  int needsResponse    = FALSE;
  int staggerResponses = FALSE;
  int delayResponse    = FALSE;

  /* For speed, should order these from most to least likely */
  if ( !strcmp(msg, HELLO_MSG) ){
    Mem->SetInactive(from);
  }
  if ( !strcmp(msg, PING_MSG) ){
    if ( Mem->GetMyActiveStatus() != ACTIVE ){
      needsResponse = TRUE;
      if ( !toMe )
	staggerResponses = TRUE;
    }
  }
  if ( !strcmp(msg, ALREADY_THERE_MSG) ){
    if ( Mem->GetPlayerPosition(from) == Mem->GetMyPosition() ){
      Mem->SetMyPosition(GetNewPosition());  
      if ( Mem->GetMyActiveStatus() != ACTIVE ){
	needsResponse = TRUE;
	delayResponse = TRUE;
      }
    }
  }
  if ( !strcmp(msg, MY_BALL_MSG) ){
    Mem->SetActive(from);
    if ( Mem->GetMyActiveStatus() != ACTIVE ){
      needsResponse = TRUE;
      staggerResponses = TRUE;
    }
  }
  else if ( !strncmp (msg, INFORM_POSITION_MSG, INFORM_POSITION_MSG_LEN) ){
    /* To say you're leaving a position, just make position UNKNOWN_POSITION */
    /*
    int position;
    float x,y;
    sscanf(msg,INFORM_POSITION_MSG,&position,&x,&y);
    Mem->SetPlayerPosition(from, position);
    Mem->HearTeammateGlobalPosition(from, x, y, time);
    */
    my_error("Shouldn't be using INFORM_POSITION_MSG anymore");
  }
  else if ( !strncmp (msg, LEAVING_POSITION_MSG, LEAVING_POSITION_MSG_LEN) ){
    if ( Mem->GetMyActiveStatus() == INACTIVE ){
      int position;
      int my_position = Mem->GetMyPosition();
      sscanf(msg,LEAVING_POSITION_MSG,&position);
      
      /*if (!position)
	printf("%d:%d Heard goalie leaving position\n",Mem->MyNumber,Mem->CurrentTime);*/

      if ( Mem->GetPlayerPosition(from) != UNKNOWN_POSITION )
	my_error("should have already cleared this position");
      if ( Mem->GetPositionPlayer(position) == from ){
	my_error("should have already cleared this player");
      }
      
      if ( position != my_position )
	position = ConsiderPosition(position);
      if ( position != UNKNOWN_POSITION && position != my_position ){ 
	/* If I'm going to take the freed position */
	Mem->SetMyPosition(position);      
	needsResponse = TRUE;
	staggerResponses = TRUE;
      }
    }
  }
  else if ( !strncmp (msg, BALL_COORDINATES_MSG, BALL_COORDINATES_MSG_LEN) ){
    float x,y;
    sscanf(msg,BALL_COORDINATES_MSG,&x,&y);
    Mem->HearBallGlobalPosition(x,y,time);
  }
  else if ( !strncmp (msg, PLAYER_COORDS_MSG, PLAYER_COORDS_MSG_LEN) ){
    char side; int player;
    float x,y;
    sscanf(msg,PLAYER_COORDS_MSG,&side,&player,&x,&y);
    Mem->HearPlayerGlobalPosition(side,player,x,y,time);
  }
  else if ( !strcmp (msg, READY_TO_RECEIVE_MSG) ){
    Mem->SetStatus(Mem->MySide,from, OPEN_STAT);
    if ( Mem->MyPositionInSetPlay() &&
	 Mem->GetMySetPlayPositionType() == SETPLAY_STARTER )
      needsResponse = TRUE;
  }
  else if ( !strcmp (msg, OK_READY_TO_RECEIVE_MSG) ){
    Mem->SetMyStatus(OPEN_STAT);
  }
  else if ( !strcmp (msg, READY_FOR_SETPLAY_MSG) ){
    needsResponse = TRUE;
    staggerResponses = TRUE;
  }
  else if ( !strcmp (msg, SETPLAY_STARTER_MSG) ){
    if ( Mem->GetSetPlayStarterPosition() != Mem->GetPlayerPosition(from) ){
      /* printf("%d:%d gonna have to reinitialize (wrong starter1)\n",
	     Mem->MyNumber,Mem->CurrentTime);*/
      if ( Mem->SetPlay && Mem->PlayMode != MY_KICK_IN )
	printf("     not  kick-in, why confusion (1) ???? starter:%d, from:%d\n",
	       Mem->GetSetPlayStarterPosition(),Mem->GetPlayerPosition(from));
      Mem->SetPlay = FALSE; /* force reinitialization */
    }
    else
      Mem->SetStatus(Mem->MySide,from,SETPLAY_STARTER_STAT);
  }
  else if ( !strcmp (msg, NOT_SETPLAY_STARTER_MSG) ){
    if ( Mem->GetSetPlayStarterPosition() == Mem->GetPlayerPosition(from) ){
      /* printf("%d:%d gonna have to reinitialize (wrong starter1)\n",
	     Mem->MyNumber,Mem->CurrentTime);*/
      if ( Mem->SetPlay && Mem->PlayMode != MY_KICK_IN )
	printf("     not  kick-in, why confusion (2) ???? starter:%d, from:%d\n",
	       Mem->GetSetPlayStarterPosition(),Mem->GetPlayerPosition(from));
      Mem->SetPlay = FALSE; /* force reinitialization */
    }
  }
  else if ( !strcmp (msg, ARE_YOU_STARTER_MSG) ){
    needsResponse = TRUE;
    delayResponse = TRUE;
  }
  else if ( !strcmp (msg, READY_TO_PASS_MSG) ){
    Mem->ClearStatuses(RECEIVER_STAT);
    Mem->SetStatus(Mem->MySide,from, WITH_BALL_STAT);
    Mem->ClearStatus(Mem->MySide,0);
  }
  /*else if ( !strcmp (msg, BYE_MSG) ){
    ;
  }*/
  else if ( !strncmp (msg, PASSING_DECISION, PASSING_DECISION_LEN) ){
    int receiver;
    sscanf(msg,PASSING_DECISION,&receiver);
    /* Could be marking self */
    Mem->ClearStatus(Mem->MySide,Mem->FindTeammateWithStatus(RECEIVER_STAT));
    Mem->SetStatus(Mem->MySide,receiver, RECEIVER_STAT);
    if (receiver == Mem->MyNumber && Mem->GetMyActiveStatus() == INACTIVE){
      Mem->SetMyselfAtAttention();
    }
    Mem->ClearStatus(Mem->MySide,Mem->FindTeammateWithStatus(WITH_BALL_STAT));
    Mem->SetStatus(Mem->MySide,from, WITH_BALL_STAT);
  }
  else if ( !strncmp (msg, DATA_MSG, DATA_MSG_LEN) ){
    StrReplace(&msg[DATA_MSG_LEN],COMMA_STANDIN,',');
    Mem->SetData(from, &msg[DATA_MSG_LEN]); /* Fast forward past data_msg */
  }
  else if ( !strncmp (msg, MARK_ASSIGN_MSG, MARK_ASSIGN_MSG_LEN) ){
    int mark, player;
    sscanf(msg,MARK_ASSIGN_MSG,&mark,&player);
    /* If not for me, keep track of who's marking whom? */
    if ( player == Mem->MyNumber && Mem->IsUnitCaptain(to,from) ){
      Mem->SetMark(mark);  /* Announce player that's being left? */
      Mem->MarkChangeMethod = MARK_OBEY;
      switch( Mem->HomeChangeMethod ){
      case HOME_MARK:
      case HOME_MARK_ELSE_SHIFT: break;
      case HOME_SHIFT: Mem->HomeChangeMethod = HOME_MARK_ELSE_SHIFT; break;
      case HOME_OBEY:  Mem->HomeChangeMethod = HOME_MARK; break;
      default: my_error("What's the HomeChangeMethod?");
      }
    }
  }
  else if ( !strncmp (msg, POSITION_ASSIGN_MSG, POSITION_ASSIGN_MSG_LEN) ){
    int position, player;
    sscanf(msg,POSITION_ASSIGN_MSG,&position,&player);
    /* If not for me, keep track of who's assigned to a position? */
    if ( player == Mem->MyNumber && Mem->IsUnitCaptain(to,from) ){
      Mem->SetMyPosition(position);  /* Announce player that's being left? */
      if ( Mem->GetMyActiveStatus() != ACTIVE ){
	needsResponse = TRUE;
	delayResponse = TRUE;
      }
    }
  }
  else if ( !strcmp(msg,JOLT_MSG) ){
    needsResponse = TRUE;
  }
  else if ( !strcmp(msg,GIVE_DATA_MSG) ){
    if ( Mem->GetMyActiveStatus() != ACTIVE )
      needsResponse = TRUE;
  }
  else if ( !strcmp(msg,PING_BALL_MSG) ){ 
    if ( Mem->GetMyActiveStatus() != ACTIVE )
      needsResponse = TRUE;
    if ( Mem->PlayMode != PLAY_ON )
      /* Important that closest to ball knows where it is */
      staggerResponses = TRUE;
  }
  else if ( !strncmp(msg,PING_PLAYER_MSG,PING_PLAYER_MSG_LEN) ){  
    if ( Mem->GetMyActiveStatus() != ACTIVE )
      needsResponse = TRUE;
  }

  if ( Mem->GetPlayerPosition(from) == Mem->GetMyPosition() && 
       Mem->GetMyPosition() != UNKNOWN_POSITION ){
    int position = Mem->GetMyPosition();
    /*printf("%d:%d %d is in my position (%d) ...",
	   Mem->MyNumber,Mem->CurrentTime,from,position);*/
    float x,y;
    Mem->GetTeammateHeardGlobalXY(from,&x,&y);
    if ( Mem->PlayerDistanceToPositionHome(0,position) <
	 Mem->DistanceToPositionHome(position,x,y) ){
      SAYTO(from,ALREADY_THERE_MSG);
      if ( !delayResponse && !staggerResponses )
	delayResponse = TRUE; /* Wait for this message to get through */
      /*printf(" already there\n");*/
    }
    else{
      Mem->SetMyPosition(GetNewPosition());
      /*printf(" vacating\n");*/
    }
  }

  if ( Mem->HeardNewSound() )
    needsResponse = FALSE;  /* Don't override a bending response */

  if ( needsResponse ){
    Mem->NewSound(time, from, msg);/* Note that this is a new sound that's been heard:
				      for communications purposes */
    Mem->CommunicateDelay = MIN_COMMUNICATE_DELAY; /* The default */

    if (delayResponse)
      Mem->CommunicateDelay = COMMUNICATE_INTERVAL;
    else if (staggerResponses){
      if ( Mem->MyNumber > from )
	Mem->CommunicateDelay += (((Mem->MyNumber-from)-1)*2   )*COMMUNICATE_INTERVAL;
      else /* Mem->MyNumber < from */
	Mem->CommunicateDelay += (((from-Mem->MyNumber)-1)*2 +1)*COMMUNICATE_INTERVAL;
    }
  }
}

/*****************************************************************************/

void HearTeammate(int from, int key, float ang, int formation, int formtime, int pos, 
		  float x, float y, char *msg, int time)
{
#if PRACTICE
#else
  if ( !KeyValid(key,from,formation,formtime,pos,x,y,time) ){
    printf("%d:%d  This message from %d wasn't valid %s\n",Mem->MyNumber,time,from,msg);
    HearOpponent(ang,msg,time,FALSE); 
    return;
  }
#endif
  Mem->HearTeammateGlobalPosition(from, x, y, time);  
  Mem->HearTeammateFormationPosition(from, formation, formtime, pos);
  HearTeammate(from,ang,msg,time);
}

/*****************************************************************************/

void HearOpponent(float ang, char *msg, int time, int save)
{
  char side = Mem->TheirSide;

  /* store the angle of this player at least in some memory slot */
  /* check if the angle matches one where an opponent should be  */

  /* Save the msg into memory */
  if ( save && !int_random(10) )
    Mem->ReplaceTheirOldestSound(msg);
}

/*****************************************************************************/

int Communicate(int behavior){
  
  char *msg = Mem->GetNewSound();
  char team[50], tmp[TO_DELIMITER_LEN];
  int  from,to;

  from = Mem->GetNewSoundSpeaker();

  /* Following checks should already have been done, but just in case ...*/
  if ( from == Mem->MyNumber )         /* Ignore self                 */
    return 0;

  /* For speed, should order these from most to least likely */
  if ( !strcmp(msg,PING_MSG) ){  /* Give your angle position if a teammate needs it */
    SAY(HELLO_MSG);
  }
  else if ( !strcmp(msg,PING_BALL_MSG) ){  /* Give the ball position to a teammate */
    if ( Mem->PlayMode != PLAY_ON ){
      /* Only if sure and you see ball correctly                */
      if ( Mem->BallValid() == 1 && Mem->BallInSetPlayPosition() )
	ANNOUNCEBALLCOORDINATES; 
    }
    else if ( Mem->BallValid() == 1 && Mem->GetBallDistance() <= 30 ) /* play_on mode */
      /* Only if sure                                        */
      /* Only if you're one of the 2 closest to the ball ??? */
      ANNOUNCEBALLCOORDINATES; 
  }
  else if ( !strncmp(msg,PING_PLAYER_MSG,PING_PLAYER_MSG_LEN) ){  
    /* Give the player position to a teammate */
    char side; int player;
    sscanf(msg,PING_PLAYER_MSG,&side,&player);
    if ( Mem->PlayerValid(side,player) == 1 )
      /* Only if sure                                        */
      ANNOUNCEPLAYERCOORDINATES(side,player); 
  }
  else if ( !strcmp(msg,MY_BALL_MSG) ){
    if ( Mem->GetMyActiveStatus() != ACTIVE )
      if ( Mem->AmCandidateReceiverOfPlayer(from) )
	SAYPASSDATATO(from);
  }
  else if ( !strncmp (msg, LEAVING_POSITION_MSG, LEAVING_POSITION_MSG_LEN) ){
    ANNOUNCEMYPOSITION;
  }
  else if ( !strncmp (msg, POSITION_ASSIGN_MSG, POSITION_ASSIGN_MSG_LEN) ){
    ANNOUNCEMYPOSITION;
  }
  if ( !strcmp(msg, ALREADY_THERE_MSG) ){
    ANNOUNCEMYPOSITION;
  }
  else if ( !strcmp (msg, READY_FOR_SETPLAY_MSG) ){
    if ( Mem->GetMyActiveStatus() == INSETPLAY && Mem->InMySetPlayPosition() )
      SAY(READY_TO_RECEIVE_MSG);
  }
  else if ( !strcmp (msg, READY_TO_RECEIVE_MSG) ){
    SAYTO(from,OK_READY_TO_RECEIVE_MSG);
  }
  else if ( !strcmp (msg, ARE_YOU_STARTER_MSG) ){
    if ( Mem->SetPlay && Mem->MyPositionInSetPlay() ){
      if ( Mem->GetMySetPlayPositionType() == SETPLAY_STARTER ){
	SAY(SETPLAY_STARTER_MSG);
      }
      else{
	SAY(NOT_SETPLAY_STARTER_MSG);
      }
    }
  }
  else if ( !strcmp(msg,GIVE_DATA_MSG) ){  /* Give your data if a teammate needs it */
    SAYPASSDATATO(from);
  }
  else if ( !strcmp(msg,JOLT_MSG) ){       /* For the decision tree tests: client stuck*/
    TURN(5);     
  }
  return 0;
  /* Depending on behavior, check for different things?*/

}


