/* command.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _COMMAND_
#define _COMMAND_

#define MAXPOWER 100
#define MINPOWER -30
#define MAXMOMENT 180
#define MINMOMENT -180

int WaitUntilFreeToAct();
#define WAITUNTILFREETOACT WaitUntilFreeToAct() 

int WaitForSight();
#define WAITFORSIGHT WaitForSight() 

void PositionToKickoffPosition( float *x, float *y );

int PreGameMove( float x, float y );
#define PREGAMEMOVE(a,b) PreGameMove(a,b)

int Change_view(int, int);
#define CHANGE_VIEW(a,b) Change_view(a,b)
#define NARROW_VIEW      CHANGE_VIEW(NARROW_WIDTH,SAME_QUALITY)
#define NORMAL_VIEW      CHANGE_VIEW(NORMAL_WIDTH,SAME_QUALITY)
#define WIDE_VIEW        CHANGE_VIEW(WIDE_WIDTH,  SAME_QUALITY)
#define HIGH_QUAL_VIEW   CHANGE_VIEW(SAME_WIDTH,  HIGH_QUALITY)
#define LOW_QUAL_VIEW    CHANGE_VIEW(SAME_WIDTH,  LOW_QUALITY )
#define NARROW_HIGH_VIEW CHANGE_VIEW(NARROW_WIDTH,HIGH_QUALITY)
#define NORMAL_HIGH_VIEW CHANGE_VIEW(NORMAL_WIDTH,HIGH_QUALITY)
#define WIDE_HIGH_VIEW   CHANGE_VIEW(WIDE_WIDTH,  HIGH_QUALITY)
#define NARROW_LOW_VIEW  CHANGE_VIEW(NARROW_WIDTH,LOW_QUALITY )
#define NORMAL_LOW_VIEW  CHANGE_VIEW(NORMAL_WIDTH,LOW_QUALITY )
#define WIDE_LOW_VIEW    CHANGE_VIEW(WIDE_WIDTH,  LOW_QUALITY )

int Turn(float);
#define TURN(a) if(Turn(a)==-1)  my_error("bla")

int Kick( float, float );
#define KICK(a,b) if(Kick(a,b)==-1)  my_error("bla")

int Dash( float );
#define DASH(a) if(Dash(a)==-1)  my_error("bla")

int Look(char);
#define LOOK(a) if(Look(a)==-1) return -1

int Go(float, float, int, int);
/*
#define GO(a) if(Go(0,a,1,2)==-1) return -1
#define GO(a,b) if(Go(0,a,1,b)==-1) return -1
#define GO(a,b,c) if(Go(a,b,1,c)==-1) return -1
*/
#define GO(a,b,c,d) if(Go(a,b,c,d)==-1) return -1

int KickAndFace(float, float);
#define KICKANDFACE(a,b) if(KickAndFace(a,b)==-1) return -1

int TrapBall(int trapTimes);
#define TRAPBALL if(TrapBall(1)==-1) return -1
#define KEEPBALL if(TrapBall(ACT_MAX)==-1) return -1

extern int CircleBall(float, float);
#define CIRCLEBALL(a,b) CircleBall(a,b)

extern int DodgePlayer(float, float, float);
#define DODGEPLAYER(a,b,c) DodgePlayer(a,b,c)

extern int DodgeBall(float FirstAng, float DashPower);
#define DODGEBALL(a,b) DodgeBall(a,b)

#endif
