/* command.c
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#include "global.h"

/*****************************************************************************/
/************        PRIMATIVES       ****************************************/
/*****************************************************************************/

int WaitUntilFreeToAct(){
  message_poll_while_waiting(GLOBAL_sock);
  return 0;
}
/*#define WAITUNTILFREETOACT WaitUntilFreeToAct() */

/*****************************************************************************/

int WaitForSight(){
  message_poll_until_sight(GLOBAL_sock);
  return 0;
}
/*#define WAITFORSIGHT WaitForSight() */

/*****************************************************************************/

void PositionToKickoffPosition( float *x, float *y ){
  if (*x > 10 && fabs(*y)<9){ 
    *x = -1;                    /* Don't put the center forward behind the circle */
    *y = 10;
  }

  if ( fabs(*x) <= 10 && *y == 0){      
    if ( Mem->KickOffMode == THEIR_KICK_OFF ){
      *x = -10;
      *y - 0;
    }
    else{
      /* Put the center midfielder right at the ball */
      *x = -1;
      *y = -(KICK_DISTANCE - 1);
    }
  }
  else if (*x > -1) {
    if ( *y > 0 )                              /* Stagger the players     */
      *y += *x/5;
    else 
      *y -= *x/5;
    *x = -3;                                   /* Always start on my side */
  }

  if ( Mem->KickOffMode == THEIR_KICK_OFF ){ /* Stay out of the center circle */ 
    if ( sqrt(*x * *x + *y * *y) < FREE_KICK_BUFFER ) 
      *x = -10; 
  }

  if (*x > X0) *x = X0;
  if (*x < -X0) *x = -X0;
  if (*y > Y0) *y = Y0;
  if (*y < -Y0) *y = -Y0;
}

/*****************************************************************************/

int PreGameMove( float x, float y ){

  if ( Mem->PlayMode != BEFORE_KICK_OFF )
    return 0;

  PositionToKickoffPosition( &x, &y );

/*  if (Mem->MySide == 'l')/* A hack for now--server's global y is opposite from mine */
    y *= -1;               /* Would like to take this out !!!                         */

  char buf[MAXMESG];

  sprintf(buf,"(move %.1f %.1f)\n", x, y);

  if(send_message(buf, GLOBAL_sock) == -1)  /* Send the move     */
    return -1;    
  else 
    return 0;
}
/*#define PREGAMEMOVE(a,b) if(PreGameMove(a,b)==-1) return -1*/

/*****************************************************************************/

int Change_view(int width, int quality){

  int old_width   = Mem->view_width;
  int old_quality = Mem->view_quality;

  if ( (width == old_width || width == SAME_WIDTH) && 
       (quality == old_quality || quality == SAME_QUALITY) )
    return 0;                         /* no change           */
  
  char buf[MAXMESG];

  if ( width != SAME_WIDTH && width != old_width ){     
    Mem->view_width = width;                /* width changing      */
  }
  if ( quality != SAME_QUALITY && quality != old_quality ){        
    Mem->view_quality = quality;            /* quality changing    */
  }
  
  switch(Mem->view_width){ /* Now the new one */
  case NARROW_WIDTH: 
    if ( Mem->view_quality == HIGH_QUALITY ) /* Now the new one... */
      sprintf(buf,"(change_view narrow high)\n");
    else if ( Mem->view_quality == LOW_QUALITY )
      sprintf(buf,"(change_view narrow low)\n");
    else 
      my_error("(change_view narrow ?)");
    break;
  case NORMAL_WIDTH: 
    if ( Mem->view_quality == HIGH_QUALITY )
      sprintf(buf,"(change_view normal high)\n");
    else if ( Mem->view_quality == LOW_QUALITY )
      sprintf(buf,"(change_view normal low)\n");
    else 
      my_error("(change_view normal ?)");
    break;
  case WIDE_WIDTH: 
    if ( Mem->view_quality == HIGH_QUALITY )
      sprintf(buf,"(change_view wide high)\n");
    else if ( Mem->view_quality == LOW_QUALITY )
      sprintf(buf,"(change_view wide low)\n");
    else 
      my_error("(change_view wide ?)");
    break;
  default: my_error("(change_view ?)");
  }

  if(send_message(buf, GLOBAL_sock) == -1)  /* Send the change     */
    return -1;    
  else
    return 0;
}
/*#define CHANGE_VIEW(a,b) Change_view(a,b)
#define NARROW_VIEW      CHANGE_VIEW(NARROW_WIDTH,SAME_QUALITY)
#define NORMAL_VIEW      CHANGE_VIEW(NORMAL_WIDTH,SAME_QUALITY)
#define WIDE_VIEW        CHANGE_VIEW(WIDE_WIDTH,  SAME_QUALITY)
#define HIGH_QUAL_VIEW   CHANGE_VIEW(SAME_WIDTH,  HIGH_QUALITY)
#define LOW_QUAL_VIEW    CHANGE_VIEW(SAME_WIDTH,  LOW_QUALITY )
#define NARROW_HIGH_VIEW CHANGE_VIEW(NARROW_WIDTH,HIGH_QUALITY)
#define NORMAL_HIGH_VIEW CHANGE_VIEW(NORMAL_WIDTH,HIGH_QUALITY)
#define WIDE_HIGH_VIEW   CHANGE_VIEW(WIDE_WIDTH,  HIGH_QUALITY)
#define NARROW_LOW_VIEW  CHANGE_VIEW(NARROW_WIDTH,LOW_QUALITY )
#define NORMAL_LOW_VIEW  CHANGE_VIEW(NORMAL_WIDTH,LOW_QUALITY )
#define WIDE_LOW_VIEW    CHANGE_VIEW(WIDE_WIDTH,  LOW_QUALITY )
*/

/*****************************************************************************/

int Turn(float angle){

  /* Only look at the ball before kickoff */
  /* if ( Mem->PlayMode == BEFORE_KICK_OFF && Mem->BallValid() == 1 )
    return 0; */

  if ( angle < -180 || angle > 180 )
    CleanAngle(&angle);

  if (angle < .1 && angle > -.1) return 0;          /* No turn           */

  Mem->Turning(angle);
  char buf[MAXMESG];

  sprintf(buf,"(turn %.1f)\n", angle);

  if(send_message(buf, GLOBAL_sock) == -1)  /* Send the turn     */
    return -1;    
  else
    return 0;
}
/*#define TURN(a) if(Turn(a)==-1) return -1*/

/*****************************************************************************/

int Kick( float power, float angle ){

  if ( Mem->PlayMode == BEFORE_KICK_OFF )
    return 0;

#if 0
  if ( Mem->BallValid() == 1 &&
       Mem->GetBallDistance() > KICK_DISTANCE && 
       (Mem->GetMyActiveStatus() != INSETPLAY || 
	Mem->GetMySetPlayPositionType() != SETPLAY_BLASTER) ){
    printf("%d shouldn't be kicking from distance %f (%.1f)\n",
	   Mem->MyNumber,Mem->GetBallDistance(),Mem->BallValid());
  }
#endif

  if (power > MAXPOWER) power = MAXPOWER;
  if (power < MINPOWER) power = MINPOWER;
  if ( angle < -180 || angle > 180 )
    CleanAngle(&angle);

  if ( power < 1 ) return 0;        /* No kick           */

  Mem->Kicking(power,angle);
  char buf[MAXMESG];

  sprintf(buf,"(kick %.1f %.1f)\n", power, angle);

  if(send_message(buf, GLOBAL_sock) == -1)  /* Send the turn     */
    return -1;    
  else 
    return 0;
}
/*#define KICK(a,b) if(Kick(a,b)==-1) return -1*/

/*****************************************************************************/

int Dash( float power){

  if ( Mem->PlayMode == BEFORE_KICK_OFF )
    return 0;

  if (power > MAXPOWER) power = MAXPOWER;
  if (power < MINPOWER) power = MINPOWER;

  if (power < 1) return 0;          /* No dash           */

  Mem->Dashing(power);

  char buf[MAXMESG];

  sprintf(buf,"(dash %.1f)\n", power);

  if(send_message(buf, GLOBAL_sock) == -1)  /* Send the turn     */
    return -1;    
  else 
    return 0;
}
/*#define DASH(a) if(Dash(a)==-1) return -1*/

/*****************************************************************************/

/*****************************************************************************/
/************        LOW LEVELS       ****************************************/
/*****************************************************************************/

int Look(char dir){

  int ang = Mem->GetViewAngle()*9/10;  /* Leave some overlap in turns */

  switch(dir){
  case 'r': break;
  case 'l': ang = -ang; break;
  /*  default:  ang = 90; */
  }
  
  TURN(ang);    /** Look around **/
}
/*#define LOOK(a) if(Look(a)==-1) return -1*/

/*****************************************************************************/

int Go(float distance, float power, int MinDashTimes, int MaxDashTimes){

  float startX, startY;
  Mem->GetGlobalXY(&startX,&startY);

#if USE_LEARNED_MOVE
  if (distance) /* If no distance, then do exactly as power and times say */
    GetPowerAndTimes(distance,&power,&dashTimes,Mem);
#endif

#if MOVE_LEARN

  Mem->MoveRecorded = TRUE;

  /* LastDashPower is set in position.c: PositionInfo::Dashing(float power) */
  /* OK as long as power of multiple dashes is always constant              */
  Mem->LastDashTimes = dashTimes;
  
  /* Not necessary if old global position is stored in Memory */
  RecordPreDash(power,dashTimes,Mem);
#endif

  int i=0;
  for (; i<MinDashTimes; i++){
    DASH(power);
    WAITUNTILFREETOACT;
    /* stop at the distance */
    if ( Mem->DistanceToPoint(startX,startY) > distance )
      break;
  }

  for (; i<MaxDashTimes; i++){
    if ( Mem->NewSight ) 
      break;     /* Go back for the new sight */
    DASH(power);
    WAITUNTILFREETOACT;
  }
  return 0;
}
/*
#define GO(a) if(Go(0,a,1,2)==-1) return -1
#define GO(a,b) if(Go(0,a,1,b)==-1) return -1
#define GO(a,b,c) if(Go(a,b,1,c)==-1) return -1
#define GOMINDASHES(a,b,c,d) if(Go(a,b,c,d)==-1) return -1
*/

/*****************************************************************************/

int KickAndFace(float power, float angle){

  KICK(power,angle);
  if ( fabs(angle) > 3 ){   /* Arbitrary */
    WAITUNTILFREETOACT;
    if ( !Mem->NewSight )
	 TURN(angle);  
  }
}
/*#define KICKANDFACE(a,b) if(Shoot(a,b)==-1) return -1*/

/*****************************************************************************/

#define TRAP_CONSTANT 60

int TrapBall(int trapTimes){

  for (int i=0; i<trapTimes; i++){
    KICK(TRAP_CONSTANT,Mem->GetBallAngle() + 180);
    WAITUNTILFREETOACT;
    if ( Mem->NewSight ) 
      break;;     /* Go back for the new sight */
  }
}
/*
#define TRAPBALL if(TrapBall(1)==-1) return -1
#define KEEPBALL if(TrapBall(ACT_MAX)==-1) return -1
*/

/*****************************************************************************/

int CircleBall(float DashPower, float BallGoalDifference){
/* This could be better--turn around the ball in the direction you want to end up */
/*                     --turn back to see it */

  float turn, ballAng = Mem->GetBallAngle(), TotalTurn = 80;
  if ( BallGoalDifference > 0 )
    TotalTurn *= -1; /* Determine whether going right or left of ball (- = left)*/
#if 0
    turn = -(TotalTurn - ballAng);
  else  /* BallGoalDifference <= 0 */
    turn = TotalTurn + ballAng;
   
  TURN(turn); 
  DASH(DashPower);
  TURN(ballAng-turn); /* Try to face the ball again */
                      /* Angle is designed to make the ball not valid (or see ball) */
#endif
  TURN(ballAng+TotalTurn);
  DASH(DashPower);
  TURN(-TotalTurn); /* Try to face the ball again */
                    /* Angle is designed to make the ball not valid (or see ball) */
  Mem->NewSight = FALSE; /* After 3 actions, wait for the next sight */
}
/*#define CIRCLEBALL(a,b) CircleBall(a,b)*/

/*****************************************************************************/

int DodgePlayer(float FirstAng, float DashPower, float SecondAng){
  TURN(FirstAng); 
  DASH(DashPower);
  TURN(SecondAng);
}
/*#define DODGEPLAYER(a,b,c) DodgePlayer(a,b,c)*/

/*****************************************************************************/

int DodgeBall(float FirstAng, float DashPower){

  TURN(FirstAng); 
  DASH(DashPower);
}
/*#define DODGEBALL(a,b) DodgeBall(a,b)*/

/*****************************************************************************/
