/* backprop.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _BACKPROP_
#define _BACKPROP_

#define FOR_USE

#define EPOCHS            5000
#define SAVE_WGTS_FREQ    10
#define DISPLAY_FREQ      10

#define NN_n_inp 3
#define NN_n_hid 4
#define NN_n_out 1

#define ETA1 .01
#define ETA2 .001

#define GAMMA1 .999
#define GAMMA2 .999

#define TRAIN_FILE      "Random1-3.dat"       /* Use "none" for no training    */
#define TEST_FILE       "test.dat"            /* Use "none" for no test        */
#define INITIALIZE_FILE "none"                /* none => random init           */
#define TEST_WEIGHTS    "none"                /* none => test with trained wgts*/
/*#define INIT_ToUse_FILE "nets/weights/Random1-3/weights-Jan23-9:40.dat"*/

static float INP_BASES[]  =  {  7, -7,   1,  -15};
static float INP_RANGES[] =  {  7,  14,   1,   30};
static float OUT_BASES[]  =  {0,   2,   0};
static float OUT_RANGES[] =  {1,   3,   1};  /* No scale for linear units */

void  NN_initialize_to_use(char*);
void  NN_use(float*);
void  train(char*, int);
void  test(char*);

#endif

