/* adversarial.c
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#include "global.h"

/*****************************************************************************/
/** Change the team strategy based on situation and/or opponents             */
/** Can change formation, setplay, coaching, changepositions, echosound,     */
/** Markchangemethod, homechangemethod                                       */
/*****************************************************************************/


void ReactToScoreAndTime(){
  /* based on score difference and time left */
  int ScoreDiff = Mem->MyScore - Mem->TheirScore;
  int TimeLeft  = GAME_LENGTH - Mem->CurrentTime;
  int MinutesLeft = TimeLeft/600; /* Lower bound */


  if ( ScoreDiff < 0 && -ScoreDiff >= MinutesLeft ){
    /*  losing by more than 1 goal/minutes: 334, setplays, echo sounds */
    /* printf(" (1) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    Mem->SetFormation(f334_FORMATION,Mem->CurrentTime);
    Mem->UseSetPlays = TRUE;
    /* Mem->EchoSounds = TRUE; */
    return;
  }

  if ( ScoreDiff < 0 && -3*ScoreDiff >= MinutesLeft ){
    /*  losing by more than 1 goal/3 minutes: 442, setplays, echo sounds */
    /* printf(" (2) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    Mem->SetFormation(f442_FORMATION,Mem->CurrentTime);
    Mem->UseSetPlays = TRUE;
    /* Mem->EchoSounds = TRUE; */
    return;
  }

  if ( ScoreDiff == 0 && MinutesLeft <= 0 ){
    /* OT or tied with a minute left:  442, setplays, echo sounds */
    /* printf(" (3) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    Mem->SetFormation(f442_FORMATION,Mem->CurrentTime);
    Mem->UseSetPlays = TRUE;
    /* Mem->EchoSounds = TRUE; */
    return;
  }

  if ( ScoreDiff > 0 && ScoreDiff >= MinutesLeft ){
    /*  winning by more than 1 goal/minute:  72, no setplays, no echo sounds,
        dont change positions */
    /* printf(" (4) Score Diff = %d,  TimeLeft = %d\n", ScoreDiff, TimeLeft); */
    Mem->SetFormation(f72_FORMATION,Mem->CurrentTime);
    Mem->UseSetPlays = TRUE;
    Mem->EchoSounds = FALSE;
    Mem->ChangePositions = FALSE;
    return;
  }

  /* default:  442, no setplays, no echo sounds */
  Mem->SetFormation(f442_FORMATION,Mem->CurrentTime);
  Mem->UseSetPlays = TRUE;
  Mem->EchoSounds = FALSE;
  return;
}


void ReactToOpponents(){
  ;
}

void SwitchRightLeft(){
  
  if ( (Mem->CurrentTime/3000)%2 )
    Mem->SetFormation(fRT_FORMATION,Mem->CurrentTime);
  else
    Mem->SetFormation(fLT_FORMATION,Mem->CurrentTime);

  if ( Mem->GetMyPosition() > 0 ){
    /* not goalie */
    Mem->HomeChangeMethod = HOME_MARK; 
    Mem->MarkChangeMethod = MARK_CLOSEST;
  }
  else 
    Mem->HomeChangeMethod = HOME_SHIFT; 

  return;
}

void SinglePlayerSwitch(){

#if 1
  if ( Mem->MyNumber == 6 ){
    int newFormationType;
    if ( (Mem->CurrentTime/300)%2 )
      newFormationType = f72_FORMATION;
    else
      newFormationType = f334_FORMATION;


    if ( Mem->GetCurrentFormation() == UNKNOWN_FORMATION || 
         newFormationType != Mem->GetCurrentFormationType() ){
      FILE *outFile = fopen("out.dat","a");
      fprintf(outFile,"\n%d:%d Initiating change to %d at time %d\n",
	      Mem->MyNumber,Mem->CurrentTime,newFormationType,Mem->CurrentTime);
      fclose(outFile);

      Mem->SetFormation(newFormationType,Mem->CurrentTime);
      ANNOUNCEMYPOSITION;
    }
  }
#else
  /* For stagger test */

  Mem->SetFormation(f72_FORMATION,Mem->CurrentTime);
  
  static int lastTime=0;

  if ( Mem->MyNumber == 7 && Mem->CurrentTime/100 > lastTime ){
    printf("\nnew\n\n");
    lastTime = Mem->CurrentTime/100;
    SAY(PING_MSG);
  }
#endif
  
  return;
}


