/* act.h
 * CMUnited-97 (soccer client for Robocup-97)
 * Peter Stone <pstone@cs.cmu.edu>
 * Computer Science Department
 * Carnegie Mellon University
 * Copyright (C) 1997 Peter Stone
 *
 * CMUnited-97 was created by Peter Stone and Manuela Veloso
 *
 * You may copy and distribute this program freely as long as you retain this notice.
 * If you make any changes or have any comments we would appreciate a message.
 */

#ifndef _ACT_
#define _ACT_

#include "memory.h"

#define FAILURE 0
#define TRYING  FAILURE+1
#define TRIED   TRYING +1
#define SUCCESS TRIED  +1


extern int FaceBall();
#define FACEBALL FaceBall()

extern int FaceMarker(int);
#define FACEMARKER(a) FaceMarker(a)

extern int FacePlayer(char, int);
#define FACEPLAYER(a,b) FacePlayer(a,b)
#define FACETEAMMATE(a) FacePlayer(Mem->MySide,a)
#define FACEOPPONENT(a) FacePlayer(Mem->TheirSide,a)

extern int FacePoint(float x, float y, float buffer);
#define FACEPOINT(a,b) FacePoint(a,b,1)

extern int LookForBall(char dir);
#define LOOKFORBALL LookForBall('r')

extern int FindBall();
#define FINDBALL FindBall()

extern int LookForMarker(int, char dir);
#define LOOKFORMARKER(a) LookForMarker(a,'r')

extern int LookForPlayer(char, int, char dir);
#define LOOKFORPLAYER(a,b) LookForPlayer(a,b,'r')
#define LOOKFORTEAMMATE(a) LookForPlayer(Mem->MySide,a,'r')
#define LOOKFOROPPONENT(a) LookForPlayer(Mem->TheirSide,a,'r')

extern int FindPlayer(char side, int player);
#define FINDPLAYER(a,b) FindPlayer(a,b) 
#define FINDTEAMMATE(a) FindPlayer(Mem->MySide,a) 
#define FINDOPPONENT(a) FindPlayer(Mem->TheirSide,a) 

int Move(float, float, float, int, int);
#define DASHMOVE(a,b)   Move(0,a,b,1,2)
#define GOMOVE(a,b,c,d,e) Move(a,b,c,d,e)
/*#define MOVE(a,b) Move(a,b)*/

float NeedToCircle(float GoalAngle);
#define NEEDTOCIRCLE(a) NeedToCircle(a)
#define NEEDTOCIRCLETOPASSTO(a) NeedToCircle(Mem->GetPlayerAngle(Mem->MySide,a))

int Shoot(float, float, int, int, int);
#define SHOOTONGOAL(a) Shoot(a,Mem->GetMarkerAngle(THEIR_GOAL),MAX_ACTS,1,1)
#define SHOOTATMARKER(a,b) Shoot(b*Mem->GetMarkerDistance(a),Mem->GetMarkerAngle(a),MAX_ACTS,1,0)
#define SHOOTATANGLE(a,b) Shoot(a,b,MAX_ACTS,0,0)
#define DRIBBLEATMARKER(a,b) Shoot(b,Mem->GetMarkerAngle(a),1,0,0)
#define DRIBBLEATTEAMMATE(a,b) Shoot(b,Mem->GetPlayerAngle(Mem->MySide,a),1,0,0)
#define DRIBBLEATOPPONENT(a,b) Shoot(b,Mem->GetPlayerAngle(Mem->TheirSide,a),1,0,0)
#define PASSTOTEAMMATE(a,b) Shoot(b*Mem->GetPlayerDistance(Mem->MySide,a),Mem->GetPlayerAngle(Mem->MySide,a),MAX_ACTS,1,0)
/* No need to trap */
#define EASYPASSTOTEAMMATE(a,b) Shoot(b*Mem->GetPlayerDistance(Mem->MySide,a),Mem->GetPlayerAngle(Mem->MySide,a),MAX_ACTS,0,0)
/* If don't know player's distance */
#define PASSTOWARDTEAMMATE(a,b) Shoot(b,Mem->GetPlayerAngle(Mem->MySide,a),MAX_ACTS,1,0)
#define EASYPASSTOWARDTEAMMATE(a,b) Shoot(b,Mem->GetPlayerAngle(Mem->MySide,a),MAX_ACTS,0,0)

int ShootAtPoint(float kpow, float x, float y, int trap_ball, int hard_shot);
#define SHOOTATPOINT(a,b,c) ShootAtPoint(a,b,c,0,1)
#define BLASTATPOINT(a,b) ShootAtPoint(100,a,b,0,0)
#define SHOOTONGOALATCORNER(a) ShootAtPoint(a,X0,(GOAL_WIDTH/2 - 3) * (int_random(2) ? 1 : -1),0,1) 
#define SHOOTATNEARPOST(a) ShootAtPoint(a,X0,(GOAL_WIDTH/2 -3) * (Mem->GetGlobalY()>0 ? 1 : -1),0,1)
#define SHOOTATFARPOST(a) ShootAtPoint(a,X0,(GOAL_WIDTH/2 -3) * (Mem->GetGlobalY()>0 ? -1 : 1),0,1)

int ClearTowards(float kpow, float ang);
#define CLEARTOWARDSMARKER(a,b) ClearTowards(b*Mem->GetMarkerDistance(a),Mem->GetMarkerAngle(a))
#define CLEARTOWARDSPOINT(a,b,c) ClearTowards(c*Mem->DistanceToPoint(a,b),Mem->AngleToPoint(a,b))

extern int CollectStoppedBall(float CollectDist, float DashPower);
#define COLLECTSTOPPEDBALL(a) CollectStoppedBall(150,a)

extern int CollectBall (int (*ChoiceFunction)(float*,float*),float,float);
#define CHASEBALL(a) CollectBall(&ChooseStraight,150,a)
#define COLLECTBALL(a,b,c) CollectBall(a,b,c)
#define ACTIVECOLLECTBALL(a,b) Collectball(a,150,b)

extern int GetCollectTargetXY(float *targetX, float *targetY);
extern int AnalyticCollectBall (float,float);
#define ANALYTICCOLLECTBALL(a,b) AnalyticCollectBall(a,b)

extern int GoalieHome (float);
#define GOALIEHOME(a) GoalieHome(a)

extern int KamramHome (float);
#define KAMRAMHOME(a) KamramHome(a)

extern int GotoPoint (float x, float y, float DashPower, float Buffer, int minDashes);
#define GOTOPOINT(x,y,z,a) GotoPoint(x,y,z,a,1)
#define GOTOPOINTMINDASHES(x,y,z,a,b) GotoPoint(x,y,z,a,b)

extern int HoldHome(float DashPower);
#define HOLDHOME(a) HoldHome(a)

extern int MarkPlayer( float DashPower );
#define MARKPLAYER(a) MarkPlayer(a)

extern int HoldPosition( float DashPower );
#define HOLDPOSITION(a) HoldPosition(a)

extern int ExecuteSetPlay(float DashPower, float ShotPower);
#define EXECUTESETPLAY(a,b) ExecuteSetPlay(a,b) 

extern int DribbleToMarker(int, float, float);
#define DRIBBLETOMARKER(a,b,c) DribbleToMarker(a,b,c)
#define DRIBBLESTRAIGHT(a,b) DribbleToMarker(-1,a,b)

extern int CollectAndKnock (int Marker, float x, float y,
			    int (*ChoiceFunction)(float*,float*), 
			    float CollectDist, float ShootDist, float DashPower, 
			    float DribblePower, float ShotPower, int clear);
extern int CollectAndKnock (int Marker, int (*ChoiceFunction)(float*,float*), 
		     float CollectDist, float ShootDist, float DashPower, 
		     float DribblePower, float ShotPower, int clear);
#define COLLECTANDSHOOT(a,b,c,d) CollectAndKnock(THEIR_GOAL,a,b,150,c,0,d,0)
#define CHASEANDSHOOT(a,b)     CollectAndKnock(THEIR_GOAL,&ChooseStraight,150,150,a,0,b,0)
#define DRIBBLEANDSHOOT(a,b,c,d) CollectAndKnock(THEIR_GOAL,&ChooseStraight,150,a,b,c,d,0)
#define STAYANDSHOOT(a)   CollectAndKnock(THEIR_GOAL,&ChooseStraight,0,150,0,0,a,0)
#define COLLECTANDKNOCK(a,b,c,d,e) CollectAndKnock(a,b,c,150,d,0,e,0)
#define ACTIVECOLLECTANDKNOCK(a,b,c,d) CollectAndKnock(a,b,150,150,c,0,d,0)
#define CHASEANDKNOCK(a,b,c)     CollectAndKnock(a,&ChooseStraight,150,150,b,0,c,0)
#define DRIBBLEANDKNOCK(a,b,c,d,e)   CollectAndKnock(a,&ChooseStraight,150,b,c,d,e,0)
#define COLLECTANDDRIBBLE(a,b,c,d,e)   CollectAndKnock(a,b,c,0,d,e,0,0)
#define ACTIVECOLLECTANDDRIBBLE(a,b,c,d)   CollectAndKnock(a,b,150,0,c,d,0,0)
#define COLLECTANDCLEAR(a,b,c,d,e) CollectAndKnock(a,b,c,150,d,0,e,1)
#define COLLECTANDCLEARTOPOINT(a,b,c,d,e,f) CollectAndKnock(0,a,b,c,d,150,e,0,f,1)
#define COLLECTANDKNOCKTOPOINT(a,b,c,d,e,f) CollectAndKnock(0,a,b,c,d,150,e,0,f,0)

extern int CollectAndPassTo (int, int (*ChoiceFunction)(float*,float*), 
			      float, float, float, float, float, int);
#define COLLECTANDPASSTO(a,b,c,d,e) CollectAndPassTo(a,b,c,150,d,10,e,1)
#define EASYCOLLECTANDPASSTO(a,b,c,d,e) CollectAndPassTo(a,b,c,150,d,10,e,0)
#define ACTIVECOLLECTANDPASSTO(a,b,c,d) CollectAndPassTo(a,b,150,150,c,10,d,1)
#define DRIBBLEANDPASSTO(a,b,c,d,e) CollectAndPassTo(a,&ChooseStraight,150,b,c,d,e,1)
#define APPROACHANDPASSTO(a,b,c,d,e,f) CollectAndPassTo(a,&ChooseNN,b,c,d,e,f,1)
/* a is receiver, b is CollectDist (collect when ball is < b), c is PassDist 
   (pass when ball < c), d is DashPower, e is DribblePower, f is PassPower */
#define STAYANDPASSTO(a,b)   CollectAndPassTo(a,&ChooseStraight,0,150,0,0,b,0)
/* a is receiver, b is PassPower */

extern int CollectAndAct (int (*ActFunction)(char*,int*),
			  int (*ChoiceFunction)(float*,float*),
			  float CollectDist, float ShotDist, float DashPower, 
			  float DribblePower, float ShotPower);
#define COLLECTANDACT(a,b,c,d) CollectAndAct(a,&ChooseNN,b,0,c,10,d)
#define ACTIVECOLLECTANDACT(a,b,c) CollectAndAct(a,&ChooseNN,150,0,b,10,c)

extern int HoldPositionAndAct (int (*ActFunction)(char*,int*),
			int (*ChoiceFunction)(float*,float*),
			float ShotDist, float DashPower, 
			float DribblePower, float ShotPower);
   /* a is action func. b is collectdist. c,d are dash/shot power */
#define HOLDPOSITIONANDACT(a,b,c) HoldPositionAndAct(a,&ChooseNN,0,b,10,c)

int ReceivePass(int (*ChoiceFunction)(float*,float*), float CollectDist, float DashPower);
#define RECEIVEPASS(a,b,c) ReceivePass(a,b,c)

#endif

