import os, sys
import glob
import time
import datetime
from decimal import *
import math
from scipy.interpolate import interp1d
import matplotlib.pyplot as plt
from scipy import interpolate, interp
import numpy as np
import string
from math import *
import numpy as np 
from scipy import sparse
import fractions
import math
import datetime
from datetime import datetime, timedelta, date, time
import ephem
import read_one_run 

#############################################################################################

def compile_all(main_dir, frameRate, extract_option):

	all_light_of_day = []
	all_image_list = [] 
	all_IMlon = []
	all_IMlat = []
	all_image_date_list = []
	all_sharpness_array = []

	run_name_list = os.listdir(main_dir)

	for run_name in run_name_list:
		if run_name[0] == '2':
			info = read_one_run.read_one_run(run_name, main_dir, frameRate, 1, extract_option)
			image_list_length = info[6]
			all_light_of_day += ([info[0]] * image_list_length)
			all_image_list += info[1]
			all_IMlon += info[2]
			all_IMlat += info[3]
			all_image_date_list += info[4]
			all_sharpness_array += info[5]

			# uncomment to read gps data to file ##############################################
			# temp_gps = main_dir + '\\' + run_name + '-temp-gps.txt'
			# if (not os.path.isfile(temp_gps)):
			# 	ftempgps = open(temp_gps, "w")
			# 	for i in xrange(len(all_image_list)):
			# 		ftempgps.write(info[1][i]+ ' ')
			# 		ftempgps.write(str(info[2][i])+ ' ')
			# 		ftempgps.write(str(info[3][i])+'\n')
			# 	ftempgps.close()


	return (all_light_of_day, all_image_list, all_IMlon, all_IMlat, all_image_date_list, all_sharpness_array)

def horizontalDistance(lat1,lat2,lon1,lon2):
	#this is the helper function to calculate distance given two gps locations
	#Haversine Formuala to find vertical angle and distance
	lon1, lat1, lon2, lat2 = map(radians, [lon1, lat1, lon2, lat2])

	dlon = lon2 - lon1
	dlat = lat2 - lat1
	a = sin(dlat/2)**2 + cos(lat1) * cos(lat2) * sin(dlon/2)**2
	c = 2 * atan2(sqrt(a), sqrt(1-a))
	return 6371 * 1000 * c # the distance in meters

def find_first_image(main_dir, threshhold, frameRate, extract_option):
	# find the first image that has sharpness above the threshhold
	# returns the index
	data = compile_all(main_dir, frameRate, extract_option)
	sharpness_array = data[5]
	for i in xrange(len(sharpness_array)):
		if sharpness_array[i] >= threshhold: return i
	return None

def getLatest(main_dir, frameRate, extract_option):

	all_data = compile_all(main_dir, frameRate, extract_option)
	all_light_of_day = all_data[0]
	all_image_list = all_data[1] 
	all_IMlon = all_data[2] 
	all_IMlat = all_data[3]
	all_image_date_list = all_data[4]
	all_sharpness_array = all_data[5]

	sub_light_of_day = []
	sub_image_list = []
	sub_IMlon = []
	sub_IMlat = []
	sub_image_date_list = []
	sub_sharpness_array = []

	# use the sparse matrix to save the index of the later date
	matrix = sparse.csr_matrix((50000,10000)) 
	lon0 = -79.95250
	lat0 = 40.43350	

	for i in range(1, len(all_image_list)):
		# do not deal with index 0 since it will clash with the 0.0 init value of spare matrix
		lon = all_IMlon[i]
		lat = all_IMlat[i]
		row = int(abs(round((lon - lon0) * (10**5))))
		col = int(abs(round((lat - lat0) * (10**5))))

		if matrix[row, col] == 0.0:
			matrix[row, col] = i

		else:
			if all_image_date_list[i] > all_image_date_list[int((matrix[row, col]))]:
				matrix[row, col] = i


	# deals with 0th index
	lon = all_IMlon[0]
	lat = all_IMlat[0]
	row = int(abs(round((lon - lon0) * (10**5))))
	col = int(abs(round((lat - lat0) * (10**5))))
	if matrix[row, col] == 0.0:	
		sub_light_of_day += [all_light_of_day[0]]
		sub_image_list += [all_image_list[0]]
		sub_IMlon += [all_IMlon[0]]
		sub_IMlat += [all_IMlat[0]]
		sub_image_date_list += [all_image_date_list[0]]
		sub_sharpness_array += [all_sharpness_array[0]]
	
	else:
		if all_image_date_list[0] > all_image_date_list[int((matrix[row, col]))]:
			sub_light_of_day += [all_light_of_day[0]]
			sub_image_list += [all_image_list[0]]
			sub_IMlon += [all_IMlon[0]]
			sub_IMlat += [all_IMlat[0]]
			sub_image_date_list += [all_image_date_list[0]]
			sub_sharpness_array += [all_sharpness_array[0]]
			# unwrite the old index
			matrix[row, col] = 0.0

	for k in xrange(matrix.getnnz()):
		row2 = matrix.nonzero()[0][k]
		col2 = matrix.nonzero()[1][k]
		index = int(matrix[row2, col2])
		sub_light_of_day += [all_light_of_day[index]]
		sub_image_list += [all_image_list[index]]
		sub_IMlon += [all_IMlon[index]]
		sub_IMlat += [all_IMlat[index]]
		sub_image_date_list += [all_image_date_list[index]]
		sub_sharpness_array += [all_sharpness_array[index]]

	return (sub_light_of_day, sub_image_list, sub_IMlon, sub_IMlat, sub_image_date_list, sub_sharpness_array)


def subsampleByMeters(main_dir, option, frameRate, extract_option, meters = 10):

	if option == 0:
		all_data = compile_all(main_dir, frameRate, extract_option)

	if option == 1:
		all_data = getLatest(main_dir, frameRate, extract_option)

	running = True
	lower_meters = 0
	upper_meters = meters

	all_light_of_day = all_data[0]
	all_image_list = all_data[1] 
	all_IMlon = all_data[2] 
	all_IMlat = all_data[3]
	all_image_date_list = all_data[4]
	all_sharpness_array = all_data[5]

	starting_position = find_first_image(main_dir, 10.0, frameRate, extract_option)
	lat0 = all_IMlat[starting_position]
	lon0 = all_IMlon[starting_position]
	sub_light_of_day = [all_light_of_day[starting_position]]
	sub_image_list = [all_image_list[starting_position]] 
	sub_IMlon = [all_IMlon[starting_position]] 
	sub_IMlat = [all_IMlat[starting_position]]
	sub_image_date_list = [all_image_date_list[starting_position]]
	sub_sharpness_array = [all_sharpness_array[starting_position]]	

	if starting_position == None:
		starting_position = 0

	while running:

		samples = []
		max_sharpness = -100
		max_sharpness_index = 0

		for i in range(starting_position + 1, len(all_image_list)):
			dist = horizontalDistance(lat0,all_IMlat[i],lon0,all_IMlon[i])
			if lower_meters < dist <= upper_meters:
				samples += [i]

		# PROBLEMM!!!! when to stop?
		if len(samples) == 0:
			break

		for index in samples:
			if all_sharpness_array[index] > max_sharpness:
				max_sharpness = all_sharpness_array[index]
				max_sharpness_index = index

		sub_light_of_day += [all_light_of_day[max_sharpness_index]]
		sub_image_list += [all_image_list[max_sharpness_index]]
		sub_IMlon += [all_IMlon[max_sharpness_index]]
		sub_IMlat += [all_IMlat[max_sharpness_index]]
		sub_image_date_list += [all_image_date_list[max_sharpness_index]]
		sub_sharpness_array += [all_sharpness_array[max_sharpness_index]]
		lower_meters += meters
		upper_meters += meters

	return (sub_light_of_day, sub_image_list, sub_IMlon, sub_IMlat, sub_image_date_list, sub_sharpness_array)


def write_your_kml_main(main_dir, frameRate, extract_option, option = 0):

	# info return format : (light_of_day, image_list, IMlon, IMlat, image_date_list, sharpness_array, image_list_length)

	if option == 3: #both latest and every 10 meters. i.e. most efficient image set.
		info = subsampleByMeters(main_dir, 1, frameRate, extract_option, 10)
	elif option == 2: #only images every 10 meters
		info = subsampleByMeters(main_dir, 0, frameRate,extract_option, 10)
	elif option == 1: #only latest images
		info = getLatest(main_dir, frameRate, extract_option)
	elif option == 0: # all the images 
		info = compile_all(main_dir, frameRate, extract_option)

	light_of_day = info[0]
	image_list = info[1]
	IMlon = info[2]
	IMlat = info[3]
	image_date_list = info[4]





	f = open(main_dir + '/hi-your-kml.kml', 'w')
	kmlHead = """<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2">
<Document>
"""

	kml_body = ""

	for i in xrange(len(image_list) - 1): 

		arrow_arg1 = (atan2(((IMlon[i + 1]) - (IMlon[i])), \
			((IMlat[i + 1]) - (IMlat[i]))) + 2 * pi) / pi * 180
		arrow_arg2 = str(int(round(arrow_arg1 % 360))/10 * 10) 

		# 'isDay': arwColor = 'yellow'
		# 'isDawnDusk': arwColor = 'cyan'
		# 'isNight': arwColor = 'magenta'
		if light_of_day[i] == 1:
			arrow_color = "yellow"
		elif light_of_day[i] == 2:
			arrow_color = "cyan"
		elif light_of_day[i] == 3:
			arrow_color = "magenta"

		# image_path = main_dir + "/" + run_name +"/" + image_list[i]
		image_path = image_list[i]
		image_lon = str(IMlon[i])
		image_lat = str(IMlat[i])

		# image_date format : 2013-06-28T15:55:05Z
		image_date = image_date_list[i]
		year = str(image_date.year).zfill(4)
		month = str(image_date.month).zfill(2) 
		day = str(image_date.day).zfill(2) 
		hour = str(image_date.hour).zfill(2)
		minute = str(image_date.minute).zfill(2) 
		seconds = str(image_date.second).zfill(2)
		image_date = year + "-" + month + "-" + day + "T" + hour + ":" + minute + ":" + seconds + "Z"

		kmlSection = (    '  <Placemark>\n'
      '      <Style id="normalPlacemark">\n'
      '        <IconStyle>\n'
      '          <scale>0.5</scale>\n'
      '          <Icon>\n'
      '           <href>arrows/arrow_%s_%s.png</href>\n'
      '          </Icon>\n'
      '        </IconStyle>\n'
      '      </Style>\n'
      #reference: https://developers.google.com/kml/documentation/kml_tut#placemarks
      '    <description> <![CDATA[\n'
      '        <img style="width: 600px; height: 400px;" src="%s">\n' 
      '            ]]></description>\n'
      '    <Point>\n'
      '      <coordinates> %s, %s, 0</coordinates>\n'
      '    </Point>\n'
      '    <TimeStamp>\n'
      '       <when>%s</when>\n'
      '    </TimeStamp>\n'
      '  </Placemark>\n') % (arrow_arg2, arrow_color, image_path, image_lon, image_lat, image_date)
		kml_body += kmlSection

	kmlHead += kml_body

	kml = kmlHead + '''
		</Document>\n
			</kml>\n
		'''

	f.write(kml)
	f.close()

	# indicates successful output
	# print ("KML created successfully!\n")
	# print ("Use the following file path to access the .kml file: \n")
	# print (main_dir + '/hi-your-kml.kml' + "\n")
	# print ("End of run for: " + main_dir + "\n")

	return


#############################################################################################

# RUN THE CODE AS FOLLOWS: 

# Run write_your_kml_main by uncommenting this line: 
# write_your_kml_main("/Users/lamwingchan/Desktop/navlab", 7, 0)

#############################################################################################


