# External module: 
# (NOTE: Some of the modules might require manual installation. Run the code and see which of them has to be installed)

import os, sys
import glob
import time
import datetime
from decimal import *
import math
from scipy.interpolate import interp1d
import matplotlib.pyplot as plt
from scipy import interpolate, interp
import numpy as np
import string
from math import *
import numpy as np 
from scipy import sparse
import fractions
import math
import datetime
from datetime import datetime, timedelta, date, time
import ephem
import urllib
import json
import cv2
import extract_jpg_frm_mp4

#############################################################################################

# Overview:
# read_one_run processes data read from the log file and returns values as indicated in the [Index CHART]
# the main function compiles all the processed data from the read_one_run function and produces a final report

# This file contains four functions:
# 1. datetime2matlabdn
# 2. is_Daylight_Savings
# 3. read_one_run
# 4. main

# To Run the code:
# Go to the end of the file to access information on how to run the code.

#############################################################################################

# The code in the function datetime2matlabdn is adapted from code shared on Stackoverflow:
# "http://stackoverflow.com/questions/8776414/python-datetime-to-matlab-datenum"
# The function takes a datetime type and convert it to an output equivalent to the matlab datenum function

def datetime2matlabdn(dt):
   mdn = dt + timedelta(days = 366)
   
   frac_seconds = (dt-datetime(dt.year,dt.month,dt.day,0,0,0)).seconds / (24.0 * 60.0 * 60.0)
   
   frac_microseconds = dt.microsecond / (24.0 * 60.0 * 60.0 * 1000000.0)
   
   return mdn.toordinal() + frac_seconds + frac_microseconds

def str2datenum(date_string, offset, option = 0):
    # 20150624_152835_244
    # 0123456789012345678901234567890123
    # 0         1         2         3

    # option 0 is for general read_one_run (default), returning (dates and seconds) in datenum
    # option 1 is for kml file, where startdate is required in date type
    
    new_date_string = date_string.split("_")
    year = int(new_date_string[0][0:4])
    month = int(new_date_string[0][4:6])
    day = int(new_date_string[0][6:8])
    hour = int(new_date_string[1][0:2])
    minute = int(new_date_string[1][2:4])
    second = int(new_date_string[1][4:6])
    msec = int(new_date_string[2])

    dates = datetime(year, month, day, hour, minute, second)
    STARTdate0_date = dates
    dates = datetime2matlabdn(dates)

    # no offset 
    if (offset == -1):
        seconds = dates*86400 + msec/1000.0

    # offset = first time
    elif (offset == 0):
        seconds = msec/1000.0

    # user defined offset:
    else:
        seconds = (dates-offset)*86400 + msec/1000.0

    if (option == 1):
    	return STARTdate0_date

    else:
    	return (dates, seconds)

def make_imagedate_list(STARTdate0_date, seconds_delta, image_list_length):
	# for writing kml, which needs dates to be in date type
	# type(STARTdate0_date) is date
	# type(seconds_delta) is float

	image_date_list = []

	for i in xrange(image_list_length):
		next_date = STARTdate0_date + timedelta(seconds = (i * seconds_delta))
		image_date_list += [next_date]

	return image_date_list



#############################################################################################


def is_Daylight_Savings(date_str):
	# Function takes a date as a string in (20150624_152835_244) format and outputs a
	# logical, true if the date is during daylight savings time for that year. See
	# definition of daylight savings time in the USA
	date_str = date_str.split("_")[0]

	year = int(date_str[0:4])
	month = int(date_str[4:6])
	day = int(date_str[6:8])

	# If the month is between April and October, true
	if ((month > 3) and (month < 11)): return True 
	# If month is January, February, or December, false
	elif ((month < 3) or (month == 12)): return False 
	if (month == 3): # days on/after 2nd Sunday in March, true
		sundays = 0
		for i in xrange(day+1):
			if datetime.date(year, month, day).isoweekday() == 7: 
				sundays += 1
		if sundays >= 2: 
			return True
		else: 
			return False
	elif (month == 11): # days before 1st Sunday in Nov, true
		sundays = 0
		for i in xrange(day):
			if datetime.date(year, month, day).isoweekday() == 7: 
				sundays += 1
		if sundays < 1: 
			return True
		else: 
			return False

#############################################################################################

def weather_new(run_name, main_dir, STARTdate0_date, lat0, lon0):

	year = str(STARTdate0_date.year).zfill(4)
	month = str(STARTdate0_date.month).zfill(2) 
	day = str(STARTdate0_date.day).zfill(2) 
	hour = str(STARTdate0_date.hour).zfill(2)
	minute = str(STARTdate0_date.minute).zfill(2)

	opener = urllib.FancyURLopener({})
	APIkey = "4d53ca5971e81aa7e60f1bfecf462f01"

	f = opener.open("https://api.forecast.io/forecast/%s/%s,%s,%s-%s-%sT%s:%s:00" % (APIkey,str(lat0),str(lon0),year,month,day,hour,minute))

	data = json.load(f)

	outputFileShort = main_dir + '/' + run_name + '/' + run_name + '-weather_short.txt'

	write_weather = open(outputFileShort, 'w')

	write_weather.write('%s' % data["currently"]["summary"])

	write_weather.close()

	return

#############################################################################################

def sharpness_detection_per_image(image_path):

	image = image_path

	img = cv2.imread(image)
	
	(height, width, depth) = img.shape

	ddepth = cv2.CV_16S
	sub_image = img[height/2:height/2+ height/3, width/3:width/3*2]

	gray = cv2.cvtColor(sub_image, cv2.COLOR_RGB2GRAY)

	grad_x = cv2.Sobel(gray,ddepth,1,0,ksize = 3, scale = 1, delta = 0,borderType = cv2.BORDER_DEFAULT)
	grad_y = cv2.Sobel(gray,ddepth,0,1,ksize = 3, scale = 1, delta = 0, borderType = cv2.BORDER_DEFAULT)

	size = sub_image.shape
	abs_grad_x = cv2.convertScaleAbs(grad_x)
	abs_grad_y = cv2.convertScaleAbs(grad_y)

	grad = cv2.addWeighted(abs_grad_x,0.5,abs_grad_y,0.5,0)

	cumsum = float(cv2.sumElems(grad)[0])/(sub_image.shape[1])/(sub_image.shape[0])

	return cumsum

def sharpness_detection_main(run_name, main_dir, image_list):

	sharpness_file = main_dir + '/' + run_name + '/' + run_name + '-sharpness.txt'

	fsharpness = open(sharpness_file, "w")

	sharpness_string = ""

	sharpness_number = 0

	for i in xrange(len(image_list)):

		sharpness_number = sharpness_detection_per_image(image_list[i])

		sub_sharpness_string = str(i) + ' ' + str(sharpness_number) + "\n"

		sharpness_string += sub_sharpness_string

	fsharpness.write(sharpness_string)

	return None

#############################################################################################

def main(run_name, main_dir, data_content):

	# Sample input : main("20150806_172541_260_CMU", "/Users/lamwingchan/Desktop")
	# the function main creates a .txt file that displays the data processed by the read_one_run function

	# [Index CHART] function read_one_run returns the following in a tuple format:
	# 0  - STARTseconds
	# 1  - ENDseconds
	# 2  - GPSseconds
	# 3  - lon
	# 4  - lat
	# 5  - STARTdate0
	# 6  - ACCseconds
	# 7  - ax
	# 8  - ay
	# 9  - az
	# 10 - IMseconds
	# 11 - IMdates
	# 12 - image_list_length
	# 13 - IMax
	# 14 - image_list
	# 15 - light_of_day
	# 16 - sharpness
	# 17 - weather_str
	# 18 - weather_num

	# To access the individual data, index the data_content[i]
	# i denotes the index as indicated Index CHART above

	if data_content == None:
		# ALERTS client that read_one_run is not running properly and exits
		print ("read_one_run not running properly, no report created!")
		return

	dirdir = main_dir + '/' + run_name

	final_report = dirdir + '/' + run_name + '-FINAL_REPORT.txt'

	f_final_report = open(final_report, "w")


	# The following writes the data line by line:

	# title:
	title = "FINAL REPORT FOR: %s\n" % (run_name)
	f_final_report.write(title)
	f_final_report.write("\n")

	# Start_seconds:
	array = data_content[0]
	f_final_report.write("STARTseconds: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# End_seconds:
	array = data_content[1]
	f_final_report.write("ENDseconds: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# GPS_Seconds:
	array = data_content[2]
	f_final_report.write("GPSseconds: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# lon:
	array = data_content[3]
	f_final_report.write("lon: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# lat:
	array = data_content[4]
	f_final_report.write("lat: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# STARTdate0
	val = data_content[5]
	f_final_report.write("STARTdate0: \n")
	f_final_report.write(str(val) + "\n")
	f_final_report.write("\n")

	# ACCseconds:
	array = data_content[6]
	f_final_report.write("ACCseconds: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# ax:
	array = data_content[7]
	f_final_report.write("ax: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# ay:
	array = data_content[8]
	f_final_report.write("ay: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# az:
	array = data_content[9]
	f_final_report.write("az: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# IMseconds:
	array = data_content[10]
	f_final_report.write("IMseconds: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# IMdates:
	array = data_content[11]
	f_final_report.write("IMdates: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")	

	# image_list_length:
	val = data_content[12]
	f_final_report.write("image_list_length: \n")
	f_final_report.write(str(val) + "\n")	
	f_final_report.write("\n")

	# IMax:
	array = data_content[13]
	f_final_report.write("IMax: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")	

	# image_list:
	array = data_content[14]
	f_final_report.write("image_list: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# light_of_day:
	val = data_content[15]
	f_final_report.write("light_of_day: \n")
	f_final_report.write(str(val) + "\n")	
	f_final_report.write("\n")

	# sharpness:
	array = data_content[16]
	f_final_report.write("sharpness: \n")
	for value in array:
		f_final_report.write(str(value) + "\n")
	f_final_report.write("\n")

	# weather_str:
	val = data_content[17]
	f_final_report.write("weather_str: \n")
	f_final_report.write(str(val) + "\n")	
	f_final_report.write("\n")

	# weather_num:
	val = data_content[18]
	f_final_report.write("weather_num: \n")
	f_final_report.write(str(val) + "\n")	
	f_final_report.write("\n")

	# indicates successful output
	# print ("Final Report created successfully!\n")
	# print ("Use the following file path to access the .txt file: \n")
	# print (final_report + "\n")
	# print ("End of run for: " + run_name + "\n")

	return 	


#############################################################################################

# [Index CHART] function read_one_run returns the following in a tuple format:
# 0  - STARTseconds
# 1  - ENDseconds
# 2  - GPSseconds
# 3  - lon
# 4  - lat
# 5  - STARTdate0
# 6  - ACCseconds
# 7  - ax
# 8  - ay
# 9  - az
# 10 - IMseconds
# 11 - IMdates
# 12 - image_list_length
# 13 - IMax
# 14 - image_list
# 15 - light_of_day
# 16 - sharpness
# 17 - weather_str
# 18 - weather_num

def read_one_run(run_name, main_dir, frameRate, option = 0, extract_option = 6):

	# Sample input : read_one_run("20150806_172541_260_CMU", "/Users/lamwingchan/Desktop")
	# option 0 is for general run (default)
	# option 1 is specifically for kml run

	GPS_date_strings = []
	lat = []
	lon = []
	ng = 0

	ACC_date_strings = []
	ax = []
	ay = [] 
	az = []
	na = 0

	STARTseconds_array = []
	ENDseconds_array = []

	STARTdate_array = []
	ENDdate_array = []

	#these parameters are only true around Pittsburgh!
	dlon2meter =  84231 #delta longitudinal to meters
	dlat2meter = 111122 #delta latitude to meters
	ddeg2meter = 100000 #approx. for both of them

	good_data = 1

	STARTdate0 = 0 

	# Extract photos from mp4 video:
	extract_jpg_frm_mp4.extract_jpg_frm_mp4(main_dir, run_name, frameRate, extract_option)

	# the directory which contains all the data (*.txt files and images)
	dirdir = main_dir + '/' + run_name

	# we will first test if there are no images, that will save us time in
	# certain cases where the video recording was not working but the system
	# kept logging.
	image_list = glob.glob(dirdir + '/*.jpg')

	image_list_length = len(image_list)

	sharpness_detection_main(run_name, main_dir, image_list)

	if (image_list_length == 0): # no images
		good_data = 0
		print('Warning: no images!\n')


	else:

		log_file = dirdir + '/VID_' + run_name + '.log'

		filee = open(log_file)

		fid = filee.read()

		filee.close()

		s = ''

		for line in fid.splitlines():

			newline = line.split(" ")

			if (line[0] == '2'):

				if (newline[1][0:4] == 'GPS_'):
					# 20150806_172542_255: GPS_LAT_LONG 40.43569230408778 -79.9940946754624
					ng = ng + 1
					GPS_date_strings += [newline[0][0:-1]] # "20150806_172542_255"
					lat += [Decimal(newline[2])]
					lon += [Decimal(newline[3])]

				if (newline[1][0:4] == "LINE"):
					# 20150806_172541_781: LINEAR_ACCELERATION 7.26305 0.5133168 -0.20685902
					na = na + 1
					ACC_date_strings += [newline[0][0:-1]] # "20150806_172541_781"
					ax += [Decimal(newline[2])]
					ay += [Decimal(newline[3])]
					az += [Decimal(newline[4])]

			if (newline[0] == "Start"):
				# Start time:20150624_152835_244
				STARTdate_string = line.split(":")[1] # 20150624_152835_244
				(STARTdate_array_new, STARTseconds_array_new) = str2datenum(STARTdate_string,0)
				STARTdate0_date = str2datenum(STARTdate_string, 0, 1)
				STARTdate_array += [STARTdate_array_new]
				STARTseconds_array += [STARTseconds_array_new]
				STARTdate0 = STARTdate_array[0]

			if (newline[0] == "Stop"):
				# Stop time:20150806_172713_866
				ENDdate_string = line.split(":")[1] # 20150806_172713_866
				(ENDdate_array_new, ENDseconds_array_new) = str2datenum(ENDdate_string,STARTdate0)
				ENDdate_array += [ENDdate_array_new]
				ENDseconds_array += [ENDseconds_array_new]
				ENDdate0 = ENDdate_array[0]

			if (newline[0][0:4] == "Zoom"):
				# Zoom:1.0x
				zoom = Decimal(line.split(":")[1][0:3])


		if (ng > 1):

			GPSseconds_array = []
			GPSdate_array = []

			for i in xrange(len(GPS_date_strings)):

				(GPSdate_array_new, GPSseconds_array_new) = str2datenum(GPS_date_strings[i], STARTdate0)
				GPSdate_array += [GPSdate_array_new]
				GPSseconds_array += [GPSseconds_array_new]


			GPSdate0 = GPSdate_array[0]

			gps_file = dirdir + '/' + run_name + '-gps.txt'

			if (not os.path.isfile(gps_file)):

				fgps = open(gps_file, "w")

				gps_string = run_name + ": " + str(lon[0]) + ", " + str(lat[0]) + "\n"

				fgps.write(gps_string)

				weather_new(run_name, main_dir, STARTdate0_date, lat[0], lon[0])

		if (ng <= 1):

			good_data = 0

			print ('Warning: no or only one GPS!!\n')

		if (na > 0):

			ACCdate_array = []
			ACCseconds_array = []

			for i in xrange(len(ACC_date_strings)):
				(ACCdate_array_new, ACCseconds_array_new) = str2datenum(ACC_date_strings[i],STARTdate0)
				ACCdate_array += [ACCdate_array_new]
				ACCseconds_array += [ACCseconds_array_new]

			ACCdate0 = ACCdate_array[0]

		if (na <= 0):

			good_data = 0 

			print ('Warning: no linear ACC!\n')

		if (good_data == 1):

			# read images
			image_list = glob.glob(dirdir + '/*.jpg')
			image_list_length = len(image_list)

			if (image_list_length == 0): # no images

				good_data = 0

				print('Warning: no images!\n')

			else:
				# if the run directory contains only a subset of the images the number image_list_length
				# will not be the number of images that were recorded. In that case we
				# created the additional file im_num.txt with this number.
				im_num_file = dirdir + '/im_num.txt'

				if (os.path.isfile(im_num_file)):

					im_num_file_read = open(im_num_file)

					image_list_length = int(im_num_file_read.read())

				if image_list_length != 1:

					IMseconds_array = range(1,image_list_length + 1)

					seconds_delta = (ENDseconds_array[0] - STARTseconds_array[0]) / (image_list_length - 1)

					for i in xrange(image_list_length):
						# Making IMseconds increase linearly
						IMseconds_array[i] = STARTseconds_array[0] + ((IMseconds_array[i] - 1) * seconds_delta)

					IMdates_array = range(1,image_list_length + 1)

					for i in xrange(image_list_length):

						IMdates_array[i] = STARTdate0 + IMseconds_array[i] / 86400.0

					# interpolated GPS for each image:
					# this will make sure that the seconds are monotonically increasing:
					ind_mono = [1] * len(GPSseconds_array)
					for i in xrange(len(ind_mono) - 1):
						ind_mono[i + 1] = GPSseconds_array[i + 1] - GPSseconds_array[i]

					GPSseconds_array2 = [0] * len(GPSseconds_array)

					for i in xrange(len(GPSseconds_array)):
						if (ind_mono[i] > 0):
							GPSseconds_array2[i] = GPSseconds_array[i]

						if (ind_mono[i] <= 0):
							GPSseconds_array2[i] = None

					IMlat = interp(IMseconds_array, GPSseconds_array2,lat)

					IMlon = interp(IMseconds_array, GPSseconds_array2,lon)

					# Calculate speed of vehicle when the image was taken
					dIMlat = [0] * (len(IMlat))
					for i in xrange(len(dIMlat) - 1):
						dIMlat[i + 1] = (IMlat[i + 1] - IMlat[i]) * dlat2meter

					dIMlon = [0] * (len(IMlon))
					for i in xrange(len(dIMlon) - 1):
						dIMlon[i + 1] = (IMlon[i + 1] - IMlon[i]) * dlon2meter

					dIMsec = [0] * (len(IMseconds_array))
					for i in xrange(len(dIMsec) - 1):
						dIMsec[i + 1] = IMseconds_array[i + 1] - IMseconds_array[i]
					dIMsec[0] = dIMsec[1]

					dIMmeter = [0] * len(dIMlon)
					for i in xrange(len(dIMmeter)):
						dIMmeter[i] = math.sqrt((dIMlat[i] * dIMlat[i]) + (dIMlon[i] * dIMlon[i]))

					IMspeed = [0] * (len(dIMmeter))
					for i in xrange(len(IMspeed)):
						IMspeed[i] =  dIMmeter[i] / dIMsec[i]
					IMspeed[0] = IMspeed[1]

					# this will make sure that the seconds are monotonically increasing:
					ind_mono = [1] * (len(ACCseconds_array))
					for i in xrange(len(ind_mono) - 1):
						ind_mono[i + 1] = ACCseconds_array[i + 1] - ACCseconds_array[i]

					if (min(ind_mono) > -2):
						ACCseconds_array2 = [0] * len(ACCseconds_array)
						for i in xrange(len(ACCseconds_array)):
							if (ind_mono[i] > 0):
								ACCseconds_array2[i] = ACCseconds_array[i]

							if (ind_mono[i] <= 0):
								ACCseconds_array2[i] = None

						IMax  = interp(IMseconds_array, ACCseconds_array2, ax)
						
					if (min(ind_mono) <= -2):
						print ('Something seriously wrong with time!\n')

				if image_list_length == 1:

					seconds_delta = 0

					IMseconds_array = range(1,image_list_length + 1)

					IMseconds_array[0] = STARTseconds_array[0]

					IMdates_array = range(1,image_list_length + 1)

					IMdates_array[0] = STARTdate0 

					ind_mono = [1] * len(GPSseconds_array)
					for i in xrange(len(ind_mono) - 1):
						ind_mono[i + 1] = GPSseconds_array[i + 1] - GPSseconds_array[i]

					GPSseconds_array2 = [0] * len(GPSseconds_array)

					for i in xrange(len(GPSseconds_array)):
						if (ind_mono[i] > 0):
							GPSseconds_array2[i] = GPSseconds_array[i]

						if (ind_mono[i] <= 0):
							GPSseconds_array2[i] = None

					IMlat = interp(IMseconds_array, GPSseconds_array2,lat)

					IMlon = interp(IMseconds_array, GPSseconds_array2,lon)

					IMspeed = [None]

					IMax = [np.float64(ax[0])]


	# # day-night-dawn-dusk ##############################################

	# ephem use the UTC time. 
	# it assumes that dawn/dusk is +-30 mins of sunrise/sunset.
	# format input as ('40.4444','-79.555','201306282320443252')

	isNight = 0
	isDay = 0
	isDawnDusk = 0

	isDaySave = is_Daylight_Savings(STARTdate_string)

	hour_offset = 5 - int(isDaySave)

	# The following code is taken from Jina:
	sun =ephem.Sun()
	# ephem has the location of 122 cities. check if your city is there.
	pittsburgh = ephem.Observer()
	pittsburgh.lon = lon[0]
	pittsburgh.lat = lat[0]
	pittsburgh.pressure = 0	
	imageTime = datetime.strptime(STARTdate_string, "%Y%m%d_%H%M%S_%f")
	pittsburgh.date = datetime.strptime(STARTdate_string, "%Y%m%d_%H%M%S_%f")
	# convert UTC time to localtime. It already takes into consideration the Daylight Time.
	# refer: http://rhodesmill.org/pyephem/date.html

	try: 
		rising1 = ephem.localtime(pittsburgh.next_rising(sun))
		rising2 = ephem.localtime(pittsburgh.previous_rising(sun))
		setting1 = ephem.localtime(pittsburgh.next_setting(sun))
		setting2 = ephem.localtime(pittsburgh.previous_setting(sun))

		rising = rising1 if imageTime.day == rising1.day else rising2
		setting = setting1 if imageTime.day == setting1.day else setting2

		if ((imageTime.hour >= 22) or (imageTime.hour <=2)): 
			isNight = 1
			#return 'isNight'

		elif (imageTime > setting + datetime.timedelta(minutes = 30)): #sunset--midnight
			isNight = 1
			#return 'isNight'

		elif ((imageTime < setting + datetime.timedelta(minutes = 30)) and 
			(imageTime > setting + datetime.timedelta(minutes = -30))): 
			isDawnDusk = 1
			#return 'isDusk'

		elif ((imageTime < rising + datetime.timedelta(minutes = 30)) and 
			(imageTime > rising + datetime.timedelta(minutes = -30))):  
			isDawnDusk = 1 
			#return 'isDawn'

		elif ((imageTime > rising + datetime.timedelta(minutes = -30)) and 
			(imageTime < setting + datetime.timedelta(minutes = -30))):
			isDay = 1
			#return 'isDay'

		else: 
			isNight = 1
			#return 'isNight'

	except (ephem.AlwaysUpError):
		#return 'isDay'
		isDay = 1

	except (ephem.NeverUpError):
		#return 'isNight'
		isNight = 1

	light_of_day = 0

	if (isDay):
		light_of_day = 1

	elif (isDawnDusk):
		light_of_day = 2

	elif (isNight):
		light_of_day = 3


	# read the sharpness ##############################################

	sharpness_file = dirdir + '/' + run_name + '-sharpness.txt'

	sharpness_array = []

	if (not os.path.isfile(sharpness_file)) or (image_list_length == 0):
		print 'Warning: no %s\n' % (sharpness_file)

	else:
		sharpness_dats = open(sharpness_file)

		sharpness_dats_content = sharpness_dats.read()

		sharpness_dats.close()

		for sharpnessline in sharpness_dats_content.splitlines():

			sharpness_array += [Decimal(sharpnessline.split(" ")[1])]


	# weather data ##############################################

	weather_file = dirdir + '/' + run_name + '-weather_short.txt'

	if (not os.path.isfile(weather_file)):
		print 'Warning: no %s\n' % (weather_file)
		weather_str = 'none'

	else:
		weather_dats = open(weather_file)

		weather_str = weather_dats.read()

		weather_dats.close()

		weather_num = 0

		if (weather_str == " "):
			weather_str = 'none'

	weather_num = 0

	if (weather_str == 'none'):
		weather_num = 1

	elif (weather_str == 'Heavy Rain'):
		weather_num = 2

	elif (weather_str == 'Rain'):
		weather_num = 3

	elif (weather_str == 'Light Snow'):
		weather_num = 4

	elif (weather_str == 'Light Rain'):
		weather_num = 5

	elif (weather_str == 'Flurries'):
		weather_num = 6

	elif (weather_str == 'Drizzle'):
		weather_num = 7

	elif (weather_str == 'Foggy'):
		weather_num = 8

	elif (weather_str == 'Clear'):
		weather_num = 9

	elif (weather_str == 'Dry'):
		weather_num = 10

	elif (weather_str == 'Partly Cloudy'):
		weather_num = 11

	elif (weather_str == 'Mostly Cloudy'):
		weather_num = 12 

	elif (weather_str == 'Overcast'):
		weather_num = 13

	else:
		print "Unknown weather: %s\n" % (weather_str)

	data_content = (STARTseconds_array, ENDseconds_array, GPSseconds_array, lon, lat, STARTdate0, ACCseconds_array, \
			ax, ay, az, IMseconds_array, IMdates_array, image_list_length, IMax, image_list, \
			light_of_day, sharpness_array, weather_str, weather_num)

	main(run_name, main_dir, data_content)

	if (option == 0 and len(sharpness_array) > 0 and good_data == 1 and weather_num > 0):
		# general output
		return (STARTseconds_array, ENDseconds_array, GPSseconds_array, lon, lat, STARTdate0, ACCseconds_array, \
			ax, ay, az, IMseconds_array, IMdates_array, image_list_length, IMax, image_list, \
			light_of_day, sharpness_array, weather_str, weather_num)

	if (option == 1 and len(sharpness_array) > 0 and good_data == 1 and weather_num > 0):
		# special output for kml
		image_date_list = make_imagedate_list(STARTdate0_date, seconds_delta, image_list_length)

		if image_list_length == 1 or extract_option == 1 or extract_option == 3 or extract_option == 5:
			return (light_of_day, image_list, IMlon.tolist() + [lat[1]], IMlat.tolist() + [lon[1]], image_date_list, sharpness_array, image_list_length)

		else:
			return (light_of_day, image_list, IMlon.tolist(), IMlat.tolist(), image_date_list, sharpness_array, image_list_length)


	else:
		print ("Code is not running properly!")
		return


#############################################################################################
# RUN THE CODE AS FOLLOWS: 

# Run general output read_one_run by uncommenting this line: 
# read_one_run("20150806_172541_260_CMU", "/Users/lamwingchan/Desktop/navlab", 7, 0 , 6)

# Run kml output read_one_run by uncommenting this line: 
# print read_one_run("20150806_172541_260_CMU", "/Users/lamwingchan/Desktop/navlab", 7, 1, 6)

# Run main by uncommenting this line: 
# main("20150806_172541_260_CMU", "/Users/lamwingchan/Desktop/navlab", 7, 0, 6)
#############################################################################################


# x = np.float64(Decimal(24.34))
# print str(x)
# # print type(x)
# # print type(float(x))

# x = [np.float64(Decimal(24.34))]
# for val in x:
# 	print val

