import cv2
import time
import numpy 
import os
import sys
import glob
from moviepy.editor import *
import subprocess as sp
import matplotlib.pyplot as plt
import scipy.misc
import math

def extract_jpg_frm_mp4(main_dir, run_name, frameRate, option):

	dirdir = main_dir + '/' + run_name
	mp4_file = dirdir + '/VID_' + run_name + '.mp4'

	# path to ffmpeg.exec
	# CHANGE ME!
	FFMPEG_BIN = "/Library/Python/2.7/site-packages/ffmpeg"
	
	#########################################################
	# if ffmpeg is not installed, openCV is be used instead:

	if not os.path.exists(FFMPEG_BIN):

		if option == 3:
			print ("ERROR: ffmpeg is not installed. OpenCV is used instead!")
			print ("Install ffmpeg and update file path if ffmpeg is preferred.")
			option = 5

		if option == 4:
			print ("ERROR: ffmpeg is not installed. OpenCV is used instead!")
			print ("Install ffmpeg and update file path if ffmpeg is preferred.")
			option = 6

	#########################################################

	# # High definition (OpenCV):
	if option == 1:
		# cv2
		# # Output a single frame from the video into an image file:
		cv2_ver = (cv2.__version__).split('.')[0]
		capture = cv2.VideoCapture(mp4_file)
		success, image = capture.read()
		cv2.imwrite(dirdir + '/' + run_name + '_' + '0001' + '.jpg', image)
		capture.release()

	# if option == 6:
	# 	cv2_ver = (cv2.__version__).split('.')[0]
	# 	if int(cv2_ver)  < 3 :
	# 		# cv2
	# 		# # Output X image every second
	# 		capture = cv2.VideoCapture(mp4_file)
	# 		fps = (capture.get(cv2.cv.CV_CAP_PROP_FPS))
	# 	else: 
	# 		capture = cv2.VideoCapture(mp4_file)
	# 		fps = (capture.get(cv2.CAP_PROP_FPS))

	if option == 2:
		# cv2
		# # Output X image every second

		cv2_ver = (cv2.__version__).split('.')[0]
		if int(cv2_ver)  < 3 :
			# cv2
			# # Output X image every second
			capture = cv2.VideoCapture(mp4_file)
			fps = (capture.get(cv2.cv.CV_CAP_PROP_FPS))
		else: 
			capture = cv2.VideoCapture(mp4_file)
			fps = (capture.get(cv2.CAP_PROP_FPS))

		i = 0
		success = True
		saved_pic_num = 1

		while (success):
			i += 1
			success,image = capture.read()
			if success:
				if (i % int(fps / (frameRate))) == 0:
					cv2.imwrite(dirdir + '/' + run_name + '_' + str(saved_pic_num).zfill(4) + '.jpg', image)
					saved_pic_num += 1
		capture.release()

	# # Low definition (ffmpeg):
	if option == 3:
		# (ffmpeg)
		# # Output a single frame from the video into an image file:
		sp.check_output([FFMPEG_BIN, "-i", mp4_file, "-ss",  "00:00:00.000", "-vframes", "1", dirdir + '/' + run_name + '_' + '0001' + '.jpg'])

	if option == 4:
		# (ffmpeg)
		# # Output X image every second
		fps_string = 'fps = ' + str(frameRate)
		sp.check_output([FFMPEG_BIN, '-i', mp4_file, '-vf', fps_string, dirdir + '/' + run_name + '_' + '%04d' + '.jpg'])

	if option == 5:
		# cv2
		# # Output a single frame from the video into an image file:
		capture = cv2.VideoCapture(mp4_file)
		success, image = capture.read()
		cv2.imwrite(dirdir + '/' + run_name + '_' + '0001' + '.jpg', image, [cv2.IMWRITE_JPEG_QUALITY,40])
		capture.release()

	if option == 6:
		# cv2
		# # Output X image every second
		
		cv2_ver = (cv2.__version__).split('.')[0]
		if int(cv2_ver)  < 3 :
			# cv2
			# # Output X image every second
			capture = cv2.VideoCapture(mp4_file)
			fps = (capture.get(cv2.cv.CV_CAP_PROP_FPS))
		else: 
			capture = cv2.VideoCapture(mp4_file)
			fps = (capture.get(cv2.CAP_PROP_FPS))

		i = 0
		success = True
		saved_pic_num = 1

		while (success):
			i += 1
			success,image = capture.read()
			if success:
				if (i % int(fps / (frameRate))) == 0:
					cv2.imwrite(dirdir + '/' + run_name + '_' + str(saved_pic_num).zfill(4) + '.jpg', image, [cv2.IMWRITE_JPEG_QUALITY,40])
					saved_pic_num += 1
		capture.release()

	return 0



