import read_one_run
import write_your_kml
import extract_jpg_frm_mp4
import os

def MAIN(main_dir, frameRate, kml_option, extract_option):

	for run_name in os.listdir(main_dir):
		if run_name[0] == '2':
			# 1. extract photos
			# 2. create final report
			# 3. create gps.txt
			# 4. create sharpness.txt
			# 5. create weather-short.txt
			read_one_run.read_one_run(run_name, main_dir, frameRate, 0, extract_option)

	# 6. create kml in main dir
	write_your_kml.write_your_kml_main(main_dir, frameRate, extract_option, kml_option)

	print ("Successful Run!" + "\n")
	print ("You should find the following in each sub-directories:")
	print ('1. Photos' + "\n" + '2. Final Report' + "\n" + '3. gps.txt' + "\n" + '4. sharpness.txt' + "\n" + '5. weather-short.txt' + "\n")
	print ("You should find the following in the main directory:")
	print ('1. hi-my-kml.kml' + "\n")

	return 0

# kml option :
# 0. all images
# 1. only latest images at each location 
# 2. only the sharpness image every 10 meters 
# 3. both latest and every 10 meters (RECOMMENDED! most efficient set)

# extract_option :
# 1. High resolution - single frame (openCV)
# 2. High resolution - multiple frames at a given rate (openCV)
# 3. Low resolution - single frame (ffmpeg)
# 4. Low resolution - multiple frames at a given rate (ffmpeg)
# 5. Low resolution - single frame (OpenCV)
# 6. Low resolution - multiple frames at a given rate (OpenCV)

# Parameters: main_dir, frame rate, kml option, extract option:
# INPUT HERE!
MAIN("/Users/lamwingchan/Desktop/navlab", 1, 1, 6)

