/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_eth_tx_int.h
 *
 * = DESCRIPTION
 *      This file contains wrapper APIs for interfacing with the Ethernet media driver.
 *      component.
 *
 * = CHANGE HISTORY
 *      04/31/2003 - Created.
 *
 * ============================================================================
 * $Id: ix_cc_eth_tx_drv_wrapper.h,v 1.2 2003/07/23 19:02:55 ktseng Exp $
 */

#if !defined(__IX_CC_ETH_TX_DRV_WRAPPER_H__)
#define __IX_CC_ETH_TX_DRV_WRAPPER_H__


/**
 * System defined include files required.
 */


/* device driver common includes */
#include "ixf1104ce_linux_driver.h"
#include "ixf1104ce_ioctl.h"
#include "ixf1104ce_internal.h"



/**
 * User defined include files required.
 */


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */


#if (_IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_)

typedef void (*_ix_cc_eth_tx_drv_cb)(void *, ix_uint32, ix_uint32);

gbe_mac_error GbEMAC_DeviceStart(
    uint32 arg_PortMask,
    uint32 *arg_Handle,
    uint32 arg_mode);

gbe_mac_error GbEMAC_DeviceStop(
    uint32 arg_PortMask,
    uint32 *arg_Handle);

gbe_mac_error GbEMAC_Ioctl(
    uint32 *arg_Handle, 
    uint32 ioctl_command, 
    void *ioctl_struct);

unsigned int GbEMAC_Callback(
    uint32 *argHandle,
    void * arg_pCallback,
    void * arg_pUserContext);

#endif /* _IX_OS_TYPE_ == _IX_OS_LINUX_KERNEL_ */

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_ETH_TX_DRV_WRAPPER_H__) */
