/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation.All rights reserved.
 *
 *
 * = PRODUCT
 *      Intel(r) IXA SDK 3.0 for the IXP2000 Network Processor, Release 6
 *
 * = FILENAME
 *      internal_stkdrv.h
 *
 * = DESCRIPTION
 *      Internal macros and functions shared among the stack driver components.
 *
 * = AUTHOR
 *       Aaron Luk
 *       aaron.luk@intel.com
 *
 * = CHANGE HISTORY
 *      11/25/2002 1:29:51 AM - creation time
 *
 * ============================================================================
 * $Id: internal_stkdrv.h,v 1.3 2002/12/17 19:51:45 asluk Exp $
 * $History: $
 */

#if !defined(__INTERNAL_STKDRV_H__)
#define __INTERNAL_STKDRV_H__


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

/**
 * MACRO NAME: _IX_CC_STKDRV_GET_HANDLER_MODULE
 *
 * DESCRIPTION: Finds the handler module with the given handler ID.
 *
 * @Param:  - IN arg_HandlerId - ID of the desired handler module.
 * @Param:  - INOUT - arg_pHandlerModule - pointer to the list of
 *          handler modules to traverse.  If we find the desired
 *          handler module, it will be returned in this pointer, otherwise
 *          it will be NULL.
 *
 * @Return:
 */
#define _IX_CC_STKDRV_GET_HANDLER_MODULE( \
                                         arg_HandlerId, \
                                         arg_pHandlerModule \
                                       ) \
    do \
    { \
        while((arg_pHandlerModule) != NULL) \
        { \
            if((arg_pHandlerModule)->id == (arg_HandlerId)) \
                break; \
            (arg_pHandlerModule) = (arg_pHandlerModule)->pNextHandler; \
        } \
    } \
    while(0)

/**
 * MACRO NAME: _IX_CC_STKDRV_GET_PHYSICAL_IF
 *
 * DESCRIPTION: Performs a linear search through a list of ports to find
 *              the port with a specific port ID.
 *
 * @Param:  - IN arg_portID - ID of the desired port.
 * @Param:  - INOUT arg_pPhysicalIf - pointer to the list of
 *          ports to traverse.  If we find the desired
 *          port structure, it will be returned in this pointer, otherwise
 *          it will be NULL.
 *
 * @Return:
 */
#define _IX_CC_STKDRV_GET_PHYSICAL_IF( \
                                      arg_portId, \
                                      arg_pPhysicalIf \
                                      ) \
    do \
    { \
        /* Traverse the list of ports to find the port with the given port ID. */ \
        while ((arg_pPhysicalIf) != NULL) \
        { \
            if((arg_pPhysicalIf)->pPhysicalIfInfo->portId == (arg_portId)) \
                break; \
            (arg_pPhysicalIf) = (arg_pPhysicalIf)->pNextPhysicalIf; \
        } \
    } \
    while(0)


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__INTERNAL_STKDRV_H__) */
