/***********************************************************************************
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 ************************************************************************************
 *
 * 		File Name: scheduler_pkt.h
 * 
 * 		Purpose:	  Header file for Egress DRR scheduler 
 *
 ************************************************************************************
 *
 * 		History:
 *
 * 		Date			Comment										By
 *		---------------------------------------------------------------------------
 *
 *		03/17/02		Created										Uday Naik
 *
 *************************************************************************************/


#ifndef __EGRESS_SCHEDULER_DRR_H__
#define __EGRESS_SCHEDULER_DRR_H__

#ifdef USE_IMPORT_VAR

 .import_var SCHED_WEIGHT_CREDIT_BASE
 .import_var SRAM_ZERO_BLOCK

#else

/* Need 16 words of 0 to initialize xfer registers 0..15. Set this up correctly. 
 * Right now points to channel 0, location 0
 */

#ifndef			SRAM_ZERO_BLOCK
#define 		SRAM_ZERO_BLOCK   		0
#endif

#endif


/*************************************************************************************
 *
 * Constants for the algorithm. These should be replaced with import vars to make 
 * the code more configurable
 *
 ************************************************************************************/

/* Number of ports */
#ifndef NUMBER_OF_PORTS
#define 		NUMBER_OF_PORTS              16
#endif

/* Bit vector that says which ports have credit. Set this up appropriately. For e.g.
 * if there are only 4 ports, then set it up as 0xf. For now we will set up all 16 
 * ports
 */

#define 		PORT_INITIAL_CREDIT_VECTOR	 0xffff


/* Number of queues per port */

#define 		NUMBER_OF_QUEUES_PER_PORT    16

/* Queue Mask */

#define_eval    QUEUE_MASK					((1 << NUMBER_OF_QUEUES_PER_PORT) - 1)

/* The port and queue in the port are encoded into one id. LSB 4 bits are used for 
 * queue id and then 4 bits for port id
 */

#define 		NUMBER_OF_BITS_FOR_QUEUE	4

/* bits for port */
#ifndef NUMBER_OF_BITS_FOR_PORT
#define 		NUMBER_OF_BITS_FOR_PORT		4
#endif

/* MTU for the media */

#define_eval 	MTU							(9*1024)

/* Number of bits used to encode the packet size */

#define 		BITS_FOR_PACKET_LENGTH          7

/* units in which packet size and queue credit increments are counted */

#define_eval	CHUNK_SIZE                   (1 << BITS_FOR_PACKET_LENGTH)

/*
 * Location in Local Memory where start Port Data structures. In fact this is a starting offset for the 
 * Scheduler.
 */
#ifndef PORT_LM_BASE_OFFSET
#define	PORT_LM_BASE_OFFSET				0x0
#endif

/* location in local memory where the data structures per queue are stored
 * This is computed by using 32 bytes for the port structure * number of ports. 
 * This is where the port data structures end. 
 */

#define_eval    QUEUE_LM_BASE_OFFSET         (PORT_LM_BASE_OFFSET + (NUMBER_OF_PORTS << 5) )

/*
 * Ring id for scratch ring (from system.h)
 */

#define_eval 		RING_ID					SCHEDULER_RING_OUT

/*
 * Ring full value for testing branch state. This depends on which ring you are using
 * Eventhough 0-15 rings are possible, the "ring full"input state can be used
 * only on rings 0-11. i.e SCR_Ring#_Full is valid only for # = 0-11.
 */

#if (RING_ID > 11)

#error			"For Ring > 11, we cannot use the SCR_Ring#_Full input state"

#else

#define_eval	RING_FULL_VALUE				SCR_Ring/**/RING_ID/***/_Full
	
#endif

/*
 * Ring size [31:30]. Hardware representation
 * 00 = 128
 * 01 = 256
 * 10 = 512
 * 11 = 1024
 */
#define RING_SIZE_128 		0
#define RING_SIZE_256		1
#define RING_SIZE_512		2
#define RING_SIZE_1024		3

/* Maximum number of packets in flight */
/* MAX_IN_FLIGHT is 16 for MPHY_16 mode, and 32 for other modes */
#if TX_PHY_MODE == MPHY_16	
#define 		MAX_IN_FLIGHT			16
#else	/* not MPHY_16  mode */
#define 		MAX_IN_FLIGHT			32
#endif /* end of #if TX_PHY_MODE == MPHY_16 */	


				
/*************************************************************************************
 *
 *
 * For each port there are 8 words in local memory. (16 * 8 = 128 words)
 *
 *
 * PortScheduleVector			: Bit vector for which queues have credit > 0 
 *								  (Uses NUMBER_OF_QUEUES_PER_PORT bits in the vector)
 *
 * PortCurrentQueueMask         : Used to round robin among queues in a port 
 *
 * PortQueueEmptyVector			: Bit vector for which queues have data for a port 
 *
 * PortPacketsScheduled			: Packets scheduled for this port
 *
 * PortCurrentCredit			: Current WRR credit for port
 *
 * PortWeight:					: Weight for the port
 *
 * Reserved[2]					: Reserved
 *
 *
 * For each queue there are 2 words in local memory (256 * 2 = 512 words)
 *
 * QueueCurrentCredit			: Current Credit for the queue
 *
 * QueueCreditIncrement         : The credit increment to be given to a queue at the
 *								  end of every round
 *
 *
 *************************************************************************************/

/* The below define fields in the port data structure */

#define PORT_SCHEDULE_VECTOR_INDEX			0
#define PORT_CURRENT_QUEUE_MASK_INDEX		1
#define PORT_QUEUE_EMPTY_VECTOR_INDEX		2
#define PORT_PACKETS_SCHEDULED_INDEX		3
#define PORT_CURRENT_CREDIT_INDEX			4
#define PORT_WEIGHT_INDEX					5

/* The below define fields in the queue data structure */

#define QUEUE_CURRENT_CREDIT_INDEX			0
#define QUEUE_CREDIT_INCREMENT_INDEX		1			

/*************************************************************************************/


#endif 		/* __EGRESS_SCHEDULER_DRR_H__ */


/*************************************************************************************/