/////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                 
//
// Change History
// --------------
//
// Date			Description											Whom
// ------------------------------------------------------------------------------------
//
// 11/11/01    	Created for Sausalito								Uday Naik
// 10/06/02		Modified for IXP2800								Prashant Chandra
//
/////////////////////////////////////////////////////////////////////////////////////

#ifndef __CSIX_SCHEDULER_H__
#define __CSIX_SCHEDULER_H__

#include <dl_system.h>

/////////////////////////////////////////////////////////////////////////////////////
//
// Constants for the algorithm. These should be replaced with import vars to make the code
// more configurable
//
/////////////////////////////////////////////////////////////////////////////////////


// Number of fabric ports

#define 		NUM_PORTS       	32
#define 		NUM_PORTS_SHF		5

// Number of classes per port

#define 		NUM_CLASSES			8
#define			NUM_CLASSES_SHF		3


// location in local memory where the data structures per queue are stored. 
// Each queue data structure is 2 words and there are a total of 256 queues
//
//  1                      23                                   8
// |-+------------------------------------------------+-------------------|
// |F|                 cell_count                     |     next_ind      |
// |-+------------------------------+-----------------+-------------------|
// |          weight                |               credit                |
// |--------------------------------+-------------------------------------|
// weight		WRR weight allocated to the queue 
// credit		current weight for the queue
// cell_count	total cell count of CFRAMES in the queue
// next_ind		index of the next active queue for the port
// F			flow control bit -- set when the queue has flow control turned on
// R            reserved bit --- must be 0

#define			QUEUE_FC_BIT		31
#define 		QUEUE_LM_BASE		0

//
// Maximum number of packets (C-Frames actually) in flight
//

#define MAX_IN_FLIGHT		47

//
// Address of the Tx sequence number register used to read tbufs transmitted
//

#define TX_SEQUENCE_0 		0x60

/////////////////////////////////////////////////////////////////////////////////////
//
// Global Data Structures
//
/////////////////////////////////////////////////////////////////////////////////////

// Current and previous queue pointers for the queue active list and for the list of queues that have completed the current WRR round.
//
//  1       4               11                 5                 11
// |-+-------------+-----------------+-----------------+------------------|
// |I|   rsvd1     |  prev_q_addr    |      rsvd2      |    cur_q_addr    |
// |-+-------------+-----------------+-----------------+------------------|
//
// prev_q_addr	previous active queue in the linked list (11 bit index into queue data structure)
// cur_q_addr	next active queue in the linked list (11 bit index into the queue data structure)
// I            inactive flag --- indicates list is empty
// rsvd1,rsvd2  reserved fields --- must be 0

#define LIST_INACTIVE_BIT      31

.reg @active_list
.reg @wrr_round_complete

// Some global constants are registers
.reg wrr_weights_base

// 
// Number of c-frames in flight (scheduled but not transmitted)
//

.reg @packets_in_flight

//
// Number of c-frames scheduled by scheduler 
//

.reg @packets_scheduled			


#endif // __CSIX_SCHEDULER_H__

/////////////////////////////////////////////////////////////////////////////////////