/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_sched.h
 *
 * = DESCRIPTION
 *
 * = CHANGE HISTORY
 *      8/16/2002 - Created
 * $Id: ix_cc_sched.h,v 1.12 2003/11/14 21:34:45 rranjeet Exp $
 **/

#if !defined(__IX_CC_SCHED_H__)
#define __IX_CC_SCHED_H__

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

   

/* number and name of Sched symbols to patch */
#if (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)
#if defined(IX_PLATFORM_2801)
/*
 * Temporary fix - remove when 2800 scheduler will be integrated in uCode
 */
#define IX_SCHED_NUM_PATCH_SYMBOLS                  1  /* number of symbols to patch - 1 for each scheduler */
#else /* IX_PLATFORM_2801 */
#define IX_SCHED_NUM_PATCH_SYMBOLS                  0
#endif /* IX_PLATFORM_2801 */
#else
#define IX_SCHED_NUM_PATCH_SYMBOLS                  1  /* number of symbols to patch - 1 for each scheduler */
#endif /* (_IX_HARDWARE_TYPE_ == _IX_HW_2800_) */

#define IX_SCHED_SYMBOL_VOQ_CREDIT_BASE         "SCHED_VOQ_CREDIT_BASE"
#define IX_SCHED_SYMBOL_WEIGHT_CREDIT_BASE      "SCHED_WEIGHT_CREDIT_BASE"

/* define strings for repository access */
#define REPOSITORY_PATH_SRAM_CHANNEL_NUM                "System_Properties/SRAM_CHANNEL_NUM"
#define REPOSITORY_PATH_INGRESS_EGRESS                  "INGRESS_EGRESS"
#define REPOSITORY_PATH_SCHEDULER_TYPE                  "SCHED/SCHEDULER_TYPE"
#define REPOSITORY_PATH_SCHED_SCHED_UENG_NUM            "SCHED/SCHED_UENG_NUM"
#define REPOSITORY_PATH_SCHED_NUMBER_OF_PORTS           "SCHED/NUMBER_OF_PORTS"
#define REPOSITORY_PATH_SCHED_VOQ_WEIGHTS_PER_PORT      "SCHED/VOQ_WEIGHTS_PER_PORT"
#define REPOSITORY_PATH_SCHED_VOQ_WEIGHT_VALUE          "SCHED/VOQ_WEIGHT_VALUE"
#define REPOSITORY_PATH_SCHED_PKT_WEIGHT_VALUE          "SCHED/PKT_WEIGHT_VALUE"
#define REPOSITORY_PATH_SCHED_QUEUE_PORT_SIZE           "SCHED/QUEUE_PORT_SIZE" /* number of queues per port */

/* enums for scheduler types */
    
typedef enum ix_e_sched_type
{
    IX_CSIX_SCHEDULER,  /* now runs on ingress - scheduler for csix cells */
    IX_PACKET_SCHEDULER /* now runs on egress scheduler - scheduler for Tx packets */
}ix_sched_type;
    
    

#define IX_CSIX_SCHED_WEIGHT_LIST_SIZE                  1024 /* size of list with weight entries - 1024 = 16 weights
                                                        * 64 blades */
#define IX_CSIX_SCHED_CLASSES_PER_PORT                  16   /* default value for ingress scheduler */
#define IX_PKT_SCHED_MAX_PORTS                          16 /* max number of ports */
#define IX_PKT_SCHED_MAX_QUEUES                         16 /* 16 credit queues per port*/
#define IX_SCHED_DRR_MAX_CREDIT                         -1 /* maximum value for credit */


#if defined (IX_DEBUG)
    #define IX_SCHED_DEBUG   1
#endif

#if 0
#if defined (IX_INCLUDE_REGISTRY)
#undef IX_INCLUDE_REGISTRY
#endif
#endif
/* configuration items for Scheduler Core Component in case of no registry*/
#if !defined (IX_INCLUDE_REGISTRY)
    #define IX_SCHED_TYPE                  IX_CSIX_SCHEDULER   

#if (_IX_HARDWARE_TYPE_ == _IX_HW_2800_)
    #define IX_SCHED_UENG_NUM              0x06 /* ME 0x06 */
#else /* (_IX_HARDWARE_TYPE_ != _IX_HW_2800_) */
    #define IX_SCHED_UENG_NUM              0x10
#endif /* (_IX_HARDWARE_TYPE_ == _IX_HW_2800_) */

    #define IX_SCHED_NUMBER_OF_PORTS       64  /* 64 for CSIX, 16 for PACKET */
    #define IX_SCHED_ING_VOQ_SIZE          1024
    #define IX_SCHED_ING_VOQ_WEIGHTS_PORT  1
    #define IX_SCHED_ING_WEIGHT_VALUE      1
    #define IX_SCHED_EG_PORT_QUEUE_SIZE    256
    #define IX_SCHED_EG_WEIGHT_VALUE       1
    #define IX_SCHED_SRAM_CHANNEL_NUM      0
#endif

/* end of configuration for microblock */


/* Scheduler core  data structures */


typedef struct ix_s_cc_sched_ublock_config
{
        /* SRAM channel */
        ix_uint32 	sram_channel_num; 
        /* microengine number the microblock is running on */
        ix_uint32	ueng_number;
        /* number of ports - both for ingress and egress */
        ix_uint32   number_of_ports; /* should no exceed 64 for ingress and 16 for egress */
        /* number of VOQ for csix scheduler - currently 1024 queues*/
        ix_uint32	ingress_voq_size ; 
        /* number of weights per port - this field for same weight distribution used for all ports - 
           currently 16 per port */
        ix_uint32	ingress_voq_weights_per_port; /*how many weights from 16 available is used */ 
        ix_uint32   ingress_weight_value; /* value the same accross all weights */
        /* value of weights for the egress ports */
        ix_uint32	egress_weight_value;
        /* total number of queues */
        ix_uint32	egress_queue_port_size;
        /* base of the array of virtual output queues - SRAM memory*/
        /* passing physical offset into the SRAM channel */
        ix_uint32	base_offset ; 
        /* store virtual address to free it on shutdown */
        void*       virtual_base;
}ix_cc_sched_ublock_config;



/* Scheduler context data structure */
typedef struct ix_s_cc_sched_context
{
    ix_uint32               ingressEgress;       /* indicates ingress (0) or egress (1) side we are running on */
    ix_cc_sched_ublock_config*	pUblockConfig;   /* pointer to the microblock configuration structure */
    ix_cc_handle			hSchedHandle;	     /* handle of Scheduler produced by the execution engine */	
    ix_sched_type           schedulerType; /* Now: CSIX type for Ingress, Packet Type for Egress, will expand 
                                            in future  */
}ix_cc_sched_context;

/* Scheduler specific error codes */

enum ix_cc_sched_error {
    IX_CC_SCHED_ERROR_FIRST = IX_ERROR_MAKE_GROUP(CC_SCHED),
    IX_CC_SCHED_ERROR_REPOSITORY_OPEN,
    IX_CC_SCHED_ERROR_REPOSITORY_READ,
    IX_CC_SCHED_ERROR_VIRTUAL_TO_PHYSICAL,
    IX_CC_SCHED_ERROR_PATCH_SYMBOLS,
    IX_CC_SCHED_ERROR_FREE_MEM,
    IX_CC_SCHED_INVALID_HANDLE,
    IX_CC_SCHED_ERROR_LAST
};

/*
 *
 * Prototypes for functions invoked by CCI.
 */

/*
 *
 * Prototype for initialization function invoked by CCI.
*/
ix_error ix_cc_sched_init(ix_cc_handle arg_hCcHandle, void **arg_ppContext);

/*
 *
 * Prototype for shut down function invoked by CCI.
*/
ix_error ix_cc_sched_fini(ix_cc_handle arg_hCcHandle, void *arg_pContext);

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_SCHED_H__) */


















