#ifndef _ATM_TM_SHAPER_UC_
#define _ATM_TM_SHAPER_UC_

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/

/*
 *      File Name: atm_tm_shaper.uc                                         
 *                                                                   
 *      Description: This is the main file for TM4.1 GCRA based shaper. 
 *                                                                   
 *      History: ver 1.0                                             
 *
 */


#include <dl_system.h>
#include <atm_tm.h>
#include <atm_tm_thread_init.uc>
#include <atm_tm_shaper_init.uc>
#include <atm_tm_shaper_util.uc>


	//Signal definitions

	.sig volatile next_thread_sig	//inter-thread signal

	.addr next_thread_sig NEXT_THREAD_SIGNAL_VAL	//numeric value for this signal

	.reg next_thread_sig_csr_val	//register to store the next thread signal

	.reg _gcra_param_sram_base	//base addr in SRAM for storing traffic descriptors

    //Register definitions
    .reg mask_upper15		//bit masking register
    .reg mult_fac 			//multiply factor need to divide to obtain the cell tx slot
    // Mask registers
    .reg mask_for_port_extraction
    .reg mask_for_mul_result
    .reg mask_for_thmask_extraction   

	.reg @sched_tstamp			// scheduler timestamp low
	.reg @sched_tslot			// scheduler time in transmission slots
	.reg @ring_delay			// The delay in communication between shaper & scheduler

    .reg @_indirect_read9

	.reg global tmp_sched_tq    // scheduler time in timeslots (TIME_CONSTANT each)
	
	.reg visible global $sync_shap

	.reg global $tq_shap $tslo_shap

    .reg gcra_lm_offset         // lm offset per each thread - used when shaper does not use CAM

	.xfer_order $sync_shap $tq_shap $tslo_shap

	.set $sync_shap $tq_shap $tslo_shap

	//Initialize the threads.
	_8thread_init()

	//Wait till system initialization is complete
	.if(ctx()==0)
       .begin
       	    .sig visible sys_init_signal				
	        ctx_arb[sys_init_signal]
       .end
	.else
		ctx_arb[next_thread_sig]
	.endif

	.if (ctx()!=7)
		local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val] 	 	
	.endif


//call the initialization macros to set up signals, CSRs and global registers
init#:

	atm_tm_shaper_init(_gcra_param_sram_base, mult_fac, mask_upper15, \
						gcra_lm_offset, @ring_delay, mask_for_port_extraction, \
						mask_for_mul_result, mask_for_thmask_extraction, @_indirect_read9)


//infinite loop for shaping one cell at a time
loop#:

    atm_tm_shaper_util(mask_upper15, mult_fac, gcra_lm_offset, @ring_delay, mask_for_thmask_extraction)
	
	br[loop#]


#endif  //_ATM_TM_SHAPER_UC_