#ifndef _ATM_TM_SCHEDULER_INIT_UC_
#define _ATM_TM_SCHEDULER_INIT_UC_

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/

/*
 *                                                                   
 *      File Name: atm_tm_scheduler_init.uc                                         
 *                                                                   
 *      Description: This file contains the initialization for scheduler and write-out
 *					 microcode. 
 *
 *      History: ver 1.0                                             
 *
 */


#include <atm_tm.h>
#include <xbuf.uc>

//------------------------------------------------------------------
// atm_tm_scheduler_init()
//
//    Description: Initializes scheduler microcode
//
//    Parameters: None.
//		  Inputs:
//			None.
// 		 Outputs:
//			None.
//------------------------------------------------------------------

#macro atm_tm_scheduler_init()
.begin
.reg delay temp
.reg delmax
.reg sched_base cell_count

	// Init base addresses for SRAM
	immed32[@_rtq_sram_base, RTQ_SRAM_BASE]
	immed32[@_nrtq_sram_base, NRTQ_SRAM_BASE]
	immed32[@_ubrtq_sram_base, UBRTQ_SRAM_BASE]
	immed32[_rtqlen_sram_base, RTQLEN_SRAM_BASE]
	immed32[_nrtqlen_sram_base, NRTQLEN_SRAM_BASE]
	immed32[_ubrtqlen_sram_base, UBRTQLEN_SRAM_BASE]
	immed32[@port_shaping_lm_base, PORTSHAPING_LM_BASE]

/////////////////////////////////////////////////////////////////////////////
#ifndef HBR_EXCLUDED

	//Initialize base addresses for LM
	immed32[_vcqlen_lm_base, VCQ_LEN_LM_BASE]
	immed32[_hbrtq_lm_base, HBR_TQ_LM_BASE]
	immed32[@_rt_hbr, 0]

	immed32[@reload_hbrtq_timer_max, RELOAD_HBRTQ_TIMERMAX]
	immed32[@reload_hbrtq_timer, 0]

#endif	//HBR_EXCLUDED
/////////////////////////////////////////////////////////////////////////////

	immed32[@dq_lm_base, DQ_CACHE_LM_BASE]

	#define_eval INCREMENT (8 * TIME_CONSTANT)  ; checking timegain is done once every 8 ports
	immed[@ts_incr, INCREMENT]
	#undef	INCREMENT

	//Other initializations
	immed32(_cells_sent_scratch, AAL5_TX_CELLS_TX_SCRATCH_BASE)
	immed32(@mask_upper13, 0x7ffff)
	immed32(mask_upper16, 0xffff)
	immed32(mask_upper21, 0x7ff)
   	immed32[temp, 0xffff]
#define_eval INDIRECT_MASK		(0x7 << PORTINFO_ENTRY_SIZE_LOG2)	; for this mode port range is 0-7
    immed32[mask_for_portinfo, INDIRECT_MASK]
#undef INDIRECT_MASK

#define_eval INDIRECT_MASK		(0xffff << TQ_SIZE_SHIFT)	; mask lower bits
    immed32[mask_nrtq_num, INDIRECT_MASK]
#undef INDIRECT_MASK
	alu[mask_tqofs, --, B, temp, <<TQ_SIZE_SHIFT]
	alu[mask_tqlofs, --, B, temp, <<TQLEN_ENTRY_SIZE_SHIFT]

	; Read-Modify-Write sig. registers must have signal and signal+1 mask
	alu[temp, --, B, 3, <<&sram_read_dn_newtq0]
	alu[@sram_read_dn_newtq0_reg, --, B, temp]

	alu[temp, --, B, 3, <<&sram_read_dn_newtq1]
	alu[@sram_read_dn_newtq1_reg, --, B, temp]

	alu[temp, --, B, 3, <<&sram_read_dn_newtq2]
	alu[@sram_read_dn_newtq2_reg, --, B, temp]

//compute the signal masks for the SRAM read to obtain the
//lengths of the real time and non-real time TQ in LM.

	//Initialize the LM base for the port state.
	immed[sched_base, SCHED_PARAM_BASE]
	local_csr_wr[ACTIVE_LM_ADDR_0, sched_base]

#ifndef SUPPORT_2K_PORTS
     move(@ubrwpri_lm_base, UBRWPRI_LM_BASE)
#endif

	//Other global registers 
	alu_shf[qmring_num, --, b, SCHEDULER_RING_OUT_0, <<2]

#ifdef SUPPORT_2K_PORTS
    br!=ctx[6, end_init#]
#else
    br!=ctx[7, end_init#]
#endif

        // Initialize TIMESTAMP CSR
        .begin
        .sig cap_read_sig
        .reg $cap_read

        cap[read, $cap_read, MISC_CONTROL], ctx_swap[cap_read_sig]
        alu[$cap_read, 0x80, OR, $cap_read]
        cap[write, $cap_read, MISC_CONTROL], ctx_swap[cap_read_sig]

        .end


init_nn#:
	; Initialize the NN

	; Bit 31    : IN_USE_CTX    : = 0 8 context mode
	; Bit 20    : NN_MODE       : = 0 Gets NN data from this ME
	; Bit 19:18 : NN_RING_EMPTY : = 0 Eempty flag set when 0 or less entries valid
	; Bits [15:8] CTX enables for contexts 0,1,2,3,4,5,6,7
	.reg ctx_enable_data

#ifdef SUPPORT_2K_PORTS
    move[ctx_enable_data, 0x80045500]
#else
	move[ctx_enable_data, 0x0004FF00]
#endif

	local_csr_wr[CTX_ENABLES,ctx_enable_data]
	local_csr_wr[nn_put,0]
	local_csr_wr[nn_get,0]

// Initialize CAM, putting adresses of ports to CAM and data from SRAM to LM
	cam_clear
/* ------------------------------------------------------------------------------ */
.begin 
.reg cam_entry cam_value

#ifdef SUPPORT_2K_PORTS
    #for IN_PORT_NO[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
	    move[cam_entry, IN_PORT_NO]
	    #ifdef FIRST_SCHEDULER_ME
		    move[cam_value,((IN_PORT_NO * 2) * (1 << PORTINFO_XXRAM_OFFSET_LOG2))]
		    cam_write[cam_entry,cam_value,0]
		    _read_port_to_lm_2k((IN_PORT_NO * 2), cam_entry)
	    #else
		    #ifdef SECOND_SCHEDULER_ME
			    move[cam_value,(((IN_PORT_NO * 2)+1) * (1 << PORTINFO_XXRAM_OFFSET_LOG2))]
			    cam_write[cam_entry,cam_value,0]
			    _read_port_to_lm_2k(((IN_PORT_NO * 2)+1), cam_entry)
		    #else
			    move[cam_value,(IN_PORT_NO * (1 << PORTINFO_XXRAM_OFFSET_LOG2))]
			    cam_write[cam_entry,cam_value,0]
			    _read_port_to_lm_2k(IN_PORT_NO, cam_entry)
		    #endif
	    #endif
    #endloop
#else //SUPPORT_2K_PORTS
    #define_eval  IN_PORT_NO 0
    #if (MAX_ATM_PORTS > MAX_STATIC_PORTS)
        #error "MAX_ATM_PORTS can't exceed MAX_STATIC_PORTS without SUPPORT_2K_PORTS definition !!!"
    #endif
    #while (IN_PORT_NO < MAX_ATM_PORTS)
	    _read_port_to_lm(IN_PORT_NO)
        #define_eval IN_PORT_NO (IN_PORT_NO+1)
    #endloop
    #undef IN_PORT_NO
#endif //SUPPORT_2K_PORTS

.end
/* ------------------------------------------------------------------------------ */

	; initialize variable with mximum number of port entries
#define INDIRECT_MASK	(MAX_ATM_PORTS_PER_ME - 1)
	immed32[@max_port_mask, INDIRECT_MASK]
#undef INDIRECT_MASK

	move[@one24, 0x01000000]	; value used to do fast increments
	move[@one16, 0x00010000]	; value used to do fast increments
	move[@one8,  0x00000100]	; value used to do fast increments

    ; Initialize time synchronization register
	move(@cur_tslot,0)

	; Initialize time register
	local_csr_rd[TIMESTAMP_LOW]
#ifdef FIRST_SCHEDULER_ME	// Init time to 0
	immed[@new_time,0]	
#else
	#ifdef SECOND_SCHEDULER_ME	// Init time to offset equal to half of TIME_CONSTANT 
		#define INDIRECT_VALUE ((8*TIME_CONSTANT/2) )
	immed[@new_time, 0]	
	alu[@new_time, @new_time, +, INDIRECT_VALUE]
		#undef INDIRECT_VALUE
	#else
		immed[@new_time,0]	
	#endif
#endif
	

///////////////////////////////////////////////////////////////////////////////////
#ifndef HBR_EXCLUDED

init_hbr#:
	//Load the HBR Time queues from SRAM
	_read_hbr_tq_sram()

	//Set the lengths of HBR VCQs to zero.
	_init_hbr_vcqlen()

#endif	//HBR_EXCLUDED
///////////////////////////////////////////////////////////////////////////////////

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]

end_init#:
	ctx_arb[next_thread_sig]

#ifndef SUPPORT_2K_PORTS
	local_csr_rd[ACTIVE_CTX_STS]
	immed[active_ctx, 0]
	alu[active_ctx, active_ctx, AND,0x7]

	; initialize pointer of PortShaping table reg
	_init_port_shaping_table_reg(portshaping_table)
#endif
.end
#endm


/////////////////////////////////////////////////////////////////////
#ifndef HBR_EXCLUDED

//------------------------------------------------------------------
// _read_hbr_tq_sram()
//
//    Description: Reads the HBR time queues from SRAM into LM
//
//    Parameters: None.
//		  Inputs:
//			None.
// 		 Outputs:
//			None.
//------------------------------------------------------------------

#macro _read_hbr_tq_sram()
.begin
	.reg offset _hbrtq_sram_base
	.sig sram_read_dn

	//Allocate 8 xfer registers.
	xbuf_alloc($hbr_tq, 8, read)

	local_csr_wr[ACTIVE_LM_ADDR_1, _hbrtq_lm_base]
	immed32(_hbrtq_sram_base, HBR_TQ_SRAM_BASE)
	move(offset, 0)

_hbr_sram_read#:
	//Read first 8 of the 32 LWs and store in local memory
	sram[read, $hbr_tq0, _hbrtq_sram_base, offset, 8], \
		sig_done[sram_read_dn]
	ctx_arb[sram_read_dn]
	alu[*l$index1++, --, b, $hbr_tq[0]]
	alu[*l$index1++, --, b, $hbr_tq[1]]
	alu[*l$index1++, --, b, $hbr_tq[2]]
	alu[*l$index1++, --, b, $hbr_tq[3]]
	alu[*l$index1++, --, b, $hbr_tq[4]]
	alu[*l$index1++, --, b, $hbr_tq[5]]
	alu[*l$index1++, --, b, $hbr_tq[6]]
	alu[*l$index1++, --, b, $hbr_tq[7]]
	alu[offset, offset, +, 32]
	alu[--, offset, -, HBR_TQ_SRAM_SIZE]
	bne[_hbr_sram_read#]

	xbuf_free($hbr_tq)
.end
#endm


//------------------------------------------------------------------
// _init_hbr_vcqlen()
//
//    Description: Initializes the lengths of the 192 HBR and UBR VCQs
//					to zero
//
//    Parameters: None.
//		  Inputs:
//			None.
// 		 Outputs:
//			None.
//------------------------------------------------------------------

#macro _init_hbr_vcqlen()
.begin
	.reg count

	local_csr_wr[ACTIVE_LM_ADDR_1, _vcqlen_lm_base]
	move(count, 64)
	nop
	nop

_hbr_vcq_init#:
	alu[*l$index1++, --, b, 0]
	alu[count, count, -, 1]
	bne[_hbr_vcq_init#]

.end
#endm

#endif	//HBR_EXCLUDED
/////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------
// _read_port_to_lm(in_pi_addr)
//
//    Description: Read Port Info Entry, UBRwPRI entry from
//      given SRAM address offset to LM - version for up to 16 ports
//
//
//    Parameters: 1
//		  Inputs: in_port_no - Port no.
//			None.
// 		 Outputs: None
//			None.
//------------------------------------------------------------------
#macro _read_port_to_lm(in_port_no)
.begin
	.sig rp_read_dn0 rp_read_dn1
	.reg offset addr_base entry_size addr_offset lm_addr tmp bit_mask

#ifdef PORTINFO_IN_SDRAM

	alu[addr_offset, --, B, in_port_no, <<PORTDATA_SDRAM_ENTRY_SIZE_LOG2]

#else /* PORTINFO_IN_SDRAM */

	alu[addr_offset, --, B, in_port_no, <<PORTDATA_SRAM_ENTRY_SIZE_LOG2]

#endif /* PORTINFO_IN_SDRAM */

	; Preparing LM base address
    move(tmp, PORTINFO_LM_BASE)
   	alu[lm_addr, --, B, in_port_no, <<PORTINFO_ENTRY_SIZE_LOG2]
    alu[lm_addr, lm_addr, +, tmp]
	local_csr_wr[active_lm_addr_0, lm_addr]

	; Prepare address for PortInfo
#ifdef PORTINFO_IN_SDRAM

	immed32[addr_base, PORTINFO_SDRAM_BASE]

#else /* PORTINFO_IN_SDRAM */

	immed32[addr_base, PORTINFO_SRAM_BASE]

#endif /* PORTINFO_IN_SDRAM */

/* *********** PortInfo table reloading *********** */
	; allocate  buffers for SRAM/DRAM operation
#ifdef PORTINFO_IN_SDRAM
	#define TX_REG_TYPE		$$port_
#else  
	#define TX_REG_TYPE		$port_
#endif
    
    xbuf_alloc(TX_REG_TYPE/**/data_rw, 16, read_write)


#ifdef PORTINFO_IN_SDRAM
	dram_read(TX_REG_TYPE/**/data_rw[0], addr_base, addr_offset, 8, rp_read_dn0, SIG_NONE, ___)
	ctx_arb[rp_read_dn0]
#else
	sram_read(TX_REG_TYPE/**/data_rw[0],  addr_base, addr_offset, 16, rp_read_dn0, SIG_NONE, ___)
	ctx_arb[rp_read_dn0]
#endif


	; Copy PortInfo from SRAM to LM
    ; Unpacking data
    // LW0
	alu[*l$index0[0], --,b, 0]
    alu[tmp, mask_upper16, AND, TX_REG_TYPE/**/data_rw[0], >>8]              ; CurTQ
    alu[*l$index0[14], --, B, tmp]                                              ; CurTQ
    ld_field_w_clr[*l$index0[1], 0001, TX_REG_TYPE/**/data_rw0]                ; Valid bit and FC
    ld_field[*l$index0[1], 0100, TX_REG_TYPE/**/data_rw[0], >>8]             ; RT_fro_the_LBR_TQ
    // LW1
	alu[*l$index0[5], --,b, TX_REG_TYPE/**/data_rw[1]]                       ; RTQnum, NRTQnum
    // LW2
	ld_field_w_clr[*l$index0[6], 0011, TX_REG_TYPE/**/data_rw[2], >>16]      ; DQRTlen
	ld_field_w_clr[*l$index0[7], 1100, TX_REG_TYPE/**/data_rw[2], <<16]      ; DQNRTlen
    // LW3
	ld_field_w_clr[tmp, 0001, TX_REG_TYPE/**/data_rw[3], >>24]               ; RTQlen
	alu[*l$index0[8], --, B, tmp]                                               ; RTQlen
   	ld_field_w_clr[tmp, 0001, TX_REG_TYPE/**/data_rw[3], >>16]               ; NRTQlen
   	alu[*l$index0[9], --, B, tmp]                                               ; NRTQlen
	ld_field_w_clr[tmp, 0001, TX_REG_TYPE/**/data_rw[3], >>8]                ; Working_RTQlen
	alu[*l$index0[11], --, B, tmp]                                              ; Working_RTQlen
   	ld_field_w_clr[tmp, 0001, TX_REG_TYPE/**/data_rw[3]]                     ; Working_NRTQlen
   	alu[*l$index0[12], --, B, tmp]                                            ; Working_NRTQlen
    //LW4
	ld_field[*l$index0[1], 1000, TX_REG_TYPE/**/data_rw[4]]                  ; Schcount
    immed32(bit_mask, 0xFFF)
    alu[tmp, bit_mask, AND, TX_REG_TYPE/**/data_rw[4], >>12]                     ; MaxTQmask
	ld_field_w_clr[*l$index0[4], 0011, tmp]                                   ; MaxTQmask
    //LW5
	ld_field[*l$index0[6], 1100, TX_REG_TYPE/**/data_rw[5]]                  ; UBRTQnum
	ld_field[*l$index0[7], 0011, TX_REG_TYPE/**/data_rw[5]]                  ; DQUBRTlen
    //LW6
	ld_field_w_clr[*l$index0[2], 1100, TX_REG_TYPE/**/data_rw[6]]            ; TQ_offset
	ld_field_w_clr[tmp, 0001, TX_REG_TYPE/**/data_rw[6], >>8]                ; UBRTQlen
	alu[*l$index0[10], --, B, tmp]                                            ; UBRTQlen
   	ld_field_w_clr[tmp, 0001, TX_REG_TYPE/**/data_rw[6]]                     ; Working_UBRTQlen
   	alu[*l$index0[13], --, B, tmp]                                            ; Working_UBRTQlen
    //LW7
    alu[tmp, 0xf, AND, TX_REG_TYPE/**/data_rw[7], >>28]                 ; Rtdq_producer
	ld_field_w_clr[*l$index0[3], 1000, tmp, <<24]
    alu[tmp, 0xf, AND, TX_REG_TYPE/**/data_rw[7], >>24]                 ; Rtdq_consumer
	ld_field[*l$index0[3], 0100, tmp, <<16]
    alu[tmp, 0xf, AND, TX_REG_TYPE/**/data_rw[7], >>20]                 ; Nrtdq_producer
	ld_field[*l$index0[3], 0010, tmp, <<8]
    alu[tmp, 0xf, AND, TX_REG_TYPE/**/data_rw[7], >>16]                 ; Nrtdq_consumer
	ld_field[*l$index0[3], 0001, tmp]
    alu[tmp, 0xf, AND, TX_REG_TYPE/**/data_rw[7], >>12]                 ; Ubrtdq_producer
	ld_field[*l$index0[2], 0010, tmp, <<8]
    alu[tmp, 0xf, AND, TX_REG_TYPE/**/data_rw[7], >>8]                  ; Ubrtdq_consumer
	ld_field[*l$index0[2], 0001, tmp]

	ld_field[*l$index0[4], 1000, TX_REG_TYPE/**/data_rw[7], <<16]       ; UBRwPRI cache

    // Loading UBRwPRI table
	move(tmp, UBRWPRI_LM_BASE)
	alu[lm_addr, --, B, in_port_no, <<UBR_WPRI_ENTRY_SIZE_LOG2]
	alu[lm_addr, tmp, +, lm_addr]
	local_csr_wr[active_lm_addr_0, lm_addr]
	nop
	nop
	nop
	alu[*l$index0[0], --,b, TX_REG_TYPE/**/data_rw[8]]
	alu[*l$index0[1], --,b, TX_REG_TYPE/**/data_rw[9]]
	alu[*l$index0[2], --,b, TX_REG_TYPE/**/data_rw[10]]
	alu[*l$index0[3], --,b, TX_REG_TYPE/**/data_rw[11]]
	alu[*l$index0[4], --,b, TX_REG_TYPE/**/data_rw[12]]
	alu[*l$index0[5], --,b, TX_REG_TYPE/**/data_rw[13]]
	alu[*l$index0[6], --,b, TX_REG_TYPE/**/data_rw[14]]
	alu[*l$index0[7], --,b, TX_REG_TYPE/**/data_rw[15]]

	; Copy DQ rings from DRAM to LM
	; Preparing LM base address
	alu_shf[lm_addr, --, B, in_port_no, <<DQ_ELEMENT_SIZE_LOG2]	; Each DQ rings table is 16 (12) LW wide
	move[tmp, DQ_CACHE_LM_BASE]
	alu[lm_addr, tmp, +, lm_addr]
	local_csr_wr[active_lm_addr_0, lm_addr]
	nop
	nop
	nop
	alu[*l$index0[0], --,b, 0]
	alu[*l$index0[1], --,b, 0]
	alu[*l$index0[2], --,b, 0]
	alu[*l$index0[3], --,b, 0]
	alu[*l$index0[4], --,b, 0]
	alu[*l$index0[5], --,b, 0]
	alu[*l$index0[6], --,b, 0]
	alu[*l$index0[7], --,b, 0]
	alu[*l$index0[8], --,b, 0]
	alu[*l$index0[9], --,b, 0]
	alu[*l$index0[10], --,b, 0]
	alu[*l$index0[11], --,b, 0]
    xbuf_free(TX_REG_TYPE/**/data_rw)
.end
	#undef TX_REG_TYPE
#endm

//------------------------------------------------------------------
// _read_port_to_lm_2k()
//
//    Description: Read PortInfo and UBRwPRI entry from given
//                 SRAM address offset to LM - version for 2k ports
//
//
//    Parameters: 1
//		  Inputs: in_port_no - Port no.
//				  in_entry - LM entry no.
// 		 Outputs: None
//			None.
//------------------------------------------------------------------
#macro _read_port_to_lm_2k(in_port_no, in_entry)
.begin
	.sig rp_read_dn0 rp_read_dn1
	.reg offset addr_base entry_size addr_offset lm_addr tmp

#ifdef PORTINFO_IN_SDRAM

	alu[addr_offset, --, B, in_port_no, <<PORTDATA_SDRAM_ENTRY_SIZE_LOG2]

#else /* PORTINFO_IN_SDRAM */

	alu[addr_offset, --, B, in_port_no, <<PORTDATA_SRAM_ENTRY_SIZE_LOG2]

#endif /* PORTINFO_IN_SDRAM */

	; Preparing LM base address
    move(tmp, PORTINFO_LM_BASE)
   	alu[lm_addr, --, B, in_entry, <<PORTINFO_ENTRY_SIZE_LOG2]
    alu[lm_addr, lm_addr, +, tmp]
	local_csr_wr[active_lm_addr_0, lm_addr]

	; Prepare address for PortInfo
#ifdef PORTINFO_IN_SDRAM

	immed32[addr_base, PORTINFO_SDRAM_BASE]

#else /* PORTINFO_IN_SDRAM */

	immed32[addr_base, PORTINFO_SRAM_BASE]

#endif /* PORTINFO_IN_SDRAM */

/* *********** PortInfo table reloading *********** */
	; allocate  buffers for SRAM/DRAM operation
#ifdef PORTINFO_IN_SDRAM
	#define TX_REG_TYPE		$$port_
#else
	#define TX_REG_TYPE		$port_
#endif

	.reg TX_REG_TYPE/**/data_rw[28] 
    .xfer_order TX_REG_TYPE/**/data_rw
    
#ifdef PORTINFO_IN_SDRAM
	dram_read(TX_REG_TYPE/**/data_rw[0], addr_base, addr_offset, 14, rp_read_dn0, SIG_NONE, ___)
	ctx_arb[rp_read_dn0]
#else
	sram_read(TX_REG_TYPE/**/data_rw[0],  addr_base, addr_offset, 16, rp_read_dn0, SIG_NONE, ___)
	immed32[addr_base, DQ_SRAM_BASE]
	sram_read(TX_REG_TYPE/**/data_rw[16], addr_base, addr_offset, 12, rp_read_dn1, SIG_NONE, ___)
	ctx_arb[rp_read_dn0, rp_read_dn1]
#endif

	; Copy PortInfo from DRAM to LM
	alu[*l$index0[0], --,b, TX_REG_TYPE/**/data_rw[0]]
	alu[*l$index0[1], --,b, TX_REG_TYPE/**/data_rw[1]]
	alu[*l$index0[2], --,b, TX_REG_TYPE/**/data_rw[2]]
	alu[*l$index0[3], --,b, TX_REG_TYPE/**/data_rw[3]]
	alu[*l$index0[4], --,b, TX_REG_TYPE/**/data_rw[4]]
	alu[*l$index0[5], --,b, TX_REG_TYPE/**/data_rw[5]]
	alu[*l$index0[6], --,b, TX_REG_TYPE/**/data_rw[6]]
	alu[*l$index0[7], --,b, TX_REG_TYPE/**/data_rw[7]]
	; Copy UBRwPRI from DRAM to LM
	alu[*l$index0[8], --,b, TX_REG_TYPE/**/data_rw[8]]
	alu[*l$index0[9], --,b, TX_REG_TYPE/**/data_rw[9]]
	alu[*l$index0[10], --,b, TX_REG_TYPE/**/data_rw[10]]
	alu[*l$index0[11], --,b, TX_REG_TYPE/**/data_rw[11]]
	alu[*l$index0[12], --,b, TX_REG_TYPE/**/data_rw[12]]
	alu[*l$index0[13], --,b, TX_REG_TYPE/**/data_rw[13]]
	alu[*l$index0[14], --,b, TX_REG_TYPE/**/data_rw[14]]
	alu[*l$index0[15], --,b, TX_REG_TYPE/**/data_rw[15]]
	; Copy DQ rings from DRAM to LM
	; Preparing LM base address
	alu_shf[lm_addr, --, B, in_entry, <<DQ_ELEMENT_SIZE_LOG2]
	immed32[tmp, DQ_CACHE_LM_BASE]
	alu[lm_addr, lm_addr, +, tmp]
	local_csr_wr[active_lm_addr_0, lm_addr] 
	nop
	nop
	nop
	alu[*l$index0[0], --,b, TX_REG_TYPE/**/data_rw[16]]
	alu[*l$index0[1], --,b, TX_REG_TYPE/**/data_rw[17]]
	alu[*l$index0[2], --,b, TX_REG_TYPE/**/data_rw[18]]
	alu[*l$index0[3], --,b, TX_REG_TYPE/**/data_rw[19]]
	alu[*l$index0[4], --,b, TX_REG_TYPE/**/data_rw[20]]
	alu[*l$index0[5], --,b, TX_REG_TYPE/**/data_rw[21]]
	alu[*l$index0[6], --,b, TX_REG_TYPE/**/data_rw[22]]
	alu[*l$index0[7], --,b, TX_REG_TYPE/**/data_rw[23]]
	alu[*l$index0[8], --,b, TX_REG_TYPE/**/data_rw[24]]
	alu[*l$index0[9], --,b, TX_REG_TYPE/**/data_rw[25]]
	alu[*l$index0[10], --,b, TX_REG_TYPE/**/data_rw[26]]
	alu[*l$index0[11], --,b, TX_REG_TYPE/**/data_rw[27]]
.end
	#undef TX_REG_TYPE
#endm


#endif		//_ATM_TM_SCHEDULER_INIT_UC_