#ifndef _ATM_TM_SCHEDULER_UC_
#define _ATM_TM_SCHEDULER_UC_

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/

/*
 *      File Name: atm_tm_scheduler.uc                                         
 *                                                                   
 *      Description: This is the main scheduler and write-out file.
 *                                                                   
 *      History: ver 1.0                                             
 *
 */


// TM4.1 scheduler
#ifndef STUB

#include <atm_tm.h>
#include <atm_tm_thread_init.uc>
#include <atm_tm_scheduler_init.uc>

#ifdef SUPPORT_2K_PORTS
    #include <atm_tm_scheduler_util_2k.uc>
#else
    #include <atm_tm_scheduler_util.uc>
#endif

#ifndef PORTINFO_IN_SDRAM 
    #ifndef PORTINFO_IN_SRAM
        #error "There must be PORTINFO_IN_SDRAM or PORTINFO_IN_SRAM define in dl_system.h"
    #endif
#endif

	//signal definitions
    // Signals used during Read-Modify-Write operations
	.sig sram_read_dn0_wo		    //sram read done signal
	.sig sram_read_dn_newtq0	    //signal for reading new RTQlen 
	.sig sram_read_dn_newtq1	    //signal for reading new NRTQlen 
	.sig sram_read_dn_newtq2	    //signal for reading new UBRTQlen 
    
    // Volatile signals
	.sig volatile next_thread_sig	    //inter-thread signal
	.sig volatile sram_read_portshaping	//sram PortShaping entries done signal
	.sig volatile cap_write_done_sig    //sending timestamp and time slot to shaper

	.sig sram_read_dn_sched 	    //sram read done signal
  
	.sig sram_write_dn0 		    //sram write done signal

	.sig scratch_put_dn			    //scratch put done signal

#ifndef SUPPORT_2K_PORTS
    .sig scratch_read_dn            //reading FC scratch
#else
	.sig cap_read_head_dn		    //cap read head pointer done signal
   	.sig cap_read_tail_dn		    //cap read tail pointer done signal
#endif

	.sig _future_cnt_sig_name	    //future count signal name

	//********** register definitions **********

	//following registers hold the masks for the above signals
	.reg volatile next_thread_sig_csr_val	//register to store the next thread signal

	.reg @sram_read_dn_newtq0_reg	; signals used to read-modify-write opertions , uses 2 signals !!!
	.reg @sram_read_dn_newtq1_reg	; signals used to read-modify-write opertions , uses 2 signals !!!
	.reg @sram_read_dn_newtq2_reg	; signals used to read-modify-write opertions , uses 2 signals !!!

	// Mask registers
	.reg mask_upper16 	//register to mask out the upper 16 bits of a LW
	.reg mask_upper21 	//register to mask out the upper 16 bits of a LW
	.reg @mask_upper13 	//register to mask out upper 13 bits - leave 19 lower bits
	.reg mask_tqofs		//mask used to get offset to TQ
	.reg mask_tqlofs	//mask used to get offset to TQlen
    .reg mask_nrtq_num  //mask used to get TQ offset for non-realtime 
    .reg mask_for_portinfo

	.reg qmring_num 	//the number of the scratch ring used between QM-Scheduler

	// registers used to during incrementation by one at different position
	.reg @one8 @one16 @one24 

	//base addresses for DQ
	.reg @dq_lm_base			//DQ cache address base in LM
    .reg dq_lm_offset			//DQ cahce address offset for served port (with base = 0x0)

#ifndef SUPPORT_2K_PORTS

    .reg @ubrwpri_lm_base	    //UBRwPRI table cache address base in LM
    .reg active_ctx             //Active context number (per thread)

#endif

	// variables for PortShaping loop
	.reg @port_shp_ptr			// PortShaping LM cache pointer
	.reg @port_shp_rahead_ptr 	// Pointer used to read next 8 elements of PortShaping table from SRAM to LM
	.reg @port_shaping_lm_base	// Base address of PortShaping cache in LM

    // Variables for time synchronization feedback to shaper
    .reg @cur_tslot             // Number of currently serviced time slot
	.reg remote $sync_shap
	.reg write $sync_sched $tq_sched $tslo_sched 
	.xfer_order $sync_sched $tq_sched $tslo_sched

	//variables to keep a time check on the scheduler and ensure
	//scheduler doesnt run ahead of time.
	.reg @new_time				// Counter that keeps expected scheduler loop finish time
    .reg @ts_incr               // Time needed to process 8 cells
	.reg _fut_cnt_sig_addr 		// ACTIVE_FUTURE_COUNT signal address

	//base addresses of data structures in SRAM
	.reg @_rtq_sram_base 		//real time queue base address
	.reg @_nrtq_sram_base 		//non-real time queue base address
	.reg @_ubrtq_sram_base		//ubr time queue base address
	.reg _rtqlen_sram_base 		//real time queue lengths base address
	.reg _nrtqlen_sram_base		//non-real time queue lengths base address
	.reg _ubrtqlen_sram_base	//ubr time queue lengths base address

/////////////////////////////////////////////////////////////////////////////
#ifndef HBR_EXCLUDED

	//variables needed for polling for a new HBR TQ in SRAM
	.reg @reload_hbrtq_timer_max	//Maximum time interval, after which the scheduler checks if it has gained time
	.reg @reload_hbrtq_timer		//Counter used to decide when we need to check if there was HBR conf. change

	.reg _hbrtq_lm_base 		//HBR TQ base address
	.reg _vcqlen_lm_base		//Lengths of the HBR/UBR VCs
	.reg @_rt_hbr				//HBR TQ current slot

#endif	//HBR_EXCLUDED
/////////////////////////////////////////////////////////////////////////////

	.reg _cells_sent_scratch 	//scratch location that stores the #cells tx on the wire

	// variables for PortShaping loop
    .reg portshaping_table
	.reg port 								// Port being serviced in loop
	.reg @max_port_mask 					// mask for MAX_ATM_PORTS
	.reg serv_port_lm_base 					// Caches pointer to currently serviced port
	.reg ts_incr cur_time					// registers used to control time gained by scheduler
	.reg temp								// temporary value

	//other registers
	.reg @rt_lm_mask			//mask for the LM HBR TQ to detect wraparounds

#ifdef SUPPORT_2K_PORTS
.num_contexts 4
	_4thread_init()
#else
.num_contexts 8
	_8thread_init()
#endif

.if(ctx()==0)

	.begin

#ifdef UNIT_TEST
	#include <system_init.uc>
	system_init()
#endif


    /* This signal is declared in system_init() macro */
    .sig visible sys_init_signal

	ctx_arb[sys_init_signal]
	.end

.else
	ctx_arb[next_thread_sig]
.endif

#ifdef SUPPORT_2K_PORTS
.if (ctx()!=6)
#else
.if (ctx()!=7)
#endif

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val] 	 	
.endif

//call the initialization macros to set up signals, CSRs and global registers
init#:
	atm_tm_scheduler_init()

	br!=ctx[0, port_loop#]
//Inifinte loop for write out and scheduler
; ------------------------- port servicing loop ------------------------

#ifdef SUPPORT_2K_PORTS
	#if (MAX_ATM_PORTS <= MAX_STATIC_PORTS)
		#error "Remove SUPPORT_2K_PORTS definition - it is used for configurations with more than 16 ports"
	#else //(MAX_ATM_PORTS <= MAX_STATIC_PORTS)
port_loop_init#:
	immed[@port_shp_rahead_ptr, 8]
	immed[@port_shp_ptr, 0]
	alu[@port_shp_rahead_ptr, @port_shp_rahead_ptr, +, 4]
	; initialize pointer of PortShaping structure
	_init_8_port_shaping_entries()
port_loop#: // Service each port from PortShaper table
.reg portshaping_address
	alu[portshaping_address, --, B, @port_shp_ptr]
	alu[portshaping_address, 0x3c, AND, portshaping_address, <<2]	; (offset % 16)
	alu[portshaping_address, @port_shaping_lm_base, +, portshaping_address]
	local_csr_wr[ACTIVE_LM_ADDR_1, portshaping_address]
	alu[@port_shp_ptr, @port_shp_ptr, +, 1]
	nop
	nop
	alu[port, --, B, *l$index1]
	alu[--, --, ~B, *l$index1]
	beq[port_skip#]	; go if port unused

// Schedule for port
	atm_tm_scheduler_util(port)

	; **************** Loop's control section ***************
.reg tmp lm_base
port_loop_continue#:
	// Check if it's time to read/save PortShaping elements that we have read ahead
	alu[--, 0x03, AND, @port_shp_ptr]
	bne[port_loop#]					; @port_shp_ptr%4 !=0 go on

	// Do we need to issue next 8 elements read or save elements we read previously
	alu[tmp, 0x07, AND, @port_shp_ptr]	; @port_shp_ptr%8
	alu[@port_shp_ptr, @port_shp_ptr, AND, @max_port_mask]
	alu[--, 4, -, tmp]
	bne[pl_save#]				; is @port_shp_ptr%8 == 4 ?

pl_read#:
	// Issue reading next 8 PortShaping elements from SRAM
	xbuf_alloc($r_portshp, 8,  read)
	alu[tmp, @port_shp_ptr, +, 4]
	alu[tmp, tmp, AND, @max_port_mask]	

.reg portshaping_base portshaping_offset
	
	immed32[portshaping_base, PORTSHAPING_SRAM_BASE]
	alu[portshaping_offset, --, B, tmp]
	alu[portshaping_offset, --, B, portshaping_offset, <<2]
	sram[read, $r_portshp[0], portshaping_base, portshaping_offset, 8], sig_done[sram_read_portshaping]
	alu[@port_shp_rahead_ptr, @port_shp_rahead_ptr, +, 4]
	br[port_loop#]

pl_save#:
	// Write PortShaping entries read from SRAM to LM
	ctx_arb[sram_read_portshaping]
	; Preparing LM base address
	immed32[lm_base, PORTSHAPING_LM_BASE]

	; calculating LM offset
	alu[tmp, 0x08, AND, @port_shp_ptr]
	alu[tmp, --, B, tmp, <<2]
	alu[lm_base, lm_base, +, tmp]
	local_csr_wr[ACTIVE_LM_ADDR_1, lm_base]
	nop
	nop
	nop

// Tx registers set to avoid warnings
// $r_portshp always containts proper value because 
// pl_save# routine is interleaved with pl_read# routine
	.set $r_portshp[0] $r_portshp[1] $r_portshp[2] $r_portshp[3] 
	.set $r_portshp[4] $r_portshp[5] $r_portshp[6] $r_portshp[7]

	; writing next 8 PortShaping table entries to LM
	alu[*l$index1[0], --,b, $r_portshp[0]]
	alu[*l$index1[1], --,b, $r_portshp[1]]
	alu[*l$index1[2], --,b, $r_portshp[2]]
	alu[*l$index1[3], --,b, $r_portshp[3]]
	alu[*l$index1[4], --,b, $r_portshp[4]]
	alu[*l$index1[5], --,b, $r_portshp[5]]
	alu[*l$index1[6], --,b, $r_portshp[6]]
	alu[*l$index1[7], --,b, $r_portshp[7]]
	xbuf_free($r_portshp)

	; Is it last 8 entries of PortShaping
	alu[--, @port_shp_rahead_ptr, AND, @max_port_mask]
	beq[pl_reset_rah_ptr#]
	// Increment ahead pointer
	alu[@port_shp_rahead_ptr, @port_shp_rahead_ptr, +, 4]
	br[check_time_gain#]

pl_reset_rah_ptr#:
	// Initialize ahead pointer
	immed[@port_shp_rahead_ptr, 4]
	br[check_time_gain#]

// ****************

port_skip#:
// If port is disabled (set to 0xffffffff) then we need to do the same number of ctx swaps
#ifndef PORTINFO_IN_SDRAM
	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

#ifdef DOUBLE_WRITEOUT
	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]
#endif
#endif

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

#ifdef DOUBLE_WRITEOUT
	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]
#endif

	br[port_loop_continue#]
	#endif //(MAX_ATM_PORTS <= MAX_STATIC_PORTS)

#else // !SUPPORT_2K_PORTS

	#if (MAX_ATM_PORTS > MAX_STATIC_PORTS)
		#error "Can't have MAX_ATM_PORTS set to more than 16 without SUPPORT_2K_PORTS"
	#else 
port_loop_init#:
	move[@port_shp_ptr, 0]

port_loop#:
	alu[--, @port_shp_ptr, OR, 0]
    alu[port, 0x0f, AND, portshaping_table, >>indirect]
	alu[@port_shp_ptr, @port_shp_ptr, +, 4]
	alu[@port_shp_ptr, 0x1f, AND, @port_shp_ptr]

#ifdef ALLOW_PORT_DISABLE

	br=byte[port, 0, 0xff, port_skip#] ; skip disabled port

#endif
// Schedule for port
	atm_tm_scheduler_util(port)



	; **************** Loop's control section ***************

port_loop_continue#:
	br!=byte[active_ctx, 0, 0, port_loop#]

	; *******************************************************
    
    #endif /* (MAX_ATM_PORTS > MAX_STATIC_PORTS) */

#endif /* SUPPORT_2K_PORTS */


check_time_gain#:
//Increment the real time by AGGREGATION timeslots after
//doing the conversion from timeslots to timestamps.
//This value will be needed for checking if the scheduler has
//gained time and if so, sleeping till the scheduler syncs
//up with real time again.

#if defined(FIRST_SCHEDULER_ME) || ( !defined(FIRST_SCHEDULER_ME) && !defined(SECOND_SCHEDULER_ME) )

// Prepare transfer registers for reflect writing time synchronization to shaper ME
	alu[$sync_sched, --, b, @new_time]
	alu[$tq_sched, --, b, @cur_tslot]
	alu[$tslo_sched, --, b, @new_time]

    #ifndef REFLECT_SHAPER_ME
        #error "REFLECT_SHAPER_ME should contain Shaper ME number !!!"
    #endif
	cap[write, $sync_sched, REFLECT_SHAPER_ME, $sync_shap, 0, 3], sig_done[cap_write_done_sig]   ; reflect write
	.io_completed cap_write_done_sig

#endif

check_time_cont#:
	alu[@new_time, @new_time, +, @ts_incr]

// Update timeslot number by adding number of slots processed
	alu[@cur_tslot, @cur_tslot, +, TSLOT_INCREMENT]

//Check if the Scheduler has gained time.
//If the scheduler has gained time, it means that 
//it needs to sleep until it syncs up with the real time
//If not, it will end up reading from Time queues that are ahead of
//real time.
	.set_sig _future_cnt_sig_name
	local_csr_rd[TIMESTAMP_LOW]
	immed[cur_time, 0]

//If the scheduler time is greater than the real time, no need
//to sleep also.
	alu[temp, @new_time, -, cur_time]
	alu[--, temp, -, 2]
	ble[port_loop#]

	local_csr_wr[ACTIVE_CTX_FUTURE_COUNT,  @new_time]  
	alu[_fut_cnt_sig_addr, --, b, &_future_cnt_sig_name]
	local_csr_wr[ACTIVE_FUTURE_COUNT_SIGNAL, _fut_cnt_sig_addr]
	ctx_arb [_future_cnt_sig_name], br[port_loop#]


#ifndef SUPPORT_2K_PORTS
    #ifdef ALLOW_PORT_DISABLE

port_skip#:
	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	local_csr_wr[SAME_ME_SIGNAL, next_thread_sig_csr_val]	; signal next thread
	ctx_arb[next_thread_sig]

	br[port_loop_continue#]

    #endif /* ALLOW_PORT_DISABLE */
#endif SUPPORT_2K_PORTS

; --------------------- end of port servicing loop ---------------------

// This is a bypass path for the TM4.1 scheduler. When 'STUB'
// is defined this path is taken. It is a simple round robin
// scheduler.
#else
.while(1)
	nop
.endw
#endif // STUB

#endif		//_ATM_TM_SCHEDULER_UC_