#ifndef _ATM_TM_H_
#define _ATM_TM_H_

/*******************************************************************************
                             Intel Proprietary

 Copyright (c) 1998-2002 By Intel Corporation.  All rights reserved.
 No part of this program or publication may be reproduced, transmited,
 transcribed, stored in a retrieval system, or translated into any language
 or computer language in any form or by any means, electronic, mechanical,
 magnetic, optical, chemical, manual, or otherwise, without the prior
 written permission of:
                         Intel Corporation
                         2200 Mission College Blvd.
                         Santa Clara, CA  95052-8119
*******************************************************************************/


/*
 *      File Name: atm_tm.h                                         
 *
 *      Description: This file contains the various #defines needed for 
 *					 the TM4.1 blocks. Part of the #defines that are 
 *					 needed and are common to the system like memory maps
 *					 and scratch usage are undeffed here and defed in the
 *					 dl_system.h
 *                                                                   
 *      History: ver 1.0                                             
 *
 */                            


#ifdef USE_IMPORT_VAR

    #include <dl_system.h>
    #include <atm_tm_defs.h>

#else

    #include <dl_system.h>

#endif

#include <dispatch_loop.uc>

#ifdef USE_IMPORT_VAR

.import_var GCRA_PARAM_SRAM_BASE
.import_var RTQ_SRAM_BASE
.import_var NRTQ_SRAM_BASE
.import_var UBRTQ_SRAM_BASE
.import_var RTQLEN_SRAM_BASE
.import_var NRTQLEN_SRAM_BASE
.import_var UBRTQLEN_SRAM_BASE
.import_var HBR_TQ_SRAM_BASE
.import_var PORTSHAPING_SRAM_BASE
.import_var HBR_TQ_SRAM_INDICATOR
.import_var AAL5_TX_CELLS_TX_SCRATCH_BASE

#ifdef PORTINFO_IN_SDRAM
    .import_var PORTINFO_SDRAM_BASE
#else
    .import_var PORTINFO_SRAM_BASE
#endif

#endif /* USE_IMPORT_VAR */

/*These defs are common to dl_sys.h. Hence if dl_sys.h is included,
these values will be auto included*/

/*These defs are not included in dl_sys.h*/

/* Traffic Classes definition DO NOT CHANGE it here */
#ifndef RTQUEUE
#define			RTQUEUE							rt_write#
#endif
#ifndef	NRTQUEUE
#define			NRTQUEUE						nrt_write#
#endif
#ifndef UBRQUEUE
#define			UBRQUEUE						ubr_write#
#endif

/* These default Traffic Class maps should be overriden by dl_system.h defs */
/* Traffic Classes to SAR queue map */
#ifndef CLASS_CBR
#define			CLASS_CBR						RTQUEUE
#warning "CBR to SAR queue map undefined, using default."
#endif
#ifndef CLASS_RTVBR
#define			CLASS_RTVBR						RTQUEUE
#warning "rt-VBR to SAR queue map undefined, using default."
#endif
#ifndef CLASS_NRTVBR
#define			CLASS_NRTVBR					NRTQUEUE
#warning "nrt-VBR to SAR queue map undefined, using default."
#endif
#ifndef CLASS_UBR_PCR
#define			CLASS_UBR_PCR					UBRQUEUE
#warning "UBR w/PCR to SAR queue map undefined, using default."
#endif
#ifndef CLASS_UBR_MDCR
#define			CLASS_UBR_MDCR					UBRQUEUE
#warning "UBR w/MDCR to SAR queue map undefined, using default."
#endif
#ifndef CLASS_GFR
#define			CLASS_GFR						NRTQUEUE
#warning "GFR to SAR queue map undefined, using default."
#endif

/* ************************************************************* */
/* ATM TM Realtime to timestamp transformation constants */

/*
 * Number of timeslots processed by scheduler between two check-for-timegain sections
 */
#ifdef SUPPORT_2K_PORTS
    
    #ifdef DUAL_OC24    

        #define TSLOT_INCREMENT     16

    #else /* DUAL_OC24 */

        #define TSLOT_INCREMENT     8

    #endif /* DUAL_OC24 */

#else /* SUPPORT_2K_PORTS */

    #define TSLOT_INCREMENT     8
    
#endif /* SUPPORT_2K_PORTS */

/*Shaper ME Specific definitions*/


/*Numeric value for the next thread signal*/
#define 		NEXT_THREAD_SIGNAL_VAL 		9

/*Numeric value for the future count signal*/
#define 		FUTURE_COUNT_SIG_VAL		14

/*Definition for Scheduler to QM starch ring full state*/
#define_eval	RING_NO						SCHEDULER_RING_OUT_0
#define_eval	RING_FULL					SCR_Ring/**/RING_NO/**/_Status	
#undef			RING_NO

/*Scheduler ME Specific definitions*/

/* Portinfo structures size used to calculate addres offset in SRAM and SDRAM */
/* The size is different for SDRAM because PortInfo is combined with DQ table */
#ifdef PORTINFO_IN_SDRAM

	#define PORTINFO_XXRAM_OFFSET_LOG2	7

#else /* PORTINFO_IN_SDRAM */

	#define PORTINFO_XXRAM_OFFSET_LOG2	6

#endif /* PORTINFO_IN_SDRAM */

/*Base in Scheduler Local Memory for storing the port state values*/
#define SCHED_PARAM_BASE 			0

/*real time departure ring size in scheduler local memory*/
#define RTDQ_SIZE					4
#define RTDQ_SIZE_MASK 				(RTDQ_SIZE-1)
#define RTDQ_SIZE_SHIFTED_MASK 		((RTDQ_SIZE-1) << 4)

/*non-real time departure ring size in scheduler local memory*/
#define NRTDQ_SIZE 					4
#define NRTDQ_SIZE_MASK 			(NRTDQ_SIZE-1)
#define NRTDQ_SIZE_SHIFTED_MASK 	((NRTDQ_SIZE-1) << 4)
#define NRTDQ_LM_OFFSET             (RTDQ_SIZE * 4) // each entry is 1LW

/*UBR departure ring size in scheduler local memory*/
#define UBRDQ_SIZE 					4
#define UBRDQ_SIZE_MASK 			(UBRDQ_SIZE-1)
#define UBRDQ_SIZE_SHIFTED_MASK 	((UBRDQ_SIZE-1) << 4)
#define UBRDQ_LM_OFFSET             (NRTDQ_LM_OFFSET + NRTDQ_SIZE * 4)

/*The max number of packets in flight value for flow contrl purposes*/
#ifdef FLOW_CONTROL

    #define	FC_DELTA 					192

#endif /* FLOW_CONTROL */

#ifdef FLOW_CONTROL_NEW

    #define	FC_DELTA 					48

#endif /* FLOW_CONTROL_NEW */
   
/*Mask for rolling over the high bit rate time queue pointer*/
#define RTLM_MASK 					127

/*Maximum time interval, after which the scheduler checks if it has 
gained time*/
#define_eval 	RELOAD_HBRTQ_TIMERMAX 		(AGGREGATION*10000)

/*UBR VCQ for Port0*/
#define UBR_VCQ_PORT0				129

/* port variable number of bits  */
#define	    	PORT_NUMBER_OF_BITS			11
#define_eval	PORT_NUMBER_CLR_SHIFT		(32 - PORT_NUMBER_OF_BITS)

/* VCQ# number of bits */
#define			VCQ_NUMBER_OF_BITS			17
#define_eval	VCQ_NUMBER_OF_BITS_CLR_SHIFT	(32 - VCQ_NUMBER_OF_BITS)

/* Number of bits assigned to cell counter in an entry of the UBR w/priority table*/
#define_eval	CELL_COUNT_NUMBER_OF_BITS	(32 - VCQ_NUMBER_OF_BITS)

/* Number of bits assigned to cell_coun in the QM to Shaper message */
#define			QM_REQ_CELL_COUNT_LEN		11
#define_eval	QM_REQ_CELL_COUNT_CLR_SHIFT	(32 - QM_REQ_CELL_COUNT_LEN)

/* Offset of a port field in the Scheduler to QM message */
#define			QM_REQ_PORT_OFFSET			19


#ifdef SCRATCH_INTERFACE

    #define_eval	RING_TO_SCHEDULER_EVEN				(SHAPER_TO_SCHEDULER_SCR_RING0 << 2)
    #define_eval	RING_TO_SCHEDULER_ODD				(SHAPER_TO_SCHEDULER_SCR_RING1 << 2)

    /*Definition for Shaper to Scheduler starch ring full state*/
    #define_eval    RING_NO                             SHAPER_TO_SCHEDULER_SCR_RING0
    #define_eval	SCHEDULER_FULL_EVEN					SCR_Ring/**/RING_NO/**/_Status	
    #undef          RING_NO
    #define_eval    RING_NO                             SHAPER_TO_SCHEDULER_SCR_RING1
    #define_eval	SCHEDULER_FULL_ODD					SCR_Ring/**/RING_NO/**/_Status	
    #undef          RING_NO

#endif /* SCRATCH_INTERFACE */

#endif  /*_ATM_TM_H_*/
