///////////////////////////////////////////////////////////////////////
//                                                                   
//                  I N T E L   P R O P R I E T A R Y                
//                                                                   
//     COPYRIGHT (c)  2001-2002 BY  INTEL  CORPORATION.  ALL RIGHTS  
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY   
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A 
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER 
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL, 
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT 
//     THE PRIOR WRITTEN PERMISSION OF :                             
//                                                                   
//                        INTEL  CORPORATION                         
//                                                                   
//                     2200 MISSION COLLEGE BLVD                     
//                                                                   
//               SANTA  CLARA,  CALIFORNIA  95052-8119               
//                                                                   
///////////////////////////////////////////////////////////////////////
//                                                                   
//                                                                   
//      Filename: rr_scheduler.h 
//                                                                   
//      Description: This is a round robin scheduler used by the IPv4
//                   AAL5 Egress OC48 and quad OC12 applications.
//                   For a TM 4.1 scheduler, refer to the ATM diffserv
//                   application.
//
//      History:
//
//      07/22/2003  Created                               asv
//
///////////////////////////////////////////////////////////////////////

#ifndef _RR_SCHEDULER_H_
#define _RR_SCHEDULER_H_


/* Queue numbers 1..127 are high bit rate queues.
 *
 * For quad OC12 designs, 
 *     output port 0 is assigned queues 1..31.
 *     output port 1 is assigned queues 32..63.
 *     output port 2 is assigned queues 64..95.
 *     output port 3 is assigned queues 96..127.
 *
 * For OC48 designs, 
 *     output port 0 is assigned queues 1..127.
 *
 * Queue numbers 128..65534 are low bit rate queues.
 *
 * For quad OC12 designs, 
 *     output port 0 is assigned queues 128, 132, 136 etc.
 *     output port 1 is assigned queues 129, 133, 137 etc.
 *     output port 2 is assigned queues 130, 134, 138 etc.
 *     output port 3 is assigned queues 131, 135, 139 etc.
 *
 * For OC48 designs, 
 *     output port 0 is assigned queues 128..65534.
 *
 */
#define MAX_HBR_QUEUE 				127


/* High bit rate queues (queue numbers 0..127) are maintained
 * in local memory.
 * For each queue, a cell count is maintained.
 * The format of each queue structure in local memory is as shown.
 *     LW 0 bits 31:0 : Number of cells waiting to be scheduled on
 *                      the queue.
 */
#define QUEUE_STRUCTURE_LM_BASE		0

/* Size of the entire queue structure in bytes. 128 queues x 4 bytes per queue */
#define QUEUE_STRUCTURE_LM_SIZE		512

/* Used for readability when accessing local memory indexes of the queue structure */
#define LM_QUEUE_CELL_COUNT			0


/* High bit rate queues are grouped into 4 groups with 32 queues per group.
 *
 * For quad OC12 designs, each group stores queues belonging to one port.
 * So group 0 stores queues belonging to port 0, group 1 for port 1 and so on.
 *
 * For OC48 designs, all groups store queues belonging to port 0.
 * 
 * The groups are used to do round robin scheduling across high bit rate queues.
 * The format of each group structure in local memory is as shown.
 *    LW 0 bits 31:0 : Group vector. Each bit represents a queue status.
 *                     0 indicates empty queue, 1 indicates non-empty queue.
 *    LW 1 bits 31:0 : Group mask used to select a set of eligible queues
 *                     for scheduling.
 */
#define GROUP_STRUCTURE_LM_BASE		512

/* Size of the entire group structure in bytes. 4 groups x 8 bytes per group */
#define GROUP_STRUCTURE_LM_SIZE		32

/* Used for readability when accessing local memory indexes of the group structure */
#define LM_GROUP_VECTOR				0
#define LM_GROUP_MASK				1


#endif // _RR_SCHEDULER_H_