////////////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119 
//
//		
//		Change History
// 		--------------
//
// Date			Description											Whom
// ------------------------------------------------------------------------------------
//
// 12/11/01    	Ingress Queue Manager for Sausalito  				Aneet Chopra                 
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////////


#ifndef QMMESSAGE_UC
#define QMMESSAGE_UC

#ifdef EGRESS
	#include "qm_packet_include.h" ; packet based queue manager
#else
	#include "qm_cell_include.h"	; cell based queue manager
#endif

#include "dispatch_loop.uc"

////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_set_enqhit_message
// Description : This macro checks if enqueue transition message needs to be 
//				 sent to scheduler. This is the CAM hit case ie. entry is 
//				 already in the Q_Array.
// Output      : out_message
// Input       : in_enq_queue_num
// Constants   : none
// Size        : 5
// Branches	   : 1
// 
////////////////////////////////////////////////////////////////////////////
	//    1    1    1 		11					18
	// --------------------------------------------------------
	// |1 |ENQ TR|  X |Cell Count/Pkt Length|      ENQ Q Num   |  1st Lword
	// --------------------------------------------------------

#macro _qm_set_enqhit_message[in_enq_queue_num, out_message]

#ifdef TM4_1

	// set the enqueue queue num in the message. this also sets the MSB

	alu[out_message, --, b, in_enq_queue_num]

	// set this reg to indicate that there is a message needs to be sent
	// to scheduler.

	alu[gl_transition_valid_reg, --,b, 1]

#endif

	// read the queue count for a given queue from local memory
	// the index is set during cam_lookup in the previous phase.

	alu[--, --, b, *l$index0]

	// check for enqueue transition

	//.if( queueCount == 0 )
	bne[enq_transition_check_done#], defer[1]

		// write the incremented queue count back to local memory

		alu[*l$index0, *l$index0, +, 1]


	// set the enqueue queue num in the message. this also sets the MSB

	alu[out_message, --, b, in_enq_queue_num]

	// its an enqueue transition so set the transition message bit

	alu[out_message, out_message, OR, @enq_transition_bit_mask]

	
	alu[gl_transition_valid_reg, --,b, 1]


	//.endif end of branch

enq_transition_check_done#:	





#endm

////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_set_enqmiss_message
// Description : This macro checks if enqueue transition message needs to be 
//				 sent to scheduler. This is the CAM miss case ie. entry was 
//				 not in the Q_Array and had to be read in.
// Output      : out_message
// Input       : in_enq_queue_num
// Constants   : none
// Size        : 5
// Branches	   : 1
// 
////////////////////////////////////////////////////////////////////////////
#macro _qm_set_enqmiss_message[in_enq_queue_num, in_qd_array_enq_0, out_message]

#ifdef TM4_1

	// set the enqueue queue num in the message. this also sets the MSB

	alu[out_message, --, b, in_enq_queue_num]

	// set this reg to indicate that there is a message needs to be sent
	// to scheduler.

	alu[gl_transition_valid_reg, --,b, 1]

#endif

	// read the queue count to check for enqueue transtion
	// on a CAM miss in the previous phase the read of the 
	// queue descriptor from SRAM into Q_Array returns the
	// queue count and that is the one we are using to compare.

	alu[--, --, b, in_qd_array_enq_0]
	
	// check for enqueue transition

	//.if( $QDArrayEnq_0 == 0 )
	bne[enq_transition_check_done#], defer[1]

		// write the incremented queue count back to local memory
		// the index is set during cam_lookup in the previous phase.

		alu[*l$index0, 1, +, in_qd_array_enq_0]

	// set the enqueueNum in the message. this also sets the MSB

	alu[out_message, --, b, in_enq_queue_num]

	// its an enqueue transition so set the transition message bit

	alu[out_message, out_message, OR, @enq_transition_bit_mask]

	
	alu[gl_transition_valid_reg, --,b, 1]


	//.endif end of branch
enq_transition_check_done#:


#endm

////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_dropq_deq_handler
// Description : This macro is used to enq a buffer to the free list. This was
//				 originally part of a buffer chain that had to be dropped. The
//				 buffer being dequeued from the drop queue is enqueue back to the
//				 free list when the cell count goes to zero.
// Output      : 
// Input       : in_deq_queue_num, in_qarray_message
// Constant	   : none
// Size        : 10
// Branches	   : 3
////////////////////////////////////////////////////////////////////////////
#macro _qm_dropq_deq_handler[in_deq_queue_num, in_qarray_message]

	.local tail_ptr, cellcount_mask, eopbit_mask, qarray_entry

	// check if we have a valid dequeue from the drop Q

	alu[--,--,b, in_qarray_message]
	beq[reset_lm_bit#]

#ifdef EGRESS

	// Add the buffer to the free list

	dl_buf_drop[in_qarray_message]


#else // INGRESS

	// now we need to enqueue the dequeued buffer to the free list
	// if the cellcount is zero

	// mask bits other than cell count to zero

	move[cellcount_mask, 0x3f000000]
	alu[--, in_qarray_message, AND, cellcount_mask]
	
	// if the cell count is not zero then buffer has not been evicted from
	// the Q_Array and we have to wait for more dequeue to add the buffer 
	// to the free list

	bne[end_handler#]

	// Add the buffer to the free list

	dl_buf_drop[in_qarray_message]

	// to decrement packet count stored in local memory we have
	// to check if the buffer has its eop bit set.

	move[eopbit_mask, 0x80000000]
	alu[--, in_qarray_message, AND, eopbit_mask]
	beq[end_handler#]

#endif

	br[end_handler#]

reset_lm_bit#:

	//reset the LM bit to 0

	alu[*l$index1, --, b, 0]

end_handler#:

	.endlocal

#endm


////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_set_deq_message
// Description : This macro checks if dequeue message needs to be sent to 
//				 scheduler. In this macro we also send the transmit message
//				 by writing on the scratch ring of the transmit block. The
//				 message varies for ingress and egress.
// Output      : out_message
// Input       : in_deq_queue_num, in_qarray_message
// Constant	   : none
// Size        : 14
// Branches	   : 3
////////////////////////////////////////////////////////////////////////////
#macro _qm_set_deq_message[in_deq_queue_num, in_qarray_message, out_message]

	.local   eop_cellcount_set, dummy, queue_num

	#ifdef EGRESS


			// This is the message format for the transmit scratch ring 
			// for egress
			//    1             7    			       24
			// --------------------------------------------------------
			// |1 |		output port number|  	Buffer handle 		  |  1st Lword
			// --------------------------------------------------------

		
		// Before setting the message for the scheduler we now prep the
		// message for the transmit block to be written on the transmt scratch
		// ring. The dummy register is used to do the prep work. 

		// zero out the MSByte which contains the eop, sop and cellcount
		// for the buffer handle

		alu[dummy, gl_addr_ptr_mask_reg, AND, in_qarray_message]

		// set the MSB as required in  transmit message format

		alu[dummy, dummy, OR, 1, <<31]

		// adjust the buf handle pointer that is pointing to the 7th LW of the meta data
		// back to its original value

		alu[dummy, dummy, -, META_PACKET_NEXT_LW_PTR]
 
		// mask out the class bits in the queue number

		alu[queue_num, --, b, in_deq_queue_num, >>NUM_CLASS_BITS]

		// This shift assumes that the least significant nibble will always be zero
		// since we are not using any classes and port number starts after this
		// nibble.

		alu[$deq_q, dummy, OR, queue_num, <<TX_MESSAGE_QNUM_POSITION]

		// Here we set the message for sending to the scheduler.

		// add dequeue queue num to the message

		alu[out_message, out_message, OR, in_deq_queue_num]

		// also make sure the MSB is set for the message

		alu[out_message, out_message, OR, 1, <<31]
		

	#else // if ingress pipeline

	#ifdef TM4_1

		alu[out_message, out_message, OR, in_deq_queue_num]	

		alu[gl_transition_valid_reg, --,b, 1]
	#endif
		// get the eop and cell count from the dequeue return message

		alu[eop_cellcount_set, SOPRESET_MASK, AND, in_qarray_message, >>EOPCELLCOUNT_BITS]

		//.if( eopCellcountSet == EOPCELLCOUNT_MASK)

		br!=byte[eop_cellcount_set,0, EOPCELLCOUNT_MASK, just_transmit#], defer[2]

			// this is required to send transmit message on the transmit scratch
			// ring
			alu[$qa_message,--,b,in_qarray_message]

			// move from read to write xfer register to write to scratch ring.

			alu[$deq_q, --,b, in_deq_queue_num]
	#endif
		
		//.if($QDArrayDeq_0 == 1)

		alu[--, *l$index0,-,DEQ_TRANS_CHECK]

		bne[just_transmit#], defer[1]

			// write queue count to local memory by decrementing by 1
			// u only do it if cellCount is 1 and eop bit is set

			alu[*l$index0, *l$index0 , -, 1]
			
		// add dequeue queue num to the message

		;alu[out_message, out_message, OR, in_deq_queue_num, <<DEQ_Q_NUM_POSITION]
		alu[out_message, out_message, OR, in_deq_queue_num]			
		// set the dequeue transition bit

		alu[out_message, out_message, OR, @qm_deq_transition_bit_mask_reg]

		
		alu[gl_transition_valid_reg, --,b, 1]

just_transmit#:

		// send dequeued cell to transmit block

		_qm_send_transmit_message[$deq_q, in_deq_queue_num] ; 2, 1


	.endlocal


#endm


////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_send_sched_message
// Description : This macro sends the message to the schedular
//				 Only enqueue/dequeue transition and invalid dequeue request
//				 messages are sent for the ingress. It is almost the same for
//				 egress except that on every dequeue we send the packet length
// 				 and there fore we send 2 LW.
// Output      : Nil
// Input       : in_message
// Constant	   : none
// Size        : 4
// Branches	   : 2
////////////////////////////////////////////////////////////////////////////
#macro _qm_send_sched_message[in_message_enq, in_message_deq, in_sop_handle]

#ifdef EGRESS

	.local pkt_length

	// get the pkt size from the sop buffer handle. The packet length
	// is in the most significant byte of the sop handle. but the MSB
	// is not part of the packet length.

	alu[pkt_length, --, b, in_sop_handle, >>PACKET_SIZE_START_BIT]
	alu[pkt_length, PACKET_SIZE_MASK, AND, pkt_length]

	alu[in_message_deq, in_message_deq, OR, pkt_length, <<PACKET_OFFSET_IN_MESSAGE]
		
	// Write to Schedular via NN ring

	_qm_write_nn_ring[ in_message_enq, in_message_deq] ;2, 1

	.endlocal

#else // for the ingress side

	// check if message needs to be sent

	;alu[--, in_message_enq, AND, 0x7, <<TR_INV_CHECK_BITS ]
	alu[--,--,b,gl_transition_valid_reg]
	BEQ[do_not_send_message#]

	// Write to Schedular via NN ring

	_qm_write_nn_ring[ in_message_enq, in_message_deq] ;2, 1

#endif


do_not_send_message#:
	
	alu[gl_transition_valid_reg, --,b, 0]

#endm

////////////////////////////////////////////////////////////////////////////
// Macro Name  : _qm_send_transmit_message
// Description : This macro writes to the transmit scratch ring
//				 and also sets the signalmap so to wait on the write signal
// Output      : NIL
// Input       : in_deq_queue_num 
// Size        : 5
// Branches	   : 1
////////////////////////////////////////////////////////////////////////////

#macro _qm_send_transmit_message[in_tx_message, in_deq_queue_num]	

#ifdef EGRESS

#if( defined(TX_PHY_MODE) && ( TX_PHY_MODE == MPHY_16) )
	.local temp
	// this is to reset the MSB

	alu[temp, in_deq_queue_num, AND~, 1, <<31]

	// Why shift by 7? The comparison is for which scratch ring to send on
	// For queue number 0..7 goes on one scratch ring and queue number 8..15
	// go on the other. Based on queue number format the lease significant nibble
	// determines the class id and the next nibble will contain the queue number
	// Now if the most significant bit of the second is nibble that means we are 
	// addressing queues 8..15

	alu[--,--, b, temp, >>7]
	beq[write_scr_for_q_0to7#]

		// write to POS TX scratchring ring 1

		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_1, QM_RING_OUT_1]
		br[done#]

write_scr_for_q_0to7#:

		// write to POS TX scratchring ring 0

		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_0, QM_RING_OUT_0]

done#:
	.endlocal

#else

	#if ( defined(TX_PHY_MODE) && ((TX_PHY_MODE == SPHY_4_8) | (TX_PHY_MODE == MPHY_4) ))
	.local temp

		// this is to reset the MSB

		alu[temp, in_deq_queue_num, AND~, 1, <<31]

		alu[temp, --,b, temp, >>NUM_CLASS_BITS ]

		// The write scratch ring macro uses 2 instructions
		alu[temp, --,b, temp, <<2]
		jump[temp, write_ring0#], targets[write_ring0#,write_ring1#,write_ring2#,write_ring3#]
		

write_ring0#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_0, QM_RING_OUT_0]
		br[write_done#]
		nop
write_ring1#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_1, QM_RING_OUT_1]
		br[write_done#]
		nop
write_ring2#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_2, QM_RING_OUT_2]
		br[write_done#]
		nop
write_ring3#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_3, QM_RING_OUT_3]
	
write_done#:
	.endlocal
	#else // implies TX_PHY_MODE == SPHY

	.local temp

		// this is to reset the MSB

		alu[temp, in_deq_queue_num, AND~, 1, <<31]

		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_0, QM_RING_OUT_0]

	.endlocal

	#endif

#endif

#else

	#if ( defined(TX_PHY_MODE) && ((TX_PHY_MODE == SPHY_4_8) | (TX_PHY_MODE == MPHY_4) ))

	.local temp

		// this is to reset the MSB

		alu[temp, in_deq_queue_num, AND~, 1, <<31]

		alu[temp, --,b, temp, >>NUM_CLASS_BITS ]

		// The write scratch ring macro uses 2 instructions
		alu[temp, --,b, temp, <<2]
		jump[temp, write_ring0#], targets[write_ring0#,write_ring1#,write_ring2#,write_ring3#]
		

write_ring0#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_0, QM_RING_OUT_0]
		br[write_done#]
		nop
write_ring1#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_1, QM_RING_OUT_1]
		br[write_done#]
		nop
write_ring2#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_2, QM_RING_OUT_2]
		br[write_done#]
		nop
write_ring3#:
		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER_3, QM_RING_OUT_3]
	
write_done#:
	.endlocal

	#else //SPHY mode on qm_cell mode
		// write to CSIX TX scrating ring 

		_qm_write_scratch_ring[ NUM_WORDS_TX_MESSAGE, in_tx_message, TX_RING_NUMBER, TX_RING] ;2, 1


	#endif
#endif


#endm


#endif