
////////////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119 
//
//		
//		Change History
// 		--------------
//
// Date			Description											Whom
// ------------------------------------------------------------------------------------
//
// 12/11/01    	Ingress Queue Manager for Sausalito  				Aneet Chopra                 
//                                                                      
////////////////////////////////////////////////////////////////////////////////////////////


#ifndef QMINCLUDE_H
#define QMINCLUDE_H

// standard macros from IXPBlocks

#include "stdmac.uc"
#include "localmem.uc"
#include "dl_system.h"
#include "definitions.h"

#ifdef USE_IMPORT_VAR

  .import_var QM_DROP_QUEUE_ENTRY
  .import_var QD_SRAM_BASE
  .import_var QD_TOTAL

#else

/* defined in dl_system.h */


#endif /* USE_IMPORT_VAR */

/////////////////////////////////////////////////////
// Signal Allocation
/////////////////////////////////////////////////////

// All this is for manual allocation of signals till its automated by assembler

#define SIG_1	1
#define SIG_2	2
#define SIG_3	3
#define SIG_4	4
#define SIG_5	5
#define SIG_6	6
#define SIG_7	7
#define SIG_8   8
#define SIG_9 	9
#define SIG_10	10
#define SIG_11	11
#define SIG_12	12
#define SIG_13	13
#define SIG_14	14
#define SIG_15	15

// this signal is used to signal between threads
// basically every thread waits on the previous thread
// to signal

.sig 	volatile sig_prev_thread

// these signals are used to wait on scratch read to complete

.sig    sig_scratch_deq_r_done , sig_scratch_enq_r_done

// this signal is used when writing to a scratch ring.

.sig	volatile sig_scratch_w_done

// when a deq request is issued this signal is used to 
// wait for the request to complete.

.sig 	sig_deq_done

// these signals are used to wait on q array read issued for enq and
// deq.

.sig	sig_q_array_deq_r_done, sig_q_array_enq_r_done

// this signal is used for any reads and writes to SRAM

.sig	sram_done

// This is a global signal that indicates that 
// system initialization is done

.sig	volatile system_init_done
.addr 	system_init_done				me_init_signal

// addressing some signals to be able to use signal map register
// to wait on signals.

.addr sig_prev_thread 				SIG_1
.addr sig_scratch_enq_r_done		SIG_2
.addr sig_q_array_deq_r_done		SIG_8
.addr sig_deq_done					SIG_9
.addr sig_scratch_w_done			SIG_4


/////////////////////////////////////////////////////
// Ring Definitions
/////////////////////////////////////////////////////


#ifdef EGRESS

//ring numbers
#define_eval ENQ_RING_NUMBER	(QM_RING_IN_0  << 2) 
#define_eval DEQ_RING_NUMBER	(QM_RING_IN_1  << 2)
#define_eval TX_RING_NUMBER_0	(QM_RING_OUT_0 << 2)
#define_eval TX_RING_NUMBER_1	(QM_RING_OUT_1 << 2)

// Depends on the phy mode
#if ( defined(TX_PHY_MODE) && ((TX_PHY_MODE == SPHY_4_8) | (TX_PHY_MODE == MPHY_4) ))
	#define_eval TX_RING_NUMBER_2	(QM_RING_OUT_2 << 2)
	#define_eval TX_RING_NUMBER_3	(QM_RING_OUT_3 << 2)
#endif


// message length

#define NUM_WORDS_ENQ_MESSAGE 	3
#define NUM_WORDS_DEQ_MESSAGE 	1
#define NUM_WORDS_TX_MESSAGE 	1

#else // for INGRESS

#if ( defined(TX_PHY_MODE) && ((TX_PHY_MODE == SPHY_4_8) | (TX_PHY_MODE == MPHY_4) ))
	#define_eval ENQ_RING_NUMBER	(QM_RING_IN_0  << 2) 
	#define_eval DEQ_RING_NUMBER	(QM_RING_IN_1  << 2)
	#define_eval TX_RING_NUMBER_0	(QM_RING_OUT_0 << 2)
	#define_eval TX_RING_NUMBER_1	(QM_RING_OUT_1 << 2)
	#define_eval TX_RING_NUMBER_2	(QM_RING_OUT_2 << 2)
	#define_eval TX_RING_NUMBER_3	(QM_RING_OUT_3 << 2)

#else

// ring numbers

	#define_eval ENQ_RING_NUMBER	(QM_RING_IN    << 2) 
	#define_eval TX_RING_NUMBER	(QM_RING_OUT   << 2)
	#define_eval DEQ_RING_NUMBER	(SCHEDULER_TO_QM_SCR_RING << 2)
	#define_eval TX_RING		QM_RING_OUT

#endif

// message length for each ring

#define NUM_WORDS_ENQ_MESSAGE 	3
#define NUM_WORDS_DEQ_MESSAGE 	1
#define NUM_WORDS_TX_MESSAGE 	2
#define NUM_WORDS_SCHED_MESSAGE 1


#endif


// Ring size [31:30]. Hardware representation
// 00 = 128
// 01 = 256
// 10 = 512
// 11 = 1024

;#define RING_SIZE_128 		0
;#define RING_SIZE_256		1
;#define RING_SIZE_512		2
;#define RING_SIZE_1024		3


/////////////////////////////////////////////////////
// Begin register allocations
/////////////////////////////////////////////////////

// these transfer registers are used to 
// write to transmit scratch ring

.reg $deq_q , $qa_message
.xfer_order	  $deq_q, $qa_message

// global register used. Most of the registers especially those ending 
// with _reg or _mask are used to store constants. This effort is to reduce an
// instruction to move immediate data into a register. Hopefully the names are
// self explanatory. Also these names will have a corresponding #define with the 
// same name except the "_reg".

.reg	gl_next_context_sig,  gl_channel_num, zero,  gl_addr_ptr_mask_reg
.reg	gl_qarray_entry_mask_reg , gl_qm_drop_queue_reg, gl_qd_sram_base_reg
.reg	gl_transition_valid_reg, gl_enq_queue_num_mask, gl_override_bit_ingress, gl_override_bit_egress
// these are initialized registers used to store 32bitconstants

.reg  	@enq_transition_bit_mask, @qm_deq_transition_bit_mask_reg
.reg	@bits_for_queue_mask, @invalid_dequeue_bit_mask
.reg	@enq_ind_ref_mask_reg, @sopreset_mask_reg

#ifdef _QM_DEBUG
// register for debug

.reg  	debug_reg

#endif

/////////////////////////////////
// Done register allocations
/////////////////////////////////

/////////////////////////////////////////////////////
// Bunch of #defines
/////////////////////////////////////////////////////


// CAM MACRO

#define GET_CAM_HIT 		alu_shf[cam_hit, 0x1, AND, cam_result, >>7]     // ( (x >> 7 ) & 0x1 )
#define GET_CAM_STATUS		alu_shf[cam_status, 0xf, AND, cam_result, >>8]  // ( (x >> 8 ) & 0xf )
#define GET_CAM_ENTRY		alu_shf[cam_entry, 0xf, AND, cam_result, >>3]   // ( (x >> 3 ) & 0xf )

// SRAM QD Defines

#define CHANNEL_NUM  				0x0			; SRAM Channel. Specifies whichQ_Array to be used.
#define SRAM_CHANNEL_NUMBER_FIELD	30			; used to define the qarray entry for q array operations.
#define SRAM_Q_ARRAY_NUMBER_FIELD	24			; used to define the qarray entry for q array operations.
#define SRAM_CHANNEL0_BASE_ADDRESS	0x0			; used to set the SRAM CONTROL CSR
#define OFFSET_SRAMCONTROL_CSR		0x0			; used to set the SRAM CONTROL CSR
#define META_PACKET_NEXT_LW_PTR 	0x7			; during enq/deq the handle ptr is incremented by the define.
												; this is used for packet based dequeue and
												; not cell based dequeue.


// for CAM status

#define STATUS_VALID				0x1

// All these masks

#define TR_INV_CHECK_MASK			0x70000000	; schedular message check
#define ADDR_PTR_MASK				0x00ffffff	; to mask of eop,sop and cellcount
#define ENQ_IND_REF_MASK			0x001ff000	; enqueue indirect reference mask
#define SOPRESET_MASK				0xbf		; cell count mask
#define EOPCELLCOUNT_MASK			0x80		; to check eop bit set and last cell
#define MSB_SET						0x80000000	; 
#define DEQ_TRANS_CHECK				0x1			; used to check if there is deq transtion 
#define TX_MESSAGE_QNUM_POSITION	24			; for egress qnum is put in the MSByte of
												; the transmit message.

// Drop Queue defines
#define CELL_COUNT_MASK				0x00ffffff	; to mask of the eop, cellcount
#define QM_LM_DROP_Q_BASE			0x400		; LM address for maintaining drop queue
												; packet count.

// All these bit numbers for shifts

#define TR_INV_CHECK_BITS			28			; schedular message check
#define CELLCOUNT_BIT				24			; shift to get cellcount
#define EOPCELLCOUNT_BITS			24			; shift to get start of cellcount
#define PACKET_SIZE_START_BIT		24			; CSIX RX gives packet length starting at
												; this position
#define PACKET_SIZE_MASK			0x3f		; packet size in put in seven bits.
#define PACKET_OFFSET_IN_MESSAGE	20			; 
#define EOP_BIT						31	
#define DEQ_Q_NUM_POSITION			0		
#define NUM_CLASS_BITS				4
#define ENQ_QUEUE_NUM_MASK			0x8003ffff
// Start of local memory

#define LM_Q_BASE					0x0


#define			DL_NEXT_ME  0xff

// Number of queue groups (first level of hierarchical bit vector

#define 		NUMBER_OF_QUEUE_GROUPS       32

// Number of queues per group

#define 		NUMBER_OF_QUEUES_PER_GROUP    32

// The queue group and queue in the group are encoded into one id. LSB 5 bits are used for 
// queue and then 5 bits for queue group id

#define 		NUMBER_OF_BITS_FOR_QUEUE_MASK	0x1f

// bits for queue group

#define 		NUMBER_OF_BITS_FOR_GROUP	5

// Bit number for detecting enqueue transition messages (empty queue getting data)

#define QM_ENQ_TRANSITION_BIT_MASK           0xc0000000

// Bit number for detecting dequeue transition messages (queue going to empty)

#define QM_DEQ_TRANSITION_BIT_MASK           0xc0000000

// Bit number for invalid dequeues

#define QM_INVALID_DEQUEUE_BIT_MASK			 0xa0000000


#endif //QMINCLUDE_H