/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_mhlp.c
 *
 * = DESCRIPTION
 *         The file contains API functions exposed by QM Core Component
 **/
#define IX_ERROR_FILE_IDENT "$Id: ix_cc_qm_mhlp.c,v 1.19 2003/09/13 01:23:21 rranjeet Exp $"

#include "ix_cc_error.h"
#include "ix_types.h"
#include "ix_error.h"
#include "ix_rm.h"
#if !defined(IX_EXCLUDE_CCI)
    #include "ix_cci.h"
#endif /* end !defined(IX_EXCLUDE_CCI) */

#include "ix_cc.h"
#include "cc/ix_cc_msup.h"
#include "cc/ix_cc_qm_frmwrk.h"
#include "cc/ix_cc_qm.h"
#include "cc/internal/ix_cc_qm_internal.h"

#include "bindings.h"

IX_CC_QM_INSTANCE_TABLE_DECLARE()
  
 /**
 * NAME: ix_cc_qm_async_get_packet_count()
 *
 * DESCRIPTION: This is a Messaging API (Level 1 support ) function that returns a packet count. 
 *              It is called by Client of QM core component 
 * 
 * @Param:  - IN        ix_cc_qm_cb_pkt_count arg_Callback - user callback
 *            IN        void* arg_pContext - context to be used by user callback
 *          
 * @Return: IX_SUCCESS in case of success or valid ix_error if call fails
 */


ix_error ix_cc_qm_async_get_packet_count (ix_cc_qm_cb_pkt_count arg_Callback, 
                                          ix_generic_context* arg_pContext)
{
    ix_error err = IX_SUCCESS;
    ix_cc_qm_pkt_count_ctx* pIntCtx = NULL;
    ix_uint32 instanceCC = 0;

    if (NULL == arg_Callback) 
    {
        return IX_ERROR_WARNING(IX_CC_QM_ERROR_USER_CB, 
        ("ix_cc_qm_async_get_packet_count was called with NULL callback"));
    }
    /* create ix_cc_qm_pkt_count_ctx */
    pIntCtx = ix_ossl_malloc(sizeof(ix_cc_qm_pkt_count_ctx));
    if (NULL == pIntCtx) 
    {
        return IX_ERROR_WARNING(IX_CC_ERROR_OOM_SYSTEM,
                            ("Out of system memory in ix_cc_qm_async_get_packet_count"));
    }
    pIntCtx->pktCountCb = arg_Callback;
    pIntCtx->pUserCtx = arg_pContext;
    pIntCtx->pktCount = 0;
    instanceCC = IX_HANDLE_TO_INSTANCE(arg_pContext->hCC);
    err = ix_cc_msup_send_async_msg (IX_CC_QM_INSTANCE_TABLE_GET(instanceCC,msgIn),
                                        (ix_cc_msghlp_callback)_ix_cc_qm_cb_get_packet_count, 
                                        pIntCtx,IX_CC_QM_MSG_GETPKTCOUNT,
                                        &(pIntCtx->pktCount),sizeof(ix_uint64));
    if (IX_SUCCESS != err)
    {
        ix_ossl_free(pIntCtx);
        err = IX_ERROR_WARNING(IX_CC_QM_ERROR_MSUP, ("Fail to send async. message"));
    }
    return err;
}



/**
 * NAME: ix_cc_qm_icb_get_packet_count
 * 
 * DESCRIPTION: This function is an internal callback for the async 
 *              messaging API, ix_cc_qm_async_get_packet_count().
 * 
 * @Param: IN - arg_Result  - error from the operation
 * @Param: IN - arg_pContext     - pointer to internal callback context
 * @Param: IN - arg_Msg          - message data returned by component message handler
 * @Param: IN - arg_MsgLen       - length of message data
 * 
 * @Return: IX_SUCCESS if successful or a valid ix_error for failure.
 */
ix_error _ix_cc_qm_cb_get_packet_count(ix_error arg_Result,void* arg_pContext,
                                               void* arg_Msg,ix_uint32 arg_MsgLen)
{
    ix_error err = IX_SUCCESS;
    ix_cc_qm_pkt_count_ctx* pContext = (ix_cc_qm_pkt_count_ctx *)arg_pContext;
    void* pUserCtx = NULL;
    ix_cc_qm_cb_pkt_count Callback;
    
    if (NULL == pContext)
    {
        return IX_ERROR_WARNING(IX_CC_ERROR_NULL, ("Null pContext in internal cb"));
    }
    /* Retrieve the user callback and context from the context pointer */
    Callback = pContext->pktCountCb;
    if (NULL == Callback)
    {
        /* can not call user - free context */
        ix_ossl_free(pContext);
        return IX_ERROR_WARNING(IX_CC_ERROR_NULL, ("Null Callback in internal cb"));;
    }
    pUserCtx = pContext->pUserCtx;
    /* Invoke the user callback to pass back the result and data */
    err = (Callback)(arg_Result,pUserCtx,*(ix_uint64*)arg_Msg);
    if (IX_SUCCESS != err)
    {
        err = IX_ERROR_REMOTE(IX_CC_QM_ERROR_USER_CB, ("Error in user callback"));
    }
    /* Free the callback context entry */
    ix_ossl_free(pContext);
    return err;
}

/*******************************  FILE HISTORY  *******************************
 * \main\sdk_3_0\lp_merge\1 Thu Aug 28 18:56:01 2003 adziecia
 * IGK0100025366: LP MERGE: Core Corponents merge checkin 
 *  
 *****************************************************************************/
