/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2000-2002 Intel Corporation. All rights reserved.
 *
 * = PRODUCT
 *      Intel(r) IXA SDK for the IXP2X00 Network Processor
 *
 * = FILENAME
 *      ix_cc_qm_internal.h
 *
 * = DESCRIPTION
 *
 * = AUTHOR
 *      Herman Zaks
 *      Herman.Zaks@intel.com
 *
 * = CHANGE HISTORY
 *      7/16/2002 - Created
 * $Id: ix_cc_qm_internal.h,v 1.12 2003/09/13 01:23:06 rranjeet Exp $
 **/


#if !defined(__IX_CC_QM_INTERNAL_H__)
#define __IX_CC_QM_INTERNAL_H__


/* #include "ix_types.h" */

#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */

/**
 * TYPENAME: ix_cc_qm_cb_pkt_count_ctx
 * 
 * DESCRIPTION: Context data structure for storing user info
 *              in async call
 *
 */

typedef struct ix_s_cc_qm_pkt_count_ctx
{
	ix_cc_qm_cb_pkt_count  pktCountCb;	/* pointer to the user callback function */
	void*		pUserCtx;               /* pointer to the user callback */
    ix_uint64   pktCount;               /* pointer to the user memory for the counter */ 
}ix_cc_qm_pkt_count_ctx;


/* internal macros */
#define IX_CC_QM_MSG_GETPKTCOUNT            0x10
#define IX_CC_QM_MSG_GET_QUEUE_DESCRIPTOR   0x11


/**
 * MACRO NAME: SET_UBLOCK_SYMBOLS
 *
 * DESCRIPTION: This macro sets microblock symbols into the ix_imported_symbol data structure
 *  @Param:  - INOUT argSymbolStruct -  imported symbol structure .
 *  @Param:  - IN    argValue   - value of the imported variable.
 *  @Param:  - IN    argName    - name of the imported variable
 * @Return: Fills data structure with the name and value
 */
#define SET_UBLOCK_SYMBOLS( argSymbolStruct,argValue,argName) { \
                            argSymbolStruct.m_Value = argValue; \
                            argSymbolStruct.m_Name = argName; \
                            }


/* Packet count functions  */
ix_uint64 _ix_cc_qm_get_packet_count(void);
ix_uint64 _ix_cc_qm_increment_pkt_count(void);
void _ix_cc_qm_zero_pkt_count(void);

/* Configuration functions */
ix_error _ix_cc_qm_update_configuration(ix_uint32 arg_instance,
                                        ix_cc_qm_context* pContext);
ix_error _ix_cc_qm_patch_microblock(const ix_cc_qm_context* pContext);

/* Registration of packet and message handlers */
ix_error _ix_cc_qm_reg_pkt_msg_handlers(const ix_cc_handle arg_hComponent,const ix_cc_qm_context* pContext);
ix_error _ix_cc_qm_unreg_pkt_msg_handlers(const ix_cc_handle arg_hComponent);

/* Resource de-allocation function */
void _ix_cc_qm_free_init_resources(ix_cc_qm_context* pContext);

/**
 * function prototypes - internal callback 
 */
ix_error _ix_cc_qm_cb_get_packet_count(ix_error arg_Result,void* arg_pContext,
                                       void* arg_Msg,ix_uint32 arg_MsgLen);

/* internal packet handling function - actually sends packets to ublock */
ix_error _ix_cc_qm_ublock_pkt_handler(
                                ix_buffer_handle arg_hBuffer, 
                                ix_uint32 arg_ExceptionCode,
                                void* arg_pContext );


#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__IX_CC_QM_INTERNAL_H__) */
/*******************************  FILE HISTORY  *******************************
 * \main\sdk_3_0\lp_merge\1 Thu Aug 28 18:55:47 2003 adziecia
 * IGK0100025366: LP MERGE: Core Corponents merge checkin 
 *  
 *****************************************************************************/
