/////////////////////////////////////////////////////////////////////////////////////////
//                                                                      
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119 
//
/////////////////////////////////////////////////////////////////////////////////////////
// 		
//	File	:	ipv4_mcast_dispatcher.uc
//
//	Purpose	:	Implements IPV4 Multicast Forwarding algorithm on Egress. This includes
//		post lookup checks, interaction with packet replication functions to make
//		copies for each port.
//                                                                  
/**********************************************************************************/

#ifndef	_IPV4_MCAST_DISPATCHER_UC_
#define	_IPV4_MCAST_DISPATCHER_UC_


	/*
	 * Include files
	 */
#include	<stdmac.uc>
#include	<xbuf.uc>
#include	<sig_macros.uc>
#include	<dispatch_loop.uc>
#include	<system_init.uc>
#include	<dl_misc.uc>
#include	<ipv4.h>
#include	"dl_system.h"


/*
 * Some defines
 */

#define		IPV4_MCAST_FRAG_REQUIRED		0x20
#define		MOIT_OIF_TABLE_LM_BASE			256		/* byte address */
#define		MOIT_OIF_TABLE_LM_INDEX			0		/* index 0 is used */

/*
 * Global registers
 */
.reg	moit_port_mask_base
.reg	moit_oif_lm_base


	/*
	 *	Initialization function
	 *	-----------------------
	 */

/////////////////////////////////////////////////////////////////////////////
//
//	_ipv4_mcast_dsptchr_init()
//
//	Description
//		Initialize global registers, Local Memory used by the dispatcher
//		block.
//
//	Output
//
//		None.
//
//	Input
//
//		None.
//
/////////////////////////////////////////////////////////////////////////////
#macro	ipv4_mcast_dsptchr_init()

	; init global variables

	immed32[moit_port_mask_base, MOIT_PORT_MASK_TABLE_BASE]

	immed32[moit_oif_lm_base, MOIT_OIF_TABLE_LM_BASE]


	br!=ctx[0, done#]

	/*
	 * read the interface properties into Local memory
	 */
.begin
	.reg	oif_sram_addr 
	.reg	num_trips
	.reg	offset
	.sig	oif_sram_sig

	/* maximum number of longwords can be read from SRAM */

#define	_OIF_XFER_EACH_TRIP		8

	/* allocate xfer register buffer */
	xbuf_alloc($oif_xfer, _OIF_XFER_EACH_TRIP, read)

	; set num trips
	immed[num_trips, 0x2]

	; set offset
	immed[offset, 0x0]

	; set LM pointer
	.begin
		.reg tmp
		
		immed32[tmp, MOIT_OIF_TABLE_LM_BASE]
		local_csr_wr[active_lm_addr_/**/MOIT_OIF_TABLE_LM_INDEX, tmp]
	.end

	; get MOIT base address
	immed32[oif_sram_addr, MOIT_OIF_TABLE_BASE]

	.while (num_trips > 0)

		; issue SRAM read
		sram[read, $oif_xfer[0], oif_sram_addr, offset, _OIF_XFER_EACH_TRIP], ctx_swap[oif_sram_sig]

		; populate LM

#define	_IDX	0
#while	(_IDX < _OIF_XFER_EACH_TRIP)
	
		alu[*l$index/**/MOIT_OIF_TABLE_LM_INDEX/**/++, --, B, $oif_xfer[_IDX]]

#define_eval	_IDX	(_IDX + 1)
#endloop
#undef	_IDX

		alu[offset, offset, +, (_OIF_XFER_EACH_TRIP * 4)]

		alu[num_trips, num_trips, - ,1]

	 .endw

#undef	_OIF_XFER_EACH_TRIP

	xbuf_free[$oif_xfer]
.end

done#:
#endm



/////////////////////////////////////////////////////////////////////////////
//
//	_ipv4_mcast_dsptchr()
//
//	Description
//		Perform Egress multicast processing on IPV4 multicast packets.
//
//	Output
//
//		out_buf	=	Buffer where IPV4 header is copied.
//
//	Input
//
//		in_ip		=	buffer containing the IPV4 Packet.
//		BUF_WR_START_BYTE	=	Start offset of IPV4 header within output buffer.
//		BUF_RD_START_BYTE	=	Start offset of IPV4 header within input buffer.
//
/////////////////////////////////////////////////////////////////////////////

#macro	ipv4_mcast_dsptchr(out_buf, in_buf, BUF_WR_START_BYTE, BUF_RD_START_BYTE)

.begin
	.reg	mtid
	.reg	num_copies
	.reg	tmp_mask, accum_mask
	.reg	ttl
	.reg	pkt_size
	.sig	moit_rd_sig


	; check Dl next block ID
	br!=byte[dl_next_block, 0, BID_MCAST_DISPATCHER, exit#]

	dl_meta_get_packet_size[pkt_size]	; get packet size

	; get the MTID
	dl_meta_get_nexthop_id(mtid)

	; get byte address
	alu_shf[mtid, --, B, mtid, <<2]

	; read the MOIT. Each entry is 1 LW
	xbuf_alloc[$port_mask, 1, read]

	; read MOIT
	sram[read, $port_mask[0], mtid, moit_port_mask_base, 1], ctx_swap[moit_rd_sig], defer[2]

	; get the TTL
	xbuf_extract(ttl, in_buf, BUF_RD_START_BYTE, IP_TIME_TO_LIVE)

	; remember, the Ingress already decrements the TTL.
	alu[ttl, ttl, +, 1]

	; we now have the MOIT entry

	; copy temp mask
	ld_field_w_clr[tmp_mask, 0011, $port_mask[0], >>0]

	; NOTE: Currenly this design supports only 16 ports
	;		-------------------------------------------

loop#:

	; initialize number of ports
	immed[num_copies, 0x0]
	immed[accum_mask, 0x0]

	.while(tmp_mask != 0)
	.begin
		.reg	port
		.reg	tmp, tmp2
		.reg	lm_addr
		.reg	tmp_ttl
		.reg	mtu

		; find a port
		ffs[port, tmp_mask]
		beq[loop_done#]

		; a port is set
		; set the LM to get the i/f properties
		alu_shf[lm_addr, moit_oif_lm_base, OR, port, <<2]
		local_csr_wr[ACTIVE_LM_ADDR_/**/MOIT_OIF_TABLE_LM_INDEX, lm_addr]

		; clear tmp_mask
		alu[--, port, OR, 0x0]
		alu_shf[tmp2, --, B, 0x1, <<indirect]
		alu[tmp_mask, tmp_mask, AND~, tmp2]
	
		ld_field_w_clr[tmp_ttl, 0001, *l$index/**/MOIT_OIF_TABLE_LM_INDEX[0], <<0]
		ld_field_w_clr[mtu, 0011, *l$index/**/MOIT_OIF_TABLE_LM_INDEX[0], >>16]
	
		.if (tmp_ttl <= ttl)

			.if (pkt_size <= mtu)
		
				; accumulate this port

				alu[accum_mask, accum_mask, OR, tmp2]

				; increment count
				alu[num_copies, num_copies, +, 1]

			.endif

		.endif

	.end
	.endw

loop_done#:

	/* check if only one port requires transmission. If so, lets
	 * not bother Packet Copier */
	
	alu[--, num_copies, -, 1]

	ble[no_copies#]


	/* now create the request to packet copier */

	; create only 1 LW, as others are in DL state

	alu_shf[dl_copy_req[0], dl_copy_req[0], OR, num_copies, <<16]

	br[exit#], defer[2]

	ld_field[dl_copy_req[0], 0011, accum_mask, <<0]

	immed[dl_next_block, MCAST_DISPATCHER_NEXT2]


no_copies#:

	immed[dl_next_block, MCAST_DISPATCHER_NEXT1]

exit#:

.end

#endm



#endif	/* _IPV4_MCAST_DISPATCHER_UC_ */
