/**
 * ============================================================================
 * = COPYRIGHT
 *              INTEL CORPORATION PROPRIETARY INFORMATION
 *   This software is supplied under the terms of a license agreement or
 *   nondisclosure agreement with Intel Corporation and may not be copied 
 *   or disclosed except in accordance with the terms in that agreement.
 *      Copyright (C) 2002 Intel Corporation. All rights reserved.
 *
 *
 *      
 *
 * = MODULE
 *      ICMP module of IPv4 Fwdr CC
 *
 * = FILENAME
 *      utils.h
 *
 * = DESCRIPTION
 *   This file contains utility functions like calculation of IP
 *   packet checksum and calculation of Identification field
 *   to be filled up in IP header for formation of
 *   ICMP messages   
 *
 * 
 *      
 *
 * = CREATION TIME
 *      1/8/2002 1:53:42 PM
 *
 * = CHANGE HISTORY
 *
 * ============================================================================
 * $Id: utils.h,v 1.9 2003/04/22 01:12:09 ktseng Exp $
 */

#if !defined(__UTILS_H__)
#define __UTILS_H__
#include <assert.h>

#include "ix_cc_error.h"
#include "header_defs.h"
#include "cc/ix_cc_rtmv4.h"
#include "cc/ix_cc_ipv4.h"
#include "cc/ipv4/internal/ix_cc_ipv4_init.h"
#include "cc/ipv4/internal/ix_cc_ipv4_prop.h"
#include "cc/ipv4/internal/ix_cc_ipv4_dbcast.h"


#if defined(__cplusplus)
extern "C"
{
#endif /* end defined(__cplusplus) */


extern ix_cc_ipv4_registry_data g_Ipv4RegistryData;


/**
 * Prototypes for interface functions.
 */

/**
 * NAME: _ix_cc_ipv4_get_ip_id
 *
 * DESCRIPTION: This function calculates the value of identification field
 *              for filling up IP header during building of ICMP
 *              messages. The identification field value has to be unique
 *              with respect to those used by TCP/IP stack. To ensure this, 
 *              Stack Driver Core Component will turn off the most
 *              significant bit off for packets coming from TCP/IP stack
 *              before sending it to IPv4 Forwarder Core Component
 * 
 * @Param:  - IN  - None
 *		
 *            
 * @Param:  - INOUT  - None
 * @Param:  - OUT - 16 bit identification field value 
 *
 *      
 */

ix_uint16 _ix_cc_ipv4_get_ip_id(void);


/**
 * NAME: _ix_cc_ipv4_calculate_checksum
 *
 * DESCRIPTION: This function calculates checksum of the header pointed
 *              to by arg_pAddr according to RFC1071.
 * 
 * @Param:  - IN arg_pAddr - a pointer to IP header 
 *	      IN arg_Size - size of the header	
 * 
 * @Param:  - INOUT  - None
 * @Param:  - OUT - 16 bit checksum value 
 *
 *
 */

ix_uint16 _ix_cc_ipv4_calculate_checksum( ix_uint8 *arg_pAddr, ix_uint32 arg_Size );

/**
 * NAME: _ix_cc_ipv4_init_ip_header
 *
 * DESCRIPTION: This function copies the data of size indicated by header length
 *              from packet pointed to by arg_pData onto IP header structure
 *              pointed to by arg_pIpHdr
 * 
 * @Param:  - IN arg_pData - pointer to data to copy onto IP header
 *		
 *            
 * @Param:  - OUT  arg_pIphdr - Pointer to IP header
 * @Param:  - OUT - Returns the number of bytes copied onto IP header
 *
 */


ix_uint32 _ix_cc_ipv4_init_ip_header(ix_uint8 *arg_pData,
                                  ix_cc_ipv4_header *arg_pIphdr);


/**
 * NAME: _ix_cc_ipv4_print_iphdr
 *
 * DESCRIPTION: This function is a utility function to print the
 *              contents of IP header
 *             
 * 
 * @Param:    IN arg_pHdr - Pointer to IP header
 * @Param:  - INOUT  - None
 * @Param:  - OUT - None
 *
 *
 */
void _ix_cc_ipv4_print_iphdr( ix_uint8 *arg_pHdr );



/**
 * Exported variables.
 */

#if defined(__cplusplus)
}
#endif /* end defined(__cplusplus) */

#endif /* end !defined(__UTILS_H__) */

